function loadBlock3(year, city) {
    $.getJSON("js/baseUrl.json", function (rlt) {
        var baseURL = rlt.baseUrl;
        var cy_URL = baseURL + 'service/sjcj/dp/loadData?dataCode=zf';
        if (year != undefined) {
            if (year != "全年") {
                cy_URL += '&dataYear=' + year
            }
        }
        if (city != "" && city != undefined) {
            cy_URL += '&cityCode=' + city
        }
        $.ajax({
            url: cy_URL,    //请求的url地址
            async: true,
            type: "get",
            success: function (data) {
                var xData = [];
                var series1 = [];
                var series2 = [];
                var _json = {
                    'Q30': '30平',
                    'Q60': '60平',
                    'Q3040': '30~40平',
                    'Q4050': '40~50平',
                    'Q5060': '50~60平',
                    'H30': '30平',
                    'H60': '60平',
                    'H3040': '30~40平',
                    'H4050': '40~50平',
                    'H5060': '50~60平'
                };
                xData = ['30平', '30~40平', '40~50平', '50~60平', '60平'];
                var gsq = data.gsq;
                var gsh = data.gsh;
                var newGsq = [];
                var newGsh = [];
                for (var key in gsq) {
                    newGsq[_json[key]] = gsq[key];
                }
                for (var key in gsh) {
                    newGsh[_json[key]] = gsh[key];
                }
                for (var i = 0; i < xData.length; i++) {
                    series1.push(newGsq[xData[i]]);
                    series2.push(newGsh[xData[i]]);
                }

                let houseChart = echarts.init(document.getElementById('block3'));
                houseChart.setOption({
                    tooltip: {
                        show: true,
                        trigger: 'axis',
                        backgroundColor: 'rgba(31, 61, 88, 0.92)',
                        borderWidth: '1',
                        borderColor: '#649EBD',
                        padding: [15, 15],
                        textStyle: {
                            color: '#fff',
                            fontSize: 30
                        },
                        formatter: function (params) {
                            var showHtm = params[0].name + '<br>';
                            for (var i = 0; i < params.length; i++) {
                                var name = params[i].seriesName;
                                var value = params[i].value;
                                showHtm += name + ':' + value + '户' + '<br>'

                            }
                            return showHtm;

                        }
                    },
                    legend: {
                        top: '50',
                        textStyle: {  // 图列内容样式
                            color: '#fff',  // 字体颜色
                            fontSize: 30,
                            width: 200
                        },
                        itemWidth: 31,
                        itemHeight: 31,
                        itemGap: 35,
                        data: ['改善前', '改善后'],
                    },
                    grid: {
                        show: true,    // 是否显示直角坐标系网格
                        top: 150,
                        left: 40,
                        right: 40,
                        bottom: 60,
                        borderWidth: '0',
                        containLabel: true, // gird 区域是否包含坐标轴的刻度标签
                    },
                    xAxis: {
                        data: xData,
                        splitLine: {
                            show: false,
                        },
                        axisLabel: {
                            show: true,
                            textStyle: {
                                fontSize: 30,
                                color: '#709FD9'
                            },
                            interval: 0
                        },
                        axisLine: {
                            lineStyle: {
                                color: 'rgba(133, 177, 180, 0.2)',
                                width: 1
                            }
                        },
                        axisTick: {
                            show: false
                        }
                    },
                    yAxis: {
                        type: 'value',
                        name: '单位:户',
                        nameTextStyle: {
                            fontSize: 30,
                            color: '#709FD9'
                        },
                        nameGap: 35,
                        splitLine: {
                            show: false,
                        },
                        axisLabel: {
                            show: true,
                            textStyle: {
                                fontSize: 30,
                                color: '#709FD9'
                            },
                            interval: 0
                        },
                        axisLine: {
                            show: true,
                            lineStyle: {
                                color: 'rgba(133, 177, 180, 0.2)',
                                width: 1
                            }
                        },
                        axisTick: {
                            show: false
                        }
                    },
                    series: [{
                        name: '改善前',
                        type: 'bar',
                        barWidth: 30,
                        stack: '使用情况',
                        data: series1,
                        itemStyle: {
                            normal: {
                                color: new echarts.graphic.LinearGradient(1, 1, 0, 0, [{
                                    offset: 0,
                                    color: '#0DCAFF'
                                },
                                    {
                                        offset: 1,
                                        color: '#4562FF'
                                    }])
                            }

                        },
                    },
                        {
                            name: '改善后',
                            type: 'bar',
                            barWidth: 30,
                            stack: '使用情况',
                            data: series2,
                            itemStyle: {
                                normal: {
                                    color: new echarts.graphic.LinearGradient(1, 1, 0, 0, [{
                                        offset: 0,
                                        color: '#51C5FE'
                                    },
                                        {
                                            offset: 1,
                                            color: '#51FDD1'
                                        }])
                                }

                            }
                        }]
                });


            },
            error: function (rlt, msg) {
                console.log("获取失败，原因：" + msg);
            }
        })
    })


}
