function loadBlock2(year, city) {
    $.getJSON("js/baseUrl.json", function (rlt) {
        var baseURL = rlt.baseUrl;
        var cy_URL = baseURL + 'service/sjcj/dp/loadData?dataCode=mj';
        if (year != undefined) {
            if (year != "全年") {
                cy_URL += '&dataYear=' + year
            }
        }
        if (city != "" && city != undefined) {
            cy_URL += '&cityCode=' + city
        }
        $.ajax({
            url: cy_URL,    //请求的url地址
            async: true,
            type: "get",
            success: function (data) {
                var xData = [];
                var xy_area = [];//协议拆除旧房面积
                var sj_area = [];//实际拆除旧房面积
                var tc_area = [];//协议退出宅基地面积
                var sjtc_area = [];//实际退出宅基地面积
                var newData1={};
                var newData2={};
                var newData3={};
                var newData4={};
                if(data.xycc != undefined){
                    newData1 = JSON.parse(JSON.stringify( data.xycc, ["徐州","连云港","淮安","盐城","宿迁"] , 5));
                }
                $.each(newData1, function (index, item) {
                    xData.push(index);
                    xy_area.push(item);
                });
                if(data.sjcc != undefined){
                    newData2 = JSON.parse(JSON.stringify( data.sjcc, ["徐州","连云港","淮安","盐城","宿迁"] , 5));
                }
                $.each(newData2, function (index, item) {
                    sj_area.push(item);
                });
                if(data.xytc != undefined){
                    newData3 = JSON.parse(JSON.stringify( data.xytc, ["徐州","连云港","淮安","盐城","宿迁"] , 5));
                }
                $.each(newData3, function (index, item) {
                    tc_area.push(item);
                });
                if(data.sjtc != undefined){
                    newData4 = JSON.parse(JSON.stringify( data.sjtc, ["徐州","连云港","淮安","盐城","宿迁"] , 5));
                }
                $.each(newData4, function (index, item) {
                    sjtc_area.push(item);
                });
                // 初始化echarts实例
                let houseChart = echarts.init(document.getElementById('block2'));
                houseChart.setOption({
                    tooltip: {
                        show: true,
                        trigger: 'axis',
                        backgroundColor: 'rgba(31, 61, 88, 0.92)',
                        borderWidth: '1',
                        borderColor: '#649EBD',
                        padding: [15, 15],
                        textStyle: {
                            color: '#fff',
                            fontSize: 30
                        },
                        formatter: function (params) {
                            var showHtm = params[0].name + '<br>';
                            for (var i = 0; i < params.length; i++) {
                                var name = params[i].seriesName;
                                var value = params[i].value;
                                showHtm += name + ':' + value + '㎡' + '<br>'

                            }
                            return showHtm;
                        }
                    },
                    grid: {
                        show: true,    // 是否显示直角坐标系网格
                        top: 190,
                        left: 40,
                        right: 40,
                        bottom: 60,
                        borderWidth: '0',
                        containLabel: true, // gird 区域是否包含坐标轴的刻度标签
                    },
                    legend: {
                        top: '22',
                        textStyle: {  // 图列内容样式
                            color: '#fff',  // 字体颜色
                            fontSize: 30,
                            width: 200
                        },
                        itemWidth: 31,
                        itemHeight: 31,
                        itemGap: 30,
                        data: ['协议拆除旧房面积', '实际拆除旧房面积', '协议退出宅基地面积', '实际退出宅基地面积']
                    },
                    xAxis: [
                        {
                            type: 'category',
                            data: xData,
                            axisLabel: {
                                show: true,
                                textStyle: {
                                    fontSize: '28',
                                    color: '#fff'
                                }
                            },
                            axisLine: {
                                lineStyle: {
                                    color: 'rgba(255,255,255,0.2)',
                                    width: 1
                                }
                            },
                            axisTick: {
                                show: false
                            }
                        }
                    ],
                    yAxis: [
                        {
                            type: 'value',
                            axisLine: {
                                show: false
                            },
                            axisLabel: {
                                show: true,
                                textStyle: {
                                    fontSize: '25',
                                    color: '#fff'
                                }
                            },
                            splitLine: {
                                show: true,
                                lineStyle: {
                                    type: 'dashed',
                                    color: 'rgba(255,255,255,0.25)'
                                }
                            }
                        }
                    ],
                    series: [
                        {
                            name: '协议拆除旧房面积',
                            type: 'bar',
                            itemStyle: {
                                normal: {
                                    color: new echarts.graphic.LinearGradient(1, 1, 0, 0, [{
                                        offset: 0,
                                        color: '#FFAB96'
                                    },
                                        {
                                            offset: 1,
                                            color: '#93112F'
                                        }]),
                                    borderWidth: 1,
                                    borderType: 'solid',
                                    borderColor: '#EB6877'
                                },

                            },
                            data: xy_area,
                            color: '#CC0066'
                        },
                        {
                            name: '实际退出宅基地面积',
                            type: 'bar',
                            itemStyle: {
                                normal: {
                                    color: new echarts.graphic.LinearGradient(1, 1, 0, 0, [{
                                        offset: 0,
                                        color: '#00A8FF'
                                    },
                                        {
                                            offset: 1,
                                            color: '#0F3352'
                                        }]),
                                    borderWidth: 1,
                                    borderType: 'solid',
                                    borderColor: '#00B7EE'
                                }
                            },
                            data: sjtc_area,
                            color: '#009999'
                        },
                        {
                            name: '协议退出宅基地面积',
                            type: 'bar',
                            itemStyle: {
                                normal: {
                                    color: new echarts.graphic.LinearGradient(1, 1, 0, 0, [{
                                        offset: 0,
                                        color: '#E4B90C'
                                    },
                                        {
                                            offset: 1,
                                            color: '#A0670E'
                                        }]),
                                    borderWidth: 1,
                                    borderType: 'solid',
                                    borderColor: '#FFFF00'
                                }
                            },
                            data: tc_area,
                            color: '#FFCC33'
                        },
                        {
                            name: '实际拆除旧房面积',
                            type: 'bar',
                            itemStyle: {
                                normal: {
                                    color: new echarts.graphic.LinearGradient(1, 1, 0, 0, [{
                                        offset: 0,
                                        color: '#8FFCA0'
                                    },
                                        {
                                            offset: 1,
                                            color: '#0D7F9C'
                                        }]),
                                    borderWidth: 1,
                                    borderType: 'solid',
                                    borderColor: '#009944'
                                }
                            },
                            data: sjtc_area,
                            color: '#FFCC33'
                        }
                    ]
                });


            },
            error: function (rlt, msg) {
                console.log("获取失败，原因：" + msg);
            }
        })
    })


}
