var BorderWidth = '16';

function loadBlock1(year, city) {
    $.getJSON("js/baseUrl.json", function (rlt) {
        var baseURL = rlt.baseUrl;
        var cy_URL = baseURL + 'service/sjcj/dp/loadData?dataCode=gslx'
        if (year != undefined) {
            if (year != "全年") {
                cy_URL += '&dataYear=' + year
            }
        }
        if (city != undefined) {
            cy_URL += '&cityCode=' + city
        }

        $.ajax({
            url: cy_URL,    //请求的url地址
            async: true,
            type: "get",
            success: function (data) {
                debugger
                if (data != null) {
                    var houseProportion = [{
                        name: '入镇购房',
                        value: data.入镇购房
                    }, {
                        name: '就地修缮',
                        value: data.就地修缮
                    }, {
                        name: '新型农村社区',
                        value: data.新型农村社区
                    }, {
                        name: '小城镇集中安置区',
                        value: data.小城镇集中安置区
                    }, {
                        name: '进城购房',
                        value: data.进城购房
                    }, {
                        name: '规划发展村庄就地新建翻建',
                        value: data.规划发展村庄就地新建翻建
                    }
                    ];

                    //反方向剩下部分的样式
                    var colors = [{
                        color1: '#116CFD',
                        color2: '#0BAEFD'
                    }, {
                        color1: '#06bb70',
                        color2: '#08ef8b'
                    }, {
                        color1: '#73dafc',
                        color2: '#2dcbff'
                    }, {
                        color1: '#30a3b9',
                        color2: '#0bd9d7'
                    }, {
                        color1: '#f5c545',
                        color2: '#f5b945'
                    }, {
                        color1: '#ff7675',
                        color2: '#ff7675'
                    }
                    ];
                    var placeHolderStyle = {
                        normal: {
                            label: {
                                show: false,
                                position: "outside"
                            },
                            labelLine: {
                                show: false,
                                length: 100,
                                smooth: 0.5
                            },
                            borderWidth: BorderWidth,
                            /*shadowBlur: 40,*/
                            borderColor: "#1e575b"
                        },
                        emphasis: {
                            color: "#1e575b",
                            borderColor: "#1e575b",
                            borderWidth: 0

                        }
                    };
                    var _arry = [];
                    for (var i = 0; i < houseProportion.length; i++) {
                        _arry.push(houseProportion[i].value);
                    }
                    var max = Math.max.apply(null, _arry) * 1.2;
                    var series = [];
                    for (var i = 0; i < houseProportion.length; i++) {
                        series.push(
                            {
                                name: houseProportion[i].name,
                                type: 'pie',
                                clockWise: true, //顺时加载
                                hoverAnimation: false, //鼠标移入变大
                                radius: [200 - 35 * i, 200 - 35 * i],
                                itemStyle: {
                                    normal: {
                                        label: {
                                            show: false,
                                            position: 'outside'
                                        },
                                        labelLine: {
                                            show: false,
                                            length: 100,
                                            smooth: 0.5
                                        },
                                        borderWidth: BorderWidth,
                                        shadowBlur: 40,
                                        borderColor: new echarts.graphic.LinearGradient(1, 1, 0, 0, [{
                                            offset: 0,
                                            color: colors[i].color1
                                        },
                                            {
                                                offset: 1,
                                                color: colors[i].color2
                                            }]),
                                        shadowColor: 'rgba(0, 0, 0, 0)'
                                    }
                                },
                                data: [{
                                    value: houseProportion[i].value,
                                    name: parseInt(100 * houseProportion[i].value / max) + '%'
                                },
                                    {
                                        value: max - houseProportion[i].value,
                                        name: '',
                                        itemStyle: placeHolderStyle
                                    }
                                ]
                            }
                        );

                        if (houseProportion[i].name == "入镇购房") {
                            if (houseProportion[i].value == undefined) {
                                $("#cy-rzgf").text("")
                            } else {
                                $("#cy-rzgf").text(houseProportion[i].value + "户");
                            }
                        }
                        if (houseProportion[i].name == "就地修缮") {
                            if (houseProportion[i].value == undefined) {
                                $("#cy-jdxs").text("")
                            } else {
                                $("#cy-jdxs").text(houseProportion[i].value + "户");
                            }
                        }
                        if (houseProportion[i].name == "新型农村社区") {
                            if (houseProportion[i].value == undefined) {
                                $("#cy-xxnc").text("");
                            } else {
                                $("#cy-xxnc").text(houseProportion[i].value + "户");
                            }
                        }
                        if (houseProportion[i].name == "小城镇集中安置区") {
                            if (houseProportion[i].value == undefined) {
                                $("#cy-xczazf").text("");
                            } else {
                                $("#cy-xczazf").text(houseProportion[i].value + "户");
                            }

                        }
                        if (houseProportion[i].name == "进城购房") {
                            if (houseProportion[i].value == undefined) {
                                $("#cy-jcgf").text("");
                            } else {
                                $("#cy-jcgf").text(houseProportion[i].value + "户");
                            }

                        }
                        if (houseProportion[i].name == "规划发展村庄就地新建翻建") {
                            if (houseProportion[i].value == undefined) {
                                $("#cy-ghfzcz").text("");
                            } else {
                                $("#cy-ghfzcz").text(houseProportion[i].value + "户");
                            }
                        }


                    }


                    // 初始化echarts实例
                    var fruitChart = echarts.init(document.getElementById('block1'));
                    fruitChart.setOption({
                        title: {
                            text: '',
                            left: 'center'
                        },
                        backgroundColor: '',
                        tooltip: {
                            show: true,
                            position: [101, 33],
                            alwaysShowContent: true,
                            extraCssText: 'width:322px;height:auto;',
                            trigger: 'item',
                            formatter: function (a, b) {
                                // console.log(a,11);
                                if (b.indexOf('-1') > -1) {
                                    return ''
                                }
                                return `<div style='display:block;line-height: 48px;word-break: break-all;word-wrap: break-word;white-space:pre-wrap;margin-bottom:-48px'>${a.seriesName} </div></br>${a.name}`
                            },
                            backgroundColor: 'rgba(31, 61, 88, 0.92)',//通过设置rgba调节背景颜色与透明度
                            borderWidth: '1',
                            borderColor: '#649EBD',
                            padding: [15, 25],
                            textStyle: {
                                color: '#fff',
                                fontSize: 40
                            }

                        },
                        grid: {
                            left: '244px',
                            right: '244px',
                            top: '1%',
                            containLabel: true
                        },
                        series: series
                    },true);


                }

            },
            error: function (rlt, msg) {
                console.log("获取失败，原因：" + msg);
            }

        })


    })


}
