<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<div class="easyui-layout" fit="true">
    <div data-options="region:'center'" border="false" style="padding: 4px;">
        <div class="easyui-layout" fit="true" id="workcheck-info-main">
            <div region="north" border="false" style="height: 60px; padding: 4px;">
                <div class="easyui-panel search-body" cls="search" style="width: 100%; margin-bottom: 0;">
                    <form class="clearFromValue" id="projectcheck_search_form">
                        <div class="search-item">
                            <label>状态</label>
                            <input class="easyui-combobox" name="status"
                                   target="dictionary"
                                   key="gxStatus" style="width: 150px;"/>
                        </div>
                        <div class="search-item">
                            <label>考核年份</label>
                            <input type="text" class="easyui-combobox" name="wyear"
                                   url="service/common/getYearList/10" method="get" data-options="valueField:'year',textField:'year'"/>
                        </div>
                        <div class="search-item">
                            <label>行政区划</label>
                            <input type="text" class="easyui-combobox" data-options="valueField:'unitCode',textField:'unitName'" name="city" id="user_second" method="get" prompt="市"/>
                            &nbsp;
                            <input type="text" class="easyui-combobox" data-options="valueField:'unitCode',textField:'unitName'" name="county" id="user_third" method="get" prompt="县区"/>
                            &nbsp;
                        </div>
                        <a class="easyui-linkbutton btn-search" iconCls="icon-search" id="projectcheck_search">查询</a>
                            <input type="hidden" id="wk_usertype">
                    </form>
                </div>
            </div>
            <div region="center" border="false" style="padding: 4px;">
                <table idField="id" treeField="text"
                       rownumbers="false"  sortName="updatetime"
                       sortOrder="desc" search=".search"
                       toolbar=".temp-toolbar" layoutH="0" id="workcheck_table">
                    <thead>
                    <tr>
                        <th data-options="field:'status'" width="10%"  align="center" format="Dictionary:gxStatus" >状态</th>
                        <th data-options="field:'wtype'" width="15%" align="center"  format="Dictionary:wtype">类别</th>
                        <th data-options="field:'xzqh'" width="8%" align="center">行政区划</th>
                        <th data-options="field:'wyear'" width="8%" align="center">评价年份</th>
                        <th data-options="field:'xtotalscore'" width="10%" align="center">县区评价总分</th>
                        <th data-options="field:'stotalscore'" width="10%" align="center">市评价总分</th>
                        <th data-options="field:'ptotalscore'" width="10%" align="center">省评总分</th>
                        <th data-options="field:'wresult'" width="10%" align="center" format="Dictionary:wresultStatus">省级评价结果</th>
                        <th data-options="field:'userName'" width="10%" align="center">录入用户</th>
                        <th data-options="field:'updatetime'" width="10%" align="center" format="Date:yyyy-MM-dd">更新时间</th>
                    </tr>
                    </thead>
                </table>
                <div class="temp-toolbar">
                    <a iconCls="icon-add" href="modules/check/workcheck/workcheck-info.jsp" trigger="none" id="workcheck_add_btn"
                       target="dialog" rel="workcheck_add" title="新增工作绩效评价表" width="1300" height="600"
                       buttons="[{method:'submit',text:'暂存并退出'},{method:'submitXz',text:'确认并提交'}]">新增</a>
                    <hr>
                    <%--县区级编辑，无退回--%>
                    <a iconCls="icon-edit" href="modules/check/workcheck/workcheck-info.jsp" trigger="single" id="workcheck_edit_btn"
                       target="dialog" rel="workcheck_edit" title="编辑 {{wyear}}-{{xzqh}}"  width="1300" height="600"
                       buttons="[{method:'submit',text:'暂存并退出'},{method:'submitXz',text:'确认并提交'}]">编辑</a>
                    <hr>
                    <%--  市、省级编辑，有退回--%>
                    <a iconCls="icon-edit" href="modules/check/workcheck/workcheck-info.jsp" trigger="single" id="workcheck_edit2_btn"
                       target="dialog" rel="workcheck_edit2" title="编辑  {{wyear}}-{{xzqh}}"  width="1300" height="600"
                       buttons="[{method:'submit',text:'暂存并退出'},{method:'submitXz',text:'确认并提交'},{method:'submitTh',text:'退回'}]">编辑</a>
                    <hr>

                    <a iconCls="icon-edit" href="modules/check/workcheck/workcheck-view.jsp" trigger="single"
                       target="dialog" rel="workcheck_view" title="查看  {{wyear}}-{{xzqh}}" width="1300" height="600" btnValue="查看">查看</a>
                    <hr>

                    <a iconCls="icon-base icon-base-ban" trigger="single"
                       target="confirm" rel="workcheck_remove" title="是否确定删除 {{text}}？">删除</a>
                </div>
            </div>
        </div>
    </div>
</div>

<script>

    $.parser.onComplete = function (panel) {
        $.parser.onComplete = $.noop;
        requirejs([
            'core/filter/filter.dictionary',
            'modules/check/workcheck/ctrl/workcheck','css!plugins/viewer/viewer.min.css'
        ], function (FilterDictionary,Workcheck) {
            FilterDictionary.add(['gxStatus','wtype','wresultStatus']).then(function () {
                window.Workcheck = new Workcheck('workcheck', panel);
                window.Workcheck.load(panel);
            })
        });
    };
   /* $.parser.onComplete = function (panel) {
        $.parser.onComplete = $.noop;
        requirejs([
            'modules/check/workcheck/ctrl/workcheck'
        ], function (Workcheck) {
            window.Workcheck = new Workcheck('workcheck', panel);
            window.Workcheck.load(panel);
        });
    };*/


</script>