define(function(require) {
	var Config = require('config');
	var Core = require('core/core');
	var Page = require('core/page');
    var Dialog = require('centit/centit.dialog');

    var WorkcheckExp = require('../ctrl/workcheck.exp');

	var WorkcheckView = Page.extend(function() {

        this.injecte([
            new WorkcheckExp('workcheck_exp'),
        ]);

		var _self;
		// @override
        this.load = function(panel, data) {
            _self = this;
            var form = panel.find('#workcheck_view_form1');
            var form2 = panel.find('#workcheck_view_form2');
            var table = this.table = panel.find('#workcheck_view_table');
            Core.ajax(Config.ContextPath+'service/check/workcheck/'+data.wid, {
                type: 'json',
                method: 'get'
            }).then(function(data) {
                _self.data = data;
                //设置总分显示情况
                if(data.xtotalscore != null ){
                    panel.find("#workcheck_view_xtotalscore").show();
                }
                if(data.stotalscore != null ){
                    panel.find("#workcheck_view_stotalscore").show();
                }
                if(data.ptotalscore != null ){
                    panel.find("#workcheck_view_ptotalscore").show();
                }
                //获取登录用户信息
                Core.ajax(Config.ContextPath + 'service/common/getLoginUserUnitInfo', {
                    method: 'get'
                }).then(function (loginUnitInfo) {
                    if(loginUnitInfo.unitType == 3) {//县区级
                        usertype = 1;
                    } else if(loginUnitInfo.unitType == 2) {//市
                        usertype = 2;
                    } else if(loginUnitInfo.unitType == 1){//省
                        usertype = 3;
                    }
                    //评价时间显示，有则显示
                    if(data.xtime != null){
                        panel.find("#workcheck_view_xtime").show();
                    } else {
                        panel.find("#workcheck_view_xtime").hide();
                    }

                    if(data.stime != null){
                        panel.find("#workcheck_view_stime").show();
                    } else {
                        panel.find("#workcheck_view_stime").hide();
                    }

                    if(data.ptime != null){
                        panel.find("#workcheck_view_ptime").show();
                    } else {
                        panel.find("#workcheck_view_ptime").hide();
                    }

                    form.form('load', data)
                        .form('disableValidation')
                        .form('focus');
                    form2.form('load', data);

                    var url = "service/check/workcheckitem/itemListByWid2/" + data.wid;
                    Core.ajax(Config.ContextPath + url, {
                        method: 'get'
                    }).then(function(list) {
                        if(list != null && list.length > 0){
                            var rlt = list;
                            for(var i = 0 ; i < list.length ; i ++){//数据处理
                                rlt[i].content1 = hh(rlt[i].content1, 5);
                                rlt[i].content3 = hh(rlt[i].content3, 27);
                                rlt[i].details1 = hh(rlt[i].details1, 25);
                                rlt[i].fj = "<button class=\"fjBtn\" id='" + rlt[i].wiid + "'></button>";
                            }
                            table.cdatagrid({
                                controller : _self,
                                onLoadSuccess: function (data) {
                                    mergeCellsByField("workcheck_view_table", "content1");
                                    mergeCellsByField("workcheck_view_table", "content2");
                                }
                            }).datagrid('loadData', rlt);
                            if(usertype == 1){
                                table.datagrid('hideColumn', 'sscore');
                                table.datagrid('hideColumn', 'pscore');
                            } else if(usertype== 2){
                                table.datagrid('hideColumn', 'pscore');
                            }

                            //图片上传
                            _self.panel.find('.fjBtn').bind('click', function(){
                                var i = this.id;
                                var SelectUser = require('modules/check/workcheck/ctrl/workcheck.fj.view');
                                var _SelectUser = new SelectUser(i);
                                _self.controllers[i] = _SelectUser;
                                _SelectUser.parent = _self;
                                Dialog.open({
                                    id : i,
                                    title : '改善项目绩效评价附件上传',
                                    href : "modules/check/workcheck/workcheck-fj-view.jsp",
                                    width : 900,
                                    height : 570
                                }, {'wiid':i,'usertype':usertype}, _self.controllers[i]);
                            });

                        }
                    });
                });

                //流程表加载
                var lc_table = panel.find("#wk_lc_table");
                lc_table.cdatagrid({
                    controller: _self,
                });
                Core.ajax(Config.ContextPath + 'service/utils/pmpWfRecord?s_wid=' + data.wid + '&s_wmodule=6', {
                    type: 'json',
                    method: 'get'
                }).then(function (resData) {
                    var lcList = resData.objList;
                    lc_table.cdatagrid({
                        controller: _self,
                    }).datagrid('loadData', lcList);
                });



                //加载已上传附件
                Core.ajax(Config.ContextPath+'service/attachment/getAttachments/'+2+'/'+data.wid, {
                    type: 'json',
                    method: 'get'
                }).then(function(resdata) {
                    var list = resdata.fjlist;
                    panel.find('#wcinfo_fj_div').empty();//其他家庭成员初始化清空
                    var j = 0;
                    if(list != null && list.length > 0){
                        for(var i = 0; i < list.length ;i++){
                            j = i+1;
                            var obj = list[i];
                            var container = panel.find('#wcinfo_fj_div');
                            var html = '<a href="'+Config.ContextPath+'service/attachment/downloadFJ/'+obj.iid+'" style="color: blue;" id="tzgg_fj">'+j+'、'+obj.ename+'--'+obj.userName+'</a><br>';
                            container.append(html);


                        }
                    }
                });
            });
        };

        //换行
        var hh = function (str,len) {
            var newstr = "";
            if(str != null){
                var strs = str.split("");
                for(var j = 0 ; j < strs.length;j++ ){
                    if((j+1)%len == 0){
                        newstr += '<br>'+strs[j];
                    } else {
                        newstr += strs[j];
                    }
                }
            }
            return newstr;
        }

        function mergeCellsByField(tableID, colList) {
            var ColArray = colList.split(",");
            var tTable = $("#" + tableID);
            var TableRowCnts = tTable.datagrid("getRows").length;
            var tmpA;
            var tmpB;
            var PerTxt = "";
            var CurTxt = "";
            var buyprocode = "";
            var newbuyprocode = "";
            var alertStr = "";
            for (j = ColArray.length - 1; j >= 0; j--) {
                PerTxt = "";
                buyprocode = "";
                tmpA = 1;
                tmpB = 0;

                for (i = 0; i <= TableRowCnts; i++) {
                    if (i == TableRowCnts) {
                        CurTxt = "";
                        newbuyprocode = "";
                    }
                    else {
                        CurTxt = tTable.datagrid("getRows")[i][ColArray[j]];
                        newbuyprocode = tTable.datagrid("getRows")[i]["buyprojectCode"];
                    }
                    if (PerTxt == CurTxt && buyprocode == newbuyprocode) {
                        tmpA += 1;
                    }
                    else {
                        tmpB += tmpA;

                        tTable.datagrid("mergeCells", {
                            index: i - tmpA,
                            field: ColArray[j],　　//合并字段
                            rowspan: tmpA,
                            colspan: null
                        });
                        tTable.datagrid("mergeCells", { //根据ColArray[j]进行合并
                            index: i - tmpA,
                            field: "Ideparture",
                            rowspan: tmpA,
                            colspan: null
                        });

                        tmpA = 1;
                    }
                    PerTxt = CurTxt;
                    buyprocode = newbuyprocode;
                }
            }
        }
	});
	
	return WorkcheckView;
});