define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');

    
    var WorkcheckAdd = require('./workcheck.add');
    var WorkcheckEdit = require('./workcheck.edit');
    var WorkcheckView = require('./workcheck.view');
    var WorkcheckRemove = require('./workcheck.remove');

    // 业务信息
    var Workcheck = Page.extend(function() {
    	
    	this.injecte([
          new WorkcheckAdd('workcheck_add'),
          new WorkcheckEdit('workcheck_edit'),
          new WorkcheckEdit('workcheck_edit2'),
          new WorkcheckView('workcheck_view'),
          new WorkcheckRemove('workcheck_remove')
    	]);
    	var _self;
    	// @override
    	this.load = function(panel) {
    	    _self = this;
    		var table = this.table = panel.find('#workcheck_table');
    		var url = "service/check/workcheck";
            table.cdatagrid({
                controller: this,
                url: url,
            });

            //获取登录用户信息,设置按钮显示权限，,
            Core.ajax(Config.ContextPath + 'service/common/getLoginUserUnitInfo', {
                method: 'get'
            }).then(function (loginUnitInfo) {
                //只有县区、市可以新增
                if(loginUnitInfo.unitType != 2 && loginUnitInfo.unitType != 3){//不是县区、市
                    panel.find('#workcheck_add_btn, #workcheck_add_btn + hr', panel).remove();
                    panel.find('#workcheck_add_btn').parent('td').next().remove();
                }
                //县区使用没有退回的编辑按钮，市省用有退回的编辑按钮
                if(loginUnitInfo.unitType == 3 ){//县区
                    panel.find('#workcheck_edit2_btn, #workcheck_edit2_btn + hr', panel).remove();
                    panel.find('#workcheck_edit2_btn').parent('td').next().remove();
                } else {
                    panel.find('#workcheck_edit_btn, #workcheck_edit_btn + hr', panel).remove();
                    panel.find('#workcheck_edit_btn').parent('td').next().remove();
                }

                //将用户角色信息放在主页面
                var usertype = null;
                if(loginUnitInfo.unitType == 3) {//县区级
                    usertype = 1;
                } else if(loginUnitInfo.unitType == 2) {//市
                    usertype = 2;
                } else if(loginUnitInfo.unitType == 1){//省
                    usertype = 3;
                }
                panel.find("#wk_usertype").val(usertype);
            });


            //行政区划初始化
            panel.find('#user_second').combobox({
                url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/2/320000000000",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (list) {
                    if(list != null && list.length == 1){
                        panel.find('#user_third').combobox({
                            url: Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/3/"+list[0]["unitCode"] ,
                            valueField: 'unitCode',
                            textField: 'unitName',
                        });
                    }
                }
            });

            //行政区划联动
            panel.find('#user_second').combobox({
                onChange: function(newValue,oldValue) {
                    panel.find('#user_third').combobox('clear');
                    // 重新获取数据
                    if(newValue != null){
                        panel.find('#user_third').combobox('reload', Config.ContextPath + "service/userinfo2/getUnitsByLoginAndUnitCode/3/"+newValue);
                    }
                }
            });
    	};
    	
    });

    return Workcheck;
});