define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var Dialog = require('centit/centit.dialog');
    var $ = require('jquery');
    var ajaxSubmit = require('plugins/jquery.form');

    var projectcheckFj = Page.extend(function () {

        var _self;
        var usertype;
        var emodule = 6;//图片一级分类
        // @override
        this.load = function (panel, data) {
            _self = this;
            var wiid = data.wiid;//子表主键
            usertype = data.usertype;//用户类型1-县区、2-市，3-省
            //加载图片
            reloadImage(wiid);


        };


        function reloadImage(wiid) {
            Core.ajax(Config.ContextPath + 'service/utils/images/getAttachmentsBTY/' + emodule + '/' + wiid, {
                type: 'json',
                method: 'get'
            }).then(function (data) {
                $('#wk_images_xtype').empty();
                $('#wk_images_stype').empty();
                $('#wk_images_ptype').empty();
                $.each(data.fjList, function (index, item) {
                    $('<img>', {
                        src : "data:image/jpg;base64,"+item.efj,
                    }).css({
                        height : "100px",
                        margin : "3px"
                    }).appendTo(_self.panel.find('#wk_images_' + item.type1));
                });


                _self.panel.find('#wk_images_xtype').viewer({
                    zIndex : 9999
                });

                _self.panel.find('#wk_images_stype').viewer({
                    zIndex : 9999
                });

                _self.panel.find('#wk_images_ptype').viewer({
                    zIndex : 9999
                });

            });
        }

    });

    return projectcheckFj;
});