define(function (require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var Dialog = require('centit/centit.dialog');
    var $ = require('jquery');
    var ajaxSubmit = require('plugins/jquery.form');

    var projectcheckFj = Page.extend(function () {

        var _self;
        var usertype;
        var emodule = 6;//图片一级分类
        // @override
        this.load = function (panel, data) {
            _self = this;
            var wiid = data.wiid;//子表主键
            usertype = data.usertype;//用户类型1-县区、2-市，3-省
            if (usertype == 3) {//省,上传按钮显示
                $('#wk_ptype_btn').show();
            }
            if (usertype == 2) {//市,上传按钮显示
                $('#wk_stype_btn').show();
            }
            if (usertype == 1) {//县区,上传按钮显示
                $('#wk_xtype_btn').show();
            }

            //加载图片
            reloadImage(wiid);

            panel.find('#wk_xtype_btn').click(function () {
                showUploadDialog('xtype', wiid);
            });
            panel.find('#wk_stype_btn').click(function () {
                showUploadDialog('stype', wiid);
            });
            panel.find('#wk_ptype_btn').click(function () {
                showUploadDialog('ptype', wiid);
            });

        };

        function showUploadDialog(type1, wiid) {
            new BUpload({
                upload_url: Config.ContextPath + 'service/utils/images/uploadFile?type=' + emodule + '&rid=' + wiid + '&type1=' + type1,
                ext_allow: "png|jpg|jpeg",
                ext_refuse: "exe|bat",
                max_filesize: 1024, //KB
                max_filenum: 10,
                callback: function () {
                    reloadImage(wiid);
                }
            });
        }

        function reloadImage(wiid) {
            Core.ajax(Config.ContextPath + 'service/utils/images/getAttachmentsBTY/' + emodule + '/' + wiid, {
                type: 'json',
                method: 'get'
            }).then(function (data) {
                $('#wk_images_xtype').empty();
                $('#wk_images_stype').empty();
                $('#wk_images_ptype').empty();
                $.each(data.fjList, function (index, item) {
                    // 主
                    var itemdiv = $('<div>', {}).css({
                        height: '113px',
                        margin: '3px',
                        float: 'left',
                        position: 'relative'
                    }).appendTo($('#wk_images_' + item.type1));

                    // 图片
                    var img = $('<img>', {
                        src: 'data:image/jpg;base64,' + item.efj
                    }).css({
                        height: '100%'
                    }).appendTo(itemdiv);

                    // 工具条
                    var toolbar = $('<div>', {}).css({
                        position: 'absolute',
                        background: 'rgba(0, 0, 0, 0.5) none repeat scroll 0% 0%',
                        width: '100%',
                        height: '26px',
                        top: '0px',
                        left: '0px',
                        display: 'none'
                    }).appendTo(itemdiv);

                    var width = 0;
                    var height = 0;
                    if( (usertype == 1 && item.type1 == 'xtype')
                        || (usertype == 2 && item.type1 == 'stype')
                        || (usertype == 3 && item.type1 == 'ptype')){//删除图片权限控制
                        width = 24;
                        height = 24;
                    }
                    // 删除按钮
                    var delBtn = $('<span>', {}).css({
                        width: width + 'px',
                        height: width + 'px',
                        display: 'inline',
                        float: 'right',
                        background: 'url("' + Config.ContextPath + 'ui/js/bupload/css/images/icons.png") no-repeat',
                        margin: '5px 1px 1px',
                        cursor: 'pointer',
                        'background-position': '-48px -24px'
                    }).appendTo(toolbar);

                    itemdiv.on('mouseover', function () {
                        toolbar.show();
                    }).on('mouseout', function () {
                        toolbar.hide();
                    });

                    delBtn.on('mouseover', function () {
                        delBtn.css('background-position', '-48px -0px');
                    }).on('mouseout', function () {
                        delBtn.css('background-position', '-48px -24px');
                    });

                    delBtn.click(function () {
                        $.messager.alert('提示', '是否确认删除？', 'question', function () {
                            Core.ajax(Config.ContextPath + 'service/utils/images/' + item.iid, {
                                type: 'json',
                                method: 'post',
                                data: {
                                    _method: 'delete'
                                }
                            }).then(function (rlt) {
                                if (rlt.isOk) {
                                    $.messager.alert('提醒', '删除成功！');
                                    reloadImage(wiid);
                                } else {
                                    $.messager.alert('提醒', '删除失败，原因：' + rlt.msg, 'warning');
                                    return false;
                                }
                            });
                        });
                    });
                });
            });
        }


    });

    return projectcheckFj;
});