define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var WorkcheckAdd = require('./workcheck.add');
    var Dialog = require('centit/centit.dialog');

	var WorkcheckEdit = WorkcheckAdd.extend(function() {

        this.renderButton = function (btn, data) {
            var flag = false;
            //获取用户角色：1-县区、2-市，3-省
            var wk_usertype = this.parent.panel.find("#wk_usertype").val();
            if(wk_usertype == 1){
                if((data.wtype == 1 && data.status == "00") || data.status == "02"){
                    flag = true;
                }
            } else if(wk_usertype == 2){
                if(data.status == "01" || data.status == "04"
                || (data.wtype == 2 && data.status == "00")){
                    flag = true;
                }
            } else if(wk_usertype == 3){
                if(data.status == "03"){
                    flag = true;
                }
            }
            return flag;
        };

		var _self;
		var usertype;//用户类型1-县区、2-市，3-省
        var wid;
		// @override
		this.load = function(panel, data) {
			_self = this;
			wid = data.wid;
			var form = panel.find('#workcheck_info_form1');
            var form2 = panel.find('#workcheck_info_form2');
            form.form('disableValidation')
                .form('focus');
            var table = this.table = panel.find('#workcheck_info_table');

			Core.ajax(Config.ContextPath+'service/check/workcheck/'+data.wid, {
				type: 'json',
				method: 'get'
			}).then(function(data) {
				_self.data = data;
				//设置总分显示情况
                if(data.xtotalscore != null ){
                    panel.find("#workcheck_info_xtotalscore").show();
                }
                if(data.stotalscore != null ){
                    panel.find("#workcheck_info_stotalscore").show();
                }
                if(data.ptotalscore != null ){
                    panel.find("#workcheck_info_ptotalscore").show();
                }
                //获取登录用户信息
                Core.ajax(Config.ContextPath + 'service/common/getLoginUserUnitInfo', {
                    method: 'get'
                }).then(function (loginUnitInfo) {
                    if(loginUnitInfo.unitType == 3) {//县区级
                        usertype = 1;
                    } else if(loginUnitInfo.unitType == 2) {//市
                        usertype = 2;
                    } else if(loginUnitInfo.unitType == 1){//省
                        usertype = 3;
                    }
                    if(usertype == 1){//县区级-评价时间显示
                        panel.find("#workcheck_info_xtime").show();
                        panel.find("#workcheck_info_stime").hide();
                        panel.find("#workcheck_info_ptime").hide();

                    } else if(usertype  == 2){//市级
                        if(data.xtime != null){
                            panel.find("#workcheck_info_xtime").show();
                        } else {
                            panel.find("#workcheck_info_xtime").hide();
                        }
                        panel.find("#workcheck_info_stime").show();
                        panel.find("#workcheck_info_ptime").hide();

                    } else if(usertype == 3){//省
                        if(data.xtime != null){
                            panel.find("#workcheck_info_xtime").show();
                        } else {
                            panel.find("#workcheck_info_xtime").hide();
                        }
                        panel.find("#workcheck_info_stime").show();
                        panel.find("#workcheck_info_ptime").show();

                        //省总分暂时以录入为准，不录入详细子项
                        panel.find("#workcheck_info_ptotalscore").show();

                        //增加评价结果和综合评价
                        panel.find("#workcheck_info_pjjg").show();
                    }
                    form.form('load', data);
                    if(usertype != 3){
                        form.form('readonly', 'ptotalscore');
                    }
                    form2.form('load', data);
                    var url = "service/check/workcheckitem/itemListByWid/" + data.wid;
                    Core.ajax(Config.ContextPath + url, {
                        method: 'get'
                    }).then(function(list) {
                        if(list != null && list.length > 0){
                            var rlt = list;
                            for(var i = 0 ; i < list.length ; i ++){//数据处理
                                rlt[i].content1 = hh(rlt[i].content1, 5);
                                rlt[i].content3 = hh(rlt[i].content3, 27);
                                rlt[i].details1 = hh(rlt[i].details1, 25);
                                if(usertype == 1){
                                    rlt[i].xscore = " <input name='xscore+" + rlt[i].cid + "' class='in' style='width:50px' " +
                                        "value='" + (rlt[i].xscore != null ? rlt[i].xscore : '' )+ "'>";
                                } else if(usertype == 2){
                                    rlt[i].sscore = " <input name='sscore+" + rlt[i].cid + "' class='in' style='width:50px' " +
                                        "value='" + (rlt[i].sscore != null ? rlt[i].sscore : '' )+ "'>";
                                } else if(usertype == 3){
                                    rlt[i].pscore = " <input name='pscore+" + rlt[i].cid + "' class='in' style='width:50px' " +
                                        "value='" + (rlt[i].pscore != null ? rlt[i].pscore : '' )+ "'>";
                                }
                                var wiid = rlt[i].wiid;
                                if(wiid  == null || wiid == ""){
                                    wiid = uuid();//新增模板新增项
                                }
                                rlt[i].fj = "<button class=\"fjBtn\" id='" + wiid + "'></button>";
                            }
                            table.cdatagrid({
                                controller : _self,
                                onLoadSuccess: function (data) {
                                    mergeCellsByField("workcheck_info_table", "content1");
                                    mergeCellsByField("workcheck_info_table", "content2");
                                }
                            }).datagrid('loadData', rlt);
                            if(usertype == 1){
                                table.datagrid('hideColumn', 'sscore');
                                table.datagrid('hideColumn', 'pscore');
                            } else if(usertype== 2){
                                table.datagrid('hideColumn', 'pscore');
                            }

                            //图片上传
                            _self.panel.find('.fjBtn').bind('click', function(){
                                var i = this.id;
                                var SelectUser = require('modules/check/workcheck/ctrl/workcheck.fj');
                                var _SelectUser = new SelectUser(i);
                                _self.controllers[i] = _SelectUser;
                                _SelectUser.parent = _self;
                                Dialog.open({
                                    id : i,
                                    title : '改善工作评价附件上传',
                                    href : "modules/check/workcheck/workcheck-fj.jsp",
                                    width : 900,
                                    height : 570
                                }, {'wiid':i,'usertype':usertype}, _self.controllers[i]);
                            });

                        }
                    });
                });
                //加载已上传附件
                Core.ajax(Config.ContextPath+'service/attachment/getAttachments/'+2+'/'+data.wid, {
                    type: 'json',
                    method: 'get'
                }).then(function(resdata) {
                    var list = resdata.fjlist;
                    panel.find('#wcinfo_fj_div').empty();//其他家庭成员初始化清空
                    var j = 0;
                    if(list != null && list.length > 0){
                        for(var i = 0; i < list.length ;i++){
                            j = i+1;
                            var obj = list[i];
                            var container = panel.find('#wcinfo_fj_div');
                            var html = '<a href="'+Config.ContextPath+'service/attachment/downloadFJ/'+obj.iid+'" style="color: blue;" id="tzgg_fj">'+j+'、'+obj.ename+'--'+obj.userName+'</a><br>';
                            container.append(html);


                        }
                    }
                });


            });
            //添加附件
            panel.off('click', '#add_fjwc_btn');
            panel.find('#add_fjwc_btn').click(function () {
                var SelectUser = require('modules/check/workcheck/ctrl/workcheck.wjfj');
                var _SelectUser = new SelectUser("workcheckwjfj");
                _self.controllers["workcheckwjfj"] = _SelectUser;
                _SelectUser.parent = _self;
                Dialog.open({
                    id : 'workcheckwjfj',
                    title : '改善项目绩效评价附件上传',
                    href : "modules/check/workcheck/workcheck-wjfj.jsp",
                    width : 900,
                    height : 570
                }, {'wid':wid}, _self.controllers["workcheckwjfj"]);
            });
        };

        //暂存
        // @override
        this.submit = function (panel, data, closeCallback) {
            submitDosomething(panel, data, closeCallback, _self.data.status);
            return false;
        };
        //提交
        this.submitXz = function (panel, data, closeCallback) {
            if( usertype == 1 ){//县区提交
                submitDosomething(panel, data, closeCallback, '01');
            } else if( usertype == 2 ) {//市提交
                submitDosomething(panel, data, closeCallback, '03');
            } else if( usertype == 3 ) {//省提交
                submitDosomething(panel, data, closeCallback, '05');
            } else {
                $.messager.alert('提醒', '用户身份验证错误，请刷新页面后重新提交！');
            }
            return false;
        };

        //退回
        this.submitTh = function (panel, data, closeCallback) {
            if( usertype == 2 ) {//市退回
                if(_self.data.wtype != 2){//市不能退回自己的
                    submitDosomething(panel, data, closeCallback, '02');
                } else {
                    $.messager.alert('提醒', '无退回权限！市不可退回自己新增的绩效评价考核！');
                    return false;
                }
            } else if( usertype == 3 ) {//省退回
                submitDosomething(panel, data, closeCallback, '04');
            } else {
                $.messager.alert('提醒', '用户身份验证错误，请刷新页面后重新退回！');
            }
            return false;
        };

        // @override
        var submitDosomething = function (panel, data, closeCallback, status) {
            //状态赋值
            panel.find("#wk_status").textbox('setValue', status);
            var form = panel.find('#workcheck_info_form1');
            var form2 = panel.find('#workcheck_info_form2');
            // 开启校验
            form.form('enableValidation');
            var isValid = form.form('validate');
            var obj = form.form('value');//主表数据
            var obj2 = form2.form('value');//省级评价结果
            var table = panel.find('#workcheck_info_table');
            var rows = table.datagrid('getData').rows;//子表数据
            //校验评价时间
            if(status != "02" && status != "04"){//退回不修改数据，只做状态处理
                if(usertype == 1 && (obj.xtime  == null || obj.xtime == "")){//县编辑填写评分时间
                    isValid = false;
                    $.messager.alert('提醒', '县区评分时间不可为空！');
                } else if(usertype == 2 && (obj.stime  == null || obj.stime == "")){//市编辑填写评分时间
                    $.messager.alert('提醒', '市评分时间不可为空！');
                    isValid = false;
                } else if(usertype == 3 && (obj.ptime  == null || obj.ptime == "")){//省编辑填写评分时间
                    $.messager.alert('提醒', '省评分时间不可为空！');
                    isValid = false;
                } else if(usertype == 3 && (obj2.wresult  == null || obj2.wresult == "")){//省编辑填写评价结果
                    $.messager.alert('提醒', '省评价结果不可为空！');
                    isValid = false;
                } else {
                    if(usertype != 3){//省总分暂时以录入为准，不录入详细子项,不进行校验
                        //分值校验
                        if(rows != null && rows.length > 0){
                            var reg1=/(^[0-9]{1,2}$)|(^[0-9]{1,2}[\.]{1}[0-9]{1,2}$)/;
                            for(var i = 0 ; i < rows.length ; i++) {
                                var row = rows[i];
                                var xsc;
                                if(usertype == 1){//县区
                                    xsc = $("input[name='xscore+" + row.cid + "']").val();
                                } else if(usertype == 2){//市
                                    xsc = $("input[name='sscore+" + row.cid + "']").val();
                                } else if(usertype == 3){//省
                                    xsc = $("input[name='pscore+" + row.cid + "']").val();
                                }
                                var jy = checkFz(xsc,row.maxval);
                                if(!jy.isOk){
                                    $.messager.alert('提醒', '第' + (i+1) + '个项得分检验失败，不可保存！原因：' + jy.msg);
                                    isValid = false;
                                    break;
                                }
                            }
                        } else {
                            $.messager.alert('提醒', '无评分项，不可保存！');
                            isValid = false;
                        }
                    }
                }
            }
            if (isValid) {
                //保存主表
                form.form('ajax', {
                    url: Config.ContextPath + 'service/check/workcheck',
                    method: 'post',
                    data: obj2,
                }).then(function(data) {
                    if(data.isOk == false){
                        $.messager.alert('提醒', data.msg);
                    } else {
                        data = data.obj;
                        if(status != "02" && status != "04") {//退回不修改数据，只做状态处理，子表不保存
                            //保存子表
                            var list = new Array();
                            for(var i = 0 ; i < rows.length ; i++){
                                var row = rows[i];
                                var temp = new Object();
                                temp.wid = data.wid;
                                temp.cid = row.cid;
                                temp.wiid = row.wiid;
                                if(usertype == 1){
                                    temp.score = $("input[name='xscore+" + row.cid + "']").val();
                                } else if(usertype == 2){
                                    temp.score = $("input[name='sscore+" + row.cid + "']").val();
                                } else if(usertype == 3){
                                    temp.score = $("input[name='pscore+" + row.cid + "']").val();
                                }
                                temp.wtype = usertype;
                                list[i] = temp;
                            }
                            var json =JSON.stringify(list);
                            Core.ajax(Config.ContextPath + 'service/check/workcheckitem/saveWorkcheckitems', {
                                method: 'post',
                                type: 'json',
                                traditional: true,
                                data:{"list":json},
                            }).then(function(rlt) {
                                closeCallback();
                            });
                        } else{
                            closeCallback();
                        }
                    }

                });
            }

            return false;
        };

        // @override
        this.onClose = function(table) {
            table.datagrid('reload');
        };

        //换行
        var hh = function (str,len) {
            var newstr = "";
            if(str != null){
                var strs = str.split("");
                for(var j = 0 ; j < strs.length;j++ ){
                    if((j+1)%len == 0){
                        newstr += '<br>'+strs[j];
                    } else {
                        newstr += strs[j];
                    }
                }
            }
            return newstr;
        }
        function mergeCellsByField(tableID, colList) {
            var ColArray = colList.split(",");
            var tTable = $("#" + tableID);
            var TableRowCnts = tTable.datagrid("getRows").length;
            var tmpA;
            var tmpB;
            var PerTxt = "";
            var CurTxt = "";
            var buyprocode = "";
            var newbuyprocode = "";
            var alertStr = "";
            for (j = ColArray.length - 1; j >= 0; j--) {
                PerTxt = "";
                buyprocode = "";
                tmpA = 1;
                tmpB = 0;

                for (i = 0; i <= TableRowCnts; i++) {
                    if (i == TableRowCnts) {
                        CurTxt = "";
                        newbuyprocode = "";
                    }
                    else {
                        CurTxt = tTable.datagrid("getRows")[i][ColArray[j]];
                        newbuyprocode = tTable.datagrid("getRows")[i]["buyprojectCode"];
                    }
                    if (PerTxt == CurTxt && buyprocode == newbuyprocode) {
                        tmpA += 1;
                    }
                    else {
                        tmpB += tmpA;

                        tTable.datagrid("mergeCells", {
                            index: i - tmpA,
                            field: ColArray[j],　　//合并字段
                            rowspan: tmpA,
                            colspan: null
                        });
                        tTable.datagrid("mergeCells", { //根据ColArray[j]进行合并
                            index: i - tmpA,
                            field: "Ideparture",
                            rowspan: tmpA,
                            colspan: null
                        });

                        tmpA = 1;
                    }
                    PerTxt = CurTxt;
                    buyprocode = newbuyprocode;
                }
            }
        }
        //校验项得分
        function checkFz(score ,max) {
            var obj = new Object();
            var reg1=/(^[0-9]{1,2}$)|(^[0-9]{1,2}[\.]{1}[0-9]{1,2}$)/;
            if(score == null || score == undefined || score == 'undefined' || score == '' || score == 'null'){
                obj.isOk = false;
                obj.msg = "得分为空";
            } else if(parseFloat(score).toString() == "NaN"){
                obj.isOk = false;
                obj.msg = "得分不为数字";
            } else if(!reg1.test(parseFloat(score).toString())){
                obj.isOk = false;
                obj.msg = "得分小于0或不是保留两位小数的数字";
            } else if(parseFloat(score) > parseFloat(max)){
                obj.isOk = false;
                obj.msg = "得分超过标准分值";
            } else {
                obj.isOk = true;
            }
            return obj;
        }

        //生成子表的id，附件、子表2个使用
        function uuid() {
            function S4() {
                return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
            }
            return (S4() + S4() +  S4() + S4()  + S4() + S4() + S4() + S4());

        }
    });

    return WorkcheckEdit;
});