define(function(require) {
	var Config = require('config');
	var Page = require('core/page');
    var Core = require('core/core');
    var Dialog = require('centit/centit.dialog');

	var WorkcheckAdd = Page.extend(function() {
		var _self;
		var wtype;
		// @override
		this.load = function(panel, data) {
		    _self = this;
            wtype = null;
			var form = panel.find('#workcheck_info_form1');
            var table = this.table = panel.find('#workcheck_info_table');
            table.cdatagrid({
                controller: this,
            });
			form.form('disableValidation')
			.form('focus');

            //获取登录用户信息
            Core.ajax(Config.ContextPath + 'service/common/getLoginUserUnitInfo', {
                method: 'get'
            }).then(function (loginUnitInfo) {
                data = new Object();
                if(loginUnitInfo != null){
                    if(loginUnitInfo.unitType == 3){//县区级
                        wtype = 1;
                        data.wtype = wtype;
                        data.xzqh = loginUnitInfo.city + loginUnitInfo.county;
                        panel.find("#workcheck_info_xtime").show();
                        panel.find("#workcheck_info_stime").hide();
                        panel.find("#workcheck_info_ptime").hide();
                    } else if(loginUnitInfo.unitType == 2){//市级
                        wtype = 2;
                        data.wtype = wtype;
                        data.xzqh = loginUnitInfo.city;
                        panel.find("#workcheck_info_xtime").hide();
                        panel.find("#workcheck_info_stime").show();
                        panel.find("#workcheck_info_ptime").hide();
                    }
                }
                form.form('load', data);//主表数据初始化
                var url = "service/check/workcheck/wx/checktemplateList?ctype=" + data.wtype;
                Core.ajax(Config.ContextPath + url, {
                    method: 'get'
                }).then(function(list) {
                    if(list != null && list.length > 0){
                        var rlt = list;
                        for(var i = 0 ; i < list.length ; i ++){//数据处理
                            rlt[i].content1 = hh(rlt[i].content1, 5);
                            rlt[i].content3 = hh(rlt[i].content3, 27);
                            rlt[i].details1 = hh(rlt[i].details1, 25);
                            if(data.wtype == 1){
                                rlt[i].xscore = " <input name='xscore+" + rlt[i].cid + "' class='in' style='width:50px' >";
                            }else if(data.wtype == 2){
                                rlt[i].sscore = " <input name='sscore+" + rlt[i].cid + "' class='in' style='width:50px' >";
                            }
                            var wiid = uuid();//页面自生成id
                            rlt[i].wiid = wiid;
                            rlt[i].fj = "<button class=\"fjBtn\" id='" + wiid + "'></button>";
                        }
                        table.cdatagrid({
                            controller : _self,
                            onLoadSuccess: function (data) {
                                mergeCellsByField("workcheck_info_table", "content1");
                                mergeCellsByField("workcheck_info_table", "content2");
                            }
                        }).datagrid('loadData', rlt);
                        if(data.wtype == 1){
                            table.datagrid('hideColumn', 'sscore');
                            table.datagrid('hideColumn', 'pscore');
                        } else if(data.wtype == 2){
                            table.datagrid('hideColumn', 'xscore');
                            table.datagrid('hideColumn', 'pscore');
                        }
                        //图片上传
                        _self.panel.find('.fjBtn').bind('click', function(){
                            var i = this.id;
                            var SelectUser = require('modules/check/workcheck/ctrl/workcheck.fj');
                            var _SelectUser = new SelectUser(i);
                            _self.controllers[i] = _SelectUser;
                            _SelectUser.parent = _self;
                            Dialog.open({
                                id : i,
                                title : '改善工作评价附件上传',
                                href : "modules/check/workcheck/workcheck-fj.jsp",
                                width : 900,
                                height : 570
                            }, {'wiid':i,'usertype':wtype}, _self.controllers[i]);
                        });

                    }
                });
            })

            var wid = uuid();
            panel.find("#wid").val(wid);
            //添加附件
            panel.off('click', '#add_fjwc_btn');
            panel.find('#add_fjwc_btn').click(function () {
                var SelectUser = require('modules/check/workcheck/ctrl/workcheck.wjfj');
                var _SelectUser = new SelectUser("workcheckwjfj");
                _self.controllers["workcheckwjfj"] = _SelectUser;
                _SelectUser.parent = _self;
                Dialog.open({
                    id : 'workcheckwjfj',
                    title : '改善项目绩效评价附件上传',
                    href : "modules/check/workcheck/workcheck-wjfj.jsp",
                    width : 900,
                    height : 570
                }, {'wid':wid}, _self.controllers["workcheckwjfj"]);
            });

		};

        //暂存
        // @override
        this.submit = function (panel, data, closeCallback) {
            submitDosomething(panel, data, closeCallback, '00');
            return false;
        };
        //提交
        this.submitXz = function (panel, data, closeCallback) {
            if( wtype == 1 ){//县区提交
                submitDosomething(panel, data, closeCallback, '01');
            } else if( wtype == 2 ) {//市提交
                submitDosomething(panel, data, closeCallback, '03');
            } else {
                $.messager.alert('提醒', '用户身份错误，请刷新后重新新增！');
            }
            return false;
        };

        //保存或提交
        var submitDosomething = function (panel, data, closeCallback, status){
            //状态赋值
            panel.find("#wk_status").textbox('setValue', status);
			var form = panel.find('#workcheck_info_form1');
			// 开启校验
			form.form('enableValidation');
			var isValid = form.form('validate');
			var obj = form.form('value');//主表数据
            var table = panel.find('#workcheck_info_table');
            var rows = table.datagrid('getData').rows;//子表数据
            //校验评价时间
            if(wtype == 1 && (obj.xtime  == null || obj.xtime == "")){//县自评填写评分时间
                isValid = false;
                $.messager.alert('提醒', '县区评分时间不可为空！');
            } else if(wtype == 2 && (obj.stime  == null || obj.stime == "")){//市自评填写评分时间
                $.messager.alert('提醒', '市评分时间不可为空！');
                isValid = false;
            } else {
                //分值校验
                if(rows != null && rows.length > 0){
                    var reg1=/(^[0-9]{1,2}$)|(^[0-9]{1,2}[\.]{1}[0-9]{1,2}$)/;
                    for(var i = 0 ; i < rows.length ; i++) {
                        var row = rows[i];
                        var xsc;
                        if(wtype == 1){//县区
                            xsc = $("input[name='xscore+" + row.cid + "']").val();
                        } else {//市
                            xsc = $("input[name='sscore+" + row.cid + "']").val();
                        }
                        var jy = checkFz(xsc,row.maxval);
                        if(!jy.isOk){
                            $.messager.alert('提醒', '第' + (i+1) + '个项得分检验失败，不可保存！原因：' + jy.msg);
                            isValid = false;
                            break;
                        }
                    }
                } else {
                    $.messager.alert('提醒', '无评分项，不可保存！');
                    isValid = false;
                }
            }
			if (isValid) {
                    //保存主表
                    form.form('ajax', {
                        url: Config.ContextPath + 'service/check/workcheck',
                        method: 'post',
                    }).then(function(data) {
                        if(data.isOk == false){
                            $.messager.alert('提醒', data.msg);
                        } else {
                            data = data.obj;
                            //保存子表
                            var list = new Array();
                            for(var i = 0 ; i < rows.length ; i++){
                                var row = rows[i];
                                var temp = new Object();
                                temp.wid = data.wid;
                                temp.cid = row.cid;
                                temp.wiid = row.wiid;
                                if(wtype == 1){
                                    temp.score = $("input[name='xscore+" + row.cid + "']").val();
                                } else if(wtype == 2){
                                    temp.score = $("input[name='sscore+" + row.cid + "']").val();
                                }
                                temp.wtype = wtype;
                                list[i] = temp;
                            }
                            var json =JSON.stringify(list);
                            Core.ajax(Config.ContextPath + 'service/check/workcheckitem/saveWorkcheckitems', {
                                method: 'post',
                                type: 'json',
                                traditional: true,
                                data:{"list":json},
                            }).then(function(rlt) {
                                closeCallback();
                            });
                        }

                    });
			}
			
			return false;
		};
		
		// @override 
		this.onClose = function(table, data) {
			table.datagrid('reload');
		};

        //校验项得分
        function checkFz(score ,max) {
            var obj = new Object();
            var reg1=/(^[0-9]{1,2}$)|(^[0-9]{1,2}[\.]{1}[0-9]{1,2}$)/;
            if(score == null || score == undefined || score == 'undefined' || score == '' || score == 'null'){
                obj.isOk = false;
                obj.msg = "得分为空";
            } else if(parseFloat(score).toString() == "NaN"){
                obj.isOk = false;
                obj.msg = "得分不为数字";
            } else if(!reg1.test(parseFloat(score).toString())){
                obj.isOk = false;
                obj.msg = "得分小于0或不是保留两位小数的数字";
            } else if(parseFloat(score) > parseFloat(max)){
                obj.isOk = false;
                obj.msg = "得分超过标准分值";
            } else {
                obj.isOk = true;
            }
            return obj;
        }


        function mergeCellsByField(tableID, colList) {
            var ColArray = colList.split(",");
            var tTable = $("#" + tableID);
            var TableRowCnts = tTable.datagrid("getRows").length;
            var tmpA;
            var tmpB;
            var PerTxt = "";
            var CurTxt = "";
            var buyprocode = "";
            var newbuyprocode = "";
            var alertStr = "";
            for (j = ColArray.length - 1; j >= 0; j--) {
                PerTxt = "";
                buyprocode = "";
                tmpA = 1;
                tmpB = 0;

                for (i = 0; i <= TableRowCnts; i++) {
                    if (i == TableRowCnts) {
                        CurTxt = "";
                        newbuyprocode = "";
                    }
                    else {
                        CurTxt = tTable.datagrid("getRows")[i][ColArray[j]];
                        newbuyprocode = tTable.datagrid("getRows")[i]["buyprojectCode"];
                    }
                    if (PerTxt == CurTxt && buyprocode == newbuyprocode) {
                        tmpA += 1;
                    }
                    else {
                        tmpB += tmpA;

                        tTable.datagrid("mergeCells", {
                            index: i - tmpA,
                            field: ColArray[j],　　//合并字段
                            rowspan: tmpA,
                            colspan: null
                        });
                        tTable.datagrid("mergeCells", { //根据ColArray[j]进行合并
                            index: i - tmpA,
                            field: "Ideparture",
                            rowspan: tmpA,
                            colspan: null
                        });

                        tmpA = 1;
                    }
                    PerTxt = CurTxt;
                    buyprocode = newbuyprocode;
                }
            }
        }

        //换行
        var hh = function (str,len) {
            var newstr = "";
            if(str != null){
                var strs = str.split("");
                for(var j = 0 ; j < strs.length;j++ ){
                    if((j+1)%len == 0){
                        newstr += '<br>'+strs[j];
                    } else {
                        newstr += strs[j];
                    }
                }
            }
            return newstr;
        }

        //生成子表的id，附件、子表2个使用
        function uuid() {
            function S4() {
                return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
            }
            return (S4() + S4() +  S4() + S4()  + S4() + S4() + S4() + S4());

        }
	});
	
	return WorkcheckAdd;
});