<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<div class="easyui-layout" fit="true">
	<div data-options="region:'center'" border="false" style="padding: 4px;">
		<div class="easyui-layout" fit="true" id="projectcheck-info-main">
			<div region="north" border="false" style="height: 60px; padding: 4px;">
				<div class="easyui-panel search-body" cls="search" style="width: 100%; margin-bottom: 0;">
					<form class="clearFromValue"  id="projectcheck_search_form">
						<div class="search-item">
							<label>状态</label>
							<input class="easyui-combobox" name="s_status"
								   target="dictionary"
								   key="khStatus" style="width: 150px;"/>
						</div>
						<div class="search-item">
							<label>考核年份</label>
							<input type="text" class="easyui-combobox"  name="s_wyear"
								   url="service/common/getYearList/10" method="get" data-options="valueField:'year',textField:'year'"/>
						</div>
						<div class="search-item">
							<label>行政区划</label>
							<input type="text" class="easyui-combobox" name="s_city" id="sjsecond" method="get" style="width: 90px"/>
							&nbsp;
							<input type="text" class="easyui-combobox" name="s_county" id="sjthird" method="get" style="width: 100px"/>
							&nbsp;
						</div>
						<div class="search-item">
							<label>改善项目</label>
							<input type="text" class="easyui-textbox"
								  name="s_houseName"/>
						</div>

						<a class="easyui-linkbutton btn-search" iconCls="icon-search" id="projectcheck_search">查询</a>
						<input type="hidden" id="dqRoleCode" name="dqRoleCode">
					</form>
				</div>
			</div>
			<div region="center" border="false" style="padding: 4px;">
				<table id="projectcheck_table"
					   fitColumns="true"
					   idField="pid"
					   search=".search"
					   rownumbers="false"
					   sortName="updatetime"
					   sortOrder="desc"
					   toolbar=".temp-toolbar" action="projectcheck_view"  layoutH="0">
					<thead>
					<tr>
						<th data-options="field:'pid'" hidden>主键</th>
						<th data-options="field:'status',width:100" align="center" format="Dictionary:khStatus"  >状态</th>
						<th data-options="field:'ptype' ,width:100" align="center" format="Dictionary:PtCheckHouseType"  >类别</th>
						<th data-options="field:'houseName',width:100" align="center"  >改善项目</th>
						<%--<th data-options="field:'city',width:100" align="center"  >市代码</th>--%>
						<th data-options="field:'county',width:100" align="center"  >行政区划</th>
						<th data-options="field:'wyear',width:100" align="center"  >考核年份</th>
						<th data-options="field:'xtotalscore',width:100" align="center"  >县考核总分</th>
						<th data-options="field:'stotalscore',width:100" align="center" >市考核总分</th>
						<th data-options="field:'ptotalscore',width:100" align="center"  >省考核总分</th>
						<th data-options="field:'isparticular',width:100" align="center" format="Dictionary:YesOrNo" >省级特色田园乡村</th>
						<th data-options="field:'updatetime',width:100" format="Date:yyyy-MM-dd" align="center" >更新时间</th>
						<%--<th data-options="field:'wresult',width:100"  align="center" format="Dictionary:wresultStatus">评价结果</th>
						<th data-options="field:'xtime',width:100" format="Date:yyyy-MM-dd"  align="center"  >县考核时间</th>
						<th data-options="field:'stime',width:100" format="Date:yyyy-MM-dd"  align="center"  >市考核时间</th>
						<th data-options="field:'ptime',width:100" format="Date:yyyy-MM-dd"  align="center"  >省考核时间</th>
							<th data-options="field:'xusername'" align="center"  width="9%">县考核用户</th>
                            <th data-options="field:'susername'" align="center"  width="9%">市考核用户</th>
                            <th data-options="field:'pusername'" align="center"  width="9%">省考核用户</th>
                                    <th data-options="field:'isnotok'">是否一票否决</th>
                                <th data-options="field:'isnotokreason'">一票否决清单（原因）</th>
                                <th data-options="field:'wresult'">评价结果</th>
                                <th data-options="field:'wevaluation'">综合评价</th>
                                <th data-options="field:'remarks'">备注</th>
                                <th data-options="field:'userName'">填报人姓名</th>
                                <th data-options="field:'userCode'">填报人编号</th>
                                <th data-options="field:'unitCode'">部门（行政区划）</th>
                                <th data-options="field:'createtime'">创建时间</th>
						--%>
					</tr>
					</thead>
				</table>
				<div class="temp-toolbar">
					<a iconCls="icon-add" href="modules/check/projectCheck/projectcheck-info.jsp" trigger="none"
					   target="dialog" rel="projectcheck_add" id="projectcheck_add_btn" title="新增改善项目考核验收表"width="1300" height="600"
					   buttons="[{method:'submit',text:'暂存并退出'},{method:'submitXz',text:'确认并提交'}]">新增</a>
					<hr>

					<a iconCls="icon-edit" href="modules/check/projectCheck/projectcheck-info.jsp" trigger="single"
					   target="dialog" rel="projectcheck_editx" id="projectcheck_edit_xbtn"
					   title="编辑{{wyear}}-{{county}}" width="1300"
					   height="600" buttons="[{method:'submit',text:'暂存并退出'},{method:'submitXz',text:'确认并提交'}]">编辑</a>
					<hr>
					<a iconCls="icon-edit" href="modules/check/projectCheck/projectcheck-info.jsp" trigger="single"
					   target="dialog" rel="projectcheck_editps" id="projectcheck_edit_psbtn"
					   title="编辑 {{wyear}}-{{county}}" width="1300"
					   height="600" buttons="[{method:'submit',text:'暂存并退出'},{method:'submitXz',text:'确认并提交'},{method:'submitTh',text:'退回'}]">编辑</a>
					<hr>
					<a iconCls="icon-edit" href="modules/check/projectCheck/projectcheck-view.jsp" trigger="single"
					   target="dialog" rel="projectcheck_view" title="查看 {{wyear}}-{{county}}" width="1300" height="600" btnValue="查看">查看</a>
					<hr>

					<a iconCls="icon-base icon-base-ban" trigger="single"
					   target="confirm" rel="projectcheck_remove" title="是否确定删除 {{text}}？">删除</a>
				</div>
			</div>
		</div>
	</div>
</div>

<script>
    $.parser.onComplete = function (panel) {
        $.parser.onComplete = $.noop;
        requirejs([
            'core/filter/filter.dictionary',
            'modules/check/projectCheck/ctrl/projectcheck','css!plugins/viewer/viewer.min.css'
        ], function (FilterDictionary,Projectcheck) {
            FilterDictionary.add([
                'PtCheckHouseType', 'villageType','khStatus','wresultStatus',"HouseType",'YesOrNo']).then(function () {
                window.Projectcheck = new Projectcheck('projectcheck', panel);
                window.Projectcheck.load(panel);
            })
        });
    };

</script>
