define(function(require) {
	var Config = require('config');
	var Core = require('core/core');
	var Page = require('core/page');
    var Dialog = require('centit/centit.dialog');

    var ProjectcheckExp = require('../ctrl/projectcheck.exp');

	var ProjectcheckView = Page.extend(function() {

        this.injecte([
            new ProjectcheckExp('projectcheck_exp'),
        ]);

        var  _self;
        var emodule = 5;//图片一级分类
        var itemscount = 0;//表格行数
		
		// @override
		this.load = function(panel, data) {
            _self=this;
            var form = panel.find('#pjcheck_view_form1');
            var form2 = panel.find('#pjcheck_view_form2');
            var table = _self.panel.find('#projectcheck_view_table');
            table.cdatagrid({
                controller: this
            });
            form.form('disableValidation')
                .form('focus');

            Core.ajax(Config.ContextPath+'service/check/projectcheck/'+data.pid, {
                type: 'json',
                method: 'get'
            }).then(function(data) {
                _self.data = data;
                pid = data.pid;
                var ptype = data.ptype;
                form.form('load', data)
                    .form('disableValidation')
                    .form('readonly', 'pid')
                    .form('focus');
                form2.form('load', data);
                var roleCode = _self.parent.panel.find("#dqRoleCode").val();
                if(roleCode == '0010'){
                    _self.panel.find("#projectcheck_view_isparticular_div").show();
                }


                Core.ajax(Config.ContextPath+'service/check/checktemplate?isPage=f&sort=sorts&order=asc&s_ctype='+ptype+'&pid='+pid, {
                    method: 'get'
                }).then(function(list) {
                    var rlt = list.objList;
                    itemscount = rlt.length;
                    for(var i = 0 ; i < rlt.length; i++) {
                        rlt[i].content1 = hh(rlt[i].content1, 7);
                        rlt[i].content3 = hh(rlt[i].content3, 56);
                        var piid = rlt[i].piid;
                        rlt[i].fj = "<button   class='fjBtn'  id='filebtn_"+piid+"'></button>";

                    }

                    loadTable(rlt,table);
                    if(roleCode == '0011'){
                        _self.panel.find('#projectcheck_view_table').datagrid('hideColumn','pscore');
                    }
                    if(roleCode == '0012'){
                        _self.panel.find('#projectcheck_view_table').datagrid('hideColumn','pscore');
                        _self.panel.find('#projectcheck_view_table').datagrid('hideColumn','sscore');
                    }
                    _self.panel.find('.fjBtn').bind('click', function(){
                        var i=this.id.split("_")[1];
                        var SelectUser = require('modules/check/projectCheck/ctrl/projectcheck.fj.view');
                        var _SelectUser = new SelectUser(i);
                        _self.controllers[i] = _SelectUser;
                        _SelectUser.parent = _self;
                        Dialog.open({
                            id : i,
                            title : '考核验收附件上传',
                            href : "modules/check/projectCheck/projectcheck-fj-view.jsp",
                            width : 900,
                            height : 570
                        }, {'wid':i}, _self.controllers[i]);

                    });





                });
                //流程表加载
                var lc_table = panel.find("#pcheck_lc_table");
                lc_table.cdatagrid({
                    controller: self
                });
                Core.ajax(Config.ContextPath + 'service/utils/pmpWfRecord?s_wid=' + data.pid + '&s_wmodule=5', {
                    type: 'json',
                    method: 'get'
                }).then(function (resData) {
                    var lcList = resData.objList;
                    lc_table.cdatagrid({
                        // 必须要加此项!!
                        controller: self
                    }).datagrid('loadData', lcList);
                });


                //加载已上传附件
                Core.ajax(Config.ContextPath+'service/attachment/getAttachments/'+1+'/'+data.pid, {
                    type: 'json',
                    method: 'get'
                }).then(function(resdata) {
                    var list = resdata.fjlist;
                    panel.find('#pcinfo_fj_div').empty();//其他家庭成员初始化清空
                    var j = 0;
                    if(list != null && list.length > 0){
                        for(var i = 0; i < list.length ;i++){
                            j = i+1;
                            var obj = list[i];
                            var container = panel.find('#pcinfo_fj_div');
                            var html = '<a href="'+Config.ContextPath+'service/attachment/downloadFJ/'+obj.iid+'" style="color: blue;" id="tzgg_fj">'+j+'、'+obj.ename+'--'+obj.userName+'</a><br>';
                            container.append(html);


                        }
                    }
                });

            });
		};


        function loadTable(rlt,table) {
            table.cdatagrid({
                controller : _self,
                onLoadSuccess: function (data) {
                    mergeCellsByField("projectcheck_view_table", "content1");
                }
            }).datagrid('loadData', rlt);


        }

        function mergeCellsByField(tableID, colList) {
            var ColArray = colList.split(",");
            var tTable = $("#" + tableID);
            var TableRowCnts = tTable.datagrid("getRows").length;
            var tmpA;
            var tmpB;
            var PerTxt = "";
            var CurTxt = "";
            var buyprocode = "";
            var newbuyprocode = "";
            var alertStr = "";
            for (j = ColArray.length - 1; j >= 0; j--) {
                PerTxt = "";
                buyprocode = "";
                tmpA = 1;
                tmpB = 0;

                for (i = 0; i <= TableRowCnts; i++) {
                    if (i == TableRowCnts) {
                        CurTxt = "";
                        newbuyprocode = "";
                    }
                    else {
                        CurTxt = tTable.datagrid("getRows")[i][ColArray[j]];
                        newbuyprocode = tTable.datagrid("getRows")[i]["buyprojectCode"];
                    }
                    if (PerTxt == CurTxt && buyprocode == newbuyprocode) {
                        tmpA += 1;
                    }
                    else {
                        tmpB += tmpA;

                        tTable.datagrid("mergeCells", {
                            index: i - tmpA,
                            field: ColArray[j],　　//合并字段
                            rowspan: tmpA,
                            colspan: null
                        });
                        tTable.datagrid("mergeCells", { //根据ColArray[j]进行合并
                            index: i - tmpA,
                            field: "Ideparture",
                            rowspan: tmpA,
                            colspan: null
                        });

                        tmpA = 1;
                    }
                    PerTxt = CurTxt;
                    buyprocode = newbuyprocode;
                }
            }
        }

    //换行
    var hh = function (str,len) {
        var newstr = "";
        if(str != null){
            var strs = str.split("");
            for(var j = 0 ; j < strs.length;j++ ){
                if((j+1)%len == 0){
                    newstr += '<br>'+strs[j];
                } else {
                    newstr += strs[j];
                }
            }
        }
        return newstr;
    }
    });
	return ProjectcheckView;
});