define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');

    
    var ProjectcheckAdd = require('./projectcheck.add');
    var ProjectcheckEditX = require('./projectcheck.edit');
    var ProjectcheckEditPs = require('./projectcheck.editps');
    var ProjectcheckView = require('./projectcheck.view');
    var ProjectcheckRemove = require('./projectcheck.remove');

    // 业务信息
    var Projectcheck = Page.extend(function() {
        var _self;
    	this.injecte([
          new ProjectcheckAdd('projectcheck_add'),
          new ProjectcheckEditX('projectcheck_editx'),
          new ProjectcheckEditPs('projectcheck_editps'),
          new ProjectcheckView('projectcheck_view'),
          new ProjectcheckRemove('projectcheck_remove')
    	]);
    	
    	// @override
    	this.load = function(panel) {
            _self=this;
            this.$autoHeight('north', panel.find('#projectcheck-info-main', panel));
            //市
            panel.find('#sjsecond').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfoSecond?code=320000000000",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            panel.find('#sjsecond').combobox('select', da["unitCode"]);
                            panel.find("#sjsecond").combobox('readonly', true);
                        }
                    }

                }
            });
            //区县
            panel.find('#sjthird').combobox({
                url: Config.ContextPath + "service/jhgswork/getUnitInfothird",
                valueField: 'unitCode',
                textField: 'unitName',
                onLoadSuccess: function (data) {
                    var da = data[0];
                    if (da != undefined) {
                        if (da["yhjb"] == "fsj") {
                            panel.find('#sjthird').combobox('select', da["unitCode"]);
                            panel.find("#sjthird").combobox('readonly', true);
                        }
                    }

                }
            });
            //市改变
            panel.find('#sjsecond').combobox({
                onChange: function() {
                    var code = panel.find('#sjsecond').combobox('getValue');
                    panel.find('#sjthird').combobox('clear');
                    // 重新获取数据
                    panel.find('#sjthird').combobox('reload', Config.ContextPath+'service/jhgswork/getUnitInfothird?code=' + code);
                }
            });
            //根据权限设置操作按钮
            Core.ajax(Config.ContextPath+'service/common/getLoginUserRoles', {
                method: 'get'
            }).then(function(rlt) {
                var isX = false;//县区
                var isPs = false;//市、省

                panel.find("#dqRoleCode").val(rlt[1].roleCode);
                for(var i = 0 ; i < rlt.length ; i++){
                    if(rlt[i].roleCode == '0010'||rlt[i].roleCode == '0011'){
                        isPs = true;
                        break;
                    }

                    if(rlt[i].roleCode == '0012'){
                        isX = true;
                        break;
                    }

                }

                if(isX){
                    panel.find('#projectcheck_edit_psbtn, #projectcheck_edit_psbtn + hr', panel).remove();
                    panel.find('#projectcheck_edit_psbtn').parent('td').next().remove();
                }
                if(isPs){
                    panel.find('#projectcheck_add_btn, #projectcheck_add_btn + hr', panel).remove();
                    panel.find('#projectcheck_add_btn').parent('td').next().remove();
                    panel.find('#projectcheck_edit_xbtn, #projectcheck_edit_xbtn + hr', panel).remove();
                    panel.find('#projectcheck_edit_xbtn').parent('td').next().remove();

                }

            });

            var url = "service/check/projectcheck";
            var table = this.table = panel.find('table');

            table.cdatagrid({
                controller: this,
                url: url,
                onLoadSuccess:function(data){
                    Core.ajax(Config.ContextPath+'service/common/getLoginUserRoles', {
                        method: 'get'
                    }).then(function(rlt) {
                        var isSt = false;
                        for(var i = 0 ; i < rlt.length ; i++){
                            if(rlt[i].roleCode == '0010'){
                                isSt = true;
                                break;
                            }
                        }
                        if(!isSt){
                            table.cdatagrid("hideColumn", "isparticular"); // 设置隐藏列
                        }
                    });
                }
            });








    	};

    	
    });

    return Projectcheck;
});