define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var Dialog = require('centit/centit.dialog');
    var $ = require('jquery');
    var ajaxSubmit = require('plugins/jquery.form');

    var projectcheckFj = Page.extend(function() {

        var _self;

        var emodule = 5;//图片一级分类
        // @override
        this.load = function(panel,data) {
            _self=this;
            var wid = data.wid;//piid关联主键
            var isView = data.isView;//是否可上传 1——可上传
            var roleCode = data.roleCode;//是否可上传 1——可上传 0--只查看
            if (isView=='1'){
                if(roleCode=='0010'){//省
                    $('#ptype_btn').show();
                }
                if(roleCode=='0011'){//市
                    $('#stype_btn').show();
                }
                if(roleCode=='0012'){//县
                    $('#xtype_btn').show();
                }
            }

            //加载图片
            reloadImage(wid) ;

            panel.find('#xtype_btn').click(function () {
                showUploadDialog('xtype',wid);
            });
            panel.find('#stype_btn').click(function () {
                showUploadDialog('stype',wid);
            });
            panel.find('#ptype_btn').click(function () {
                showUploadDialog('ptype',wid);
            });

        };

        function showUploadDialog(type1,wid) {
            new BUpload({
                upload_url: Config.ContextPath + 'service/utils/images/uploadFile?type='+emodule+'&rid=' + wid + '&type1=' + type1,
                ext_allow: "png|jpg|jpeg",
                ext_refuse: "exe|bat",
                max_filesize: 1024, //KB
                max_filenum: 10,
                callback: function () {
                    reloadImage(wid);
                }
            });
        }
        function reloadImage(wid) {
            Core.ajax(Config.ContextPath + 'service/utils/images/getAttachmentsBTY/'+emodule+'/' + wid, {
                type: 'json',
                method: 'get'
            }).then(function (data) {
                $('#images_xtype').empty();
                $('#images_stype').empty();
                $('#images_ptype').empty();
                $.each(data.fjList, function (index, item) {
                    // 主
                    var itemdiv = $('<div>', {}).css({
                        height: '113px',
                        margin: '3px',
                        float: 'left',
                        position: 'relative'
                    }).appendTo($('#images_'+ item.type1));

                    // 图片
                    var img = $('<img>', {
                        src: 'data:image/jpg;base64,' + item.efj
                    }).css({
                        height: '100%'
                    }).appendTo(itemdiv);

                    // 工具条
                    var toolbar = $('<div>', {}).css({
                        position: 'absolute',
                        background: 'rgba(0, 0, 0, 0.5) none repeat scroll 0% 0%',
                        width: '100%',
                        height: '26px',
                        top: '0px',
                        left: '0px',
                        display: 'none'
                    }).appendTo(itemdiv);

                    // 删除按钮
                    var delBtn = $('<span>', {}).css({
                        width: '24px',
                        height: '24px',
                        display: 'inline',
                        float: 'right',
                        background: 'url("' + Config.ContextPath + 'ui/js/bupload/css/images/icons.png") no-repeat',
                        margin: '5px 1px 1px',
                        cursor: 'pointer',
                        'background-position': '-48px -24px'
                    }).appendTo(toolbar);

                    itemdiv.on('mouseover', function () {
                        toolbar.show();
                    }).on('mouseout', function () {
                        toolbar.hide();
                    });

                    delBtn.on('mouseover', function () {
                        delBtn.css('background-position', '-48px -0px');
                    }).on('mouseout', function () {
                        delBtn.css('background-position', '-48px -24px');
                    });

                    delBtn.click(function () {
                        $.messager.alert('提示', '是否确认删除？', 'question', function () {
                            Core.ajax(Config.ContextPath + 'service/utils/images/' + item.iid, {
                                type: 'json',
                                method: 'post',
                                data: {
                                    _method: 'delete'
                                }
                            }).then(function (rlt) {
                                if (rlt.isOk) {
                                    $.messager.alert('提醒', '删除成功！');
                                    reloadImage(wid);
                                } else {
                                    $.messager.alert('提醒', '删除失败，原因：' + rlt.msg, 'warning');
                                    return false;
                                }
                            });
                        });
                    });
                });
            });
        }


    });

    return projectcheckFj;
});