define(function(require) {
	var Config = require('config');
	var Core = require('core/core');
    var Dialog = require('centit/centit.dialog');
    var $ = require('jquery');
    var ajaxSubmit = require('plugins/jquery.form');
	var ProjectcheckAdd = require('./projectcheck.add');

	var ProjectcheckEditX = ProjectcheckAdd.extend(function() {
		var _self;
		var pid;
        var emodule = 5;//图片一级分类
        var itemscount = 0;//表格行数
        var roleCode;//当前用户状态省市县状态
        var ptype ;
        var fjCnt;//其他附件数量计算

        this.renderButton = function (btn, data) {
            var status = data.status;
            var flag = false;
            roleCode = this.parent.panel.find("#dqRoleCode").val();
            if(roleCode == '0010'){//省
                if(status == "03"){
                    flag = true;
                }
            }
            if(roleCode == '0011'){//市
                if(status == "01"||status == "04"){
                    flag = true;
                }
            }
            if(roleCode == '0012'){//区
                if(status == "02"||status == "00"){
                    flag = true;
                }
            }
            return flag;

        };

		// @override
		this.load = function(panel, data) {
            _self=this;
            roleCode = this.parent.panel.find("#dqRoleCode").val();
            $("#ptype").combobox('readonly', true);
            if(roleCode=='0012'){//县
                $("#chooseNewhousing").show();
            }
            if(roleCode=='0011'){//市
                $("#stotalscorediv").show();
                $("#stimediv").show();
                $("#xtime").datebox('readonly',true);
                $("#wyear").combobox('readonly', true);

            }
            if(roleCode=='0010'){//省
                panel.find("#stotalscorediv").show();
                panel.find("#stimediv").show();
                panel.find("#ptotalscorediv").show();
                panel.find("#ptimediv").show();
                panel.find("#xtime").datebox('readonly',true);
                panel.find("#stime").datebox('readonly',true);
                panel.find("#wyear").combobox('readonly', true);
                panel.find("#pj_div2").show();

            }
			var form = panel.find('form');
            var table = panel.find('#tabel_checktemplates');
            table.cdatagrid({
                controller: this
            });

            Core.ajax(Config.ContextPath+'service/check/projectcheck/'+data.pid, {
                type: 'json',
                method: 'get'
            }).then(function(data) {
                _self.data = data;
                pid = data.pid;
                ptype = data.ptype;
                form.form('load', data);
                if(roleCode != '0010'){
                    form.form('readonly', 'ptotalscore').form('readonly', 'ptime').form('readonly', 'isparticular');
                } else {
                    _self.panel.find("#projectcheck_info_isparticular_div").show();
                }


                Core.ajax(Config.ContextPath+'service/check/checktemplate?isPage=f&sort=sorts&order=asc&s_ctype='+ptype+'&pid='+pid, {
                    method: 'get'
                }).then(function(list) {
                    var rlt = list.objList;
                    for(var i = 0 ; i < rlt.length; i++) {
                        rlt[i].content1 = hh(rlt[i].content1, 7);
                        rlt[i].content3 = hh(rlt[i].content3, 56);
                        var piid = rlt[i].piid;
                        if(roleCode=='0012'){//县
                            var xscore = rlt[i].xscore;
                            if(xscore == null || xscore == undefined || xscore == 'undefined' || xscore == 'null'){
                                rlt[i].xscore = " <input name='xscore+" + i + "' class='inx' style='width:50px' >";
                            }else{
                                rlt[i].xscore = " <input name='xscore+" + i + "' class='inx' style='width:50px' value='" +rlt[i].xscore  + "'>";
                            }

                        }

                        if(roleCode=='0011'){//市
                            var sscore = rlt[i].sscore;
                            if(sscore == null || sscore == undefined || sscore == 'undefined'  || sscore == 'null'){
                                rlt[i].sscore = " <input name='sscore+" + i + "' class='ins' style='width:50px' >";
                            }else{
                                rlt[i].sscore = " <input name='sscore+" + i + "' class='ins' style='width:50px' value='" +rlt[i].sscore  + "'>";
                            }

                        }
                        if(roleCode=='0010'){//省
                            var pscore = rlt[i].pscore;
                            if(pscore == null || pscore == undefined || pscore == 'undefined'  || pscore == 'null'){
                                rlt[i].pscore = " <input name='pscore+" + i + "' class='inp' style='width:50px' >";
                            }else{
                                rlt[i].pscore = " <input name='pscore+" + i + "' class='inp' style='width:50px' value='" +rlt[i].pscore  + "'>";
                            }


                        }
                        rlt[i].fj = "<button class=\"fjBtn\" id='filebtn_"+piid+"'></button>";
                    }
                    loadTable(rlt,table);
                });

                //加载已上传附件
                Core.ajax(Config.ContextPath+'service/attachment/getAttachments/'+1+'/'+pid, {
                    type: 'json',
                    method: 'get'
                }).then(function(resdata) {
                    var list = resdata.fjlist;
                    panel.find('#pcinfo_fj_div').empty();//其他家庭成员初始化清空
                    var j = 0;
                    if(list != null && list.length > 0){
                        for(var i = 0; i < list.length ;i++){
                            j = i+1;
                            var obj = list[i];
                            var container = panel.find('#pcinfo_fj_div');
                            var html = '<a href="'+Config.ContextPath+'service/attachment/downloadFJ/'+obj.iid+'" style="color: blue;" id="tzgg_fj">'+j+'、'+obj.ename+'--'+obj.userName+'</a><br>';
                            container.append(html);


                        }
                    }
                });
            });

            //项目类型改变时候获取考核项列表
            panel.find('#ptype').combobox({
                onChange: function() {
                    if (roleCode == '0012') {//县
                        var ptype = panel.find('#ptype').combobox('getValue');
                        // $('#houseName').textbox('clear');//清空值
                        Core.ajax(Config.ContextPath + 'service/check/checktemplate?isPage=f&sort=sorts&order=asc&s_ctype=' + ptype + '&pid=' + pid, {
                            method: 'get'
                        }).then(function (list) {
                            var rlt = list.objList;

                            for (var i = 0; i < rlt.length; i++) {
                                rlt[i].content1 = hh(rlt[i].content1, 7);
                                rlt[i].content3 = hh(rlt[i].content3, 56);
                                rlt[i].xscore = "<input type='hidden' name='piid" + i + "' value='" + rlt[i].piid + "'  id='piid" + i + "'  />"
                                    + " <input name='xscore+" + i + "' class='in' style='width:50px' >";
                                rlt[i].fj = "<button class=\"fjBtn\" id='filebtn_" + rlt[i].piid + "'></button>";
                            }
                            loadTable(rlt, table);
                        });
                    }
                }
            });

            //选择验收项目
            panel.find('#p_newhousinghid').click(function() {
                //获取验收项目类型
                var ptype = panel.find('#ptype').combobox('getValue');
                var SelectUser = require('modules/check/projectCheck/ctrl/projectcheck-choosehouseid');
                var _SelectUser = new SelectUser("newhousinghid");
                _self.controllers["newhousinghid"] = _SelectUser;
                _SelectUser.parent = _self;
                Dialog.open({
                    id : 'selectuser',
                    title : '选择验收项目信息',
                    href : "modules/check/projectCheck/projectcheck-choosehouseid.jsp",
                    width : 900,
                    height : 570
                }, {}, _self.controllers["newhousinghid"]);
            });

            //添加附件
            panel.off('click', '#add_fj_btn');
            panel.find('#add_fj_btn').click(function () {
                var SelectUser = require('modules/check/projectCheck/ctrl/projectcheck.wjfj');
                var _SelectUser = new SelectUser("projectcheckwjfj1");
                _self.controllers["projectcheckwjfj1"] = _SelectUser;
                _SelectUser.parent = _self;
                Dialog.open({
                    id : 'projectcheckwjfj1',
                    title : '考核验收附件上传',
                    href : "modules/check/projectCheck/projectcheck-wjfj.jsp",
                    width : 900,
                    height : 570
                }, {'pid':pid}, _self.controllers["projectcheckwjfj1"]);
            });
		};

        //暂存
        this.submit = function (panel, data, closeCallback) {
            submitDosomething(panel, data, closeCallback, data.status);
            return false;
        };
        //提交
        this.submitXz = function (panel, data, closeCallback) {
            var typeStatus;
            if(roleCode=='0010'){
                typeStatus='05';
            }
            if(roleCode=='0011'){
                typeStatus='03';
            }
            if(roleCode=='0012'){
                typeStatus='01';
            }
            submitDosomething(panel, data, closeCallback, typeStatus);
            return false;
        };
        // @override
        this.onClose = function(table) {
            table.datagrid('reload');
        };

        function loadTable(rlt,table) {
            table.cdatagrid({
                controller : _self,
                onLoadSuccess: function (data) {
                    mergeCellsByField("tabel_checktemplates", "content1");
                }
            }).datagrid('loadData', rlt);
            if(roleCode=='0012') {//区 --隐藏省市
                table.datagrid('hideColumn', 'sscore');
                table.datagrid('hideColumn', 'pscore');

            }
            if(roleCode=='0011') {//市 隐藏省
                table.datagrid('hideColumn', 'pscore');

            }


            _self.panel.find('.fjBtn').bind('click', function(){
                var i=this.id.split("_")[1];
                var SelectUser = require('modules/check/projectCheck/ctrl/projectcheck.fj');
                var _SelectUser = new SelectUser("projectcheckfj");
                _self.controllers["projectcheckfj"] = _SelectUser;
                _SelectUser.parent = _self;
                Dialog.open({
                    id : 'selectuser',
                    title : '考核验收附件上传',
                    href : "modules/check/projectCheck/projectcheck-fj.jsp",
                    width : 900,
                    height : 570
                }, {'wid':i,'roleCode':roleCode,'isView':1}, _self.controllers["projectcheckfj"]);

            });

        }
        //校验项得分
        function checkFz(score ,max) {
            var obj = new Object();
            var reg1=/(^[0-9]{1,2}$)|(^[0-9]{1,2}[\.]{1}[0-9]{1,2}$)/;
            if(score == null || score == undefined || score == 'undefined' || score == '' || score == 'null'){
                obj.isOk = false;
                obj.msg = "得分为空";
            } else if(parseFloat(score).toString() == "NaN"){
                obj.isOk = false;
                obj.msg = "得分不为数字";
            } else if(!reg1.test(parseFloat(score).toString())){
                obj.isOk = false;
                obj.msg = "得分小于0或不是保留两位小数的数字";
            } else if(parseFloat(score) > parseFloat(max)){
                obj.isOk = false;
                obj.msg = "得分超过标准分值";
            } else {
                obj.isOk = true;
            }
            return obj;
        }

        var submitDosomething = function (panel, data, closeCallback, typeStatus) {
            var form = panel.find('#pj_form');
            var form2 = panel.find('#pj_form2');
            // 开启校验
            form.form('enableValidation');
            var obj = form.form('value');//主表数据
            var obj2 = form2.form('value');//省级评价结果
            var isValid = form.form('validate');

            if(roleCode=='0012' && (obj.xtime  == null || obj.xtime == "")){//县自评填写评分时间
                isValid = false;
                $.messager.alert('提醒', '县区评分时间不可为空！');
            } else if(roleCode=='0011' && (obj.stime  == null || obj.stime == "")){//市自评填写评分时间
                $.messager.alert('提醒', '市评分时间不可为空！');
                isValid = false;
            } else if(roleCode=='0010' && (obj.ptime  == null || obj.ptime == "")){//省自评填写评分时间
                $.messager.alert('提醒', '省评分时间不可为空！');
                isValid = false;
            }

            var isnotok = panel.find('#isnotok').combobox('getValue');//省级 是否一票否决

            if (isValid) {
                //省用户打分时-省级特色田园乡村为空时，默认为否
                if(obj.isparticular == null || obj.isparticular == ""){
                   _self.panel.find("#projectcheck_info_isparticular").combobox('setValue','F');
                }
                //省总分暂时以录入为准，不录入详细子项;若没有总分，则以录入详细子项为准
                if(roleCode != '0010' /*|| obj.ptotalscore == null || obj.ptotalscore == '' || obj.ptotalscore <= 0*/){
                    //循环获取总分
                    var table = panel.find('#tabel_checktemplates');
                    var rows = table.datagrid('getData').rows;
                    var list = Array();
                    var xscoreTotal = 0;//县
                    var sscoreTotal = 0;//市
                    var pscoreTotal = 0;//省

                    if (rows != null && rows.length > 0) {
                        for (var i = 0; i < rows.length; i++) {
                            var row = rows[i];
                            var obj = new Object();
                            obj.piid = row.piid;
                            obj.cid = row.cid;
                            //县得分
                            if (roleCode=='0012') {
                                var xsc = $("input[name='xscore+" + i + "']").val();
                                var jy = checkFz(xsc, row.maxval);
                                if (!jy.isOk) {
                                    $.messager.alert('提醒', '第' + (i + 1) + '个项得分检验失败，不可保存！原因：' + jy.msg);
                                    return false;
                                } else {
                                    xsc = parseFloat(xsc);
                                    xscoreTotal += xsc;
                                }
                                obj.xscore = xsc;
                            }
                            //市得分
                            if (roleCode=='0011') {
                                var ssc = $("input[name='sscore+" + i + "']").val();
                                var jy = checkFz(ssc,row.maxval);
                                if(!jy.isOk){
                                    $.messager.alert('提醒', '第' + (i+1) + '个项得分检验失败，不可保存！原因：' + jy.msg);
                                    return false;
                                }else{
                                    ssc = parseFloat(ssc);
                                    sscoreTotal += ssc;
                                }
                                obj.sscore = ssc;
                                obj.xscore = row.xscore;
                            }


                            //省得分
                            if (roleCode=='0010') {
                                var psc;
                                if(isnotok=='T'){
                                    psc= 0;
                                    pscoreTotal += psc;
                                }else{
                                    psc = $("input[name='pscore+" + i + "']").val();
                                    var jy = checkFz(psc,row.maxval);
                                    if(!jy.isOk){
                                        $.messager.alert('提醒', '第' + (i+1) + '个项得分检验失败，不可保存！原因：' + jy.msg);
                                        return false;
                                    }else{
                                        psc = parseFloat(psc);
                                        pscoreTotal += psc;
                                    }

                                }
                                obj.pscore = psc;
                                obj.xscore = row.xscore;
                                obj.sscore = row.sscore;

                            }

                            list[i] = obj;
                        }
                    }
                    //更新总分
                    if (roleCode=='0012') {
                        panel.find('#xtotalscore').textbox('setValue', xscoreTotal);
                    }
                    if (roleCode=='0011') {
                        panel.find('#stotalscore').textbox('setValue', sscoreTotal);
                    }
                    if (roleCode=='0010') {
                        panel.find('#ptotalscore').textbox('setValue', pscoreTotal);
                    }
                }




                //主表保存
                form.form('ajax', {
                    url: Config.ContextPath + 'service/check/projectcheck?commitStatus='+typeStatus,
                    method: 'post',
                    data: obj2,
                }).then(function(projectcheck) {
                    //保存子表
                    var json = JSON.stringify(list);
                    var pid = projectcheck.pid;
                    Core.ajax(Config.ContextPath + 'service/check/projectcheckitem', {//保存子表
                        type: 'json',
                        method: 'post',
                        traditional: true,
                        data: {"list": json, "pid": pid},
                    }).then(closeCallback);

                    //保存附件
                    var eid=pid;
                    var fileName = panel.find("#ys_fj").val();
                    fileName = fileName.replace('C:\\fakepath\\','');
                    if(fileName != null && fileName != undefined && fileName != 'undefined' && fileName != '' && fileName != 'null') {
                        panel.find("#pj_form").ajaxSubmit({
                            url: Config.ContextPath + 'service/attachment/uploadfj?fileName=' + fileName + '&eid=' + eid + '&types=1',
                            type: 'post',
                            error: function () {
                                $.messager.alert('警告', '附件上传失败！', 'warning');
                            }
                        });
                        closeCallback();
                    }

                });
                return false;
            }
		};

        //生成子表的id，附件、子表2个使用
        function uuid() {
            function S4() {
                return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
            }
            return (S4() + S4() +  S4() + S4()  + S4() + S4() + S4() + S4());

        }
        //换行
        var hh = function (str,len) {
            var newstr = "";
            if(str != null){
                var strs = str.split("");
                for(var j = 0 ; j < strs.length;j++ ){
                    if((j+1)%len == 0){
                        newstr += '<br>'+strs[j];
                    } else {
                        newstr += strs[j];
                    }
                }
            }
            return newstr;
        }

        function mergeCellsByField(tableID, colList) {
            var ColArray = colList.split(",");
            var tTable = $("#" + tableID);
            var TableRowCnts = tTable.datagrid("getRows").length;
            var tmpA;
            var tmpB;
            var PerTxt = "";
            var CurTxt = "";
            var buyprocode = "";
            var newbuyprocode = "";
            var alertStr = "";
            for (j = ColArray.length - 1; j >= 0; j--) {
                PerTxt = "";
                buyprocode = "";
                tmpA = 1;
                tmpB = 0;

                for (i = 0; i <= TableRowCnts; i++) {
                    if (i == TableRowCnts) {
                        CurTxt = "";
                        newbuyprocode = "";
                    }
                    else {
                        CurTxt = tTable.datagrid("getRows")[i][ColArray[j]];
                        newbuyprocode = tTable.datagrid("getRows")[i]["buyprojectCode"];
                    }
                    if (PerTxt == CurTxt && buyprocode == newbuyprocode) {
                        tmpA += 1;
                    }
                    else {
                        tmpB += tmpA;

                        tTable.datagrid("mergeCells", {
                            index: i - tmpA,
                            field: ColArray[j],　　//合并字段
                            rowspan: tmpA,
                            colspan: null
                        });
                        tTable.datagrid("mergeCells", { //根据ColArray[j]进行合并
                            index: i - tmpA,
                            field: "Ideparture",
                            rowspan: tmpA,
                            colspan: null
                        });

                        tmpA = 1;
                    }
                    PerTxt = CurTxt;
                    buyprocode = newbuyprocode;
                }
            }
        }
	});

	return ProjectcheckEditX;
});