define(function(require) {
    var Config = require('config');
    var Core = require('core/core');
    var Page = require('core/page');
    var Dialog = require('centit/centit.dialog');
    var $ = require('jquery');
    var ajaxSubmit = require('plugins/jquery.form');

	var ProjectcheckAdd = Page.extend(function() {
        var _self;
        var emodule = 5;//图片一级分类
        var itemscount = 0;//表格行数
        var  roleCode//当前用户角色
        var fjCnt;//其他附件数量计算
		// @override
		this.load = function(panel, data) {
            _self=this;
            $("#chooseNewhousing").show();
			var form = panel.find('form');
            var table = _self.panel.find('#tabel_checktemplates');
            roleCode = this.parent.panel.find("#dqRoleCode").val();
            table.cdatagrid({
                controller: this
            });
            form.form('disableValidation')
                .form('focus');

            //获取登录用户行政区划信息
            Core.ajax(Config.ContextPath + 'service/common/getLoginUserUnitInfo', {
                method: 'get'
            }).then(function (rlt) {
                if(rlt != null ){
                    panel.find("#projectcheck_city").combobox("setValue",rlt.cityCode);
                    panel.find("#projectcheck_county").combobox("setValue",rlt.countyCode);
                }
            });
            //选择验收项目
            panel.find('#p_newhousinghid').click(function() {
                var SelectUser = require('modules/check/projectCheck/ctrl/projectcheck-choosehouseid');
                var _SelectUser = new SelectUser("newhousinghid");
                _self.controllers["newhousinghid"] = _SelectUser;
                _SelectUser.parent = _self;
                Dialog.open({
                    id : 'selectuser',
                    title : '选择验收项目信息',
                    href : "modules/check/projectCheck/projectcheck-choosehouseid.jsp",
                    width : 900,
                    height : 570
                }, {}, _self.controllers["newhousinghid"]);
            });


			//项目类型改变时候获取考核项列表
            panel.find('#ptype').combobox({
                onChange: function() {
                    var ptype = panel.find('#ptype').combobox('getValue');
                    _self.panel.find('#houseName').textbox('clear');//清空值
                    Core.ajax(Config.ContextPath+'service/check/checktemplate?isPage=f&sort=sorts&order=asc&s_ctype='+ptype, {
                        method: 'get'
                    }).then(function(list) {
                        var rlt = list.objList;
                        itemscount = rlt.length;
                        for(var i = 0 ; i < rlt.length; i++) {
                            rlt[i].content1 = hh(rlt[i].content1, 7);
                            rlt[i].content3 = hh(rlt[i].content3, 56);
                            var piid = uuid();
                            rlt[i].xscore = "<input type='hidden' name='piid" + i + "' value='"+piid+"'  id='piid" + i + "'/>"
                                +" <input name='xscore+" + i + "' class='in' style='width:50px' >";
                            rlt[i].fj = "<button class=\"fjBtn\" id='filebtn_"+piid+"'></button>";
                        }
                        table.cdatagrid({
                            controller : _self,
                            onLoadSuccess: function (data) {
                                mergeCellsByField("tabel_checktemplates", "content1");
                            }
                        }).datagrid('loadData', rlt);

                        table.datagrid('hideColumn', 'sscore');
                        table.datagrid('hideColumn', 'pscore');

                        if(itemscount>0){
                            _self.panel.find('.fjBtn').bind('click', function(){
                               var i=this.id.split("_")[1];
                                var SelectUser = require('modules/check/projectCheck/ctrl/projectcheck.fj');
                                var _SelectUser = new SelectUser("projectcheckfj");
                                _self.controllers["projectcheckfj"] = _SelectUser;
                                _SelectUser.parent = _self;
                                Dialog.open({
                                    id : 'selectuser',
                                    title : '考核验收附件上传',
                                    href : "modules/check/projectCheck/projectcheck-fj.jsp",
                                    width : 900,
                                    height : 570
                                }, {'wid':i,'roleCode':roleCode,'isView':1}, _self.controllers["projectcheckfj"]);

                            });
                        }
                    });
                }
            });
            var pid = uuid();
            panel.find("#pid").val(pid);
           //添加附件
            panel.off('click', '#add_fj_btn');
            panel.find('#add_fj_btn').click(function () {
                var SelectUser = require('modules/check/projectCheck/ctrl/projectcheck.wjfj');
                var _SelectUser = new SelectUser("projectcheckwjfj");
                _self.controllers["projectcheckwjfj"] = _SelectUser;
                _SelectUser.parent = _self;
                Dialog.open({
                    id : 'projectcheckwjfj',
                    title : '考核验收附件上传',
                    href : "modules/check/projectCheck/projectcheck-wjfj.jsp",
                    width : 900,
                    height : 570
                }, {'pid':pid}, _self.controllers["projectcheckwjfj"]);
            });

		};


        //暂存
        this.submit = function (panel, data, closeCallback) {
            submitDosomething(panel, data, closeCallback, '00');
            return false;
        };
        //提交
        this.submitXz = function (panel, data, closeCallback) {
            submitDosomething(panel, data, closeCallback, '01');
            return false;
        };
        var submitDosomething = function (panel, data, closeCallback, type) {
            var form = panel.find('form');
            // 开启校验
            form.form('enableValidation');
            var isValid = form.form('validate');
            var obj = form.form('value');//主表数据
            if(roleCode=='0012' && (obj.xtime  == null || obj.xtime == "")){//县自评填写评分时间
                isValid = false;
                $.messager.alert('提醒', '县区评分时间不可为空！');
            }
            if (isValid) {
                //循环获取总分
                var table = panel.find('#tabel_checktemplates');
                var rows = table.datagrid('getData').rows;
                var list = Array();
                var xscoreTotal=0;

                if(rows != null && rows.length > 0){
                    for(var i = 0 ; i < rows.length ; i++){
                        var row = rows[i];
                        var obj = new Object();
                        obj.piid = _self.panel.find("#piid"+i).val();
                        obj.cid = row.cid;
                        var  xsc = $("input[name='xscore+" + i + "']").val();
                        var jy = checkFz(xsc,row.maxval);
                        if(!jy.isOk){
                            $.messager.alert('提醒', '第' + (i+1) + '个项得分检验失败，不可保存！原因：' + jy.msg);
                            return false;
                        }else{
                            xsc = parseFloat(xsc);
                            xscoreTotal +=xsc;
                        }
                        obj.xscore =xsc;
                        list[i] = obj;

                    }
                }
                //更新总分
                panel.find('#xtotalscore').textbox('setValue', xscoreTotal);

                //主表保存
                panel.find("#pj_form").ajaxSubmit({
                    url:Config.ContextPath + 'service/check/projectcheck?type=new&commitStatus='+type,
                    type:'post',
                    success:function(projectcheck){
                        //保存子表
                        var json =JSON.stringify(list);
                        var pid= projectcheck.data.pid;
                        Core.ajax(Config.ContextPath+'service/check/projectcheckitem', {//保存子表
                            type: 'json',
                            method: 'post',
                            traditional: true,
                            data:{"list":json,"pid":pid},
                        }).then(closeCallback);

                    },
                    error :function() {
                        $.messager.alert('警告','保存失败！','warning');
                    }
                });
            }
            return false;
        }
        // @override
        this.onClose = function(table, data) {
            table.datagrid('reload');
        };

        //校验项得分
        function checkFz(score ,max) {
            var obj = new Object();
            var reg1=/(^[0-9]{1,2}$)|(^[0-9]{1,2}[\.]{1}[0-9]{1,2}$)/;
            if(score == null || score == undefined || score == 'undefined' || score == '' || score == 'null'){
                obj.isOk = false;
                obj.msg = "得分为空";
            } else if(parseFloat(score).toString() == "NaN"){
                obj.isOk = false;
                obj.msg = "得分不为数字";
            } else if(!reg1.test(parseFloat(score).toString())){
                obj.isOk = false;
                obj.msg = "得分小于0或不是保留两位小数的数字";
            } else if(parseFloat(score) > parseFloat(max)){
                obj.isOk = false;
                obj.msg = "得分超过标准分值";
            } else {
                obj.isOk = true;
            }
            return obj;
        }


        //新增图片
        function showUploadDialog(type1,i) {
            var piid =  _self.panel.find("#piid"+i).val();
            new BUpload({
                upload_url: Config.ContextPath + 'service/utils/images/uploadFile?type='+emodule+'&rid=' + piid + '&type1=' + type1,
                ext_allow: "png|jpg|jpeg",
                ext_refuse: "exe|bat",
                max_filesize: 1024, //KB
                max_filenum: 10,
                callback: function () {
                    reloadImage(piid);
                }
            });
        }

        //加载图片
        function reloadImage(piid) {
            Core.ajax(Config.ContextPath + 'service/utils/images/getAttachmentsBTY/'+emodule+'/' + piid, {
                type: 'json',
                method: 'get'
            }).then(function (data) {
                _self.panel.find('#file_'+piid+'_xtype').empty();
                $.each(data.fjList, function (index, item) {
                    // 主
                    var itemdiv = $('<div>', {}).css({
                        height: '113px',
                        margin: '3px',
                        float: 'left',
                        position: 'relative'
                    }).appendTo($('#file_'+item.eid+'_' + item.type1));

                    // 图片
                    var img = $('<img>', {
                        src: 'data:image/jpg;base64,' + item.efj
                    }).css({
                        height: '100%'
                    }).appendTo(itemdiv);

                    // 工具条
                    var toolbar = $('<div>', {}).css({
                        position: 'absolute',
                        background: 'rgba(0, 0, 0, 0.5) none repeat scroll 0% 0%',
                        width: '100%',
                        height: '26px',
                        top: '0px',
                        left: '0px',
                        display: 'none'
                    }).appendTo(itemdiv);

                    // 删除按钮
                    var delBtn = $('<span>', {}).css({
                        width: '24px',
                        height: '24px',
                        display: 'inline',
                        float: 'right',
                        background: 'url("' + Config.ContextPath + 'ui/js/bupload/css/images/icons.png") no-repeat',
                        margin: '5px 1px 1px',
                        cursor: 'pointer',
                        'background-position': '-48px -24px'
                    }).appendTo(toolbar);

                    itemdiv.on('mouseover', function () {
                        toolbar.show();
                    }).on('mouseout', function () {
                        toolbar.hide();
                    });

                    delBtn.on('mouseover', function () {
                        delBtn.css('background-position', '-48px -0px');
                    }).on('mouseout', function () {
                        delBtn.css('background-position', '-48px -24px');
                    });

                    delBtn.click(function () {
                        $.messager.alert('提示', '是否确认删除？', 'question', function () {
                            Core.ajax(Config.ContextPath + 'service/utils/images/' + item.iid, {
                                type: 'json',
                                method: 'post',
                                data: {
                                    _method: 'delete'
                                }
                            }).then(function (rlt) {
                                if (rlt.isOk) {
                                    $.messager.alert('提醒', '删除成功！');
                                    reloadImage(piid);
                                } else {
                                    $.messager.alert('提醒', '删除失败，原因：' + rlt.msg, 'warning');
                                    return false;
                                }
                            });
                        });
                    });
                });
            });
        }
        //生成子表的id，附件、子表2个使用
        function uuid() {
            function S4() {
                return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
            }
            return (S4() + S4() +  S4() + S4()  + S4() + S4() + S4() + S4());

        }


        //换行
        var hh = function (str,len) {
            var newstr = "";
            if(str != null){
                var strs = str.split("");
                for(var j = 0 ; j < strs.length;j++ ){
                    if((j+1)%len == 0){
                        newstr += '<br>'+strs[j];
                    } else {
                        newstr += strs[j];
                    }
                }
            }
            return newstr;
        }
        //生成子表的id，附件、子表2个使用
        function uuid() {
            function S4() {
                return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
            }
            return (S4() + S4() +  S4() + S4()  + S4() + S4() + S4() + S4());

        }
        function mergeCellsByField(tableID, colList) {
            var ColArray = colList.split(",");
            var tTable = $("#" + tableID);
            var TableRowCnts = tTable.datagrid("getRows").length;
            var tmpA;
            var tmpB;
            var PerTxt = "";
            var CurTxt = "";
            var buyprocode = "";
            var newbuyprocode = "";
            var alertStr = "";
            for (j = ColArray.length - 1; j >= 0; j--) {
                PerTxt = "";
                buyprocode = "";
                tmpA = 1;
                tmpB = 0;

                for (i = 0; i <= TableRowCnts; i++) {
                    if (i == TableRowCnts) {
                        CurTxt = "";
                        newbuyprocode = "";
                    }
                    else {
                        CurTxt = tTable.datagrid("getRows")[i][ColArray[j]];
                        newbuyprocode = tTable.datagrid("getRows")[i]["buyprojectCode"];
                    }
                    if (PerTxt == CurTxt && buyprocode == newbuyprocode) {
                        tmpA += 1;
                    }
                    else {
                        tmpB += tmpA;

                        tTable.datagrid("mergeCells", {
                            index: i - tmpA,
                            field: ColArray[j],　　//合并字段
                            rowspan: tmpA,
                            colspan: null
                        });
                        tTable.datagrid("mergeCells", { //根据ColArray[j]进行合并
                            index: i - tmpA,
                            field: "Ideparture",
                            rowspan: tmpA,
                            colspan: null
                        });

                        tmpA = 1;
                    }
                    PerTxt = CurTxt;
                    buyprocode = newbuyprocode;
                }
            }
        }
	});

	return ProjectcheckAdd;
});