<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="http://www.springframework.org/security/tags" prefix="authz"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://www.centit.com/el/coderepo" prefix="cp"%>
<html lang="zh-cmn-Hans">
	<head>
		<meta charset="UTF-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    	<meta name="renderer" content="webkit">
    	<meta name="viewport" content="width=device-width, initial-scale=1.0">
    	<authz:csrfMetaTags/>
    	<title>系统登录<c:if test="${'DEPLOY' eq sessionScope.ENTRANCE_TYPE}">(实施入口)</c:if></title>
		<link rel="shortcut icon" href="<c:url value="/ui/favicon.ico" />" type="image/x-icon" />
    	<link rel="stylesheet" href="${cp:SYS_VALUE('app.staticfile.home')}/modules/login/sys/style.css">
    	<script type="text/javascript" src="${cp:SYS_VALUE('app.staticfile.home')}/ui/js/jquery/jquery-1.11.2.min.js"></script>
    	<%--<script type="text/javascript" src="${cp:SYS_VALUE('app.staticfile.home')}/modules/login/sys/style.js"></script>--%>
		<style type="text/css">
			.red{position: absolute;top: 317px;right: 200px;color: red;font-size: 15px;}
            .cy-header{z-index: 100;padding:15px 10px 15px  135px;color: #fff;background:#19bbb0 url("../../modules/login/sys/img/logo-icon.png") 10px center no-repeat;background-size: 87px  87px ;position: fixed;top:0;left:0;width: 100%}
            .cy-header h3{font-size: 35px;font-weight: 500;letter-spacing: 1px}
            .cy-header>p{font-size: 26px!important;padding-left:280px;margin-top: 10px}
			.logintip{position: relative}
			.cy-error-tip{position: absolute;bottom: 10px;color: red;left: 50%;transform: translateX(-50%);font-weight: bold;width: 100%;text-align: center}
		</style>
	</head>
	<body>
	<div class="cy-logo-icon">
		<img src="${cp:SYS_VALUE('app.staticfile.home')}/modules/login/sys/img/logo-icon.png" style="width: 80px">
	</div>
	<div class="cy-title-content">

		<img src="${cp:SYS_VALUE('app.staticfile.home')}/modules/login/sys/img/cy-header-title.png" >
	</div>
		<div class="info">
			<div>
				<div>
					<div class="logintip">
						登录/用户User
					</div>
					<c:if test="${LOGIN_ERROR_MSG != null && LOGIN_ERROR_MSG != ''}">
						<span class="cy-error-tip">${LOGIN_ERROR_MSG}</span>
						<%--<c:choose>
							<c:when test="${LOGIN_ERROR_MSG eq '坏的凭证'}">
								<span class="red">密码错误!</span>
							</c:when>
							<c:otherwise>
								<span class="red">用户名不存在!</span>
							</c:otherwise>
						</c:choose>--%>
					</c:if>
					<form action="${pageContext.request.contextPath }/login" method="post">
				    	<input name="username" value="${SPRING_SECURITY_LAST_USERNAME}" type="text" autocomplete="on" placeholder="用户名" />
						<input name="password" id="password" type="password"  placeholder="密码" />
						<input type="hidden"  name="LOCAL_LANG" id="LOCAL_LANG"  value="zh_CN"  />
						<authz:csrfInput/>
						<span>
							<input id="remember" name="remember-me" type="checkbox" checked="checked" />
							<label for="remember">记住密码</label>
						</span>
						<button type="submit">登录</button>
					</form>
				</div>
			</div>
		</div>
		<div class="footer" style="line-height: 25px;height: 27px;padding: 10px;font-size: 15px;color: #4e4e4e;background: none">
			<div style="position: absolute;height: 100%;width: 100%;left:0;top:0;/*background: rgba(255,255,255,0.7)*/"></div>
			<p style="position: relative;z-index: 1000;font-size: 12px">
				Copyright@2018江苏省住房和城乡建设厅 主办  建议使用浏览器IE9以上、<span style="color: #0676fa">Google Chrome</span>
			</p>
		</div>
	</body>
</html>