/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.utils.po;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExcelUtil {
    private static final Log log = LogFactory.getLog(ExcelUtil.class);
    public static final int TYPE_INT = 1;
    public static final int TYPE_DOUBLE = 2;

    public static Workbook createWorkBook(List<Map<String, Object>> dataList, String[] keys, String[] columnNames, short[] columnWidths) {
        int i;
        Cell cell;
        XSSFWorkbook wb = new XSSFWorkbook();
        Sheet sheet = wb.createSheet(dataList.get(0).get("sheetName").toString());
        for (int i2 = 0; i2 < keys.length; ++i2) {
            sheet.setColumnWidth((int)((short)i2), (int)columnWidths[i2]);
        }
        Font titleFont = wb.createFont();
        Font headFont = wb.createFont();
        Font valueFont = wb.createFont();
        titleFont.setFontName("\u9ed1\u4f53");
        titleFont.setFontHeightInPoints((short)20);
        titleFont.setColor(IndexedColors.BLACK.getIndex());
        headFont.setFontName("\u9ed1\u4f53");
        headFont.setFontHeightInPoints((short)12);
        headFont.setColor(IndexedColors.BLACK.getIndex());
        valueFont.setFontName("\u5b8b\u4f53");
        valueFont.setFontHeightInPoints((short)11);
        valueFont.setColor(IndexedColors.BLACK.getIndex());
        CellStyle titleStyle = wb.createCellStyle();
        CellStyle headStyle = wb.createCellStyle();
        CellStyle valueStyle = wb.createCellStyle();
        titleStyle.setFont(titleFont);
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleStyle.setWrapText(true);
        headStyle.setFont(headFont);
        headStyle.setAlignment(HorizontalAlignment.CENTER);
        headStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headStyle.setWrapText(true);
        valueStyle.setFont(valueFont);
        valueStyle.setAlignment(HorizontalAlignment.LEFT);
        valueStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        valueStyle.setWrapText(true);
        int curRowNum = 0;
        Map<String, Object> map0 = dataList.get(0);
        if (map0.containsKey("titleText")) {
            int n = curRowNum;
            curRowNum = (short)(curRowNum + 1);
            Row titleRow = sheet.createRow(n);
            titleRow.setHeight((short)600);
            CellRangeAddress region = new CellRangeAddress(0, 0, 0, columnNames.length - 1);
            sheet.addMergedRegion(region);
            cell = titleRow.createCell(0);
            cell.setCellValue((RichTextString)new XSSFRichTextString(map0.get("titleText").toString()));
            cell.setCellStyle(titleStyle);
        }
        int n = curRowNum;
        curRowNum = (short)(curRowNum + 1);
        Row headRow = sheet.createRow(n);
        for (i = 0; i < columnNames.length; ++i) {
            cell = headRow.createCell(i);
            cell.setCellValue(columnNames[i]);
            cell.setCellStyle(headStyle);
        }
        for (i = 1; i < dataList.size(); i = (int)((short)(i + 1))) {
            int n2 = curRowNum;
            curRowNum = (short)(curRowNum + 1);
            Row valueRow = sheet.createRow(n2);
            for (int j = 0; j < keys.length; j = (int)((short)(j + 1))) {
                Cell cell2 = valueRow.createCell(j);
                cell2.setCellValue(dataList.get(i).get(keys[j]) == null ? " " : dataList.get(i).get(keys[j]).toString());
                cell2.setCellStyle(valueStyle);
            }
        }
        return wb;
    }

    public static List<String[]> GetExlData(InputStream is, int[] cellType, int beginRow) {
        XSSFRow rowline;
        int maxcol = cellType.length;
        XSSFWorkbook wb = null;
        XSSFCell cell = null;
        try {
            wb = new XSSFWorkbook(is);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        ArrayList<String[]> exlList = new ArrayList<String[]>();
        XSSFSheet childSheet = wb.getSheetAt(0);
        int rowNum = childSheet.getLastRowNum();
        for (int j = beginRow - 1; j <= rowNum && (rowline = childSheet.getRow(j)) != null; ++j) {
            int k;
            int cellNum = rowline.getLastCellNum();
            String[] rows = new String[maxcol + 1];
            rows[0] = String.valueOf(j + 1);
            for (k = 0; k < cellNum && k < maxcol; ++k) {
                cell = rowline.getCell((int)((short)k));
                String cellvalue = ExcelUtil.getCellValue((XSSFCell)cell, (int)cellType[k]);
                rows[k + 1] = cellvalue == null ? "" : cellvalue;
            }
            if (cellNum < maxcol) {
                for (k = cellNum; k < maxcol; ++k) {
                    rows[k + 1] = "";
                }
            }
            exlList.add(rows);
        }
        return exlList;
    }

    private static String getCellValue(XSSFCell cell, int type) {
        String cellvalue = null;
        if (cell != null) {
            CellType cellType = cell.getCellType();
            if (CellType.NUMERIC.equals((Object)cellType)) {
                switch (type) {
                    case 2: {
                        cellvalue = String.valueOf(cell.getNumericCellValue());
                        break;
                    }
                    case 1: {
                        cellvalue = String.valueOf((long)cell.getNumericCellValue());
                        break;
                    }
                }
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd");
                    cellvalue = sdf.format(date);
                }
            } else {
                cellvalue = CellType.STRING.equals((Object)cellType) ? cell.getStringCellValue().replaceAll("'", "''") : "";
            }
        }
        return cellvalue;
    }
}

