/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.utils.po;

import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.model.basedata.IDataDictionary;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.service.SysUnitManager;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DictionaryUtil {
    @Autowired
    private SysUnitManager sysUnitManager;
    public static DictionaryUtil dictionaryUtil;

    @PostConstruct
    public void init() {
        dictionaryUtil = this;
        DictionaryUtil.dictionaryUtil.sysUnitManager = this.sysUnitManager;
    }

    public static boolean isValidDictCode(String sCatalog, String dataCode) {
        boolean flag = false;
        List ptDictionary = CodeRepositoryUtil.getDictionary((String)sCatalog);
        for (IDataDictionary dictionary : ptDictionary) {
            if (!dictionary.getDataCode().equals(dataCode)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static String getValueByCode(String sCatalog, String dataCode) {
        String value = null;
        List ptDictionary = CodeRepositoryUtil.getDictionary((String)sCatalog);
        for (IDataDictionary dictionary : ptDictionary) {
            if (!dictionary.getDataCode().equals(dataCode)) continue;
            value = dictionary.getDataValue();
            break;
        }
        return value;
    }

    public static String getValidDictValue(String sCatalog, String splitStr) {
        String validValue = "";
        List ptDictionary = CodeRepositoryUtil.getDictionary((String)sCatalog);
        for (IDataDictionary dictionary : ptDictionary) {
            validValue = validValue + dictionary.getDataCode() + splitStr;
        }
        if (validValue.length() > 0) {
            validValue = validValue.substring(0, validValue.length() - splitStr.length());
        }
        return validValue;
    }

    public static String getUnitPathText(String unitCode, int rootLevel) {
        if (rootLevel < 1) {
            return null;
        }
        String pathText = "";
        if (rootLevel == 1) {
            pathText = "\u6c5f\u82cf\u7701-";
            ++rootLevel;
        }
        UnitInfo unitInfo = DictionaryUtil.dictionaryUtil.sysUnitManager.getObjectById(unitCode);
        String fullPath = unitInfo.getUnitPath();
        String[] units = fullPath.substring(1).replaceAll("//", "/").split("/");
        for (int i = rootLevel - 1; i < units.length; ++i) {
            pathText = pathText + CodeRepositoryUtil.getUnitName((String)units[i]) + "-";
        }
        if (pathText.length() > 0) {
            pathText = pathText.substring(0, pathText.length() - 1);
        }
        return pathText;
    }
}

