/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.utils.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.common.controller.CommonController;
import com.nfgl.common.service.CommonManager;
import com.nfgl.utils.po.PmpWfRecord;
import com.nfgl.utils.po.PmpWfRecordID;
import com.nfgl.utils.service.PmpWfRecordManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/utils/pmpWfRecord"})
public class PmpWfRecordController
extends BaseController {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(PmpWfRecordController.class);
    @Resource
    private PmpWfRecordManager pmpWfRecordManager;
    @Resource
    private CommonManager commonManager;
    @Resource
    private CommonController commonController;

    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<Object> list(String[] filed, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        searchColumn.put("sort", "worder");
        searchColumn.put("order", "desc");
        JSONArray listObjects = this.pmpWfRecordManager.listObjectsAsJson(searchColumn, pageDesc);
        if (listObjects != null && listObjects.size() > 0) {
            for (int i = 0; i < listObjects.size(); ++i) {
                JSONObject o = listObjects.getJSONObject(i);
                String ideaCode = (String)o.get((Object)"ideaCode");
                if (!StringUtils.isNotBlank((CharSequence)ideaCode)) continue;
                o.put("ideaCode", (Object)CodeRepositoryUtil.getValue((String)"operations", (String)ideaCode));
            }
        }
        return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseData savePmpWfRecord(@Valid PmpWfRecord pmpWfRecord, HttpServletRequest request, HttpServletResponse response) {
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        Date date = new Date();
        boolean isOk = true;
        String msg = "";
        Integer wmodule = pmpWfRecord.getWmodule();
        String wid = pmpWfRecord.getWid();
        List pmps = this.getpmpWfRecords(wmodule, wid);
        Integer ordernum = 0;
        if (pmps != null && pmps.size() > 0) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < pmps.size(); ++i) {
                list.add(((PmpWfRecord)pmps.get(i)).getWorder());
            }
            ordernum = (Integer)Collections.max(list) + 1;
        } else {
            ordernum = 1;
        }
        pmpWfRecord.setWorder(ordernum);
        pmpWfRecord.setWdate(new Date());
        pmpWfRecord.setUsername(loginUser.getUserInfo().getString("userName"));
        pmpWfRecord.setUnitcode(loginUser.getCurrentUnitCode());
        this.pmpWfRecordManager.saveNewObject((Serializable)pmpWfRecord);
        JSONObject obj = new JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        return ResponseData.makeResponseData((Map)obj);
    }

    public List<PmpWfRecord> getpmpWfRecords(Integer wmodule, String wid) {
        HashMap<String, Object> searchColumn = new HashMap<String, Object>();
        searchColumn.put("wmodule", wmodule);
        searchColumn.put("wid", wid);
        List pmpWfRecordList = this.pmpWfRecordManager.listObjects(searchColumn);
        return pmpWfRecordList;
    }

    @RequestMapping(value={"/updataPmpWfRecord"}, method={RequestMethod.POST})
    public ResponseData updataPmpWfRecord(@Valid PmpWfRecord pmpWfRecord, HttpServletRequest request, HttpServletResponse response) {
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        Date date = new Date();
        boolean isOk = true;
        String msg = "";
        Integer wmodule = pmpWfRecord.getWmodule();
        String wid = pmpWfRecord.getWid();
        Integer worder = pmpWfRecord.getWorder();
        PmpWfRecord pmpWfRecord1 = (PmpWfRecord)this.pmpWfRecordManager.getObjectByProperty("PmpWfRecordID", (Object)new PmpWfRecordID(wmodule, wid, worder));
        pmpWfRecord1.setWdate(new Date());
        this.pmpWfRecordManager.mergeObject((Serializable)pmpWfRecord1);
        JSONObject obj = new JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        return ResponseData.makeResponseData((Map)obj);
    }

    @RequestMapping(value={"getpmpRecords/{wmodule}/{wid}/{worder}"}, method={RequestMethod.GET})
    public PmpWfRecord getpmpRecords(@PathVariable Integer wmodule, @PathVariable String wid, @PathVariable Integer worder) {
        HashMap<String, Object> searchColumn = new HashMap<String, Object>();
        searchColumn.put("wmodule", wmodule);
        searchColumn.put("wid", wid);
        searchColumn.put("worder", worder);
        PmpWfRecord precord = (PmpWfRecord)this.pmpWfRecordManager.getObjectByProperty("PmpWfRecordID", (Object)new PmpWfRecordID(wmodule, wid, worder));
        return precord;
    }

    @RequestMapping(value={"/{wmodule}/{wid}/{worder}"}, method={RequestMethod.DELETE})
    public ResponseData deletepmpWfRecords(@PathVariable Integer wmodule, @PathVariable String wid, @PathVariable Integer worder, HttpServletRequest request, HttpServletResponse response) {
        boolean isOk = true;
        String msg = "";
        PmpWfRecord pmpWfRecord = (PmpWfRecord)this.pmpWfRecordManager.getObjectByProperty("PmpWfRecordID", (Object)new PmpWfRecordID(wmodule, wid, worder));
        try {
            this.pmpWfRecordManager.deleteObject((Serializable)pmpWfRecord);
        }
        catch (Exception e) {
            isOk = false;
            msg = e.getMessage();
        }
        JSONObject obj = new JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        return ResponseData.makeResponseData((Map)obj);
    }

    public void savepmpWfRecord(String status, String ideaCode, String wid, String userName, String unitCode, Integer wmodule) {
        PmpWfRecord pmpWfRecord = new PmpWfRecord();
        Date date = new Date();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("wmodule", wmodule);
        map.put("wid", wid);
        List pmps = this.pmpWfRecordManager.listObjects(map);
        Integer ordernum = 0;
        if (pmps != null && pmps.size() > 0) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < pmps.size(); ++i) {
                list.add(((PmpWfRecord)pmps.get(i)).getWorder());
            }
            ordernum = (Integer)Collections.max(list) + 1;
        } else {
            ordernum = 1;
        }
        pmpWfRecord.setPmpWfRecordID(new PmpWfRecordID(wmodule, wid, ordernum));
        pmpWfRecord.setWdate(new Date());
        pmpWfRecord.setUsername(userName);
        pmpWfRecord.setUnitcode(unitCode);
        pmpWfRecord.setStatus(status);
        pmpWfRecord.setIdeaCode(ideaCode);
        this.pmpWfRecordManager.saveNewObject((Serializable)pmpWfRecord);
    }
}

