/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.utils.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.common.controller.CommonController;
import com.nfgl.common.po.FilterUtil;
import com.nfgl.common.service.CommonManager;
import com.nfgl.sjcj.po.Farmhousejbxx;
import com.nfgl.sjcj.po.Householdregisterjbxx;
import com.nfgl.sjcj.po.Newhousingjbxx;
import com.nfgl.sjcj.po.Villagejbxx;
import com.nfgl.sjcj.service.FarmhousejbxxManager;
import com.nfgl.sjcj.service.HouseholdregisterjbxxManager;
import com.nfgl.sjcj.service.NewhousingjbxxManager;
import com.nfgl.sjcj.service.VillagejbxxManager;
import com.nfgl.utils.po.DateUtil;
import com.nfgl.utils.po.Images;
import com.nfgl.utils.service.ImagesManager;
import com.nfgl.utils.service.impl.FtpUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@RestController
@RequestMapping(value={"/utils/images"})
@PropertySource(value={"classpath:system.properties"})
public class ImagesController
extends BaseController {
    private static final Log log = LogFactory.getLog(ImagesController.class);
    private static final long serialVersionUID = 1L;
    @Resource
    private ImagesManager imagesManager;
    @Resource
    private CommonManager commonManager;
    @Resource
    private CommonController commonController;
    @Resource
    private VillagejbxxManager villagejbxxMag;
    @Resource
    private NewhousingjbxxManager newhousingjbxxManager;
    @Resource
    private HouseholdregisterjbxxManager householdregisterjbxxManager;
    @Resource
    private FarmhousejbxxManager farmhousejbxxMag;
    @Resource
    private SysUnitManager sysUnitManager;
    @Value(value="${ftp.ip}")
    public String ftpip;
    @Value(value="${ftp.username}")
    public String ftpusername;
    @Value(value="${ftp.password}")
    public String ftppassword;
    @Value(value="${ftp.port}")
    public int ftpport;
    @Value(value="${ftp.homepath}")
    public String homepath;

    public String getFtpip() {
        return this.ftpip;
    }

    public void setFtpip(String ftpip) {
        this.ftpip = ftpip;
    }

    public String getHomepath() {
        return this.homepath;
    }

    public void setHomepath(String homepath) {
        this.homepath = homepath;
    }

    public String getFtpusername() {
        return this.ftpusername;
    }

    public void setFtpusername(String ftpusername) {
        this.ftpusername = ftpusername;
    }

    public String getFtppassword() {
        return this.ftppassword;
    }

    public void setFtppassword(String ftppassword) {
        this.ftppassword = ftppassword;
    }

    public int getFtpport() {
        return this.ftpport;
    }

    public void setFtpport(int ftpport) {
        this.ftpport = ftpport;
    }

    @RequestMapping(value={"/saveAttachmentsB"}, method={RequestMethod.POST})
    public void saveAttachmentsB(@RequestParam(value="file", required=false) MultipartFile file, HttpServletRequest request, HttpServletResponse response) {
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        String typestr = request.getParameter("type");
        String ridstr = request.getParameter("rid");
        String orderNumberstr = request.getParameter("orderNumber");
        String filename = request.getParameter("filename");
        String eremark = request.getParameter("eremark");
        JSONArray arr = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{typestr}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ridstr})) {
            Long type = Long.valueOf(typestr);
            if (StringUtils.isBlank((CharSequence)orderNumberstr)) {
                String sql = "select max(eorder)+1 eorder from images ";
                ArrayList<FilterUtil> flist = new ArrayList<FilterUtil>();
                flist.add(new FilterUtil("emodule", typestr, "=", "long"));
                flist.add(new FilterUtil("eid", ridstr, "=", null));
                arr = this.commonManager.listObjectsBySqlAsJson(sql, null, flist, null);
                if (arr.getJSONObject(0).get((Object)"eorder") != null) {
                    JSONObject o = arr.getJSONObject(0);
                    orderNumberstr = o.getString("eorder");
                } else {
                    orderNumberstr = "1";
                }
            }
            Long ordernum = Long.valueOf(orderNumberstr);
            Images image = new Images();
            if (file == null || file.isEmpty()) {
                JsonResultUtils.writeErrorMessageJson((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20", (HttpServletResponse)response);
                return;
            }
            byte[] fj = null;
            try {
                fj = file.getBytes();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            image.setEmodule(Long.valueOf(typestr));
            image.setEid(ridstr);
            image.setEorder(ordernum);
            image.setEname(filename);
            image.setUserCode(loginUser.getUserCode());
            image.setUserName(loginUser.getUserInfo().getString("userName"));
            image.setUnitCode(loginUser.getCurrentUnitCode());
            image.setCreatetime(new Date());
            image.setUpdatetime(new Date());
            image.setEremark(eremark);
            this.imagesManager.mergeObject((Serializable)image);
            String iid = image.getIid();
            System.out.println(iid);
        }
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @ResponseBody
    @RequestMapping(value={"/wx/uploadFileWx"})
    public ResponseData uploadFileWx(HttpServletRequest request, HttpServletResponse response) {
        Map map = this.commonController.getUserInfosByUserCode(request);
        JSONObject user = (JSONObject)map.get("userInfo");
        JSONObject unit = (JSONObject)map.get("unitInfo");
        JSONObject userRoleInfo = (JSONObject)map.get("userRoleInfo");
        String type1 = request.getParameter("type1");
        String typestr = request.getParameter("type");
        String ridstr = request.getParameter("rid");
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        MultipartFile multipartFile = multipartRequest.getFile("file");
        return this.saveImage(typestr, ridstr, "", "", type1, multipartFile, user.getString("userCode"), user.getString("userName"), unit.getString("unitCode"));
    }

    private ResponseData saveImage(String typestr, String ridstr, String orderNumberstr, String eremark, String type1, MultipartFile multipartFile, String userCode, String userName, String unitCode) {
        try {
            JSONArray arr = null;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{typestr}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ridstr})) {
                if (StringUtils.isBlank((CharSequence)orderNumberstr)) {
                    String sql = "select max(eorder)+1 eorder from images ";
                    ArrayList<FilterUtil> flist = new ArrayList<FilterUtil>();
                    flist.add(new FilterUtil("emodule", typestr, "=", "long"));
                    flist.add(new FilterUtil("eid", ridstr, "=", null));
                    arr = this.commonManager.listObjectsBySqlAsJson(sql, null, flist, null);
                    if (arr.getJSONObject(0).get((Object)"eorder") != null) {
                        JSONObject o = arr.getJSONObject(0);
                        orderNumberstr = o.getString("eorder");
                    } else {
                        orderNumberstr = "1";
                    }
                }
                Long ordernum = Long.valueOf(orderNumberstr);
                Images image = new Images();
                if (multipartFile == null || multipartFile.isEmpty()) {
                    return ResponseData.makeErrorMessage((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                }
                byte[] fj = null;
                try {
                    fj = multipartFile.getBytes();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                image.setEmodule(Long.valueOf(typestr));
                image.setEid(ridstr);
                image.setEorder(ordernum);
                image.setType1(type1);
                image.setEname(((DiskFileItem)((CommonsMultipartFile)multipartFile).getFileItem()).getName());
                image.setUserCode(userCode);
                image.setUserName(userName);
                image.setUnitCode(unitCode);
                image.setCreatetime(new Date());
                image.setUpdatetime(new Date());
                image.setEremark(eremark);
                this.imagesManager.mergeObject((Serializable)image);
                String filename = image.getEname();
                String saveName = "";
                String hostname = this.ftpip;
                String username = this.ftpusername;
                String password = this.ftppassword;
                String ftpPath = "";
                int port = this.ftpport;
                InputStream fileInputStream = null;
                try {
                    fileInputStream = multipartFile.getInputStream();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Calendar cal = Calendar.getInstance();
                int year = cal.get(1);
                int month = cal.get(2) + 1;
                ftpPath = "/images/" + image.getEmodule() + "/" + year + "/" + month + "/";
                String fileTyle = filename.substring(filename.lastIndexOf("."), filename.length());
                saveName = image.getIid() + fileTyle;
                FtpUtil.uploadFile((String)hostname, (String)username, (String)password, (int)port, (String)ftpPath, (String)saveName, (InputStream)fileInputStream);
            }
            return ResponseData.makeSuccessResponse();
        }
        catch (Exception e) {
            return ResponseData.makeErrorMessage((String)"\u5931\u8d25");
        }
    }

    @ResponseBody
    @RequestMapping(value={"/uploadFile"})
    public ResponseData uploadFile(HttpServletRequest request, HttpServletResponse response) {
        try {
            CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
            String typestr = request.getParameter("type");
            String ridstr = request.getParameter("rid");
            String orderNumberstr = request.getParameter("orderNumber");
            String type1 = request.getParameter("type1");
            String eremark = request.getParameter("eremark");
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            MultipartFile multipartFile = multipartRequest.getFile("src");
            JSONArray arr = null;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{typestr}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{ridstr})) {
                if (StringUtils.isBlank((CharSequence)orderNumberstr)) {
                    String sql = "select max(eorder)+1 eorder from images ";
                    ArrayList<FilterUtil> flist = new ArrayList<FilterUtil>();
                    flist.add(new FilterUtil("emodule", typestr, "=", "long"));
                    flist.add(new FilterUtil("eid", ridstr, "=", null));
                    arr = this.commonManager.listObjectsBySqlAsJson(sql, null, flist, null);
                    if (arr.getJSONObject(0).get((Object)"eorder") != null) {
                        JSONObject o = arr.getJSONObject(0);
                        orderNumberstr = o.getString("eorder");
                    } else {
                        orderNumberstr = "1";
                    }
                }
                Long ordernum = Long.valueOf(orderNumberstr);
                Images image = new Images();
                if (multipartFile == null || multipartFile.isEmpty()) {
                    return ResponseData.makeErrorMessage((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                }
                byte[] fj = null;
                try {
                    fj = multipartFile.getBytes();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                image.setEmodule(Long.valueOf(typestr));
                image.setEid(ridstr);
                image.setEorder(ordernum);
                image.setType1(type1);
                image.setEname(((DiskFileItem)((CommonsMultipartFile)multipartFile).getFileItem()).getName());
                image.setUserCode(loginUser.getUserCode());
                image.setUserName(loginUser.getUserInfo().getString("userName"));
                image.setUnitCode(loginUser.getCurrentUnitCode());
                image.setCreatetime(new Date());
                image.setUpdatetime(new Date());
                image.setEremark(eremark);
                this.imagesManager.mergeObject((Serializable)image);
                String filename = image.getEname();
                String saveName = "";
                String hostname = this.ftpip;
                String username = this.ftpusername;
                String password = this.ftppassword;
                String ftpPath = "";
                int port = this.ftpport;
                InputStream fileInputStream = null;
                try {
                    fileInputStream = multipartFile.getInputStream();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Calendar cal = Calendar.getInstance();
                int year = cal.get(1);
                int month = cal.get(2) + 1;
                ftpPath = "/images/" + image.getEmodule() + "/" + year + "/" + month + "/";
                String fileTyle = filename.substring(filename.lastIndexOf("."), filename.length());
                saveName = image.getIid() + fileTyle;
                FtpUtil.uploadFile((String)hostname, (String)username, (String)password, (int)port, (String)ftpPath, (String)saveName, (InputStream)fileInputStream);
            }
            return ResponseData.makeSuccessResponse();
        }
        catch (Exception e) {
            return ResponseData.makeErrorMessage((String)"\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/getAttachmentsBTY/{emodule}/{eid}"}, method={RequestMethod.GET})
    public ResponseData getAttachmentsBTY(@PathVariable Long emodule, @PathVariable String eid, HttpServletRequest request, HttpServletResponse response) {
        List images = this.getImagesByModuleAndId(emodule, eid);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("fjList", (Object)images);
        return resData;
    }

    @RequestMapping(value={"/isImages/{emodule}/{eid}/{type1s}"}, method={RequestMethod.GET})
    public ResponseData isImages(@PathVariable Long emodule, @PathVariable String eid, @PathVariable String type1s, HttpServletRequest request, HttpServletResponse response) {
        ResponseMapData resData = new ResponseMapData();
        boolean b = false;
        String msg = "";
        HashMap<String, Object> searchColumn = new HashMap<String, Object>();
        searchColumn.put("emodule", emodule);
        searchColumn.put("eid", eid);
        List list = this.imagesManager.listObjects(searchColumn);
        String[] type1ss = type1s.split("@");
        if (type1ss != null && type1ss.length > 0 && list != null && list.size() > 0) {
            for (String s : type1ss) {
                b = false;
                for (Images i : list) {
                    if (!s.equals(i.getType1())) continue;
                    b = true;
                    msg = msg + s + "\u56fe\u7247\u5b58\u5728\uff01";
                    break;
                }
                if (b) continue;
                msg = msg + s + "\u56fe\u7247\u4e0d\u5b58\u5728\uff01";
                break;
            }
        }
        resData.addResponseData("b", (Object)b);
        resData.addResponseData("msg", (Object)msg);
        return resData;
    }

    public List<Images> getImagesByModuleAndId(Long emodule, String eid) {
        HashMap<String, Object> searchColumn = new HashMap<String, Object>();
        searchColumn.put("emodule", emodule);
        searchColumn.put("eid", eid);
        searchColumn.put("sort", "eorder");
        searchColumn.put("order", "asc");
        List list = this.imagesManager.listObjects(searchColumn);
        String iid = "";
        String saveName = "";
        String fileTyle = "";
        String filename = "";
        String ftpPath = "";
        String localpath = this.homepath;
        if (list != null && list.size() > 0) {
            for (Images image : list) {
                filename = image.getEname();
                Date date = image.getCreatetime();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int year = calendar.get(1);
                int month = calendar.get(2) + 1;
                ftpPath = "/images/" + image.getEmodule() + "/" + year + "/" + month + "/";
                fileTyle = filename.substring(filename.lastIndexOf("."), filename.length());
                iid = image.getIid();
                saveName = iid + fileTyle;
                File file = new File(localpath + "/" + saveName);
                if (!file.exists()) {
                    FtpUtil.downloadFtpFile((String)this.ftpip, (String)this.ftpusername, (String)this.ftppassword, (int)this.ftpport, (String)ftpPath, (String)localpath, (String)saveName, (String)saveName);
                }
                try {
                    FileInputStream is = new FileInputStream(file);
                    int num = is.available();
                    byte[] buffer = new byte[is.available()];
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    int len = -1;
                    if (num > 0) {
                        for (int tempi = 0; (len = is.read(buffer)) != -1 && num >= tempi; ++tempi) {
                            outStream.write(buffer, 0, len);
                        }
                    }
                    outStream.close();
                    is.close();
                    image.setEfj(outStream.toByteArray());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    @RequestMapping(value={"/downloadTY/{iid}"}, method={RequestMethod.GET})
    public String downloadTY(@PathVariable String iid, HttpServletRequest request, HttpServletResponse response) {
        Images ab = (Images)this.imagesManager.getObjectById((Serializable)((Object)iid));
        String ftpPath = "";
        Date date = ab.getCreatetime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        ftpPath = "/images/" + ab.getEmodule() + "/" + year + "/" + month + "/";
        String filename = ab.getEname();
        String fileTyle = filename.substring(filename.lastIndexOf("."), filename.length());
        String saveName = iid + fileTyle;
        InputStream in = FtpUtil.downloadFtpFile2((String)this.ftpip, (String)this.ftpusername, (String)this.ftppassword, (int)this.ftpport, (String)ftpPath, (String)saveName);
        byte[] buff = new byte[0x100000];
        int len = 0;
        response.reset();
        try {
            response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(ab.getEname(), "utf-8"));
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            while ((len = in.read(buff)) != -1) {
                ((OutputStream)toClient).write(buff, 0, len);
                ((OutputStream)toClient).flush();
            }
            if (in != null) {
                in.close();
            }
            if (toClient != null) {
                ((OutputStream)toClient).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @GetMapping
    public ResponseData list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("addUserCodes", (Object)"T");
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        JSONArray jsonArr = this.imagesManager.listObjectsAsJson(searchColumn, pageDesc);
        String fslog = "";
        HashMap<String, String> properties = new HashMap<String, String>();
        for (int i = 0; i < jsonArr.size(); ++i) {
            Newhousingjbxx newhousingjbxx;
            fslog = "";
            JSONObject obj = jsonArr.getJSONObject(i);
            String emodule = obj.get((Object)"emodule") + "";
            String eid = (String)obj.get((Object)"eid");
            if (emodule.equals("1")) {
                String un = "";
                Farmhousejbxx farmhousejbxx = (Farmhousejbxx)this.farmhousejbxxMag.getObjectById((Serializable)((Object)eid));
                if (farmhousejbxx != null && farmhousejbxx.getVid() != null && !"".equals(farmhousejbxx.getVid())) {
                    UnitInfo uf;
                    properties.clear();
                    properties.put("vid", farmhousejbxx.getVid());
                    Villagejbxx villagejbxx = (Villagejbxx)this.villagejbxxMag.getObjectByProperties(properties);
                    String districtcode = villagejbxx.getDistrictcode();
                    if (districtcode != null && !"".equals(districtcode) && (uf = this.sysUnitManager.getObjectById(districtcode)).getUnitName() != null) {
                        un = uf.getUnitName();
                    }
                    fslog = un + villagejbxx.getAdministrativevillage();
                }
                properties.clear();
                properties.put("fid", eid);
                properties.put("isHz", "T");
                Householdregisterjbxx householdregisterjbxx = (Householdregisterjbxx)this.householdregisterjbxxManager.getObjectByProperties(properties);
                if (householdregisterjbxx != null) {
                    fslog = fslog + householdregisterjbxx.getFname();
                }
            } else if (emodule.equals("2") && (newhousingjbxx = (Newhousingjbxx)this.newhousingjbxxManager.getObjectById((Serializable)((Object)eid))) != null) {
                fslog = newhousingjbxx.getHaddress();
            }
            obj.put("fslog", (Object)fslog);
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)jsonArr);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @RequestMapping(value={"/{iid}"}, method={RequestMethod.GET})
    public void getImages(@PathVariable String iid, HttpServletResponse response) {
        Images images = (Images)this.imagesManager.getObjectById((Serializable)((Object)iid));
        String filename = images.getEname();
        String fileTyle = filename.substring(filename.lastIndexOf("."), filename.length());
        String saveName = iid + fileTyle;
        Date date = images.getCreatetime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        String ftpPath = "/images/" + images.getEmodule() + "/" + year + "/" + month + "/";
        String localpath = this.homepath;
        File file = new File(localpath + "/" + saveName);
        if (!file.exists()) {
            FtpUtil.downloadFtpFile((String)this.ftpip, (String)this.ftpusername, (String)this.ftppassword, (int)this.ftpport, (String)ftpPath, (String)localpath, (String)saveName, (String)saveName);
        }
        try {
            FileInputStream is = new FileInputStream(file);
            int num = is.available();
            byte[] buffer = new byte[num];
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            int len = -1;
            if (num > 0) {
                for (int tempi = 0; (len = is.read(buffer)) != -1 && num >= tempi; ++tempi) {
                    outStream.write(buffer, 0, len);
                }
            }
            outStream.close();
            is.close();
            images.setEfj(outStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JsonResultUtils.writeSingleDataJson((Object)images, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{iid}"}, method={RequestMethod.DELETE})
    public ResponseData delete(@PathVariable String iid, HttpServletResponse response) {
        return this.delete(iid);
    }

    public ResponseData delete(String iid) {
        Images images = (Images)this.imagesManager.getObjectById((Serializable)((Object)iid));
        String hostname = this.ftpip;
        String username = this.ftpusername;
        String password = this.ftppassword;
        String ftpPath = "";
        String filename = images.getEname();
        String fileTyle = filename.substring(filename.lastIndexOf("."), filename.length());
        String saveName = iid + fileTyle;
        Date date = images.getCreatetime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        ftpPath = "/images/" + images.getEmodule() + "/" + year + "/" + month + "/";
        int port = this.ftpport;
        boolean isOk = true;
        String msg = "";
        try {
            this.imagesManager.deleteObjectById((Serializable)((Object)iid));
            FtpUtil.deleteFile((String)hostname, (String)username, (String)password, (int)port, (String)ftpPath, (String)saveName);
        }
        catch (Exception e) {
            isOk = false;
            msg = e.getMessage();
        }
        JSONObject obj = new JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        return ResponseData.makeResponseData((Map)obj);
    }

    public ResponseData saveImageData(JSONObject fjList) {
        try {
            String emodule = fjList.getString("emodule");
            String eid = fjList.getString("eid");
            byte[] efjs = fjList.getBytes("efj");
            String iid = fjList.getString("iid");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("emodule", emodule);
            map.put("iid", iid);
            map.put("eid", eid);
            List images = this.imagesManager.listObjects(map);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{emodule}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{eid}) && (images == null || images.size() == 0)) {
                Images image = new Images();
                if (efjs == null || efjs.length == 0) {
                    return ResponseData.makeErrorMessage((String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                }
                ByteArrayInputStream fileInputStream = new ByteArrayInputStream(efjs);
                String filename = fjList.getString("ename");
                String createtime = fjList.getString("createtime");
                String updatetime = fjList.getString("updatetime");
                String type1 = fjList.getString("type1");
                String userCode = fjList.getString("userCode");
                String userName = fjList.getString("userName");
                String unitCode = fjList.getString("unitCode");
                String eremark = fjList.getString("eremark");
                Integer eorder = fjList.getInteger("eorder");
                String year = createtime.substring(0, 4);
                String months = createtime.substring(5, 7);
                int month = Integer.parseInt(months);
                image.setEmodule(Long.valueOf(emodule));
                image.setEid(eid);
                image.setIid(iid);
                image.setEorder(Long.valueOf(eorder.longValue()));
                image.setType1(type1);
                image.setEname(filename);
                image.setUserCode(userCode);
                image.setUserName(userName);
                image.setUnitCode(unitCode);
                image.setCreatetime(DateUtil.parse((String)createtime, (String)"yyyy-MM-dd HH:mm:ss"));
                image.setUpdatetime(DateUtil.parse((String)updatetime, (String)"yyyy-MM-dd HH:mm:ss"));
                image.setEremark(eremark);
                this.imagesManager.mergeObject((Serializable)image);
                String saveName = "";
                String hostname = this.ftpip;
                String username = this.ftpusername;
                String password = this.ftppassword;
                String ftpPath = "";
                int port = this.ftpport;
                ftpPath = "/images/" + image.getEmodule() + "/" + year + "/" + month + "/";
                String fileTyle = filename.substring(filename.lastIndexOf("."), filename.length());
                saveName = image.getIid() + fileTyle;
                FtpUtil.uploadFile((String)hostname, (String)username, (String)password, (int)port, (String)ftpPath, (String)saveName, (InputStream)fileInputStream);
            }
            return ResponseData.makeSuccessResponse();
        }
        catch (Exception e) {
            return ResponseData.makeErrorMessage((String)"\u5931\u8d25");
        }
    }
}

