/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.utils.controller;

import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.service.SysUnitManager;
import com.nfgl.common.controller.CommonController;
import com.nfgl.common.service.CommonManager;
import com.nfgl.sjcj.service.FarmhousejbxxManager;
import com.nfgl.sjcj.service.HouseholdregisterjbxxManager;
import com.nfgl.sjcj.service.NewhousingjbxxManager;
import com.nfgl.sjcj.service.VillagejbxxManager;
import com.nfgl.utils.po.Attachment;
import com.nfgl.utils.service.AttachmentManager;
import com.nfgl.utils.service.ImagesManager;
import com.nfgl.utils.service.impl.FtpUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/attachment"})
@PropertySource(value={"classpath:system.properties"})
public class AttachmentController
extends BaseController {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AttachmentController.class);
    @Resource
    private AttachmentManager attachmentManager;
    @Resource
    private ImagesManager imagesManager;
    @Resource
    private CommonManager commonManager;
    @Resource
    private CommonController commonController;
    @Resource
    private VillagejbxxManager villagejbxxMag;
    @Resource
    private NewhousingjbxxManager newhousingjbxxManager;
    @Resource
    private HouseholdregisterjbxxManager householdregisterjbxxManager;
    @Resource
    private FarmhousejbxxManager farmhousejbxxMag;
    @Resource
    private SysUnitManager sysUnitManager;
    @Value(value="${ftp.ip}")
    public String ftpip;
    @Value(value="${ftp.username}")
    public String ftpusername;
    @Value(value="${ftp.password}")
    public String ftppassword;
    @Value(value="${ftp.port}")
    public int ftpport;
    @Value(value="${ftp.homepath}")
    public String homepath;

    public String getHomepath() {
        return this.homepath;
    }

    public void setHomepath(String homepath) {
        this.homepath = homepath;
    }

    public String getFtpip() {
        return this.ftpip;
    }

    public void setFtpip(String ftpip) {
        this.ftpip = ftpip;
    }

    public String getFtpusername() {
        return this.ftpusername;
    }

    public void setFtpusername(String ftpusername) {
        this.ftpusername = ftpusername;
    }

    public String getFtppassword() {
        return this.ftppassword;
    }

    public void setFtppassword(String ftppassword) {
        this.ftppassword = ftppassword;
    }

    public int getFtpport() {
        return this.ftpport;
    }

    public void setFtpport(int ftpport) {
        this.ftpport = ftpport;
    }

    public void checkDataReportUpload(InputStream fileInputStream, String iid, String filename, String eid, String emodoule, String eorderstr, String type1, CentitUserDetails loginUser) throws IOException {
        Attachment attachment;
        String saveName = "";
        String hostname = this.ftpip;
        String username = this.ftpusername;
        String password = this.ftppassword;
        String ftpPath = "";
        int port = this.ftpport;
        ftpPath = "/attachment/" + emodoule + "/";
        File file1 = new File(ftpPath);
        if (!file1.exists()) {
            file1.mkdirs();
        }
        String fileTyle = filename.substring(filename.lastIndexOf("."), filename.length());
        String index = UUID.randomUUID().toString().replaceAll("-", "");
        saveName = index + fileTyle;
        if (iid != null && !"undefined".equals(iid)) {
            saveName = iid + fileTyle;
            FtpUtil.uploadFile((String)hostname, (String)username, (String)password, (int)port, (String)ftpPath, (String)saveName, (InputStream)fileInputStream);
            attachment = (Attachment)this.attachmentManager.getObjectById((Serializable)((Object)iid));
            attachment.setUpdateTime(new Date());
        } else {
            FtpUtil.uploadFile((String)hostname, (String)username, (String)password, (int)port, (String)ftpPath, (String)saveName, (InputStream)fileInputStream);
            attachment = new Attachment();
            attachment.setIid(index);
            attachment.setUserCode(loginUser.getUserCode());
            attachment.setUnitCode(loginUser.getCurrentUnitCode());
            attachment.setUserName(loginUser.getUserInfo().getString("userName"));
            attachment.setCreateTime(new Date());
            attachment.setUpdateTime(new Date());
        }
        if (StringUtils.isNotBlank((CharSequence)eid)) {
            attachment.setEid(eid);
        }
        if (StringUtils.isNotBlank((CharSequence)emodoule)) {
            attachment.setEmodule(Integer.valueOf(emodoule));
        }
        if (StringUtils.isNotBlank((CharSequence)eorderstr)) {
            attachment.setEorder(Integer.valueOf(eorderstr));
        }
        if (StringUtils.isNotBlank((CharSequence)type1)) {
            attachment.setType1(type1);
        }
        attachment.setEname(filename);
        if (attachment.getEorder() == null || attachment.getEorder() < 1) {
            Integer ordernum = 0;
            HashMap<String, String> searchColumn = new HashMap<String, String>();
            searchColumn.put("eid", eid);
            searchColumn.put("emodule", emodoule);
            List attachmentList = this.attachmentManager.listObjects(searchColumn);
            if (attachmentList != null && attachmentList.size() > 0) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (Attachment att : attachmentList) {
                    list.add(att.getEorder());
                }
                ordernum = (Integer)Collections.max(list) + 1;
            } else {
                ordernum = 1;
            }
            attachment.setEorder(ordernum);
        }
        this.attachmentManager.mergeObject((Serializable)attachment);
    }

    @RequestMapping(value={"/wx/uploadfj"}, method={RequestMethod.POST})
    public ResponseData uploadFjwx(@RequestParam(value="file", required=false) MultipartFile file11, HttpServletRequest request, HttpServletResponse response) {
        String iid = request.getParameter("iid");
        String filename = request.getParameter("fileName");
        String eid = request.getParameter("eid");
        String emodoule = request.getParameter("types");
        String eorderstr = request.getParameter("eorder");
        String type1 = request.getParameter("type1");
        Map map = this.commonController.getUserInfosByUserCode(request);
        JSONObject user = (JSONObject)map.get("userInfo");
        JSONObject unit = (JSONObject)map.get("unitInfo");
        JSONObject userRoleInfo = (JSONObject)map.get("userRoleInfo");
        return this.saveAttachment(iid, filename, eid, emodoule, eorderstr, type1, file11, user.getString("userCode"), user.getString("userName"), unit.getString("unitCode"));
    }

    private ResponseData saveAttachment(String iid, String filename, String eid, String emodoule, String eorderstr, String type1, MultipartFile file11, String userCode, String userName, String unitCode) {
        Attachment attachment;
        String saveName = "";
        String hostname = this.ftpip;
        String username = this.ftpusername;
        String password = this.ftppassword;
        String ftpPath = "";
        int port = this.ftpport;
        InputStream fileInputStream = null;
        try {
            fileInputStream = file11.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ftpPath = "/attachment/" + emodoule + "/";
        File file1 = new File(ftpPath);
        if (!file1.exists()) {
            file1.mkdirs();
        }
        String fileTyle = filename.substring(filename.lastIndexOf("."), filename.length());
        String index = UUID.randomUUID().toString().replaceAll("-", "");
        saveName = index + fileTyle;
        if (iid != null && !"undefined".equals(iid)) {
            saveName = iid + fileTyle;
            FtpUtil.uploadFile((String)hostname, (String)username, (String)password, (int)port, (String)ftpPath, (String)saveName, (InputStream)fileInputStream);
            attachment = (Attachment)this.attachmentManager.getObjectById((Serializable)((Object)iid));
            attachment.setUpdateTime(new Date());
        } else {
            FtpUtil.uploadFile((String)hostname, (String)username, (String)password, (int)port, (String)ftpPath, (String)saveName, (InputStream)fileInputStream);
            attachment = new Attachment();
            attachment.setIid(index);
            attachment.setUserCode(userCode);
            attachment.setUnitCode(unitCode);
            attachment.setUserName(userName);
            attachment.setCreateTime(new Date());
            attachment.setUpdateTime(new Date());
        }
        if (StringUtils.isNotBlank((CharSequence)eid)) {
            attachment.setEid(eid);
        }
        if (StringUtils.isNotBlank((CharSequence)emodoule)) {
            attachment.setEmodule(Integer.valueOf(emodoule));
        }
        if (StringUtils.isNotBlank((CharSequence)eorderstr)) {
            attachment.setEorder(Integer.valueOf(eorderstr));
        }
        if (StringUtils.isNotBlank((CharSequence)type1)) {
            attachment.setType1(type1);
        }
        attachment.setEname(filename);
        if (attachment.getEorder() == null || attachment.getEorder() < 1) {
            Integer ordernum = 0;
            HashMap<String, String> searchColumn = new HashMap<String, String>();
            searchColumn.put("eid", eid);
            searchColumn.put("emodule", emodoule);
            List attachmentList = this.attachmentManager.listObjects(searchColumn);
            if (attachmentList != null && attachmentList.size() > 0) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (Attachment att : attachmentList) {
                    list.add(att.getEorder());
                }
                ordernum = (Integer)Collections.max(list) + 1;
            } else {
                ordernum = 1;
            }
            attachment.setEorder(ordernum);
        }
        this.attachmentManager.mergeObject((Serializable)attachment);
        return ResponseData.makeSuccessResponse();
    }

    @RequestMapping(value={"/uploadfj"}, method={RequestMethod.POST})
    public ResponseData uploadFj(@RequestParam(value="file", required=false) MultipartFile file11, HttpServletRequest request, HttpServletResponse response) {
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        String iid = request.getParameter("iid");
        String filename = request.getParameter("fileName");
        String eid = request.getParameter("eid");
        String emodoule = request.getParameter("types");
        String eorderstr = request.getParameter("eorder");
        String type1 = request.getParameter("type1");
        return this.saveAttachment(iid, filename, eid, emodoule, eorderstr, type1, file11, loginUser.getUserCode(), loginUser.getUserInfo().getString("userName"), loginUser.getCurrentUnitCode());
    }

    @RequestMapping(value={"/getAttachments/{emodule}/{eid}"}, method={RequestMethod.GET})
    public ResponseData getAttachments(@PathVariable Integer emodule, @PathVariable String eid, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> searchColumn = new HashMap<String, Object>();
        searchColumn.put("emodule", emodule);
        searchColumn.put("eid", eid);
        List attachmentList = this.attachmentManager.listObjects(searchColumn);
        JSONObject obj = new JSONObject();
        obj.put("fjlist", (Object)attachmentList);
        return ResponseData.makeResponseData((Map)obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/downloadFJ/{iid}"}, method={RequestMethod.GET})
    public String downloadFj(@PathVariable String iid, HttpServletRequest request, HttpServletResponse response) {
        Attachment attachment = (Attachment)this.attachmentManager.getObjectById((Serializable)((Object)iid));
        String saveName = "";
        String ftpPath = "";
        Integer emodule = attachment.getEmodule();
        ftpPath = "/attachment/" + emodule + "/";
        String fileName = attachment.getEname();
        String fileTyle = fileName.substring(fileName.lastIndexOf("."), fileName.length());
        saveName = iid + fileTyle;
        String localpath = this.homepath;
        File file = new File(localpath + "/" + saveName);
        if (!file.exists()) {
            FtpUtil.downloadFtpFile((String)this.ftpip, (String)this.ftpusername, (String)this.ftppassword, (int)this.ftpport, (String)ftpPath, (String)localpath, (String)saveName, (String)saveName);
        }
        int len = -1;
        BufferedOutputStream toClient = null;
        try {
            response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(attachment.getEname(), "utf-8"));
            toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            FileInputStream is = new FileInputStream(file);
            int num = is.available();
            byte[] buffer = new byte[num];
            if (num > 0) {
                for (int tempi = 0; (len = is.read(buffer)) != -1 && num >= tempi; ++tempi) {
                    ((OutputStream)toClient).write(buffer, 0, len);
                    ((OutputStream)toClient).flush();
                }
            }
            if (is != null) {
                is.close();
            }
            if (toClient != null) {
                ((OutputStream)toClient).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            File file2 = new File(localpath + "/" + saveName);
            if (file2.exists()) {
                file2.delete();
                System.out.println("\u5220\u9664\u6587\u4ef6\u6210\u529f!path=" + localpath + "/" + saveName);
            }
        }
        return null;
    }

    @RequestMapping(value={"{iid}"}, method={RequestMethod.DELETE})
    public ResponseData deleteAttachment(String iid) {
        return this.delete(iid);
    }

    @RequestMapping(value={"/delete/{iid}"}, method={RequestMethod.DELETE})
    public ResponseData delete(@PathVariable String iid, HttpServletResponse response) {
        return this.delete(iid);
    }

    private ResponseData delete(String iid) {
        Attachment attachment = (Attachment)this.attachmentManager.getObjectById((Serializable)((Object)iid));
        String saveName = "";
        String hostname = this.ftpip;
        String username = this.ftpusername;
        String password = this.ftppassword;
        String ftpPath = "";
        int port = this.ftpport;
        Integer emodule = attachment.getEmodule();
        ftpPath = "/attachment/" + emodule + "/";
        String fileName = attachment.getEname();
        String fileTyle = fileName.substring(fileName.lastIndexOf("."), fileName.length());
        saveName = iid + fileTyle;
        boolean isOk = true;
        String msg = "";
        try {
            this.attachmentManager.deleteObjectById((Serializable)((Object)iid));
            FtpUtil.deleteFile((String)hostname, (String)username, (String)password, (int)port, (String)ftpPath, (String)saveName);
        }
        catch (Exception e) {
            isOk = false;
            e.printStackTrace();
            msg = e.getMessage();
        }
        JSONObject obj = new JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        return ResponseData.makeResponseData((Map)obj);
    }
}

