/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.task.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.model.basedata.IUnitInfo;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.common.StaticVariable;
import com.nfgl.common.controller.CommonController;
import com.nfgl.sjcj.controller.DataExchangeSaveController;
import com.nfgl.task.po.Taskassignment;
import com.nfgl.task.service.TaskassignmentManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/task/taskassignment"})
public class TaskassignmentController
extends BaseController {
    private static final Log log = LogFactory.getLog(TaskassignmentController.class);
    private static final long serialVersionUID = 1L;
    @Resource
    private TaskassignmentManager taskassignmentMag;
    @Resource
    private CommonController commonController;
    @Resource
    private SysUnitManager sysUnitManager;

    @RequestMapping(method={RequestMethod.GET})
    public ResponseData list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        String currentUnitCode = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request).getCurrentUnitCode();
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        if (searchColumn.containsKey("second")) {
            currentUnitCode = searchColumn.get("second").toString();
        }
        if (searchColumn.containsKey("third")) {
            currentUnitCode = searchColumn.get("third").toString();
        }
        if (searchColumn.containsKey("fourth")) {
            currentUnitCode = searchColumn.get("fourth").toString();
        }
        Object tyear = searchColumn.get("tyear");
        String unitName = (String)searchColumn.get("unitName");
        if (tyear == null) {
            Calendar date = Calendar.getInstance();
            tyear = date.get(1);
            searchColumn.put("tyear", tyear);
        }
        List list = this.commonController.listSelfAndSubUnitsOfCache(currentUnitCode);
        JSONArray ja = new JSONArray();
        for (IUnitInfo u : list) {
            if (StringUtils.isNotBlank((CharSequence)unitName) && u.getUnitName().indexOf(unitName) == -1) continue;
            JSONObject jo = new JSONObject();
            HashMap map = new HashMap();
            map.put("tyear", tyear);
            map.put("districtcode", u.getUnitCode());
            List taskassignments = this.taskassignmentMag.listObjects(map);
            if (taskassignments != null && taskassignments.size() > 0) {
                Long detailnum = ((Taskassignment)taskassignments.get(0)).getDetailnum();
                jo.put("unitOrder", (Object)detailnum);
                jo.put("tid", (Object)((Taskassignment)taskassignments.get(0)).getTid());
            } else {
                jo.put("unitOrder", (Object)"0");
            }
            jo.put("tyear", tyear);
            if (StringUtils.isBlank((CharSequence)unitName)) {
                jo.put("state", (Object)"closed");
            }
            jo.put("id", (Object)u.getUnitCode());
            jo.put("text", (Object)u.getUnitName());
            jo.put("unitName", (Object)u.getUnitName());
            jo.put("unitCode", (Object)u.getUnitCode());
            jo.put("parentUnit", (Object)u.getParentUnit());
            ja.add((Object)jo);
        }
        return ResponseData.makeResponseData((Object)ja);
    }

    @RequestMapping(value={"/getCurrentTasks/{districtcode}/{tyear}"}, method={RequestMethod.GET})
    public void getCurrentTasks(@PathVariable String districtcode, @PathVariable Long tyear, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("parentUnit", districtcode);
        List unitInfos = this.sysUnitManager.listObjects(map);
        String districtcode1 = "";
        ArrayList taskassignments = new ArrayList();
        for (UnitInfo u : unitInfos) {
            if (!StringUtils.isNotBlank((CharSequence)u.getUnitCode())) continue;
            districtcode1 = u.getUnitCode();
            map.clear();
            map.put("districtcode", districtcode1);
            map.put("tyear", tyear);
            map.put("sort", "districtcode");
            map.put("order", "asc");
            List taskassignments1 = this.taskassignmentMag.listObjects(map);
            if (taskassignments1.size() > 0) {
                taskassignments.add(taskassignments1.get(0));
                continue;
            }
            if (taskassignments1.size() > 0) continue;
            Date date = new Date();
            Taskassignment taskassignment = new Taskassignment();
            taskassignment.setTyear(tyear);
            taskassignment.setDistrictcode(districtcode1);
            taskassignment.setDetailnum(Long.valueOf(0L));
            taskassignment.setUserCode("62");
            taskassignment.setUserName(u.getUnitName());
            taskassignment.setUnitCode(u.getUnitCode());
            taskassignment.setCreatetime(date);
            taskassignment.setUpdatetime(date);
            this.taskassignmentMag.saveNewObject((Serializable)taskassignment);
            taskassignments.add(taskassignment);
        }
        map.clear();
        map.put("districtcode", districtcode);
        map.put("tyear", tyear);
        map.put("sort", "districtcode");
        map.put("order", "asc");
        List taskassignments1 = this.taskassignmentMag.listObjects(map);
        taskassignments.add(0, taskassignments1.get(0));
        JsonResultUtils.writeSingleDataJson(taskassignments, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/saveSubTasks"}, method={RequestMethod.PUT})
    public ResponseData saveSubTasks(HttpServletRequest request, HttpServletResponse response) {
        JSONArray arr;
        String msg = "";
        boolean isOk = true;
        String list = request.getParameter("list");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{list}) && (arr = JSONArray.parseArray((String)list)) != null && arr.size() > 0) {
            for (int i = 0; i < arr.size(); ++i) {
                JSONObject obj = (JSONObject)arr.get(i);
                String tid = obj.getString("tid");
                Taskassignment taskassignmentdb = (Taskassignment)this.taskassignmentMag.getObjectById((Serializable)((Object)tid));
                String detailnum = obj.getString("detailnum");
                if (!StringUtils.isNotBlank((CharSequence)detailnum)) continue;
                taskassignmentdb.setDetailnum(Long.valueOf(Long.parseLong(detailnum)));
                this.taskassignmentMag.mergeObject((Serializable)taskassignmentdb);
            }
        }
        JSONObject obj = new JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        return ResponseData.makeResponseData((Map)obj);
    }

    @RequestMapping(value={"/{tid}"}, method={RequestMethod.GET})
    public void getTaskassignment(@PathVariable String tid, HttpServletResponse response) {
        Taskassignment taskassignment = (Taskassignment)this.taskassignmentMag.getObjectById((Serializable)((Object)tid));
        JsonResultUtils.writeSingleDataJson((Object)taskassignment, (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseData createTaskassignment(@Valid Taskassignment taskassignment, HttpServletResponse response, HttpServletRequest request) {
        boolean isOk = true;
        String msg = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tyear", taskassignment.getTyear());
        List taskassignments = this.taskassignmentMag.listObjects(map);
        if (taskassignments != null && taskassignments.size() > 0) {
            msg = taskassignment.getTyear() + "\u5e74\u4efb\u52a1\u5df2\u5206\u914d";
            isOk = false;
        } else {
            CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
            Date date = new Date();
            map.clear();
            map.put("isValid", "T");
            List unitInfos = this.commonController.listSubUnitsNotIncludedVillageOfCache(taskassignment.getDistrictcode());
            Long tyear = taskassignment.getTyear();
            String unitCode = "";
            for (IUnitInfo unitInfo : unitInfos) {
                unitCode = unitInfo.getUnitCode();
                Taskassignment t = new Taskassignment();
                t.setTyear(tyear);
                t.setDistrictcode(unitCode);
                if (taskassignment.getDistrictcode().equals(unitCode) && taskassignment.getDetailnum() != null) {
                    t.setDetailnum(taskassignment.getDetailnum());
                } else {
                    t.setDetailnum(Long.valueOf(0L));
                }
                t.setUserCode(loginUser.getUserCode());
                t.setUserName(loginUser.getUserInfo().getString("userName"));
                t.setUnitCode(loginUser.getCurrentUnitCode());
                t.setCreatetime(date);
                t.setUpdatetime(date);
                this.taskassignmentMag.saveNewObject((Serializable)t);
            }
        }
        JSONObject obj = new JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        return ResponseData.makeResponseData((Map)obj);
    }

    @RequestMapping(value={"/{tid}"}, method={RequestMethod.DELETE})
    public void deleteTaskassignment(@PathVariable String tid, HttpServletResponse response) {
        this.taskassignmentMag.deleteObjectById((Serializable)((Object)tid));
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{tid}"}, method={RequestMethod.PUT})
    public ResponseData updateTaskassignment(@PathVariable String tid, @Valid Taskassignment taskassignment, HttpServletResponse response) {
        Taskassignment dbTaskassignment = (Taskassignment)this.taskassignmentMag.getObjectById((Serializable)((Object)tid));
        if (null != taskassignment) {
            dbTaskassignment.copy(taskassignment);
            this.taskassignmentMag.mergeObject((Serializable)dbTaskassignment);
        } else {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728", (HttpServletResponse)response);
        }
        return ResponseData.makeResponseData((Object)dbTaskassignment);
    }

    @RequestMapping(value={"/list2"}, method={RequestMethod.GET})
    public String list2(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        String parentUnitCode;
        String res = "";
        String secret = request.getParameter("secret");
        Boolean b = DataExchangeSaveController.securityData((String)secret, (String)(parentUnitCode = request.getParameter("parentUnitCode")));
        if (b.booleanValue()) {
            String tyear = request.getParameter("tyear");
            HashMap<String, String> searchColumn = new HashMap<String, String>();
            searchColumn.put("districtcode1", parentUnitCode.substring(0, 6));
            searchColumn.put("tyear", tyear);
            JSONArray arr = this.taskassignmentMag.listObjectsAsJson(searchColumn, null);
            res = StaticVariable.encryptAndBase64String((String)arr.toJSONString());
        }
        return res;
    }
}

