/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.task.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.common.controller.CommonController;
import com.nfgl.task.po.Randomselection;
import com.nfgl.task.po.Randomselectiondeail;
import com.nfgl.task.service.RandomselectionManager;
import com.nfgl.task.service.RandomselectiondeailManager;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/task/randomSelection"})
public class RandomselectionController
extends BaseController {
    private static final Log log = LogFactory.getLog(RandomselectionController.class);
    private static final long serialVersionUID = 1L;
    @Resource
    private RandomselectionManager randomselectionMag;
    @Resource
    private CommonController commonController;
    @Resource
    private RandomselectiondeailManager randomselectiondeailMag;

    @RequestMapping(method={RequestMethod.GET})
    public ResponseData list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        JSONArray listObjects = this.randomselectionMag.listObjectsAsJson(searchColumn, pageDesc);
        if (listObjects != null && listObjects.size() > 0) {
            for (int i = 0; i < listObjects.size(); ++i) {
                JSONObject jsonObject = listObjects.getJSONObject(i);
                String districtcode = jsonObject.getString("districtcode");
                String[] dis = new String[]{districtcode};
                String[] names = this.commonController.getUnitNames(dis);
                jsonObject.put("districtcode", (Object)names[0]);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("rid", jsonObject.getString("rid"));
                List randomselectiondeails = this.randomselectiondeailMag.listObjects(map);
                if (randomselectiondeails == null || randomselectiondeails.size() <= 0) continue;
                jsonObject.put("fjnum", (Object)randomselectiondeails.size());
            }
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @RequestMapping(value={"/{rid}"}, method={RequestMethod.GET})
    public void getRandomselection(@PathVariable String rid, HttpServletResponse response) {
        Randomselection randomselection = (Randomselection)this.randomselectionMag.getObjectById((Serializable)((Object)rid));
        if (StringUtils.isNotBlank((String)randomselection.getDistrictcode())) {
            String[] dis = new String[]{randomselection.getDistrictcode()};
            String[] names = this.commonController.getUnitNames(dis);
            randomselection.setDistrictcode(names[0]);
        }
        JsonResultUtils.writeSingleDataJson((Object)randomselection, (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    public JSONObject createRandomselection(@Valid Randomselection randomselection, HttpServletRequest request, HttpServletResponse response) {
        JSONObject rlt = new JSONObject();
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        String rid = randomselection.getRid();
        String realityyear = request.getParameter("realityyear");
        String rtype = request.getParameter("rtype");
        if (StringUtils.isNotBlank((String)rtype)) {
            randomselection.setRtype(rtype);
        } else {
            randomselection.setRtype("2");
        }
        Date date = new Date();
        if (StringUtils.isBlank((String)rid)) {
            randomselection.setRid(null);
            randomselection.setUnitCode(loginUser.getCurrentUnitCode());
            randomselection.setUserName(loginUser.getUserInfo().getString("userName"));
            randomselection.setUserCode(loginUser.getUserCode());
            randomselection.setCreatetime(date);
            randomselection.setUpdatetime(date);
            randomselection.setRandomtime(date);
        } else {
            Randomselection randomselectiondb = (Randomselection)this.randomselectionMag.getObjectById((Serializable)((Object)rid));
            randomselectiondb.copyNotNullProperty(randomselection);
            randomselection = randomselectiondb;
            randomselection.setUpdatetime(date);
        }
        randomselection.setRealityyear(realityyear);
        this.randomselectionMag.mergeObject((Serializable)randomselection);
        rlt.put("isOk", (Object)true);
        rlt.put("obj", (Object)randomselection);
        return rlt;
    }

    @RequestMapping(value={"/{rid}"}, method={RequestMethod.DELETE})
    public void deleteRandomselection(@PathVariable String rid, HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rid", rid);
        List randomselectiondeails = this.randomselectiondeailMag.listObjects(map);
        if (randomselectiondeails != null && randomselectiondeails.size() > 0) {
            for (Randomselectiondeail rd : randomselectiondeails) {
                this.randomselectiondeailMag.deleteObject((Serializable)rd);
            }
        }
        this.randomselectionMag.deleteObjectById((Serializable)((Object)rid));
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{rid}"}, method={RequestMethod.PUT})
    public void updateRandomselection(@PathVariable String rid, @Valid Randomselection randomselection, HttpServletResponse response) {
        Randomselection dbRandomselection = (Randomselection)this.randomselectionMag.getObjectById((Serializable)((Object)rid));
        if (null == randomselection) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        dbRandomselection.copy(randomselection);
        this.randomselectionMag.mergeObject((Serializable)dbRandomselection);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }
}

