/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.sjcj.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.sjcj.po.Zklinfo;
import com.nfgl.sjcj.service.ZklinfoManager;
import com.nfgl.utils.po.ArrUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sjcj/zklinfo"})
public class ZklinfoController
extends BaseController {
    private static final Log log = LogFactory.getLog(ZklinfoController.class);
    private static final long serialVersionUID = 1L;
    @Resource
    private ZklinfoManager zklinfoMag;

    @RequestMapping(method={RequestMethod.GET})
    public void list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
    }

    @RequestMapping(value={"/{fyear}/{ftype}/{countycode}"}, method={RequestMethod.GET})
    public void getZklinfo(@PathVariable String fyear, @PathVariable String ftype, @PathVariable String countycode, HttpServletResponse response) {
        if (StringUtils.isNotBlank((String)fyear)) {
            String[] split = fyear.split(",");
            ArrUtil.compareArr((String[])split);
            fyear = "";
            for (String s : split) {
                fyear = fyear + s + ",";
            }
            fyear = fyear.substring(0, fyear.length() - 1);
        }
        Zklinfo zklinfo = new Zklinfo();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("countycode", countycode);
        map.put("fyear", fyear);
        map.put("ftype", ftype);
        List zklinfos = this.zklinfoMag.listObjects(map);
        if (zklinfos != null && zklinfos.size() > 0) {
            zklinfo = (Zklinfo)zklinfos.get(0);
        }
        JsonResultUtils.writeSingleDataJson((Object)zklinfo, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/subZklinfos"}, method={RequestMethod.POST})
    public JSONObject subZklinfos(HttpServletRequest request, HttpServletResponse response) {
        String list;
        JSONObject js = new JSONObject();
        String fyear = request.getParameter("fyear");
        if (StringUtils.isNotBlank((String)fyear)) {
            String[] split = fyear.split(",");
            ArrUtil.compareArr((String[])split);
            fyear = "";
            for (String s : split) {
                fyear = fyear + s + ",";
            }
            fyear = fyear.substring(0, fyear.length() - 1);
        }
        if (StringUtils.isNotBlank((String)(list = request.getParameter("list")))) {
            JSONArray arr = JSONArray.parseArray((String)list);
            if (arr != null && arr.size() > 0) {
                for (int i = 0; i < arr.size(); ++i) {
                    JSONObject obj = arr.getJSONObject(i);
                    String countycode = obj.getString("countycode");
                    for (int j = 1; j <= 10; ++j) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("countycode", countycode);
                        map.put("fyear", fyear);
                        map.put("ftype", j);
                        List zklinfos = this.zklinfoMag.listObjects(map);
                        if (zklinfos != null && zklinfos.size() != 0) continue;
                        Zklinfo zklinfo = new Zklinfo();
                        long oldval = 0L;
                        double newval = 0.0;
                        double zkl = 0.0;
                        if (j == 1) {
                            oldval = obj.getInteger("buyHouse").intValue();
                        } else if (j == 2) {
                            oldval = obj.getInteger("buyvillages").intValue();
                        } else if (j == 3) {
                            oldval = obj.getInteger("newHouse").intValue();
                        } else if (j == 4) {
                            oldval = obj.getInteger("temporaryHouse").intValue();
                        } else if (j == 5) {
                            oldval = obj.getInteger("overHouse2").intValue();
                        } else if (j == 6) {
                            oldval = obj.getInteger("improveNumbers").intValue();
                        } else if (j == 7) {
                            oldval = obj.getInteger("cityImproveNumbers").intValue();
                        } else if (j == 8) {
                            oldval = obj.getInteger("startsNumbers").intValue();
                        } else if (j == 9) {
                            oldval = obj.getInteger("finishNumbers").intValue();
                        } else if (j == 10) {
                            oldval = obj.getInteger("target").intValue();
                        }
                        newval = oldval;
                        zklinfo.setZik(null);
                        zklinfo.setCountycode(countycode);
                        zklinfo.setFyear(fyear);
                        zklinfo.setFtype(j + "");
                        zklinfo.setOldval(Long.valueOf(oldval));
                        zklinfo.setZkl(Double.valueOf(zkl));
                        zklinfo.setNewval(Double.valueOf(newval));
                        this.zklinfoMag.mergeObject((Serializable)zklinfo);
                    }
                }
            }
            js.put("isOK", (Object)true);
        } else {
            js.put("isOK", (Object)false);
        }
        return js;
    }

    @RequestMapping(method={RequestMethod.POST})
    public Zklinfo createZklinfo(@Valid Zklinfo zklinfo, HttpServletRequest request, HttpServletResponse response) {
        String countycode = zklinfo.getCountycode();
        String fyear = zklinfo.getFyear();
        String[] split = fyear.split(",");
        ArrUtil.compareArr((String[])split);
        fyear = "";
        for (String s : split) {
            fyear = fyear + s + ",";
        }
        fyear = fyear.substring(0, fyear.length() - 1);
        zklinfo.setFyear(fyear);
        String ftype = zklinfo.getFtype();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("countycode", countycode);
        map.put("fyear", fyear);
        map.put("ftype", ftype);
        Zklinfo zklinfodb = (Zklinfo)this.zklinfoMag.getObjectByProperties(map);
        if (zklinfodb != null) {
            this.zklinfoMag.deleteObject((Serializable)zklinfodb);
        }
        zklinfo.setZik(null);
        Long oldval = zklinfo.getOldval();
        double newval = 0.0;
        double zkl = 0.0;
        if (zklinfo.getZkl() != null && zklinfo.getZkl() != 0.0) {
            newval = (double)oldval.longValue() * (1.0 - zklinfo.getZkl());
            zklinfo.setNewval(Double.valueOf(newval));
        } else if (zklinfo.getNewval() != null) {
            zkl = ((double)oldval.longValue() - zklinfo.getNewval()) / (double)oldval.longValue();
            zklinfo.setZkl(Double.valueOf(zkl));
        }
        this.zklinfoMag.mergeObject((Serializable)zklinfo);
        return zklinfo;
    }

    @RequestMapping(value={"/{zik}"}, method={RequestMethod.DELETE})
    public void deleteZklinfo(@PathVariable String zik, HttpServletResponse response) {
        this.zklinfoMag.deleteObjectById((Serializable)((Object)zik));
    }
}

