/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.sjcj.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.model.basedata.IUnitInfo;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.service.DataDictionaryManager;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.common.StaticVariable;
import com.nfgl.common.controller.CommonController;
import com.nfgl.sjcj.controller.DataExchangeSaveController;
import com.nfgl.sjcj.po.Villagejbxx;
import com.nfgl.sjcj.service.FarmhousejbxxManager;
import com.nfgl.sjcj.service.VillagejbxxManager;
import com.nfgl.utils.controller.ImagesController;
import com.nfgl.utils.po.DateUtil;
import com.nfgl.utils.po.ExcelUtil;
import com.nfgl.utils.po.Images;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sjcj/villagejbxx"})
public class VillagejbxxController
extends BaseController {
    private static final Log log = LogFactory.getLog(VillagejbxxController.class);
    private static final long serialVersionUID = 1L;
    @Resource
    private VillagejbxxManager villagejbxxMag;
    @Resource
    private FarmhousejbxxManager farmhousejbxxManager;
    @Resource
    private CommonController commonController;
    @Resource
    private ImagesController imagesController;
    @Resource
    private SysUnitManager sysUnitManager;
    @Resource
    private DataDictionaryManager dataDictionaryManager;

    @GetMapping
    public ResponseData list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        String isPage;
        String dis;
        request.setAttribute("addUserCodes", (Object)"T");
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        String administrativevillage = request.getParameter("administrativevillage");
        if (StringUtils.isNotBlank((CharSequence)administrativevillage)) {
            searchColumn.put("administrativevillage", administrativevillage);
        }
        if (StringUtils.isNotBlank((CharSequence)(dis = (String)searchColumn.get("town")))) {
            UnitInfo unitInfo = this.sysUnitManager.getObjectById(dis);
            String unitType = unitInfo.getUnitType();
            if ("1".equals(unitType)) {
                searchColumn.put("town", dis.substring(0, 2));
            } else if ("2".equals(unitType)) {
                searchColumn.put("town", dis.substring(0, 4));
            } else if ("3".equals(unitType)) {
                searchColumn.put("town", dis.substring(0, 6));
            } else if ("5".equals(unitType)) {
                searchColumn.remove("town");
                searchColumn.put("administrativevillage", dis);
            }
        }
        if ("T".equals(isPage = request.getParameter("iaPage"))) {
            pageDesc = null;
        }
        JSONArray villageJbxxArray = this.villagejbxxMag.listObjectsAsJson(searchColumn, pageDesc);
        JSONArray newVillageJbxxArray = new JSONArray();
        if (villageJbxxArray != null && villageJbxxArray.size() > 0) {
            for (int i = 0; i < villageJbxxArray.size(); ++i) {
                com.alibaba.fastjson.JSONObject newVillageObj = new com.alibaba.fastjson.JSONObject();
                com.alibaba.fastjson.JSONObject villageObj = villageJbxxArray.getJSONObject(i);
                newVillageObj.put("vid", villageObj.get((Object)"vid"));
                String[] diss = new String[]{villageObj.getString("districtcode"), villageObj.getString("town"), villageObj.getString("administrativevillage")};
                String[] names = this.commonController.getUnitNames(diss);
                newVillageObj.put("districtcode", (Object)names[0]);
                newVillageObj.put("town", (Object)names[1]);
                newVillageObj.put("administrativevillage", (Object)names[2]);
                newVillageObj.put("villageType", villageObj.get((Object)"villageType"));
                newVillageObj.put("naturalvillage", villageObj.get((Object)"naturalvillage"));
                newVillageObj.put("longit", villageObj.get((Object)"longit"));
                newVillageObj.put("lat", villageObj.get((Object)"lat"));
                newVillageObj.put("household", villageObj.get((Object)"household"));
                newVillageObj.put("population", villageObj.get((Object)"population"));
                newVillageObj.put("villageremark", villageObj.get((Object)"villageremark"));
                newVillageObj.put("villageIndustry", villageObj.get((Object)"villageIndustry"));
                newVillageObj.put("userName", villageObj.get((Object)"userName"));
                newVillageObj.put("updatetime", villageObj.get((Object)"updatetime"));
                newVillageJbxxArray.add((Object)newVillageObj);
            }
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)newVillageJbxxArray);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @RequestMapping(value={"/list2"}, method={RequestMethod.GET})
    public List<Villagejbxx> list2(HttpServletRequest request, HttpServletResponse response) {
        String parentUnitCode;
        HashMap<String, Object> searchColumn = new HashMap<String, Object>();
        String administrativevillage = request.getParameter("administrativevillage");
        if (StringUtils.isNotBlank((CharSequence)administrativevillage)) {
            searchColumn.put("administrativevillage", administrativevillage);
        }
        if (StringUtils.isNotBlank((CharSequence)(parentUnitCode = request.getParameter("parentUnitCode")))) {
            List units = this.commonController.listSubUnitsNotIncludedVillageOfCache(parentUnitCode);
            if (units == null || units.size() < 1) {
                searchColumn.put("unitCodes", "-1");
            } else {
                String[] s = new String[units.size()];
                for (int i = 0; i < units.size(); ++i) {
                    IUnitInfo iu = (IUnitInfo)units.get(i);
                    s[i] = iu.getUnitCode();
                }
                searchColumn.put("unitCodes", s);
            }
        }
        List list = this.villagejbxxMag.listObjects(searchColumn);
        return list;
    }

    @RequestMapping(value={"/list3"}, method={RequestMethod.GET})
    public String list3(HttpServletRequest request, HttpServletResponse response) {
        String parentUnitCode;
        String res = "";
        String secret = request.getParameter("secret");
        Boolean b = DataExchangeSaveController.securityData((String)secret, (String)(parentUnitCode = request.getParameter("parentUnitCode")));
        if (b.booleanValue()) {
            HashMap<String, Object> searchColumn = new HashMap<String, Object>();
            List units = this.commonController.listSubUnitsNotIncludedVillageOfCache(parentUnitCode);
            if (units == null || units.size() < 1) {
                searchColumn.put("unitCodes", "-1");
            } else {
                String[] s = new String[units.size()];
                for (int i = 0; i < units.size(); ++i) {
                    IUnitInfo iu = (IUnitInfo)units.get(i);
                    s[i] = iu.getUnitCode();
                }
                searchColumn.put("unitCodes", s);
            }
            JSONArray jarr = this.villagejbxxMag.listObjectsAsJson(searchColumn, null);
            res = StaticVariable.encryptAndBase64String((String)jarr.toJSONString());
        }
        return res;
    }

    @RequestMapping(value={"/loadVillageByXZC"}, method={RequestMethod.GET})
    public List<Villagejbxx> loadVillageByXZC(HttpServletRequest request, HttpServletResponse response) {
        String administrativevillage = request.getParameter("administrativevillage");
        List list = null;
        if (StringUtils.isNotBlank((CharSequence)administrativevillage)) {
            list = this.villagejbxxMag.listObjectsByProperty("administrativevillage", (Object)administrativevillage);
        }
        return list;
    }

    @RequestMapping(method={RequestMethod.POST})
    public Villagejbxx saveVillagejbxx(@Valid Villagejbxx villagejbxx, HttpServletRequest request, HttpServletResponse response) {
        String type;
        Date date = new Date();
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        String vid = villagejbxx.getVid();
        if ("".equals(vid)) {
            villagejbxx.setVid(null);
        }
        if ("new".equals(type = request.getParameter("type"))) {
            villagejbxx.setUserCode(loginUser.getUserCode());
            villagejbxx.setUserName(loginUser.getUserInfo().getString("userName"));
            villagejbxx.setUnitCode(loginUser.getCurrentUnitCode());
            villagejbxx.setCreatetime(date);
            villagejbxx.setUpdatetime(date);
        } else {
            String unitCode;
            Villagejbxx dbVillage = (Villagejbxx)this.villagejbxxMag.getObjectById((Serializable)((Object)vid));
            dbVillage.copyNotNullProperty(villagejbxx);
            dbVillage.setUpdatetime(date);
            villagejbxx = dbVillage;
            if (StringUtils.isBlank((CharSequence)villagejbxx.getTown()) && StringUtils.isNotBlank((CharSequence)(unitCode = villagejbxx.getUnitCode()))) {
                villagejbxx.setTown(unitCode);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("administrativevillage", villagejbxx.getAdministrativevillage());
        map.put("naturalvillage", villagejbxx.getNaturalvillage());
        List sameList = this.villagejbxxMag.listObjectsByProperties(map);
        if (sameList != null && sameList.size() > 0) {
            for (Villagejbxx v : sameList) {
                if (v.getVid().equals(villagejbxx.getVid()) || v.getAdministrativevillage() == null || !v.getAdministrativevillage().equals(villagejbxx.getAdministrativevillage()) || v.getNaturalvillage() == null || !v.getNaturalvillage().equals(villagejbxx.getNaturalvillage())) continue;
                JsonResultUtils.writeErrorMessageJson((String)"\u7cfb\u7edf\u5df2\u6709\u6b64\u81ea\u7136\u6751\uff0c\u8bf7\u52ff\u5728\u540c\u4e00\u4e2a\u884c\u653f\u6751\u4e0b\u65b0\u589e\u540c\u540d\u81ea\u7136\u6751\uff01", (HttpServletResponse)response);
                return null;
            }
        }
        this.villagejbxxMag.mergeObject((Serializable)villagejbxx);
        return villagejbxx;
    }

    @RequestMapping(value={"/{vid}"}, method={RequestMethod.GET})
    public Villagejbxx getVillagejbxx(@PathVariable String vid, HttpServletRequest request, HttpServletResponse response) {
        Villagejbxx villagejbxx = (Villagejbxx)this.villagejbxxMag.getObjectById((Serializable)((Object)vid));
        String[] diss = new String[]{villagejbxx.getDistrictcode(), villagejbxx.getTown(), villagejbxx.getAdministrativevillage()};
        String[] names = this.commonController.getUnitNames(diss);
        villagejbxx.setDistrictcodeStr(names[0]);
        villagejbxx.setTownStr(names[1]);
        villagejbxx.setAdministrativevillageStr(names[2]);
        return villagejbxx;
    }

    @RequestMapping(value={"updateJWD/{vid}"}, method={RequestMethod.POST})
    public com.alibaba.fastjson.JSONObject saveVillagejbxx(@PathVariable String vid, HttpServletRequest request, HttpServletResponse response) {
        com.alibaba.fastjson.JSONObject obj = new com.alibaba.fastjson.JSONObject();
        Villagejbxx villagejbxx = (Villagejbxx)this.villagejbxxMag.getObjectById((Serializable)((Object)vid));
        String longit = request.getParameter("longit");
        String lat = request.getParameter("lat");
        try {
            Double longitD = Double.valueOf(longit);
            Double latD = Double.valueOf(lat);
            villagejbxx.setLongit(longitD);
            villagejbxx.setLat(latD);
            this.villagejbxxMag.mergeObject((Serializable)villagejbxx);
            obj.put("isOk", (Object)true);
            obj.put("mge", (Object)"\u5b9a\u4f4d\u4fdd\u5b58\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            obj.put("isOk", (Object)false);
            obj.put("mge", (Object)("\u5b9a\u4f4d\u4fdd\u5b58\u5f02\u5e38\uff0c\u5f02\u5e38\u95ee\u9898\uff1a" + e.getMessage()));
        }
        return obj;
    }

    @RequestMapping(value={"/{vid}"}, method={RequestMethod.DELETE})
    public ResponseData deleteVillagejbxx(@PathVariable String vid, HttpServletResponse response) {
        boolean isOk = true;
        String msg = "";
        List farmhouseJbxxList = this.farmhousejbxxManager.listObjectsByProperty("vid", (Object)vid);
        if (farmhouseJbxxList == null || farmhouseJbxxList.size() > 0) {
            isOk = false;
            msg = "\u5b58\u5728\u519c\u623f\u6539\u5584\u4fe1\u606f\uff0c\u8bf7\u5148\u5220\u9664\u519c\u623f\u6539\u5584\u4fe1\u606f";
        } else {
            try {
                this.villagejbxxMag.deleteObjectById((Serializable)((Object)vid));
                List images = this.imagesController.getImagesByModuleAndId(new Long(3L), vid);
                if (images != null && images.size() > 0) {
                    for (Images image : images) {
                        this.imagesController.delete(image.getIid());
                    }
                }
            }
            catch (Exception e) {
                isOk = false;
                msg = e.getMessage();
            }
        }
        com.alibaba.fastjson.JSONObject obj = new com.alibaba.fastjson.JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        return ResponseData.makeResponseData((Map)obj);
    }

    @RequestMapping(value={"/downloadExcel"}, method={RequestMethod.GET})
    public void downLoadExcel(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("addUserCodes", (Object)"T");
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        searchColumn.put("status", "1");
        List villageList = this.villagejbxxMag.listObjects(searchColumn);
        ArrayList list = new ArrayList();
        String[] keys = new String[]{"districtcode", "town", "administrativevillage", "naturalvillage", "longit", "lat", "household", "population", "villageremark", "villageindustry", "villagetype", "username", "updatetime"};
        HashMap<String, String> name = new HashMap<String, String>();
        String excelName = "\u6751\u5e84\u4fe1\u606f" + DateUtil.getCurrentDate24YYYYMM();
        name.put("sheetName", "sheet1");
        name.put("titleText", excelName);
        list.add(name);
        String[] columnNames = new String[]{"\u6240\u5728\u884c\u653f\u533a\u5212", "\u4e61\u9547", "\u884c\u653f\u6751\u540d", "\u81ea\u7136\u6751\u540d", "\u7ecf\u5ea6", "\u7eac\u5ea6", "\u81ea\u7136\u6751\u6237\u7c4d\u6237\u6570", "\u81ea\u7136\u6751\u6237\u7c4d\u4eba\u53e3", "\u539f\u6751\u5e84\u63cf\u8ff0", "\u6751\u5e84\u4ea7\u4e1a", "\u6751\u5e84\u7c7b\u578b", "\u5f55\u5165\u7528\u6237", "\u66f4\u65b0\u65f6\u95f4"};
        short[] columnWidths = new short[]{3600, 3600, 3200, 3000, 3000, 3000, 4000, 4000, 3600, 3600, 2500, 5000, 5000};
        for (int i = 0; i < villageList.size(); ++i) {
            Villagejbxx villagejbxx = (Villagejbxx)villageList.get(i);
            if (villagejbxx == null) continue;
            String districtcode = villagejbxx.getDistrictcode();
            String town = ((Villagejbxx)villageList.get(i)).getTown();
            HashMap<String, Object> obj = new HashMap<String, Object>();
            if (districtcode != null) {
                UnitInfo unitInfo1 = this.sysUnitManager.getObjectById(districtcode);
                obj.put("districtcode", unitInfo1.getUnitName());
            }
            if (town != null) {
                UnitInfo unitInfo2 = this.sysUnitManager.getObjectById(town);
                obj.put("town", unitInfo2.getUnitName());
            }
            obj.put("administrativevillage", villagejbxx.getAdministrativevillage());
            obj.put("naturalvillage", villagejbxx.getNaturalvillage());
            obj.put("longit", villagejbxx.getLongit());
            obj.put("lat", villagejbxx.getLat());
            obj.put("household", villagejbxx.getHousehold());
            obj.put("population", villagejbxx.getPopulation());
            obj.put("villageremark", villagejbxx.getVillageremark());
            obj.put("username", villagejbxx.getUserName());
            obj.put("updatetime", villagejbxx.getUpdatetime().toString().substring(0, 10));
            obj.put("villageindustry", villagejbxx.getVillageIndustry());
            obj.put("villagetype", villagejbxx.getVillageType());
            list.add(obj);
        }
        Workbook workbook = ExcelUtil.createWorkBook(list, (String[])keys, (String[])columnNames, (short[])columnWidths);
        response.setHeader("Content-Disposition", "attachment;filename=" + new String((excelName + ".xls").getBytes("utf-8"), "iso8859-1"));
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        ServletOutputStream out = response.getOutputStream();
        workbook.write((OutputStream)out);
        out.flush();
        out.close();
    }

    @RequestMapping(value={"/saveSynchroVillage/{standard}"}, method={RequestMethod.POST})
    public String saveSynchroVillage(@PathVariable String standard, HttpServletRequest request) {
        String res = "";
        String villagejbxxStr = "";
        String imagesStr = "";
        String statusCode = "";
        try {
            ServletInputStream is = request.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)is, "utf-8");
            BufferedReader reader = new BufferedReader(inputStreamReader);
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            res = sb.toString();
            reader.close();
            is.close();
            String[] split = res.split("&&");
            if (split.length > 1) {
                imagesStr = split[1];
                villagejbxxStr = split[0];
            } else {
                villagejbxxStr = split[0];
            }
            JSONObject jsonObject = JSONObject.fromObject((Object)villagejbxxStr);
            Villagejbxx villagejbxx = (Villagejbxx)JSONObject.toBean((JSONObject)jsonObject, Villagejbxx.class);
            if ("sy".equals(standard)) {
                JSONArray fjLists;
                String vid = villagejbxx.getVid();
                Villagejbxx villagejbxxDB = (Villagejbxx)this.villagejbxxMag.getObjectById((Serializable)((Object)vid));
                statusCode = villagejbxxDB != null ? "t002" : "t000";
                this.villagejbxxMag.mergeObject((Serializable)villagejbxx);
                if (imagesStr.length() > 0 && (fjLists = JSON.parseArray((String)imagesStr)) != null && fjLists.size() > 0) {
                    for (int i = 0; i < fjLists.size(); ++i) {
                        this.imagesController.saveImageData(fjLists.getJSONObject(i));
                    }
                }
            } else {
                statusCode = "js".equals(standard) ? "t001" : "f000";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statusCode;
    }
}

