/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.sjcj.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.common.controller.CommonController;
import com.nfgl.sjcj.po.Notice;
import com.nfgl.sjcj.service.NoticeManager;
import com.nfgl.utils.controller.AttachmentController;
import com.nfgl.utils.po.Attachment;
import com.nfgl.utils.service.AttachmentManager;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sjcj/notice"})
public class NoticeController
extends BaseController {
    @Resource
    private NoticeManager noticemanager;
    @Resource
    private AttachmentManager attachmentManager;
    @Resource
    private AttachmentController attachmentController;
    @Resource
    private CommonController commonController;

    @GetMapping
    public ResponseData list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        JSONArray listObjects = this.noticemanager.listObjectsAsJson(searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseData createNotice(@Valid Notice notice, HttpServletRequest request, HttpServletResponse response) {
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        Date date = new Date();
        boolean isOk = true;
        String msg = "";
        String type = request.getParameter("type");
        String nid = notice.getNid();
        if ("new".equals(type)) {
            notice.setUserCode(loginUser.getUserCode());
            notice.setUserName(loginUser.getUserInfo().getString("userName"));
            notice.setCreateTime(new Date());
            notice.setUpdateTime(new Date());
            notice.setNid(UUID.randomUUID().toString().replaceAll("-", ""));
            if (notice.getNcontent() == null || notice.getNcontent().length() < 1) {
                isOk = false;
                msg = "\u516c\u544a\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            } else {
                this.noticemanager.saveNewObject((Serializable)notice);
            }
        } else if (notice != null) {
            if (notice.getNcontent() == null || notice.getNcontent().length() < 1) {
                isOk = false;
                msg = "\u516c\u544a\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            } else {
                notice.setUpdateTime(date);
                this.noticemanager.mergeObject((Serializable)notice);
            }
        }
        JSONObject obj = new JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        obj.put("notice", (Object)notice);
        return ResponseData.makeResponseData((Map)obj);
    }

    @RequestMapping(value={"/{nid}"}, method={RequestMethod.GET})
    public Notice getNotice(@PathVariable String nid, HttpServletResponse response) {
        System.out.println("");
        Notice notice = (Notice)this.noticemanager.getObjectById((Serializable)((Object)nid));
        return notice;
    }

    @RequestMapping(value={"/{nid}"}, method={RequestMethod.DELETE})
    public ResponseData deleteNotice(@PathVariable String nid, HttpServletResponse response) {
        boolean isOk = true;
        String msg = "";
        try {
            this.noticemanager.deleteObjectById((Serializable)((Object)nid));
            List attachmentslist = this.attachmentManager.listObjectsByProperty("eid", (Object)nid);
            if (attachmentslist != null && attachmentslist.size() > 0) {
                for (Attachment att : attachmentslist) {
                    this.attachmentController.deleteAttachment(att.getIid());
                }
            }
        }
        catch (Exception e) {
            isOk = false;
            msg = e.getMessage();
        }
        JSONObject obj = new JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        return ResponseData.makeResponseData((Map)obj);
    }
}

