/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.sjcj.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.common.controller.CommonController;
import com.nfgl.common.service.CommonManager;
import com.nfgl.sjcj.po.Farmhousereturnlist;
import com.nfgl.sjcj.service.FarmhousereturnlistManager;
import com.nfgl.utils.po.FarmhousejbxxHouseVillage;
import com.nfgl.utils.service.FarmhousejbxxHouseVillageManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/facility/farmhousereturnlist"})
public class FarmhousereturnlistController
extends BaseController {
    private static final Log log = LogFactory.getLog(FarmhousereturnlistController.class);
    private static final long serialVersionUID = 1L;
    @Resource
    private FarmhousereturnlistManager farmhousereturnlistMag;
    @Resource
    private CommonController commonController;
    @Resource
    private CommonManager commonManager;
    @Resource
    private FarmhousejbxxHouseVillageManager farmhousejbxxHouseVillageManager;

    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<Object> list(PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        JSONArray arr = this.farmhousereturnlistMag.listObjectsAsJson(searchColumn, pageDesc);
        if (arr != null && arr.size() > 0) {
            for (int i = 0; i < arr.size(); ++i) {
                JSONObject obj = arr.getJSONObject(i);
                String[] dis = new String[]{obj.getString("districtcode"), obj.getString("town"), obj.getString("administrativevillage")};
                String[] names = this.commonController.getUnitNames(dis);
                obj.put("districtName", (Object)names[0]);
                obj.put("townName", (Object)names[1]);
                obj.put("administrativevillageName", (Object)names[2]);
            }
        }
        return PageQueryResult.createJSONArrayResult((JSONArray)arr, (PageDesc)pageDesc, (Class[])new Class[]{Farmhousereturnlist.class});
    }

    @RequestMapping(value={"/addFarmhousereturnlists/{frid}"}, method={RequestMethod.POST})
    public JSONObject addFarmhousereturnlists(@PathVariable String frid, HttpServletRequest request, HttpServletResponse response) {
        JSONObject rlt = new JSONObject();
        String json = request.getParameter("json");
        JSONArray arr = JSONArray.parseArray((String)json);
        if (arr != null && arr.size() > 0) {
            int suAdd = 0;
            int suUpdate = 0;
            int lose = 0;
            ArrayList<String> loseDeail = new ArrayList<String>();
            HashMap<String, String> searchColumn = new HashMap<String, String>();
            for (int i = 0; i < arr.size(); ++i) {
                JSONObject obj = arr.getJSONObject(i);
                String fid = obj.getString("fid");
                if (StringUtils.isNotBlank((CharSequence)fid)) {
                    FarmhousejbxxHouseVillage fhv = (FarmhousejbxxHouseVillage)this.farmhousejbxxHouseVillageManager.getObjectById((Serializable)((Object)fid));
                    if (fhv != null) {
                        Farmhousereturnlist frl;
                        searchColumn.clear();
                        searchColumn.put("frid", frid);
                        searchColumn.put("fid", fid);
                        Farmhousereturnlist frldb = (Farmhousereturnlist)this.farmhousereturnlistMag.getObjectByProperties(searchColumn);
                        if (frldb != null) {
                            frl = frldb;
                        } else {
                            frl = new Farmhousereturnlist();
                            frl.setFrid(frid);
                            frl.setFid(fid);
                        }
                        frl.copyFromFarmhousejbxxHouseVillage(fhv);
                        try {
                            this.farmhousereturnlistMag.mergeObject((Serializable)frl);
                            if (frldb != null) {
                                ++suUpdate;
                                continue;
                            }
                            ++suAdd;
                        }
                        catch (Exception e) {
                            ++lose;
                            loseDeail.add("\u7b2c" + (i + 1) + "\u4e2a\u6570\u636e\u6dfb\u52a0\u9519\u8bef\uff0c\u4fdd\u5b58\u6570\u636e\u5f02\u5e38\u9519\u8bef\uff1a" + e.getMessage());
                        }
                        continue;
                    }
                    ++lose;
                    loseDeail.add("\u7b2c" + (i + 1) + "\u4e2a\u6570\u636e\u6dfb\u52a0\u9519\u8bef\uff0c\u6b64\u6761\u519c\u623f\u6570\u636e\u5df2\u88ab\u5220\u9664\u3002");
                    continue;
                }
                ++lose;
                loseDeail.add("\u7b2c" + (i + 1) + "\u4e2a\u6570\u636e\u6dfb\u52a0\u9519\u8bef\uff0c\u519c\u623f\u4e3b\u952efid\u4e3a\u7a7a\u3002");
            }
            rlt.put("total", (Object)arr.size());
            rlt.put("suAdd", (Object)suAdd);
            rlt.put("suUpdate", (Object)suUpdate);
            rlt.put("lose", (Object)lose);
            rlt.put("loseDeail", loseDeail);
        }
        return rlt;
    }

    @RequestMapping(value={"/{friid}"}, method={RequestMethod.DELETE})
    public JSONObject deleteFarmhousejbxx(@PathVariable String friid, HttpServletResponse response) {
        JSONObject rlt = new JSONObject();
        try {
            this.farmhousereturnlistMag.deleteObjectById((Serializable)((Object)friid));
            rlt.put("isOk", (Object)true);
        }
        catch (Exception e) {
            rlt.put("isOk", (Object)false);
            rlt.put("msg", (Object)("\u64a4\u9500\u5931\u8d25\uff0c\u5931\u8d25\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage()));
        }
        return rlt;
    }
}

