/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.sjcj.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.basedata.IUnitInfo;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.DataDictionary;
import com.centit.framework.system.service.DataDictionaryManager;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.check.po.Projectcheck;
import com.nfgl.check.service.ProjectcheckManager;
import com.nfgl.common.StaticVariable;
import com.nfgl.common.controller.CommonController;
import com.nfgl.sjcj.controller.DataExchangeSaveController;
import com.nfgl.sjcj.po.Facility;
import com.nfgl.sjcj.service.FacilityManager;
import com.nfgl.sjcj.service.FacilityviewManager;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sjcj/facility"})
public class FacilityController
extends BaseController {
    private static final Log log = LogFactory.getLog(FacilityController.class);
    private static final long serialVersionUID = 1L;
    @Resource
    private FacilityManager facilityMag;
    @Resource
    private FacilityviewManager facilityviewManager;
    @Resource
    private CommonController commonController;
    @Resource
    private DataDictionaryManager dataDictionaryManager;
    @Resource
    private ProjectcheckManager projectcheckMag;

    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<Object> list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        JSONArray arr;
        String fyears;
        String parentUnitCode = request.getParameter("parentUnitCode");
        if (StringUtils.isNotBlank((CharSequence)parentUnitCode)) {
            request.setAttribute("addUserCodes", (Object)"A");
        } else {
            request.setAttribute("addUserCodes", (Object)"S");
        }
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        String isContain = (String)searchColumn.get("isContain");
        if ("T".equals(isContain) && StringUtils.isNotBlank((CharSequence)parentUnitCode) && !"320000000000".equals(parentUnitCode)) {
            List units = this.commonController.listSubUnitsNotIncludedVillageOfCache(parentUnitCode);
            for (String key : CommonController.subUnitcodeMap.keySet()) {
                String[] vs;
                if (!key.equals(parentUnitCode)) continue;
                String value = (String)CommonController.subUnitcodeMap.get(key);
                for (String v : vs = value.split(",")) {
                    List subUnits = this.commonController.listSubUnitsNotIncludedVillageOfCache(v);
                    units.addAll(subUnits);
                }
            }
            if (units == null || units.size() < 1) {
                searchColumn.put("unitCodes", "-1");
            } else {
                String[] s = new String[units.size()];
                for (int i = 0; i < units.size(); ++i) {
                    IUnitInfo iu = (IUnitInfo)units.get(i);
                    s[i] = iu.getUnitCode();
                }
                searchColumn.put("unitCodes", s);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(fyears = request.getParameter("fyears")))) {
            String[] fyear = fyears.split("a");
            searchColumn.put("fyear", fyear);
        }
        if ((arr = this.facilityviewManager.listObjectsAsJson(searchColumn, pageDesc)) != null && arr.size() > 0) {
            List dataList = this.dataDictionaryManager.getDataDictionary("gg");
            List dataList2 = this.dataDictionaryManager.getDataDictionary("jc");
            for (int i = 0; i < arr.size(); ++i) {
                String administrativevillage;
                String relation;
                JSONObject obj = arr.getJSONObject(i);
                String[] codes = new String[2];
                String unitCode = obj.getString("unitCode");
                IUnitInfo iu = CodeRepositoryUtil.getParentUnitInfo((String)unitCode);
                if (iu != null && "3".equals(iu.getUnitType())) {
                    codes[0] = iu.getUnitCode();
                    codes[1] = unitCode;
                } else if (iu != null && "2".equals(iu.getUnitType())) {
                    codes[0] = unitCode;
                }
                String[] names = this.commonController.getUnitNames(codes);
                obj.put("districtcodeName", (Object)names[0]);
                obj.put("townName", (Object)names[1]);
                List list = null;
                String ftype = obj.getString("ftype");
                String ftype2 = obj.getString("ftype2");
                if ("gg".equals(ftype)) {
                    list = dataList;
                } else if ("jc".equals(ftype)) {
                    list = dataList2;
                }
                if (list != null && list.size() > 0) {
                    for (DataDictionary dd : list) {
                        if (ftype2 == null || !ftype2.equals(dd.getDataCode())) continue;
                        obj.put("ftype2Name", (Object)dd.getDataValue());
                        break;
                    }
                }
                if ("1".equals(relation = obj.getString("relation")) || "2".equals(relation)) {
                    obj.put("administrativevillageName", (Object)"");
                } else {
                    obj.put("hidName", (Object)"");
                }
                String townName = obj.getString("townName");
                if (!StringUtils.isBlank((CharSequence)townName) || !StringUtils.isNotBlank((CharSequence)(administrativevillage = obj.getString("administrativevillage"))) || !"3".equals(relation)) continue;
                IUnitInfo xz = CodeRepositoryUtil.getParentUnitInfo((String)administrativevillage);
                obj.put("townName", (Object)xz.getUnitName());
            }
        }
        PageQueryResult rlt = PageQueryResult.createJSONArrayResult((JSONArray)arr, (PageDesc)pageDesc, (Class[])new Class[]{Facility.class});
        return rlt;
    }

    @RequestMapping(value={"/{fid}"}, method={RequestMethod.GET})
    public void getFacility(@PathVariable String fid, HttpServletResponse response) {
        Facility facility = (Facility)this.facilityMag.getObjectById((Serializable)((Object)fid));
        String administrativevillage = facility.getAdministrativevillage();
        if (StringUtils.isNotBlank((CharSequence)administrativevillage)) {
            IUnitInfo xz = CodeRepositoryUtil.getParentUnitInfo((String)administrativevillage);
            facility.setTown(xz.getUnitCode());
        }
        JsonResultUtils.writeSingleDataJson((Object)facility, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{fid}"}, method={RequestMethod.DELETE})
    public void deleteFacility(@PathVariable String fid, HttpServletResponse response) {
        this.facilityMag.deleteObjectById((Serializable)((Object)fid));
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    public Facility updateFacility(@Valid Facility facility, HttpServletRequest request, HttpServletResponse response) {
        String fid = facility.getFid();
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)fid)) {
            Facility dbf = (Facility)this.facilityMag.getObjectById((Serializable)((Object)fid));
            if (dbf != null) {
                dbf.copyNotNullProperty(facility);
                facility = dbf;
            }
            facility.setUpdatetime(new Date());
        } else {
            facility.setFid(null);
            facility.setUserCode(loginUser.getUserCode());
            facility.setUserName(loginUser.getUserInfo().getString("userName"));
            facility.setUnitCode(loginUser.getCurrentUnitCode());
            facility.setCreatetime(new Date());
            facility.setUpdatetime(new Date());
        }
        this.facilityMag.mergeObject((Serializable)facility);
        return facility;
    }

    @RequestMapping(value={"/list2"}, method={RequestMethod.GET})
    public String list2(HttpServletRequest request, HttpServletResponse response) {
        String res = "";
        String secret = request.getParameter("secret");
        String parentUnitCode = request.getParameter("parentUnitCode");
        String fyear = request.getParameter("fyear");
        Boolean b = DataExchangeSaveController.securityData((String)secret, (String)parentUnitCode);
        if (b.booleanValue()) {
            HashMap<String, Object> searchColumn = new HashMap<String, Object>();
            String[] codes = this.commonController.loadsubUnitsByParentUnitCode(parentUnitCode);
            searchColumn.put("unitCodes", codes);
            searchColumn.put("fyear", fyear);
            JSONArray arr = this.facilityMag.listObjectsAsJson(searchColumn, null);
            res = StaticVariable.encryptAndBase64String((String)arr.toJSONString());
        }
        return res;
    }

    @RequestMapping(value={"/getSHFacility"}, method={RequestMethod.GET})
    public String getSHFacility(HttpServletRequest request, HttpServletResponse response) {
        String res = "";
        String secret = request.getParameter("secret");
        String parentUnitCode = request.getParameter("parentUnitCode");
        String fyear = request.getParameter("fyear");
        String newhousestatus = request.getParameter("newhousestatus");
        String[] relation = new String[]{"1", "2"};
        Boolean b = DataExchangeSaveController.securityData((String)secret, (String)parentUnitCode);
        if (b.booleanValue()) {
            HashMap<String, Object> searchColumn = new HashMap<String, Object>();
            String[] codes = this.commonController.loadsubUnitsByParentUnitCode(parentUnitCode);
            searchColumn.put("unitCodes", codes);
            searchColumn.put("fyear", fyear);
            searchColumn.put("relation", relation);
            JSONArray arrRes = new JSONArray();
            JSONArray arr = this.facilityMag.listObjectsAsJson(searchColumn, null);
            if (arr != null && arr.size() > 0) {
                for (int i = 0; i < arr.size(); ++i) {
                    Projectcheck pj;
                    JSONObject js = arr.getJSONObject(i);
                    String hid = js.getString("hid");
                    if (!StringUtils.isNotBlank((CharSequence)hid) || (pj = (Projectcheck)this.projectcheckMag.getObjectByProperty("hid", (Object)hid)) == null || !StringUtils.isNotBlank((CharSequence)pj.getStatus()) || !newhousestatus.equals(pj.getStatus())) continue;
                    arrRes.add((Object)js);
                }
            }
            res = StaticVariable.encryptAndBase64String((String)arrRes.toJSONString());
        }
        return res;
    }
}

