/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.phone.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.security.model.CentitPasswordEncoder;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.framework.system.service.SysUserManager;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.common.controller.CommonController;
import com.nfgl.phone.dao.HomeDao;
import com.nfgl.phone.po.ReturnMessage;
import com.nfgl.utils.po.Images;
import com.nfgl.utils.service.AttachmentManager;
import com.nfgl.utils.service.ImagesManager;
import com.nfgl.utils.service.PmpWfRecordManager;
import com.nfgl.utils.service.impl.FtpUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/phone/home"})
public class HomeController
extends BaseController {
    @Resource
    private CommonController commoncontroller;
    @Resource
    private SysUnitManager unitManager;
    @Resource
    private SysUserManager sysUserManager;
    @Resource
    private UnitInfoDao unitInfoDao;
    @Resource
    @NotNull
    private CentitPasswordEncoder passwordEncoder;
    @Resource
    private HomeDao homeDao;
    @Resource
    private PmpWfRecordManager pmpWfRecordManager;
    @Resource
    private CommonController commonController;
    @Resource
    private AttachmentManager attachmentManager;
    @Resource
    private ImagesManager imagesManager;
    @Value(value="${ftp.ip}")
    public String ftpip;
    @Value(value="${ftp.username}")
    public String ftpusername;
    @Value(value="${ftp.password}")
    public String ftppassword;
    @Value(value="${ftp.port}")
    public int ftpport;
    @Value(value="${ftp.homepath}")
    public String homepath;

    public String getHomepath() {
        return this.homepath;
    }

    public void setHomepath(String homepath) {
        this.homepath = homepath;
    }

    public String getFtpip() {
        return this.ftpip;
    }

    public void setFtpip(String ftpip) {
        this.ftpip = ftpip;
    }

    public String getFtpusername() {
        return this.ftpusername;
    }

    public void setFtpusername(String ftpusername) {
        this.ftpusername = ftpusername;
    }

    public String getFtppassword() {
        return this.ftppassword;
    }

    public void setFtppassword(String ftppassword) {
        this.ftppassword = ftppassword;
    }

    public int getFtpport() {
        return this.ftpport;
    }

    public void setFtpport(int ftpport) {
        this.ftpport = ftpport;
    }

    @RequestMapping(value={"/loginByPhone"}, method={RequestMethod.GET})
    public void LoginByPhone(HttpServletRequest request, HttpServletResponse response) {
        String returnValue;
        String loginName = request.getParameter("loginName");
        String userPin = request.getParameter("userPin");
        ReturnMessage returnMessage = new ReturnMessage();
        if (loginName == null || userPin == null || loginName.equals("") || userPin.equals("")) {
            returnMessage.setFlag(false);
            returnMessage.setMessage("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u4e3a\u7a7a!");
            String returnValue2 = JSONObject.toJSONString((Object)returnMessage);
            JsonResultUtils.writeOriginalJson((String)returnValue2, (HttpServletResponse)response);
            return;
        }
        UserInfo userInfo = null;
        UnitInfo unitInfo = null;
        try {
            userInfo = this.sysUserManager.loadUserByLoginname(loginName);
            if (userInfo == null) {
                throw new Exception();
            }
            unitInfo = this.unitInfoDao.getObjectById(userInfo.getPrimaryUnit());
            if (unitInfo == null) {
                throw new Exception();
            }
            JSONArray jsonArray = this.homeDao.getRoles(userInfo.getUserCode());
            if (jsonArray.size() > 0) {
                String roleCode = jsonArray.getJSONObject(0).getString("roleCode");
                if ("0010".equals(roleCode)) {
                    userInfo.setUserOrder(Long.valueOf(0L));
                } else if ("0011".equals(roleCode)) {
                    userInfo.setUserOrder(Long.valueOf(1L));
                } else if ("0012".equals(roleCode)) {
                    userInfo.setUserOrder(Long.valueOf(2L));
                } else if ("0013".equals(roleCode)) {
                    userInfo.setUserOrder(Long.valueOf(3L));
                }
            }
        }
        catch (Exception e) {
            returnMessage.setFlag(false);
            returnMessage.setMessage("\u7528\u6237\u540d\u4e0d\u5b58\u5728!");
            String returnValue3 = JSONObject.toJSONString((Object)returnMessage);
            JsonResultUtils.writeOriginalJson((String)returnValue3, (HttpServletResponse)response);
            return;
        }
        boolean passwordValid = this.passwordEncoder.isPasswordValid(userInfo.getUserPin(), userPin, (Object)userInfo.getUserCode());
        if (!passwordValid) {
            returnMessage.setFlag(false);
            returnMessage.setMessage("\u5bc6\u7801\u9519\u8bef!");
            returnValue = JSONObject.toJSONString((Object)returnMessage);
            JsonResultUtils.writeOriginalJson((String)returnValue, (HttpServletResponse)response);
            return;
        }
        returnMessage.setFlag(true);
        returnMessage.setMessage("\u767b\u5f55\u6210\u529f");
        returnMessage.setUserInfo(userInfo);
        returnMessage.setUnitInfo(unitInfo);
        returnValue = JSONObject.toJSONString((Object)returnMessage);
        JsonResultUtils.writeOriginalJson((String)returnValue, (HttpServletResponse)response);
    }

    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<Object> list(String[] filed, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        searchColumn.put("sort", "worder");
        searchColumn.put("order", "desc");
        JSONArray listObjects = this.pmpWfRecordManager.listObjectsAsJson(searchColumn, null);
        if (listObjects != null && listObjects.size() > 0) {
            for (int i = 0; i < listObjects.size(); ++i) {
                JSONObject o = listObjects.getJSONObject(i);
                String ideaCode = (String)o.get((Object)"ideaCode");
                if (!StringUtils.isNotBlank((CharSequence)ideaCode)) continue;
                o.put("ideaCode", (Object)CodeRepositoryUtil.getValue((String)"operations", (String)ideaCode));
            }
        }
        return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc);
    }

    @RequestMapping(value={"/getAttachmentsBTY/{emodule}/{eid}"}, method={RequestMethod.GET})
    public ResponseData getAttachmentsBTY(@PathVariable Long emodule, @PathVariable String eid, HttpServletRequest request, HttpServletResponse response) {
        String userCode = request.getParameter("userCode");
        List images = this.getImagesByModuleAndId(emodule, eid, userCode);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("fjList", (Object)images);
        return resData;
    }

    public List<Images> getImagesByModuleAndId(Long emodule, String eid, String userCode) {
        HashMap<String, Object> searchColumn = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)userCode)) {
            searchColumn.put("userCode", userCode);
        }
        searchColumn.put("emodule", emodule);
        searchColumn.put("eid", eid);
        searchColumn.put("sort", "eorder");
        searchColumn.put("order", "asc");
        List list = this.imagesManager.listObjects(searchColumn);
        String iid = "";
        String saveName = "";
        String fileTyle = "";
        String filename = "";
        String ftpPath = "";
        String localpath = this.homepath;
        if (list != null && list.size() > 0) {
            for (Images image : list) {
                filename = image.getEname();
                Date date = image.getCreatetime();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int year = calendar.get(1);
                int month = calendar.get(2) + 1;
                ftpPath = "/images/" + image.getEmodule() + "/" + year + "/" + month + "/";
                fileTyle = filename.substring(filename.lastIndexOf("."), filename.length());
                iid = image.getIid();
                saveName = iid + fileTyle;
                File file = new File(localpath + "/" + saveName);
                if (!file.exists()) {
                    FtpUtil.downloadFtpFile((String)this.ftpip, (String)this.ftpusername, (String)this.ftppassword, (int)this.ftpport, (String)ftpPath, (String)localpath, (String)saveName, (String)saveName);
                }
                try {
                    FileInputStream is = new FileInputStream(file);
                    int num = is.available();
                    byte[] buffer = new byte[is.available()];
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    int len = -1;
                    if (num > 0) {
                        for (int tempi = 0; (len = is.read(buffer)) != -1 && num >= tempi; ++tempi) {
                            outStream.write(buffer, 0, len);
                        }
                    }
                    outStream.close();
                    is.close();
                    image.setEfj(outStream.toByteArray());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }
}

