/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.common.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.common.controller.CommonController;
import com.nfgl.common.po.WorkloadStatistics;
import com.nfgl.common.service.WorkloadStatisticsManager;
import com.nfgl.utils.po.DateUtil;
import com.nfgl.utils.po.ExcelUtil;
import com.nfgl.utils.po.PmpWfRecord;
import com.nfgl.utils.po.PmpWfRecordID;
import com.nfgl.utils.service.PmpWfRecordManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common/workloadStatistics"})
public class WorkloadStatisticsController
extends BaseController {
    private static final Log log = LogFactory.getLog(WorkloadStatisticsController.class);
    @Resource
    private CommonController commonController;
    @Resource
    private WorkloadStatisticsManager workloadStatisticsManager;
    @Resource
    private SysUnitManager sysUnitManager;
    @Resource
    private PmpWfRecordManager pmpWfRecordManager;

    @GetMapping
    public ResponseData list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        ResponseMapData resData = new ResponseMapData();
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        String primaryUnit = loginUser.getUserInfo().getString("primaryUnit");
        String unitTypes = "";
        String roleCode = loginUser.getUserRoles().getJSONObject(1).getString("roleCode");
        if ("0013".equals(roleCode)) {
            searchColumn.put("town", primaryUnit);
        } else if ("0012".equals(roleCode)) {
            searchColumn.put("countyCode", primaryUnit);
        } else if ("0011".equals(roleCode)) {
            searchColumn.put("cityCode", primaryUnit);
        }
        String towns = (String)searchColumn.get("towns");
        if (!"320000000000".equals(towns) && StringUtils.isNotBlank((CharSequence)towns)) {
            char c;
            int i;
            for (i = towns.toString().length() - 1; i >= 0 && (c = towns.toString().charAt(i)) == '0'; --i) {
            }
            searchColumn.put("dis", towns.substring(0, i + 1) + "%");
        }
        searchColumn.put("sort", "unitType");
        searchColumn.put("order", "asc");
        JSONArray jsonArr = this.workloadStatisticsManager.listObjectsAsJson(searchColumn, pageDesc);
        String detailTown = "";
        List units = this.sysUnitManager.listObjects(new HashMap());
        for (int i = 0; i < jsonArr.size(); ++i) {
            UnitInfo administrativeVillage;
            UnitInfo town;
            UnitInfo countyCode;
            detailTown = "";
            JSONObject jsonObject = jsonArr.getJSONObject(i);
            UnitInfo cityCode = this.commonController.getUnitOfListByCode(units, (String)jsonObject.get((Object)"cityCode"));
            if (cityCode != null) {
                detailTown = detailTown + cityCode.getUnitName();
            }
            if ((countyCode = this.commonController.getUnitOfListByCode(units, (String)jsonObject.get((Object)"countyCode"))) != null) {
                detailTown = detailTown + "/" + countyCode.getUnitName();
            }
            if ((town = this.commonController.getUnitOfListByCode(units, (String)jsonObject.get((Object)"town"))) != null) {
                detailTown = detailTown + "/" + town.getUnitName();
            }
            if ((administrativeVillage = this.commonController.getUnitOfListByCode(units, (String)jsonObject.get((Object)"administrativeVillage"))) != null) {
                detailTown = detailTown + "/" + administrativeVillage.getUnitName();
            }
            if (StringUtils.isNotBlank((CharSequence)((String)jsonObject.get((Object)"naturalVillage")))) {
                detailTown = detailTown + "/" + jsonObject.getString("naturalVillage");
            }
            if ("".equals(detailTown)) {
                detailTown = "\u6c5f\u82cf\u7701";
            }
            jsonObject.put("detailTown", (Object)detailTown);
            jsonObject.put("remind", (Object)this.commonController.getRemindByStatus((String)jsonObject.get((Object)"status")));
        }
        resData.addResponseData("objList", (Object)jsonArr);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @GetMapping(value={"/{wid}"})
    public void getWorkloadStatistics(@PathVariable String wid, HttpServletResponse response) {
        WorkloadStatistics workloadStatistics = (WorkloadStatistics)this.workloadStatisticsManager.getObjectById((Serializable)((Object)wid));
        JsonResultUtils.writeSingleDataJson((Object)workloadStatistics, (HttpServletResponse)response);
    }

    @GetMapping(value={"/getDetailWorkloadStatistics/{wid}"})
    public ResponseData getDetailWorkloadStatistics(@PathVariable String wid, HttpServletResponse response) {
        WorkloadStatistics workloadStatistics = (WorkloadStatistics)this.workloadStatisticsManager.getObjectById((Serializable)((Object)wid));
        JSONObject obj = new JSONObject();
        obj.put("workloadStatistics", (Object)workloadStatistics);
        if (StringUtils.isNotBlank((CharSequence)workloadStatistics.getStatus())) {
            obj.put("remind", (Object)this.commonController.getRemindByStatus(workloadStatistics.getStatus()));
        }
        return ResponseData.makeResponseData((Map)obj);
    }

    @RequestMapping(value={"/{wid}"}, method={RequestMethod.DELETE})
    public ResponseData deleteWorkloadStatistics(@PathVariable String wid, HttpServletResponse response) {
        boolean isOk = true;
        String msg = "";
        try {
            this.workloadStatisticsManager.deleteObjectById((Serializable)((Object)wid));
        }
        catch (Exception e) {
            isOk = false;
            msg = e.getMessage();
        }
        JSONObject obj = new JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        return ResponseData.makeResponseData((Map)obj);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseData saveWorkloadStatistics(@Valid WorkloadStatistics workloadStatistics, HttpServletRequest request, HttpServletResponse response) {
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        String wid = workloadStatistics.getWid();
        boolean isOk = true;
        String msg = "";
        WorkloadStatistics dbh = (WorkloadStatistics)this.workloadStatisticsManager.getObjectById((Serializable)((Object)wid));
        dbh.copyNotNullProperty(workloadStatistics);
        this.workloadStatisticsManager.mergeObject((Serializable)dbh);
        JSONObject obj = new JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        return ResponseData.makeResponseData((Map)obj);
    }

    @RequestMapping(value={"/opinion/{wmodule}/{wid}/{status}"}, method={RequestMethod.POST})
    public ResponseData workloadStatisticsListOpinion(@Valid PmpWfRecord pmpWfRecord, @PathVariable Integer wmodule, @PathVariable String wid, @PathVariable String status, HttpServletRequest request, HttpServletResponse response) {
        boolean isOk = true;
        String msg = "";
        String roleCode = "";
        WorkloadStatistics workloadStatistics = (WorkloadStatistics)this.workloadStatisticsManager.getObjectById((Serializable)((Object)wid));
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        JSONArray userRoles = loginUser.getUserRoles();
        JSONObject jsonObject = userRoles.getJSONObject(1);
        if (jsonObject != null && jsonObject.get((Object)"roleCode") != null) {
            roleCode = jsonObject.get((Object)"roleCode") + "";
        }
        if (!("01".equals(status) || "02".equals(status) || "03".equals(status) || "04".equals(status) || "05".equals(status) || "06".equals(status) || "07".equals(status) || "08".equals(status) || "09".equals(status))) {
            isOk = false;
        } else {
            workloadStatistics.setStatus(status);
            this.workloadStatisticsManager.mergeObject((Serializable)workloadStatistics);
            Date date = new Date();
            HashMap<String, Object> searchColumn = new HashMap<String, Object>();
            searchColumn.put("wmodule", wmodule);
            searchColumn.put("wid", wid);
            List pmps = this.pmpWfRecordManager.listObjects(searchColumn);
            Integer ordernum = 0;
            if (pmps != null && pmps.size() > 0) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int i = 0; i < pmps.size(); ++i) {
                    list.add(((PmpWfRecord)pmps.get(i)).getWorder());
                }
                ordernum = (Integer)Collections.max(list) + 1;
            } else {
                ordernum = 1;
            }
            pmpWfRecord.setPmpWfRecordID(new PmpWfRecordID(wmodule, wid, ordernum));
            pmpWfRecord.setWdate(new Date());
            pmpWfRecord.setUsername(loginUser.getUserInfo().getString("userName"));
            pmpWfRecord.setUnitcode(loginUser.getCurrentUnitCode());
            pmpWfRecord.setStatus(status);
            String ideaCode = "";
            if ("01".equals(status)) {
                ideaCode = "05";
            } else if ("02".equals(status)) {
                ideaCode = "01";
            } else if ("03".equals(status)) {
                ideaCode = "03";
            } else if ("04".equals(status)) {
                ideaCode = "04";
            } else if ("05".equals(status)) {
                ideaCode = "06";
            } else if ("06".equals(status)) {
                ideaCode = "03";
            } else if ("07".equals(status)) {
                ideaCode = "03";
            } else if ("08".equals(status)) {
                ideaCode = "01";
            } else if ("09".equals(status)) {
                ideaCode = "01";
            }
            pmpWfRecord.setIdeaCode(ideaCode);
            this.pmpWfRecordManager.saveNewObject((Serializable)pmpWfRecord);
        }
        JSONObject obj = new JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        return ResponseData.makeResponseData((Map)obj);
    }

    @GetMapping(value={"/export/{wtype}"})
    public String export(HttpServletRequest request, HttpServletResponse response, @PathVariable String wtype) throws IOException {
        Object towns;
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        String primaryUnit = loginUser.getUserInfo().getString("primaryUnit");
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        searchColumn.put("wtype", wtype);
        String unitTypes = "";
        String roleCode = loginUser.getUserRoles().getJSONObject(1).getString("roleCode");
        if ("0013".equals(roleCode)) {
            unitTypes = "4,5";
            searchColumn.put("town", primaryUnit);
        } else if ("0012".equals(roleCode)) {
            unitTypes = "3,4,5";
            searchColumn.put("countyCode", primaryUnit);
        } else if ("0011".equals(roleCode)) {
            unitTypes = "2,3,4,5";
            searchColumn.put("cityCode", primaryUnit);
        }
        if (StringUtils.isNotBlank((CharSequence)unitTypes)) {
            searchColumn.put("unitTypes", unitTypes.split(","));
        }
        if ((towns = searchColumn.get("towns")) != null && !"".equals(towns)) {
            char c;
            int i;
            for (i = towns.toString().length() - 1; i >= 0 && (c = towns.toString().charAt(i)) == '0'; --i) {
            }
            searchColumn.put("dis", ((String)towns).substring(0, i + 1) + "%");
        }
        JSONArray listObjects = this.workloadStatisticsManager.listObjectsAsJson(searchColumn, null);
        String title = "";
        if ("1".equals(wtype)) {
            title = "\u8ba1\u5212\u6539\u5584\u5de5\u4f5c\u91cf\u7edf\u8ba1";
        } else if ("2".equals(wtype)) {
            title = "\u5b9e\u9645\u6539\u5584\u5de5\u4f5c\u91cf\u7edf\u8ba1";
        }
        String excelName = title + DateUtil.getCurrentDate24YYYYMM();
        String[] columnNames = new String[]{"\u72b6\u6001", "\u5e74\u4efd", "\u5e02\u53bf\uff08\u533a\uff09\u9547\u6751", "\u8fdb\u57ce\u5c45\u4f4f-\u519c\u6237\u6570\uff08\u6237\uff09", "\u8fdb\u57ce\u5c45\u4f4f-\u4eba\u53e3\u6570\uff08\u4eba\uff09\uff09", "\u5165\u9547\u5c45\u4f4f-\u519c\u6237\u6570\uff08\u6237\uff09", "\u5165\u9547\u5c45\u4f4f-\u4eba\u53e3\u6570\uff08\u4eba\uff09", "\u65b0\u5efa\u65b0\u578b\u519c\u6751\u793e\u533a-\u519c\u6237\u6570\uff08\u6237\uff09", "\u65b0\u5efa\u65b0\u578b\u519c\u6751\u793e\u533a-\u4eba\u53e3\u6570\uff08\u4eba\uff09", "\u65b0\u5efa\u65b0\u578b\u519c\u6751\u793e\u533a-\u5efa\u8bbe\u9762\u79ef\uff08\u33a1\uff09", "\u5728\u89c4\u5212\u53d1\u5c55\u6751\u5e84\u5c31\u5730\u65b0\u5efa\u7ffb\u5efa-\u519c\u6237\u6570\uff08\u6237\uff09", "\u5728\u89c4\u5212\u53d1\u5c55\u6751\u5e84\u5c31\u5730\u65b0\u5efa\u7ffb\u5efa-\u4eba\u53e3\u6570\uff08\u4eba\uff09", "\u5728\u89c4\u5212\u53d1\u5c55\u6751\u5e84\u5c31\u5730\u65b0\u5efa\u7ffb\u5efa-\u5efa\u8bbe\u9762\u79ef\uff08\u33a1\uff09"};
        String[] keys = new String[]{"status", "wyear", "detailTown", "cityHousehold", "cityPopulation", "townHousehold", "townPopulation", "newHousehold", "newPopulation", "newArea", "reHousehold", "rePopulation", "reArea"};
        short[] columnWidths = new short[]{3600, 3600, 8500, 5400, 5400, 5400, 5400, 6000, 6000, 6000, 7000, 7000, 7000};
        ArrayList dataList = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sheetName", "sheet1");
        map.put("titleText", excelName);
        dataList.add(map);
        String detailTown = "";
        for (int i = 0; i < listObjects.size(); ++i) {
            UnitInfo townUnitInfo;
            JSONObject obj = listObjects.getJSONObject(i);
            HashMap<String, String> mapValue = new HashMap<String, String>();
            for (String key : keys) {
                mapValue.put(key, obj.getString(key));
            }
            mapValue.put("status", CodeRepositoryUtil.getValue((String)"sjcjStatusType", (String)obj.getString("status")));
            detailTown = "";
            if (StringUtils.isNotBlank((CharSequence)((String)obj.get((Object)"cityCode"))) && (townUnitInfo = this.sysUnitManager.getObjectById(obj.getString("cityCode"))) != null) {
                detailTown = detailTown + townUnitInfo.getUnitName();
            }
            if (StringUtils.isNotBlank((CharSequence)((String)obj.get((Object)"countyCode"))) && (townUnitInfo = this.sysUnitManager.getObjectById(obj.getString("countyCode"))) != null) {
                detailTown = detailTown + townUnitInfo.getUnitName();
            }
            if (StringUtils.isNotBlank((CharSequence)((String)obj.get((Object)"town"))) && (townUnitInfo = this.sysUnitManager.getObjectById(obj.getString("town"))) != null) {
                detailTown = detailTown + townUnitInfo.getUnitName();
            }
            if (StringUtils.isNotBlank((CharSequence)((String)obj.get((Object)"administrativeVillage")))) {
                detailTown = detailTown + obj.getString("administrativeVillage");
            }
            if (StringUtils.isNotBlank((CharSequence)((String)obj.get((Object)"naturalVillage")))) {
                detailTown = detailTown + obj.getString("naturalVillage");
            }
            mapValue.put("detailTown", detailTown);
            dataList.add(mapValue);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ExcelUtil.createWorkBook(dataList, (String[])keys, (String[])columnNames, (short[])columnWidths).write((OutputStream)os);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        response.reset();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String((excelName + ".xlsx").getBytes("gb2312"), "iso-8859-1"));
        ServletOutputStream out = response.getOutputStream();
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            int bytesRead = 0;
            while ((bytesRead = bis.read(buff)) > 0) {
                bos.write(buff, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

