/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.common.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.basedata.IUnitInfo;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.security.model.CentitPasswordEncoder;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.FVUserRoles;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserRole;
import com.centit.framework.system.po.UserRoleId;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.framework.system.service.SysUserManager;
import com.centit.framework.system.service.SysUserRoleManager;
import com.centit.framework.system.service.SysUserUnitManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.common.controller.CommonController;
import com.nfgl.common.po.FilterUtil;
import com.nfgl.common.service.CommonManager;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/userinfo2"})
public class Userinfo2Controller
extends BaseController {
    @Resource
    private CommonManager commonManager;
    @Resource
    private CommonController commonController;
    @Resource
    private SysUserRoleManager sysUserRoleManager;
    @Resource
    private SysUnitManager sysUnitManager;
    @Resource
    private SysUserUnitManager sysUserUnitManager;
    @Resource
    private SysUserManager sysUserManager;
    @Resource
    private CentitPasswordEncoder passwordEncoder;
    private static final String password = "jsnf321";

    @GetMapping
    public ResponseMapData list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse respons) {
        String isValid;
        String queryByUnit;
        String userName;
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        String sql = "select t.* from f_userinfo t";
        ArrayList<FilterUtil> flist = new ArrayList<FilterUtil>();
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        JSONArray arr = null;
        String second = request.getParameter("second");
        String third = request.getParameter("third");
        String fourth = request.getParameter("fourth");
        String unitCode = null;
        if (StringUtils.isNotBlank((CharSequence)fourth)) {
            unitCode = this.commonController.changeStrRemove0(fourth, 9);
        } else if (StringUtils.isNotBlank((CharSequence)third)) {
            unitCode = this.commonController.changeStrRemove0(third, 6);
        } else if (StringUtils.isNotBlank((CharSequence)second)) {
            unitCode = this.commonController.changeStrRemove0(second, 4);
        }
        String currentUnitCode = loginUser.getCurrentUnitCode();
        UnitInfo unit = this.sysUnitManager.getObjectById(currentUnitCode);
        if ("1".equals(unit.getUnitType())) {
            currentUnitCode = this.commonController.changeStrRemove0(currentUnitCode, 2);
        } else if ("2".equals(unit.getUnitType())) {
            currentUnitCode = this.commonController.changeStrRemove0(currentUnitCode, 4);
        } else if ("3".equals(unit.getUnitType())) {
            currentUnitCode = this.commonController.changeStrRemove0(currentUnitCode, 6);
        } else if ("4".equals(unit.getUnitType())) {
            currentUnitCode = this.commonController.changeStrRemove0(currentUnitCode, 9);
        }
        if (unitCode == null || currentUnitCode.length() >= unitCode.length()) {
            unitCode = currentUnitCode;
        }
        if (!"32".equals(unitCode)) {
            String tempUnitCode = unitCode;
            for (int i = unitCode.length(); i < 12; ++i) {
                tempUnitCode = tempUnitCode + "0";
            }
            List listObjects = this.commonController.listSubUnitsNotIncludedVillageOfCache(tempUnitCode);
            StringBuffer sb = new StringBuffer();
            sb.append(" and t.primary_unit in ('");
            for (IUnitInfo uf : listObjects) {
                sb.append(uf.getUnitCode()).append("','");
            }
            sb = sb.delete(sb.length() - 2, sb.length());
            sb.append(") ");
            flist.add(new FilterUtil("", sb.toString(), "self", null));
        }
        if (StringUtils.isNotBlank((CharSequence)(userName = (String)searchColumn.get("userName")))) {
            flist.add(new FilterUtil("user_name", userName, "like", null));
        }
        if (StringUtils.isNotBlank((CharSequence)(queryByUnit = (String)searchColumn.get("queryByUnit")))) {
            flist.add(new FilterUtil("primary_unit", queryByUnit, "=", null));
        }
        if (StringUtils.isNotBlank((CharSequence)(isValid = (String)searchColumn.get("isValid")))) {
            flist.add(new FilterUtil("is_valid", isValid, "=", null));
        }
        flist.add(new FilterUtil(null, "update_date", "sort", null));
        arr = this.commonManager.listObjectsBySqlAsJson(sql, null, flist, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)arr);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @RequestMapping(value={"/saveUserRole"}, method={RequestMethod.POST})
    public ResponseData save(@Valid UserRole userRole, HttpServletRequest request) {
        if (userRole.getCreateDate() == null) {
            userRole.setCreateDate(new Date());
        }
        userRole.setUpdateDate(new Date());
        String isDeleteOld = request.getParameter("isDeleteOld");
        List list = this.sysUserRoleManager.listUserRolesByUserCode(userRole.getUserCode());
        if ("T".equals(isDeleteOld) && list != null && list.size() > 0 && !"u0000000".equals(userRole.getUserCode())) {
            for (FVUserRoles ur : list) {
                if (ur.getRoleCode().equals(userRole.getRoleCode())) continue;
                this.sysUserRoleManager.deleteObjectById(new UserRoleId(ur.getUserCode(), ur.getRoleCode()));
            }
            UserRole dbUserRole = this.sysUserRoleManager.getObjectById(new UserRoleId(userRole.getUserCode(), userRole.getRoleCode()));
            if (dbUserRole != null) {
                this.sysUserRoleManager.mergeObject(userRole);
            } else {
                if (userRole.getObtainDate() == null) {
                    userRole.setObtainDate(new Date());
                }
                this.sysUserRoleManager.mergeObject(userRole);
            }
        } else {
            if (userRole.getObtainDate() == null) {
                userRole.setObtainDate(new Date());
            }
            this.sysUserRoleManager.mergeObject(userRole);
        }
        if (!"T".equals(isDeleteOld)) {
            this.resetPwd(userRole.getUserCode());
        }
        return ResponseData.makeSuccessResponse();
    }

    @RequestMapping(value={"/getRoleByUserCode/{userCode}"}, method={RequestMethod.GET})
    public JSONObject getRoleByUserCode(@PathVariable String userCode, HttpServletRequest request) {
        String sql = " select * from f_userrole ";
        ArrayList<FilterUtil> flist = new ArrayList<FilterUtil>();
        FilterUtil f = new FilterUtil("user_code", userCode, null, null);
        flist.add(f);
        JSONArray arr = this.commonManager.listObjectsBySqlAsJson(sql, null, flist, null);
        if (arr != null && arr.size() > 0) {
            String[] roleCodes = new String[]{"0010", "0011", "0012", "0013", "0014"};
            for (int i = 0; i < arr.size(); ++i) {
                JSONObject obj = arr.getJSONObject(i);
                String role = obj.getString("roleCode");
                for (String s : roleCodes) {
                    if (!s.equals(role)) continue;
                    return obj;
                }
            }
        }
        return new JSONObject();
    }

    @ApiOperation(value="\u65b0\u5efa\u673a\u6784", notes="\u65b0\u5efa\u4e00\u4e2a\u673a\u6784\u3002")
    @ApiImplicitParam(name="unitInfo", value="json\u683c\u5f0f\uff0c\u673a\u6784\u4fe1\u606f\u5bf9\u8c61", paramType="body", dataTypeClass=UnitInfo.class)
    @RequestMapping(value={"/createUnitInfo"}, method={RequestMethod.POST})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u673a\u6784")
    @WrapUpResponseBody
    public ResponseData createUnitInfo(@Valid UnitInfo unitInfo) {
        String sql = "select * from f_unitinfo ";
        ArrayList<FilterUtil> flist = new ArrayList<FilterUtil>();
        flist.add(new FilterUtil("unit_name", unitInfo.getUnitName(), null, null));
        JSONArray arr = this.commonManager.listObjectsBySqlAsJson(sql, null, flist, null);
        if (arr.size() > 0) {
            return ResponseData.makeErrorMessage((int)702, (String)("\u673a\u6784\u540d" + unitInfo.getUnitName() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01"));
        }
        UnitInfo dbunitInfo = this.sysUnitManager.getObjectById(unitInfo.getUnitCode());
        if (dbunitInfo != null) {
            return ResponseData.makeErrorMessage((int)702, (String)("\u90e8\u95e8\u7f16\u7801\uff08\u5373\u884c\u653f\u533a\u5212\u4ee3\u7801\uff09" + unitInfo.getUnitCode() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01"));
        }
        while (!this.sysUnitManager.isUniqueOrder(unitInfo)) {
            unitInfo.setUnitOrder(Long.valueOf(unitInfo.getUnitOrder() + 1L));
        }
        UnitInfo parentUnit = this.sysUnitManager.getObjectById(unitInfo.getParentUnit());
        if (parentUnit == null) {
            unitInfo.setUnitPath("/" + unitInfo.getUnitCode() + "/");
        } else {
            unitInfo.setUnitPath(parentUnit.getUnitPath() + "/" + unitInfo.getUnitCode() + "/");
        }
        if (StringUtils.isBlank((CharSequence)unitInfo.getUnitCode())) {
            this.sysUnitManager.saveNewUnitInfo(unitInfo);
        } else {
            this.commonManager.saveUnitInfo(unitInfo);
        }
        return ResponseData.makeResponseData((Object)unitInfo);
    }

    @ApiOperation(value="\u66f4\u65b0\u673a\u6784\u4fe1\u606f", notes="\u66f4\u65b0\u673a\u6784\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="unitCode", value="\u673a\u6784\u4ee3\u7801", paramType="path", dataType="String"), @ApiImplicitParam(name="unitInfo", value="json\u683c\u5f0f\uff0c\u673a\u6784\u4fe1\u606f\u5bf9\u8c61", paramType="body", dataTypeClass=UnitInfo.class)})
    @RequestMapping(value={"/editUnitInfo/{unitCode}"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u673a\u6784")
    @WrapUpResponseBody
    public ResponseData editUnitInfo(@PathVariable String unitCode, @Valid UnitInfo unitInfo) {
        UnitInfo dbUnitInfo = this.sysUnitManager.getObjectById(unitCode);
        if (null == dbUnitInfo) {
            return ResponseData.makeErrorMessage((String)"\u673a\u6784\u4e0d\u5b58\u5728");
        }
        if ("F".equals(unitInfo.getIsValid())) {
            List units = this.sysUnitManager.listValidSubUnit(unitCode);
            if (units != null && units.size() != 0) {
                return ResponseData.makeErrorMessage((String)"\u8be5\u673a\u6784\u5305\u542b\u4e0b\u7ea7\u673a\u6784\uff0c\u4e0d\u80fd\u8bbe\u4e3a\u7981\u7528\uff01");
            }
            List userUnits = this.sysUserUnitManager.listUnitUsersByUnitCode(unitCode);
            if (userUnits != null && userUnits.size() != 0) {
                return ResponseData.makeErrorMessage((String)"\u8be5\u673a\u6784\u5b58\u5728\u5173\u8054\u7528\u6237\uff0c\u4e0d\u80fd\u8bbe\u4e3a\u7981\u7528\uff01");
            }
        }
        this.sysUnitManager.updateUnitInfo(unitInfo);
        return ResponseData.makeResponseData((Object)unitInfo);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u673a\u6784\u4fe1\u606f", notes="\u5206\u9875\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<UnitInfo> list(PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        List listObjects = this.sysUnitManager.listObjects(searchColumn, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)listObjects, (PageDesc)pageDesc);
    }

    @RequestMapping(value={"/subunits"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listSub(boolean struct, String id, HttpServletRequest request) {
        List<Object> listObjects;
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        String unitName = (String)searchColumn.get("unitName");
        String currentUnitCode = WebOptUtils.getCurrentUnitCode((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)unitName) && StringUtils.isBlank((CharSequence)id)) {
            List listObjects2 = this.sysUnitManager.listObjects(searchColumn);
            JSONArray ja = DictionaryMapUtils.objectsToJSONArray((Collection)listObjects2);
            if (struct) {
                ja = CollectionsOpt.srotAsTreeAndToJSON((List)ja, (p, c) -> StringUtils.equals((CharSequence)((JSONObject)p).getString("unitCode"), (CharSequence)((JSONObject)c).getString("parentUnit")), (String)"children");
            }
            return ResponseData.makeResponseData((Object)ja);
        }
        HashMap<String, String> filterMap = new HashMap<String, String>(2);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            filterMap.put("parentUnit", id);
            listObjects = this.sysUnitManager.listObjects(filterMap);
        } else {
            listObjects = new ArrayList<UnitInfo>();
            listObjects.add(this.sysUnitManager.getObjectById(currentUnitCode));
        }
        this.sysUnitManager.checkState(listObjects);
        JSONArray ja = DictionaryMapUtils.objectsToJSONArray(listObjects);
        return ResponseData.makeResponseData((Object)ja);
    }

    @RequestMapping(value={"/getUnitsByUnitCode/{type}/{unitCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<IUnitInfo> getUnitsByUnitCode(@PathVariable String type, @PathVariable String unitCode, HttpServletRequest request) {
        List list = null;
        if ("all".equals(type)) {
            list = this.commonController.listAllSubUnitsOfCache(unitCode);
        } else if ("child".equals(type)) {
            list = this.commonController.listSelfAndSubUnitsOfCache(unitCode);
        } else if ("childOnly".equals(type)) {
            list = this.commonController.listSubUnitsOfCache(unitCode);
        }
        return list;
    }

    @RequestMapping(value={"/getUnitsByLoginAndUnitCode/{level}/{unitCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<IUnitInfo> getUnitsByLoginAndUnitCode(@PathVariable int level, @PathVariable String unitCode, HttpServletRequest request) {
        int unitType;
        ArrayList<IUnitInfo> list = null;
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        String loginUnitCode = null;
        if (loginUser != null) {
            loginUnitCode = loginUser.getCurrentUnitCode();
        } else {
            UserUnit userUnit;
            String userCode = request.getParameter("userCode");
            if (StringUtils.isNotBlank((CharSequence)userCode) && (userUnit = this.sysUserUnitManager.getPrimaryUnitByUserCode(userCode)) != null) {
                loginUnitCode = userUnit.getUnitCode();
            }
        }
        UnitInfo unit = this.sysUnitManager.getObjectById(loginUnitCode);
        int n = unitType = StringUtils.isNotBlank((CharSequence)unit.getUnitType()) ? Integer.valueOf(unit.getUnitType()) : 0;
        if (unitType < level) {
            list = this.commonController.listSubUnitsOfCache(unitCode);
        } else if (unitType == level) {
            list = new ArrayList<IUnitInfo>();
            list.add((IUnitInfo)unit);
        } else {
            list = new ArrayList();
            UnitInfo pUnit = this.sysUnitManager.getObjectById(unit.getParentUnit());
            int n2 = unitType = StringUtils.isNotBlank((CharSequence)pUnit.getUnitType()) ? Integer.valueOf(pUnit.getUnitType()) : 0;
            while (unitType > level) {
                unitType = StringUtils.isNotBlank((CharSequence)(pUnit = this.sysUnitManager.getObjectById(pUnit.getParentUnit())).getUnitType()) ? Integer.valueOf(pUnit.getUnitType()) : 0;
            }
            list.add((IUnitInfo)pUnit);
        }
        return list;
    }

    @ApiOperation(value="\u6279\u91cf\u91cd\u7f6e\u5bc6\u7801", notes="\u6279\u91cf\u91cd\u7f6e\u5bc6\u7801\u3002")
    @ApiImplicitParam(name="userCodes", value="\u7528\u6237\u4ee3\u7801\u96c6\u5408(\u6570\u7ec4)", allowMultiple=true, paramType="path", dataType="String")
    @RequestMapping(value={"/reset"}, method={RequestMethod.PUT})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u91cd\u7f6e\u7528\u6237\u5bc6\u7801")
    @WrapUpResponseBody
    public ResponseData resetBatchPwd(String[] userCodes) {
        if (ArrayUtils.isEmpty((Object[])userCodes)) {
            return ResponseData.makeErrorMessage((String)"\u7528\u6237\u4ee3\u7801\u96c6\u5408\u4e3a\u7a7a");
        }
        for (String userCode : userCodes) {
            this.resetPwd(userCode);
        }
        return ResponseData.makeSuccessResponse();
    }

    public void resetPwd(String userCode) {
        UserInfo user = this.sysUserManager.getObjectById(userCode);
        String pw = this.passwordEncoder.createPassword(password, (Object)userCode);
        user.setUserPin(pw);
        this.sysUserManager.updateUserInfo(user);
    }

    @RequestMapping(value={"/getUnitInfoById/{unitCode}"}, method={RequestMethod.GET})
    public UnitInfo getUnitInfoById(@PathVariable String unitCode, HttpServletRequest request, HttpServletResponse response) {
        UnitInfo unitInfo = this.sysUnitManager.getObjectById(unitCode);
        return unitInfo;
    }
}

