/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.common.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.common.controller.CommonController;
import com.nfgl.common.po.FarmHouseStatistics2;
import com.nfgl.common.po.StatisticsList;
import com.nfgl.common.service.CommonManager;
import com.nfgl.common.service.FarmHouseStatistics2Manager;
import com.nfgl.common.service.FarmHouseStatisticsManager;
import com.nfgl.common.service.StatisticsListManager;
import com.nfgl.common.service.WorkloadStatisticsManager;
import com.nfgl.sjcj.po.Farmhousejbxx;
import com.nfgl.sjcj.po.Villagejbxx;
import com.nfgl.sjcj.service.FarmhousejbxxManager;
import com.nfgl.sjcj.service.HouseholdregisterjbxxManager;
import com.nfgl.sjcj.service.NewhousingjbxxManager;
import com.nfgl.sjcj.service.VillagejbxxManager;
import com.nfgl.utils.po.DateUtil;
import com.nfgl.utils.po.ExcelUtil;
import com.nfgl.utils.po.PmpWfRecord;
import com.nfgl.utils.po.PmpWfRecordID;
import com.nfgl.utils.service.PmpWfRecordManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common/statisticsList"})
public class StatisticsListController
extends BaseController {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(StatisticsListController.class);
    @Resource
    private FarmhousejbxxManager farmhousejbxxMag;
    @Resource
    private NewhousingjbxxManager newhousingjbxxManager;
    @Resource
    private HouseholdregisterjbxxManager householdregisterjbxxManager;
    @Resource
    private VillagejbxxManager villagejbxxManager;
    @Resource
    private FarmHouseStatisticsManager farmHouseStatisticsManager;
    @Resource
    private StatisticsListManager statisticsListManager;
    @Resource
    private FarmHouseStatistics2Manager farmHouseStatistics2Manager;
    @Resource
    private WorkloadStatisticsManager workloadStatisticsManager;
    @Resource
    private SysUnitManager sysUnitManager;
    @Resource
    private CommonController commonController;
    @Resource
    private PmpWfRecordManager pmpWfRecordManager;
    @Resource
    private CommonManager commonManager;

    @GetMapping
    public ResponseData list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        ResponseMapData resData = new ResponseMapData();
        request.setAttribute("addUserCodes", (Object)"T");
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        if (searchColumn.containsKey("second")) {
            searchColumn.put("second", searchColumn.get("second").toString().substring(0, 4));
        }
        String stype = (String)searchColumn.get("stype");
        JSONArray jsonArr = this.statisticsListManager.listObjectsAsJson(searchColumn, pageDesc);
        for (int i = 0; i < jsonArr.size(); ++i) {
            String sql;
            JSONArray arr;
            String status;
            Villagejbxx villagejbxx;
            JSONObject obj = jsonArr.getJSONObject(i);
            String[] dis = new String[]{obj.getString("districtcode"), obj.getString("town"), obj.getString("administrativeVillage")};
            String[] names = this.commonController.getUnitNames(dis);
            obj.put("districtcode", (Object)names[0]);
            obj.put("town", (Object)names[1]);
            obj.put("administrativeVillage", (Object)names[2]);
            String vid = obj.getString("vid");
            if (StringUtils.isNotBlank((CharSequence)vid) && (villagejbxx = (Villagejbxx)this.villagejbxxManager.getObjectById((Serializable)((Object)obj.getString("vid")))) != null) {
                obj.put("naturalVillage", (Object)villagejbxx.getNaturalvillage());
            }
            if (StringUtils.isNotBlank((CharSequence)(status = obj.getString("status")))) {
                obj.put("remind", (Object)this.commonController.getRemindByStatus(status));
            }
            if ((arr = this.commonManager.listObjectsBySqlAsJson(sql = "1".equals(stype) ? "select count(*) sl from farmHouseStatistics t where t.sid='" + obj.getString("sid") + "'" : "select count(*) sl from FARMHOUSEJBXX t where t.realityyear=" + obj.getString("syear") + " and t.unit_code = '" + obj.getString("unitcode") + "' and t.isbetter in ('S','T')", null, null, null)) == null) continue;
            JSONObject temp = arr.getJSONObject(0);
            Integer snum = temp.getInteger("sl");
            obj.put("snum", (Object)snum);
        }
        resData.addResponseData("objList", (Object)jsonArr);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @RequestMapping(value={"/opinion/{wmodule}/{sid}/{status}"}, method={RequestMethod.POST})
    public ResponseData statisticsListOpinion(@Valid PmpWfRecord pmpWfRecord, @PathVariable Integer wmodule, @PathVariable String sid, @PathVariable String status, HttpServletRequest request, HttpServletResponse response) {
        boolean isOk = true;
        String msg = "";
        String roleCode = "";
        StatisticsList statisticsList = (StatisticsList)this.statisticsListManager.getObjectById((Serializable)((Object)sid));
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        JSONArray userRoles = loginUser.getUserRoles();
        JSONObject jsonObject = userRoles.getJSONObject(1);
        if (jsonObject != null && jsonObject.get((Object)"roleCode") != null) {
            roleCode = jsonObject.get((Object)"roleCode") + "";
        }
        if (!("01".equals(status) || "02".equals(status) || "03".equals(status) || "04".equals(status) || "05".equals(status) || "06".equals(status) || "07".equals(status))) {
            isOk = false;
        } else {
            statisticsList.setStatus(status);
            this.statisticsListManager.mergeObject((Serializable)statisticsList);
            if ("05".equals(status)) {
                HashMap<String, String> searchColumn = new HashMap<String, String>();
                searchColumn.put("sid", statisticsList.getSid());
                List f2s = this.farmHouseStatistics2Manager.listObjects(searchColumn);
                if (f2s != null && f2s.size() > 0) {
                    for (FarmHouseStatistics2 f2 : f2s) {
                        Farmhousejbxx fx = (Farmhousejbxx)this.farmhousejbxxMag.getObjectById((Serializable)((Object)f2.getFid()));
                        if (fx == null) continue;
                        fx.setIsbetter("T");
                        this.farmhousejbxxMag.mergeObject((Serializable)fx);
                    }
                }
            }
            Date date = new Date();
            HashMap<String, Object> searchColumn = new HashMap<String, Object>();
            searchColumn.put("wmodule", wmodule);
            searchColumn.put("wid", sid);
            List pmps = this.pmpWfRecordManager.listObjects(searchColumn);
            Integer ordernum = 0;
            if (pmps != null && pmps.size() > 0) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int i = 0; i < pmps.size(); ++i) {
                    list.add(((PmpWfRecord)pmps.get(i)).getWorder());
                }
                ordernum = (Integer)Collections.max(list) + 1;
            } else {
                ordernum = 1;
            }
            pmpWfRecord.setPmpWfRecordID(new PmpWfRecordID(wmodule, sid, ordernum));
            pmpWfRecord.setWdate(new Date());
            pmpWfRecord.setUsername(loginUser.getUserInfo().getString("userName"));
            pmpWfRecord.setUnitcode(loginUser.getCurrentUnitCode());
            pmpWfRecord.setStatus(status);
            String ideaCode = "";
            if ("01".equals(status)) {
                ideaCode = "05";
            } else if ("02".equals(status)) {
                ideaCode = "01";
            } else if ("03".equals(status)) {
                ideaCode = "03";
            } else if ("04".equals(status)) {
                ideaCode = "04";
            } else if ("05".equals(status)) {
                ideaCode = "06";
            } else if ("06".equals(status)) {
                ideaCode = "03";
            } else if ("07".equals(status)) {
                ideaCode = "03";
            }
            pmpWfRecord.setIdeaCode(ideaCode);
            this.pmpWfRecordManager.saveNewObject((Serializable)pmpWfRecord);
        }
        JSONObject obj = new JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        return ResponseData.makeResponseData((Map)obj);
    }

    @GetMapping(value={"/{sid}"})
    public StatisticsList getStatisticsList(@PathVariable String sid, HttpServletResponse response) {
        StatisticsList statisticsList = (StatisticsList)this.statisticsListManager.getObjectById((Serializable)((Object)sid));
        statisticsList.setRemind(this.commonController.getRemindByStatus(statisticsList.getStatus()));
        return statisticsList;
    }

    @GetMapping(value={"getStatisticsListByYear/{stype}/{syear}/{fid}"})
    public StatisticsList getStatisticsListByYear(@PathVariable String stype, @PathVariable String syear, @PathVariable String fid, HttpServletResponse response) {
        StatisticsList st = null;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("syear", syear);
        map.put("stype", stype);
        String town = null;
        Farmhousejbxx farmhousejbxx = (Farmhousejbxx)this.farmhousejbxxMag.getObjectById((Serializable)((Object)fid));
        if (farmhousejbxx != null) {
            town = farmhousejbxx.getUnitCode();
            Villagejbxx vj = (Villagejbxx)this.villagejbxxManager.getObjectById((Serializable)((Object)farmhousejbxx.getVid()));
            if (vj != null) {
                town = vj.getTown();
            }
        }
        if (town != null) {
            map.put("town", town);
            List list = this.statisticsListManager.listObjects(map);
            if (list != null && list.size() > 0) {
                st = (StatisticsList)list.get(0);
            }
        }
        return st;
    }

    @GetMapping(value={"/export/{stype}"})
    public String export(HttpServletRequest request, HttpServletResponse response, @PathVariable String stype) throws IOException {
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        searchColumn.put("stype", stype);
        Object towns = searchColumn.get("towns");
        if (towns != null && !"".equals(towns)) {
            char c;
            int i;
            for (i = towns.toString().length() - 1; i >= 0 && (c = towns.toString().charAt(i)) == '0'; --i) {
            }
            searchColumn.put("dis", ((String)towns).substring(0, i + 1) + "%");
        }
        JSONArray listObjects = this.statisticsListManager.listObjectsAsJson(searchColumn, null);
        String title = "";
        if ("1".equals(stype)) {
            title = "\u8ba1\u5212\u6539\u5584\u4fe1\u606f\u7edf\u8ba1";
        } else if ("2".equals(stype)) {
            title = "\u5b9e\u9645\u6539\u5584\u4fe1\u606f\u7edf\u8ba1";
        }
        String excelName = title + DateUtil.getCurrentDate24YYYYMM();
        String[] columnNames = new String[]{"\u72b6\u6001", "\u5e74\u4efd", "\u884c\u653f\u533a\u5212", "\u4e61\u9547", "\u884c\u653f\u6751\u540d", "\u81ea\u7136\u6751\u540d", "\u5f55\u5165\u7528\u6237", "\u66f4\u65b0\u65f6\u95f4"};
        String[] keys = new String[]{"status", "syear", "districtcode", "town", "administrativevillage", "naturalVillage", "username", "updateTime"};
        short[] columnWidths = new short[]{3600, 3600, 3600, 3600, 3600, 3600, 3600, 3600};
        ArrayList dataList = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sheetName", "sheet1");
        map.put("titleText", excelName);
        dataList.add(map);
        for (int i = 0; i < listObjects.size(); ++i) {
            UnitInfo townUnitInfo;
            UnitInfo disUnitInfo;
            JSONObject obj = listObjects.getJSONObject(i);
            HashMap<String, String> mapValue = new HashMap<String, String>();
            for (String key : keys) {
                mapValue.put(key, obj.getString(key));
            }
            mapValue.put("status", CodeRepositoryUtil.getValue((String)"sjcjStatusType", (String)obj.getString("status")));
            if (obj.getString("updateTime") != null && obj.getString("updateTime").length() > 10) {
                mapValue.put("updateTime", obj.getString("updateTime").substring(0, 10));
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("vid", obj.getString("vid"));
            Villagejbxx villagejbxx = (Villagejbxx)this.villagejbxxManager.getObjectByProperties(properties);
            if (villagejbxx != null) {
                UnitInfo administrativevillageUnitInfo;
                if (StringUtils.isNotBlank((CharSequence)villagejbxx.getAdministrativevillage()) && (administrativevillageUnitInfo = this.sysUnitManager.getObjectById(villagejbxx.getAdministrativevillage())) != null) {
                    mapValue.put("administrativevillage", administrativevillageUnitInfo.getUnitName());
                }
                mapValue.put("naturalVillage", villagejbxx.getNaturalvillage());
            }
            String districtcode = obj.getString("districtcode");
            String town = obj.getString("town");
            String administrativevillage = obj.getString("administrativevillage");
            if (StringUtils.isNotBlank((CharSequence)districtcode) && (disUnitInfo = this.sysUnitManager.getObjectById(districtcode)) != null) {
                mapValue.put("districtcode", disUnitInfo.getUnitName());
            }
            if (StringUtils.isNotBlank((CharSequence)town) && (townUnitInfo = this.sysUnitManager.getObjectById(town)) != null) {
                mapValue.put("town", townUnitInfo.getUnitName());
            }
            dataList.add(mapValue);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ExcelUtil.createWorkBook(dataList, (String[])keys, (String[])columnNames, (short[])columnWidths).write((OutputStream)os);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        response.reset();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String((excelName + ".xlsx").getBytes("gb2312"), "iso-8859-1"));
        ServletOutputStream out = response.getOutputStream();
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            int bytesRead = 0;
            while ((bytesRead = bis.read(buff)) > 0) {
                bos.write(buff, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @RequestMapping(method={RequestMethod.POST})
    public StatisticsList saveVillagejbxx(@Valid StatisticsList statisticsList, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("syear", statisticsList.getSyear());
        map.put("town", statisticsList.getTown());
        map.put("stype", "1");
        List list = this.statisticsListManager.listObjects(map);
        if (statisticsList.getSyear() == null || "".equals(statisticsList.getSyear())) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5e74\u5ea6\u8ba1\u5212\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u65b0\u589e\u8ba1\u5212\uff01", (HttpServletResponse)response);
            return null;
        }
        if (list != null && list.size() > 0) {
            JsonResultUtils.writeErrorMessageJson((String)(statisticsList.getSyear() + "\u5e74\u5ea6\u8ba1\u5212\u5df2\u65b0\u589e\uff0c\u8bf7\u52ff\u91cd\u590d\u65b0\u589e\u8ba1\u5212\uff01"), (HttpServletResponse)response);
            return null;
        }
        Date date = new Date();
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        statisticsList.setUsercode(loginUser.getUserCode());
        statisticsList.setUsername(loginUser.getUserInfo().getString("userName"));
        statisticsList.setUnitcode(loginUser.getCurrentUnitCode());
        statisticsList.setCreateTime(date);
        statisticsList.setUpdateTime(date);
        statisticsList.setStatus("01");
        this.statisticsListManager.mergeObject((Serializable)statisticsList);
        map.put("stype", "2");
        List list2 = this.statisticsListManager.listObjects(map);
        if (list2 == null || list2.size() < 1) {
            StatisticsList statisticsList2 = new StatisticsList();
            statisticsList2.copy(statisticsList);
            statisticsList2.setSid(null);
            statisticsList2.setStype("2");
            this.statisticsListManager.mergeObject((Serializable)statisticsList2);
        }
        return statisticsList;
    }
}

