/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.common.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.common.controller.CommonController;
import com.nfgl.common.po.FarmHouseStatistics;
import com.nfgl.common.po.StatisticsList;
import com.nfgl.common.service.CommonManager;
import com.nfgl.common.service.FarmHouseStatisticsManager;
import com.nfgl.common.service.StatisticsListManager;
import com.nfgl.sjcj.po.Farmhousejbxx;
import com.nfgl.sjcj.po.Householdregisterjbxx;
import com.nfgl.sjcj.po.Houseto;
import com.nfgl.sjcj.po.Newhousingjbxx;
import com.nfgl.sjcj.po.Villagejbxx;
import com.nfgl.sjcj.service.FarmhousejbxxManager;
import com.nfgl.sjcj.service.HouseholdregisterjbxxManager;
import com.nfgl.sjcj.service.HousetoManager;
import com.nfgl.sjcj.service.NewhousingjbxxManager;
import com.nfgl.sjcj.service.VillagejbxxManager;
import com.nfgl.utils.po.DateUtil;
import com.nfgl.utils.po.ExcelUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common/farmHouseStatistics"})
public class FarmHouseStatisticsController
extends BaseController {
    private static final Log log = LogFactory.getLog(FarmHouseStatisticsController.class);
    @Resource
    private CommonController commonController;
    @Resource
    private FarmHouseStatisticsManager farmHouseStatisticsManager;
    @Resource
    private SysUnitManager sysUnitManager;
    @Resource
    private VillagejbxxManager villagejbxxMag;
    @Resource
    private StatisticsListManager statisticsListManager;
    @Resource
    private NewhousingjbxxManager newhousingjbxxManager;
    @Resource
    private HousetoManager housetoManager;
    @Resource
    private FarmhousejbxxManager farmhousejbxxManager;
    @Resource
    private HouseholdregisterjbxxManager householdregisterjbxxManager;
    @Resource
    private CommonManager commonManager;

    @GetMapping
    public ResponseData list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        ResponseMapData resData = new ResponseMapData();
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        JSONArray jsonArr = this.farmHouseStatisticsManager.listObjectsAsJson(searchColumn, pageDesc);
        resData.addResponseData("objList", (Object)this.doSomethingShow(jsonArr));
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    public JSONArray doSomethingShow(JSONArray jsonArr) {
        JSONArray jsonArrNew = new JSONArray();
        for (int i = 0; i < jsonArr.size(); ++i) {
            JSONObject js = jsonArr.getJSONObject(i);
            JSONObject jsonObject = jsonArr.getJSONObject(i);
            String[] dis = new String[]{jsonObject.getString("districtcode"), jsonObject.getString("town"), jsonObject.getString("administrativeVillage")};
            String[] names = this.commonController.getUnitNames(dis);
            jsonObject.put("detailTown", (Object)(names[0] + names[1]));
            jsonObject.put("administrativeVillage", (Object)names[2]);
            String otherMember = js.getString("otherMember");
            if (StringUtils.isNotBlank((CharSequence)otherMember) && JSONArray.parseArray((String)otherMember) != null && JSONArray.parseArray((String)otherMember).size() > 0) {
                JSONArray arr = JSONArray.parseArray((String)otherMember);
                for (int k = 0; k < arr.size(); ++k) {
                    JSONObject obj = arr.getJSONObject(k);
                    String qtxx = obj.getString("fname") + obj.getString("pid");
                    if (k == 0) {
                        js.put("otherMember", (Object)qtxx);
                        jsonArrNew.add((Object)js);
                        continue;
                    }
                    obj.clear();
                    obj.put("otherMember", (Object)qtxx);
                    jsonArrNew.add((Object)obj);
                }
                continue;
            }
            js.put("otherMember", null);
            jsonArrNew.add((Object)js);
        }
        return jsonArrNew;
    }

    @GetMapping(value={"/{fsid}"})
    public void getFarmHouseStatistics(@PathVariable String fsid, HttpServletResponse response) {
        FarmHouseStatistics farmHouseStatistics = (FarmHouseStatistics)this.farmHouseStatisticsManager.getObjectById((Serializable)((Object)fsid));
        JsonResultUtils.writeSingleDataJson((Object)farmHouseStatistics, (HttpServletResponse)response);
    }

    @GetMapping(value={"/getDetailFarmHouseStatistics/{fsid}"})
    public ResponseMapData getDetailFarmHouseStatistics(@PathVariable String fsid, HttpServletResponse response) {
        ResponseMapData resData = new ResponseMapData();
        FarmHouseStatistics farmHouseStatistics = (FarmHouseStatistics)this.farmHouseStatisticsManager.getObjectById((Serializable)((Object)fsid));
        JSONArray otherMemberJsonArr = new JSONArray();
        if (farmHouseStatistics != null && farmHouseStatistics.getOtherMember() != null && !"".equals(farmHouseStatistics.getOtherMember())) {
            String otherMember = farmHouseStatistics.getOtherMember();
            otherMemberJsonArr = JSONArray.parseArray((String)otherMember);
        }
        resData.addResponseData("farmHouseStatistics", (Object)farmHouseStatistics);
        resData.addResponseData("otherMemberJsonArr", (Object)otherMemberJsonArr);
        return resData;
    }

    @RequestMapping(value={"/{fsid}"}, method={RequestMethod.DELETE})
    public void deleteFarmHouseStatistics(@PathVariable String fsid, HttpServletResponse response) {
        FarmHouseStatistics fs = (FarmHouseStatistics)this.farmHouseStatisticsManager.getObjectById((Serializable)((Object)fsid));
        if (fs == null) {
            JsonResultUtils.writeErrorMessageJson((String)"\u6b64\u519c\u6237\u5df2\u5220\u9664\u8ba1\u5212\u4e2d\uff0c\u4e0d\u53ef\u91cd\u590d\u5220\u9664\uff01", (HttpServletResponse)response);
            return;
        }
        String sid = fs.getSid();
        String fid = fs.getFid();
        if (StringUtils.isBlank((CharSequence)sid) || StringUtils.isBlank((CharSequence)fid)) {
            JsonResultUtils.writeErrorMessageJson((String)"\u6570\u636e\u5f02\u5e38\uff0c\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u65b0\u64cd\u4f5c\uff01", (HttpServletResponse)response);
            return;
        }
        StatisticsList sl = (StatisticsList)this.statisticsListManager.getObjectById((Serializable)((Object)sid));
        Farmhousejbxx fj = (Farmhousejbxx)this.farmhousejbxxManager.getObjectById((Serializable)((Object)fid));
        if (sl == null || fj == null) {
            JsonResultUtils.writeErrorMessageJson((String)"\u6570\u636e\u5f02\u5e38\uff0c\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u65b0\u64cd\u4f5c\uff01", (HttpServletResponse)response);
            return;
        }
        if ("T".equals(fj.getIsbetter()) || "S".equals(fj.getIsbetter())) {
            JsonResultUtils.writeErrorMessageJson((String)"\u6b64\u519c\u6237\u5df2\u786e\u8ba4\u6539\u5584\u6216\u5df2\u6539\u5584\uff0c\u4e0d\u53ef\u5220\u9664\uff01", (HttpServletResponse)response);
            return;
        }
        fj.setIsbetter("F");
        fj.setUpdatetime(new Date());
        List fsList = this.farmHouseStatisticsManager.listObjectsByProperty("fid", (Object)fid);
        if (fsList != null && fsList.size() == 1 && sid.equals(((FarmHouseStatistics)fsList.get(0)).getSid())) {
            if ("3".equals(fj.getBettertype()) || "5".equals(fj.getBettertype())) {
                List hlist = this.housetoManager.listObjectsByProperty("fid", (Object)fid);
                if (hlist != null && hlist.size() > 0) {
                    for (Houseto ht : hlist) {
                        this.housetoManager.deleteObject((Serializable)ht);
                    }
                }
                if (hlist != null && hlist.size() > 0) {
                    for (Houseto ht : hlist) {
                        List hlist2;
                        Newhousingjbxx nj = (Newhousingjbxx)this.newhousingjbxxManager.getObjectById((Serializable)((Object)ht.getHid()));
                        if (nj == null || (hlist2 = this.housetoManager.listObjectsByProperty("hid", (Object)nj.getHid())) == null) continue;
                        nj.setHousehold(Integer.valueOf(hlist2.size()));
                        nj.setUpdatetime(new Date());
                        this.newhousingjbxxManager.mergeObject((Serializable)nj);
                    }
                }
            }
            fj.setPlanyear(null);
            fj.setBettertype(null);
            fj.setHousingaddress(null);
            fj.setHousingstructure2(null);
            fj.setLongit2(null);
            fj.setLat2(null);
            fj.setInfrastructure2(null);
        }
        String[] fields = new String[]{"isbetter", "updatetime", "planyear", "bettertype", "housingaddress", "housingstructure2", "longit2", "lat2", "infrastructure2"};
        this.farmhousejbxxManager.updateObject(fields, fj);
        this.farmHouseStatisticsManager.deleteObjectById((Serializable)((Object)fsid));
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseData saveFarmHouseStatistics(@Valid FarmHouseStatistics farmHouseStatistics, HttpServletRequest request, HttpServletResponse response) {
        String otherMember;
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        String type = request.getParameter("type");
        String fsid = farmHouseStatistics.getFsid();
        boolean isOk = true;
        String msg = "";
        if (StringUtils.isNotBlank((CharSequence)farmHouseStatistics.getOtherMember()) && !"".equals(otherMember = StringEscapeUtils.unescapeHtml4((String)farmHouseStatistics.getOtherMember()))) {
            farmHouseStatistics.setOtherMember(otherMember);
        }
        if ("new".equals(type)) {
            this.farmHouseStatisticsManager.saveNewObject((Serializable)farmHouseStatistics);
        } else {
            FarmHouseStatistics dbh = (FarmHouseStatistics)this.farmHouseStatisticsManager.getObjectById((Serializable)((Object)fsid));
            dbh.copyNotNullProperty(farmHouseStatistics);
            this.farmHouseStatisticsManager.mergeObject((Serializable)dbh);
        }
        JSONObject obj = new JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        return ResponseData.makeResponseData((Map)obj);
    }

    @GetMapping(value={"/export/{sid}"})
    public String export(HttpServletRequest request, HttpServletResponse response, @PathVariable String sid) throws IOException {
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        searchColumn.put("sid", sid);
        JSONArray listObjects = this.farmHouseStatisticsManager.listObjectsAsJson(searchColumn, null);
        String excelName = "\u8ba1\u5212\u6539\u5584\u519c\u6c11\u7fa4\u4f17\u4f4f\u623f\u6761\u4ef6\u4fe1\u606f\u7edf\u8ba1\u8868" + DateUtil.getCurrentDate24YYYYMM();
        String[] columnNames = new String[]{"\u4e61\u9547", "\u884c\u653f\u6751", "\u81ea\u7136\u6751", "\u6237\u4e3b\u59d3\u540d", "\u8eab\u4efd\u8bc1\u53f7\u7801", "\u5bb6\u5ead\u4eba\u53e3\uff08\u4eba\uff09", "\u5176\u4ed6\u5bb6\u5ead\u6210\u5458\u4fe1\u606f", "\u5982\u5c5e\u56db\u7c7b\u4eba\u7fa4\u8bf7\u52fe\u9009ABCD", "\u534f\u8bae\u62c6\u9664\u65e7\u623f\u9762\u79ef\uff08\u33a1\uff09", "\u534f\u8bae\u9000\u51fa\u5b85\u57fa\u5730\u9762\u79ef\uff08\u33a1\uff09", "\u6539\u5584\u7c7b\u578b", "\u8054\u7cfb\u7535\u8bdd"};
        String[] keys = new String[]{"detailTown", "administrativeVillage", "naturalVillage", "fname", "pid", "num", "otherMember", "personType", "oldArea", "outArea", "betterType", "tel"};
        short[] columnWidths = new short[]{3600, 3600, 3600, 5400, 6000, 6000, 9000, 6000, 6000, 6000, 6000, 6000};
        ArrayList dataList = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sheetName", "sheet1");
        map.put("titleText", excelName);
        dataList.add(map);
        String detailTown = "";
        String administrativeVillage = "";
        JSONArray jsonArrNew = new JSONArray();
        for (int i = 0; i < listObjects.size(); ++i) {
            UnitInfo administrativeVillageUnitInfo;
            UnitInfo townUnitInfo;
            HashMap<Object, String> mapValue = null;
            JSONObject obj = listObjects.getJSONObject(i);
            if (obj.get((Object)"otherMember") != null) {
                Object otherMember = obj.get((Object)"otherMember") + "";
                if (((String)otherMember).equals("[]") || ((String)otherMember).equals("[{")) continue;
                otherMember = StringEscapeUtils.unescapeHtml4((String)otherMember);
                JSONArray otherMemberArr = JSONArray.parseArray((String)otherMember);
                for (int k = 0; k < otherMemberArr.size(); ++k) {
                    UnitInfo townUnitInfo2;
                    mapValue = new HashMap();
                    JSONObject jsNew = new JSONObject();
                    if (k == 0) {
                        jsNew = obj;
                    }
                    String otherNew = "";
                    if (StringUtils.isNotBlank((CharSequence)otherMemberArr.getJSONObject(k).toJSONString())) {
                        if (otherMemberArr.getJSONObject(k).get((Object)"name") != null) {
                            otherNew = otherMemberArr.getJSONObject(k).get((Object)"name") + "";
                        }
                        if (otherMemberArr.getJSONObject(k).get((Object)"id") != null) {
                            otherNew = otherNew + otherMemberArr.getJSONObject(k).get((Object)"id") + "";
                        }
                    }
                    jsNew.put("otherMember", (Object)otherNew);
                    for (String key : keys) {
                        mapValue.put(key, jsNew.getString(key));
                    }
                    mapValue.put("personType", CodeRepositoryUtil.getValue((String)"PersonType", (String)jsNew.getString("personType")));
                    mapValue.put("betterType", CodeRepositoryUtil.getValue((String)"BetterType", (String)jsNew.getString("betterType")));
                    detailTown = "";
                    if (StringUtils.isNotBlank((CharSequence)((String)jsNew.get((Object)"districtcode"))) && (townUnitInfo2 = this.sysUnitManager.getObjectById(jsNew.getString("districtcode"))) != null) {
                        detailTown = detailTown + townUnitInfo2.getUnitName();
                    }
                    if (StringUtils.isNotBlank((CharSequence)((String)jsNew.get((Object)"town"))) && (townUnitInfo2 = this.sysUnitManager.getObjectById(jsNew.getString("town"))) != null) {
                        detailTown = detailTown + townUnitInfo2.getUnitName();
                    }
                    mapValue.put("detailTown", detailTown);
                    dataList.add(mapValue);
                }
                continue;
            }
            mapValue = new HashMap<Object, String>();
            for (String key : keys) {
                mapValue.put(key, obj.getString(key));
            }
            mapValue.put("personType", CodeRepositoryUtil.getValue((String)"PersonType", (String)obj.getString("personType")));
            mapValue.put("betterType", CodeRepositoryUtil.getValue((String)"BetterType", (String)obj.getString("betterType")));
            detailTown = "";
            if (StringUtils.isNotBlank((CharSequence)((String)obj.get((Object)"districtcode"))) && (townUnitInfo = this.sysUnitManager.getObjectById(obj.getString("districtcode"))) != null) {
                detailTown = detailTown + townUnitInfo.getUnitName();
            }
            if (StringUtils.isNotBlank((CharSequence)((String)obj.get((Object)"town"))) && (townUnitInfo = this.sysUnitManager.getObjectById(obj.getString("town"))) != null) {
                detailTown = detailTown + townUnitInfo.getUnitName();
            }
            mapValue.put("detailTown", detailTown);
            if (StringUtils.isNotBlank((CharSequence)((String)obj.get((Object)"administrativeVillage"))) && (administrativeVillageUnitInfo = this.sysUnitManager.getObjectById(obj.getString("administrativeVillage"))) != null) {
                administrativeVillage = administrativeVillageUnitInfo.getUnitName();
            }
            mapValue.put("administrativeVillage", administrativeVillage);
            dataList.add(mapValue);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ExcelUtil.createWorkBook(dataList, (String[])keys, (String[])columnNames, (short[])columnWidths).write((OutputStream)os);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        response.reset();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String((excelName + ".xlsx").getBytes("gb2312"), "iso-8859-1"));
        ServletOutputStream out = response.getOutputStream();
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            int bytesRead = 0;
            while ((bytesRead = bis.read(buff)) > 0) {
                bos.write(buff, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @RequestMapping(value={"/planList"}, method={RequestMethod.POST})
    public JSONObject planList(HttpServletRequest request, HttpServletResponse response) {
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        String sid = request.getParameter("sid");
        String betterType = request.getParameter("betterType");
        String hid = request.getParameter("hid");
        String json = request.getParameter("json");
        JSONArray arr = JSONArray.parseArray((String)json);
        if (arr != null && arr.size() > 0) {
            List hlist;
            int success = 0;
            int lose = 0;
            StatisticsList sl = (StatisticsList)this.statisticsListManager.getObjectById((Serializable)((Object)sid));
            Newhousingjbxx nj = (Newhousingjbxx)this.newhousingjbxxManager.getObjectById((Serializable)((Object)hid));
            String error = "";
            for (int i = 0; i < arr.size(); ++i) {
                JSONObject obj = arr.getJSONObject(i);
                String fid = obj.getString("fid");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("sid", sid);
                map.put("fid", fid);
                List fs = this.farmHouseStatisticsManager.listObjects(map);
                if (fs != null && fs.size() > 0) {
                    ++lose;
                    error = error + "\u7b2c" + (i + 1) + "\u6761\u4fe1\u606f\u8ba1\u5212\u5f02\u5e38\uff0c\u539f\u56e0\uff1a\u519c\u623f\u5df2\u6dfb\u52a0\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01<br>";
                    continue;
                }
                JSONObject rlt = this.planFarmhousejbxx(loginUser, fid, sl, betterType, nj);
                boolean b = (Boolean)rlt.get((Object)"b");
                if (b) {
                    ++success;
                    continue;
                }
                ++lose;
                error = error + "\u7b2c" + (i + 1) + "\u6761\u4fe1\u606f\u8ba1\u5212\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + rlt.getString("tx") + "<br>";
            }
            if (nj != null && (hlist = this.housetoManager.listObjectsByProperty("hid", (Object)nj.getHid())) != null) {
                nj.setHousehold(Integer.valueOf(hlist.size()));
                nj.setUpdatetime(new Date());
                this.newhousingjbxxManager.mergeObject((Serializable)nj);
            }
            String rlt = "{\"success\":" + success + ",\"lose\":" + lose + ",\"error\":\"" + error + "\"}";
            return JSONObject.parseObject((String)rlt);
        }
        return null;
    }

    public JSONObject planFarmhousejbxx(CentitUserDetails loginUser, String fid, StatisticsList sl, String betterType, Newhousingjbxx nj) {
        boolean b = true;
        String tx = "\u8ba1\u5212\u6210\u529f";
        Farmhousejbxx fj = (Farmhousejbxx)this.farmhousejbxxManager.getObjectById((Serializable)((Object)fid));
        if (fj == null || sl == null) {
            b = false;
            tx = "\u519c\u623f\u6570\u636e\u6216\u8ba1\u5212\u8868\u6570\u636e\u5f02\u5e38\uff01";
        } else if (StringUtils.isBlank((CharSequence)betterType)) {
            b = false;
            tx = "\u6539\u5584\u7c7b\u578b\u6570\u636e\u83b7\u53d6\u5f02\u5e38\uff01";
        } else if ("3".equals(betterType) && nj == null) {
            b = false;
            tx = "\u6539\u5584\u7c7b\u578b\u4e3a\u65b0\u578b\u5c0f\u533a\u65f6\uff0c\u672a\u83b7\u53d6\u5230\u65b0\u5efa\u5c0f\u533a\u4fe1\u606f!";
        } else {
            try {
                Householdregisterjbxx temp;
                Villagejbxx vj = (Villagejbxx)this.villagejbxxMag.getObjectById((Serializable)((Object)fj.getVid()));
                List householdregisterjbxxList = this.householdregisterjbxxManager.listObjectsByProperty("fid", (Object)fid);
                Householdregisterjbxx hz = null;
                ArrayList<Householdregisterjbxx> qt = new ArrayList<Householdregisterjbxx>();
                if (householdregisterjbxxList != null && householdregisterjbxxList.size() > 0) {
                    for (Householdregisterjbxx hj : householdregisterjbxxList) {
                        if ("T".equals(hj.getIsHz())) {
                            hz = hj;
                            continue;
                        }
                        temp = new Householdregisterjbxx();
                        temp.setFname(hj.getFname());
                        temp.setPid(hj.getPid());
                        temp.setHid(hj.getHid());
                        qt.add(temp);
                    }
                }
                if ("3".equals(betterType) || "5".equals(betterType)) {
                    if (StringUtils.isBlank((CharSequence)fj.getHousingaddress())) {
                        fj.setHousingaddress(nj.getHaddress() + nj.getHouseName());
                    }
                    if (StringUtils.isBlank((CharSequence)fj.getHousingstructure2())) {
                        fj.setHousingstructure2(nj.getHousingStructure2());
                    }
                    if (fj.getLongit2() == null) {
                        fj.setLongit2(nj.getLongit());
                    }
                    if (fj.getLat2() == null) {
                        fj.setLat2(nj.getLat());
                    }
                    if (StringUtils.isBlank((CharSequence)fj.getInfrastructure2())) {
                        fj.setInfrastructure2(nj.getInfrastructure2());
                    }
                    Houseto ht = new Houseto();
                    ht.setFid(fid);
                    ht.setHid(nj.getHid());
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("fid", fid);
                    map.put("hid", nj.getHid());
                    temp = (Houseto)this.housetoManager.getObjectByProperties(map);
                    if (temp == null) {
                        this.housetoManager.mergeObject((Serializable)ht);
                    }
                }
                if (sl.getSyear() != null) {
                    fj.setPlanyear(Long.valueOf(sl.getSyear().longValue()));
                }
                fj.setBettertype(betterType);
                fj.setIsbetter("P");
                fj.setUpdatetime(new Date());
                this.farmhousejbxxManager.mergeObject((Serializable)fj);
                FarmHouseStatistics fs = new FarmHouseStatistics();
                fs.setFid(fid);
                fs.setSid(sl.getSid());
                fs.setFyear(sl.getSyear());
                fs.setDistrictcode(vj.getDistrictcode());
                fs.setTown(vj.getTown());
                fs.setAdministrativeVillage(vj.getAdministrativevillage());
                fs.setNaturalVillage(vj.getNaturalvillage());
                fs.setFname(hz.getFname());
                fs.setPid(hz.getPid());
                fs.setNum(hz.getFamilyNum());
                fs.setOtherMember(JSONArray.toJSONString(qt));
                fs.setPersonType(fj.getPersontype());
                fs.setOldArea(fj.getOldarea());
                fs.setOutArea(fj.getOutarea());
                fs.setBetterType(betterType);
                fs.setTel(hz.getTel());
                this.farmHouseStatisticsManager.mergeObject((Serializable)fs);
            }
            catch (Exception e) {
                b = false;
                tx = "\u6dfb\u52a0\u5f02\u5e38" + e.getMessage();
            }
        }
        String rlt = "{\"b\":" + b + ",\"tx\":\"" + tx + "\"}";
        return JSONObject.parseObject((String)rlt);
    }

    @GetMapping(value={"/getNumGroupByXzc/{sid}"})
    public JSONArray getNumGroupByXzc(@PathVariable String sid, HttpServletResponse response) {
        String sql;
        HashMap map = new HashMap();
        StatisticsList statisticsList = (StatisticsList)this.statisticsListManager.getObjectById((Serializable)((Object)sid));
        if ("1".equals(statisticsList.getStype())) {
            String tableName = "farmHouseStatistics";
            sql = "select t.administrativevillage administrativevillage,t2.unit_name unitName,count(*) num from " + tableName + " t " + "left join f_unitinfo t2 on(t.administrativevillage=t2.unit_code) " + " where t.sid = '" + sid + "' " + "group by t.administrativevillage,t2.unit_name";
        } else {
            StatisticsList st = (StatisticsList)this.statisticsListManager.getObjectById((Serializable)((Object)sid));
            sql = "select a.administrativevillage administrativevillage,b.unit_name unitName,a.num from (select t.administrativevillage administrativevillage,count(*) num from farmhousejbxxHouseVillage t where t.realityyear=" + st.getSyear() + " and t.unit_code = '" + st.getUnitcode() + "' and t.isbetter in ('S','T') " + "group by t.administrativevillage) a " + "left join f_unitinfo b on(a.administrativevillage = b.unit_code)";
        }
        JSONArray arr = this.commonManager.listObjectsBySqlAsJson(sql, null, null, null);
        return arr;
    }
}

