/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.common.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.UnitInfo;
import com.centit.framework.system.service.SysUnitManager;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.common.controller.CommonController;
import com.nfgl.common.controller.FarmHouseStatisticsController;
import com.nfgl.common.po.FarmHouseStatistics2;
import com.nfgl.common.po.StatisticsList;
import com.nfgl.common.service.FarmHouseStatistics2Manager;
import com.nfgl.common.service.StatisticsListManager;
import com.nfgl.sjcj.po.Householdregisterjbxx;
import com.nfgl.sjcj.service.HouseholdregisterjbxxManager;
import com.nfgl.utils.po.DateUtil;
import com.nfgl.utils.po.ExcelUtil;
import com.nfgl.utils.service.FarmhousejbxxHouseVillageManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common/farmHouseStatistics2"})
public class FarmHouseStatistics2Controller
extends BaseController {
    private static final Log log = LogFactory.getLog(FarmHouseStatistics2Controller.class);
    @Resource
    private CommonController commonController;
    @Resource
    private FarmHouseStatistics2Manager farmHouseStatistics2Manager;
    @Resource
    private SysUnitManager sysUnitManager;
    @Resource
    private FarmHouseStatisticsController farmHouseStatisticsController;
    @Resource
    private FarmhousejbxxHouseVillageManager farmhousejbxxHouseVillageManager;
    @Resource
    private StatisticsListManager statisticsListManager;
    @Resource
    private HouseholdregisterjbxxManager householdregisterjbxxManager;

    /*
     * Enabled aggressive block sorting
     */
    @GetMapping
    public ResponseData list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        ResponseMapData resData = new ResponseMapData();
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        String sid = (String)searchColumn.get("sid");
        StatisticsList st = (StatisticsList)this.statisticsListManager.getObjectById((Serializable)((Object)sid));
        JSONArray newArr = new JSONArray();
        if (st != null) {
            searchColumn.remove("sid");
            searchColumn.put("realityyear", st.getSyear());
            searchColumn.put("unitCode", st.getUnitcode());
            searchColumn.put("isbetter", new String[]{"S", "T"});
            searchColumn.put("sort", "fid");
            JSONArray arr = this.farmhousejbxxHouseVillageManager.listObjectsAsJson(searchColumn, pageDesc);
            if (arr != null && arr.size() > 0) {
                for (int i = 0; i < arr.size(); ++i) {
                    JSONObject obj = arr.getJSONObject(i);
                    String districtcode = (String)obj.get((Object)"districtcode");
                    String town = (String)obj.get((Object)"town");
                    String administrativevillage = (String)obj.get((Object)"administrativevillage");
                    String[] dis = new String[]{districtcode, town, administrativevillage};
                    String[] names = this.commonController.getUnitNames(dis);
                    obj.put("detailTown", (Object)(names[0] + names[1]));
                    obj.put("administrativeVillage", (Object)names[2]);
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("isHz", "F");
                    map.put("fid", obj.getString("fid"));
                    List hs = this.householdregisterjbxxManager.listObjects(map);
                    if (hs != null && hs.size() > 0) {
                    } else {
                        newArr.add((Object)obj);
                        continue;
                    }
                    for (int k = 0; k < hs.size(); ++k) {
                        Householdregisterjbxx h = (Householdregisterjbxx)hs.get(k);
                        if (k == 0) {
                            obj.put("otherMember", (Object)(h.getFname() + h.getPid()));
                            newArr.add((Object)obj);
                            continue;
                        }
                        JSONObject temp = new JSONObject();
                        temp.put("otherMember", (Object)(h.getFname() + h.getPid()));
                        newArr.add((Object)temp);
                    }
                }
            }
        }
        resData.addResponseData("objList", (Object)newArr);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @GetMapping(value={"/{fsid}"})
    public void getFarmHouseStatistics(@PathVariable String fsid, HttpServletResponse response) {
        FarmHouseStatistics2 farmHouseStatistics2 = (FarmHouseStatistics2)this.farmHouseStatistics2Manager.getObjectById((Serializable)((Object)fsid));
        JsonResultUtils.writeSingleDataJson((Object)farmHouseStatistics2, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{fsid}"}, method={RequestMethod.DELETE})
    public ResponseData deleteFarmHouseStatistics(@PathVariable String fsid, HttpServletResponse response) {
        boolean isOk = true;
        String msg = "";
        try {
            this.farmHouseStatistics2Manager.deleteObjectById((Serializable)((Object)fsid));
        }
        catch (Exception e) {
            isOk = false;
            msg = e.getMessage();
        }
        JSONObject obj = new JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        return ResponseData.makeResponseData((Map)obj);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseData saveFarmHouseStatistics(@Valid FarmHouseStatistics2 farmHouseStatistics2, HttpServletRequest request, HttpServletResponse response) {
        String otherMember;
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        String type = request.getParameter("type");
        String fsid = farmHouseStatistics2.getFsid();
        boolean isOk = true;
        String msg = "";
        if (StringUtils.isNotBlank((CharSequence)farmHouseStatistics2.getOtherMember()) && !"".equals(otherMember = StringEscapeUtils.unescapeHtml4((String)farmHouseStatistics2.getOtherMember()))) {
            farmHouseStatistics2.setOtherMember(otherMember);
        }
        if ("new".equals(type)) {
            this.farmHouseStatistics2Manager.saveNewObject((Serializable)farmHouseStatistics2);
        } else {
            FarmHouseStatistics2 dbh = (FarmHouseStatistics2)this.farmHouseStatistics2Manager.getObjectById((Serializable)((Object)fsid));
            dbh.copyNotNullProperty(farmHouseStatistics2);
            this.farmHouseStatistics2Manager.mergeObject((Serializable)dbh);
        }
        JSONObject obj = new JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        return ResponseData.makeResponseData((Map)obj);
    }

    @GetMapping(value={"/export/{sid}"})
    public String export(HttpServletRequest request, HttpServletResponse response, @PathVariable String sid) throws IOException {
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        searchColumn.put("sid", sid);
        JSONArray listObjects = this.farmHouseStatistics2Manager.listObjectsAsJson(searchColumn, null);
        String excelName = "\u5b9e\u9645\u6539\u5584\u519c\u6c11\u7fa4\u4f17\u4f4f\u623f\u6761\u4ef6\u4fe1\u606f\u7edf\u8ba1\u8868" + DateUtil.getCurrentDate24YYYYMM();
        String[] columnNames = new String[]{"\u4e61\u9547", "\u884c\u653f\u6751", "\u81ea\u7136\u6751", "\u6237\u4e3b\u59d3\u540d", "\u8eab\u4efd\u8bc1\u53f7\u7801", "\u5bb6\u5ead\u4eba\u53e3\uff08\u4eba\uff09", "\u5176\u4ed6\u5bb6\u5ead\u6210\u5458\u4fe1\u606f", "\u5982\u5c5e\u56db\u7c7b\u4eba\u7fa4\u8bf7\u52fe\u9009ABCD", "\u5df2\u62c6\u9664\u65e7\u623f\u9762\u79ef\uff08\u33a1\uff09", "\u5df2\u9000\u51fa\u5b85\u57fa\u5730\u9762\u79ef\uff08\u33a1\uff09", "\u6539\u5584\u7c7b\u578b", "\u73b0\u4f4f\u623f\u9762\u79ef\uff08\u33a1\uff09", "\u73b0\u5c45\u4f4f\u5730\u8be6\u5740", "\u8054\u7cfb\u7535\u8bdd"};
        String[] keys = new String[]{"detailTown", "administrativeVillage", "naturalVillage", "fname", "pid", "num", "otherMember", "personType", "oldArea2", "outArea2", "betterType", "housingArea", "housingAddress", "tel"};
        short[] columnWidths = new short[]{3600, 3600, 3600, 5400, 6000, 6000, 9000, 6000, 6000, 6000, 6000, 6000, 6000, 6000};
        ArrayList dataList = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sheetName", "sheet1");
        map.put("titleText", excelName);
        dataList.add(map);
        String detailTown = "";
        JSONArray jsonArrNew = new JSONArray();
        for (int i = 0; i < listObjects.size(); ++i) {
            UnitInfo townUnitInfo;
            HashMap<Object, String> mapValue = null;
            JSONObject obj = listObjects.getJSONObject(i);
            if (obj.get((Object)"otherMember") != null) {
                Object otherMember = obj.get((Object)"otherMember") + "";
                if (((String)otherMember).equals("[]") || ((String)otherMember).equals("[{")) continue;
                otherMember = StringEscapeUtils.unescapeHtml4((String)otherMember);
                JSONArray otherMemberArr = JSONArray.parseArray((String)otherMember);
                for (int k = 0; k < otherMemberArr.size(); ++k) {
                    UnitInfo townUnitInfo2;
                    mapValue = new HashMap();
                    JSONObject jsNew = new JSONObject();
                    if (k == 0) {
                        jsNew = obj;
                    }
                    String otherNew = "";
                    if (StringUtils.isNotBlank((CharSequence)otherMemberArr.getJSONObject(k).toJSONString())) {
                        if (otherMemberArr.getJSONObject(k).get((Object)"name") != null) {
                            otherNew = otherMemberArr.getJSONObject(k).get((Object)"name") + "";
                        }
                        if (otherMemberArr.getJSONObject(k).get((Object)"id") != null) {
                            otherNew = otherNew + otherMemberArr.getJSONObject(k).get((Object)"id") + "";
                        }
                    }
                    jsNew.put("otherMember", (Object)otherNew);
                    for (String key : keys) {
                        mapValue.put(key, jsNew.getString(key));
                    }
                    mapValue.put("personType", CodeRepositoryUtil.getValue((String)"PersonType", (String)jsNew.getString("personType")));
                    mapValue.put("betterType", CodeRepositoryUtil.getValue((String)"BetterType", (String)jsNew.getString("betterType")));
                    detailTown = "";
                    if (StringUtils.isNotBlank((CharSequence)((String)jsNew.get((Object)"districtcode"))) && (townUnitInfo2 = this.sysUnitManager.getObjectById(jsNew.getString("districtcode"))) != null) {
                        detailTown = detailTown + townUnitInfo2.getUnitName();
                    }
                    if (StringUtils.isNotBlank((CharSequence)((String)jsNew.get((Object)"town"))) && (townUnitInfo2 = this.sysUnitManager.getObjectById(jsNew.getString("town"))) != null) {
                        detailTown = detailTown + townUnitInfo2.getUnitName();
                    }
                    mapValue.put("detailTown", detailTown);
                    dataList.add(mapValue);
                }
                continue;
            }
            mapValue = new HashMap<Object, String>();
            for (String key : keys) {
                mapValue.put(key, obj.getString(key));
            }
            mapValue.put("personType", CodeRepositoryUtil.getValue((String)"PersonType", (String)obj.getString("personType")));
            mapValue.put("betterType", CodeRepositoryUtil.getValue((String)"BetterType", (String)obj.getString("betterType")));
            detailTown = "";
            if (StringUtils.isNotBlank((CharSequence)((String)obj.get((Object)"districtcode"))) && (townUnitInfo = this.sysUnitManager.getObjectById(obj.getString("districtcode"))) != null) {
                detailTown = detailTown + townUnitInfo.getUnitName();
            }
            if (StringUtils.isNotBlank((CharSequence)((String)obj.get((Object)"town"))) && (townUnitInfo = this.sysUnitManager.getObjectById(obj.getString("town"))) != null) {
                detailTown = detailTown + townUnitInfo.getUnitName();
            }
            mapValue.put("detailTown", detailTown);
            dataList.add(mapValue);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ExcelUtil.createWorkBook(dataList, (String[])keys, (String[])columnNames, (short[])columnWidths).write((OutputStream)os);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        response.reset();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String((excelName + ".xlsx").getBytes("gb2312"), "iso-8859-1"));
        ServletOutputStream out = response.getOutputStream();
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream((OutputStream)out);
            byte[] buff = new byte[2048];
            int bytesRead = 0;
            while ((bytesRead = bis.read(buff)) > 0) {
                bos.write(buff, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

