/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.check.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.core.controller.BaseController;
import com.nfgl.check.controller.WorkcheckController;
import com.nfgl.check.po.Checktemplate;
import com.nfgl.check.po.Workcheck;
import com.nfgl.check.po.Workcheckitem;
import com.nfgl.check.service.ChecktemplateManager;
import com.nfgl.check.service.WorkcheckManager;
import com.nfgl.check.service.WorkcheckitemManager;
import com.nfgl.common.controller.CommonController;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/check/workcheckitem"})
public class WorkcheckitemController
extends BaseController {
    private static final Log log = LogFactory.getLog(WorkcheckitemController.class);
    private static final long serialVersionUID = 1L;
    @Resource
    private WorkcheckitemManager workcheckitemMag;
    @Resource
    private CommonController commonController;
    @Resource
    private WorkcheckController workcheckController;
    @Resource
    private ChecktemplateManager checktemplateManager;
    @Resource
    private WorkcheckManager workcheckManager;

    @RequestMapping(value={"/itemListByWid/{wid}"}, method={RequestMethod.GET})
    public JSONArray list(@PathVariable String wid, HttpServletRequest request, HttpServletResponse response) {
        Workcheck workcheck = (Workcheck)this.workcheckManager.getObjectById((Serializable)((Object)wid));
        List wks = this.workcheckitemMag.listObjectsByProperty("wid", (Object)wid);
        HashMap<String, String> searchColumn = new HashMap<String, String>();
        searchColumn.put("ctype", workcheck.getWtype());
        searchColumn.put("isvalid", "1");
        searchColumn.put("sort", "sorts");
        searchColumn.put("order", "asc");
        List checktemplates = this.checktemplateManager.listObjects(searchColumn);
        JSONArray arr = new JSONArray();
        if (checktemplates != null && checktemplates.size() > 0) {
            for (Checktemplate ck : checktemplates) {
                JSONObject obj = (JSONObject)JSONObject.toJSON((Object)ck);
                if (wks != null && wks.size() > 0) {
                    for (Workcheckitem wk : wks) {
                        if (!ck.getCid().equals(wk.getCid())) continue;
                        obj.put("wiid", (Object)wk.getWiid());
                        obj.put("wid", (Object)wk.getWid());
                        obj.put("cid", (Object)wk.getCid());
                        obj.put("xscore", (Object)wk.getXscore());
                        obj.put("sscore", (Object)wk.getSscore());
                        obj.put("pscore", (Object)wk.getPscore());
                        obj.put("remarks", (Object)wk.getRemarks());
                    }
                }
                arr.add((Object)obj);
            }
        }
        return arr;
    }

    @RequestMapping(value={"/itemListByWid2/{wid}"}, method={RequestMethod.GET})
    public JSONArray list2(@PathVariable String wid, HttpServletRequest request, HttpServletResponse response) {
        Workcheck workcheck = (Workcheck)this.workcheckManager.getObjectById((Serializable)((Object)wid));
        List wks = this.workcheckitemMag.listObjectsByProperty("wid", (Object)wid);
        HashMap<String, String> searchColumn = new HashMap<String, String>();
        searchColumn.put("ctype", workcheck.getWtype());
        searchColumn.put("sort", "sorts");
        searchColumn.put("order", "asc");
        List checktemplates = this.checktemplateManager.listObjects(searchColumn);
        JSONArray arr = new JSONArray();
        if (checktemplates != null && checktemplates.size() > 0) {
            for (Checktemplate ck : checktemplates) {
                JSONObject obj = (JSONObject)JSONObject.toJSON((Object)ck);
                if (wks == null || wks.size() <= 0) continue;
                for (Workcheckitem wk : wks) {
                    if (!ck.getCid().equals(wk.getCid())) continue;
                    obj.put("wiid", (Object)wk.getWiid());
                    obj.put("wid", (Object)wk.getWid());
                    obj.put("cid", (Object)wk.getCid());
                    obj.put("xscore", (Object)wk.getXscore());
                    obj.put("sscore", (Object)wk.getSscore());
                    obj.put("pscore", (Object)wk.getPscore());
                    obj.put("remarks", (Object)wk.getRemarks());
                    arr.add((Object)obj);
                }
            }
        }
        return arr;
    }

    @RequestMapping(value={"/{wiid}"}, method={RequestMethod.GET})
    public void getWorkcheckitem(@PathVariable String wiid, HttpServletResponse response) {
        Workcheckitem workcheckitem = (Workcheckitem)this.workcheckitemMag.getObjectById((Serializable)((Object)wiid));
        JsonResultUtils.writeSingleDataJson((Object)workcheckitem, (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    public JSONObject createWorkcheckitem(@RequestBody Workcheckitem workcheckitem, HttpServletResponse response) {
        JSONObject obj = this.saveWorkcheckitem(workcheckitem);
        if (StringUtils.isNotBlank((String)workcheckitem.getWid())) {
            this.workcheckController.updateWorkScoreBywid(workcheckitem.getWid());
        }
        return obj;
    }

    @RequestMapping(value={"/saveWorkcheckitems"}, method={RequestMethod.POST})
    public void saveWorkcheckitems(HttpServletRequest request, HttpServletResponse response) {
        JSONArray arr;
        String list = request.getParameter("list");
        JSONArray rlt = new JSONArray();
        if (StringUtils.isNotBlank((String)list) && (arr = JSONArray.parseArray((String)list)) != null && arr.size() > 0) {
            String wid = null;
            for (int i = 0; i < arr.size(); ++i) {
                JSONObject obj = arr.getJSONObject(i);
                Workcheckitem workcheckitem = new Workcheckitem();
                wid = obj.getString("wid");
                workcheckitem.setWid(wid);
                workcheckitem.setCid(obj.getString("cid"));
                workcheckitem.setWiid(obj.getString("wiid"));
                String score = obj.getString("score");
                if (StringUtils.isNotBlank((String)score)) {
                    Double s = 0.0;
                    try {
                        s = Double.valueOf(score);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    String wtype = obj.getString("wtype");
                    if ("1".equals(wtype)) {
                        workcheckitem.setXscore(s);
                    } else if ("2".equals(wtype)) {
                        workcheckitem.setSscore(s);
                    } else if ("3".equals(wtype)) {
                        workcheckitem.setPscore(s);
                    }
                }
                rlt.add((Object)this.saveWorkcheckitem(workcheckitem));
            }
            this.workcheckController.updateWorkScoreBywid(wid);
        }
        JsonResultUtils.writeSingleDataJson((Object)rlt, (HttpServletResponse)response);
    }

    public JSONObject saveWorkcheckitem(Workcheckitem workcheckitem) {
        JSONObject obj = new JSONObject();
        String wid = workcheckitem.getWid();
        String cid = workcheckitem.getCid();
        String wiid = workcheckitem.getWiid();
        if (StringUtils.isBlank((String)wid) || StringUtils.isBlank((String)cid)) {
            obj.put("isOk", (Object)false);
            obj.put("msg", (Object)"wid\u548ccid\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("wid", wid);
            map.put("cid", cid);
            List list = this.workcheckitemMag.listObjects(map);
            if (list != null && list.size() > 0) {
                Workcheckitem dbw = (Workcheckitem)list.get(0);
                if (StringUtils.isNotBlank((String)wiid) && !wiid.equals(dbw.getWiid())) {
                    obj.put("isOk", (Object)false);
                    obj.put("msg", (Object)"\u9875\u9762\u5b50\u8868\u4e3b\u952e\u4e0e\u6570\u636e\u5e93\u5b58\u5728\u5b50\u8868\u4e3b\u952e\u4e0d\u4e00\u81f4\uff01");
                } else {
                    dbw.copyNotNullProperty(workcheckitem);
                    this.workcheckitemMag.mergeObject((Serializable)dbw);
                    obj.put("isOk", (Object)true);
                    obj.put("obj", (Object)dbw);
                }
            } else {
                this.workcheckitemMag.mergeObject((Serializable)workcheckitem);
                obj.put("isOk", (Object)true);
                obj.put("obj", (Object)workcheckitem);
            }
        }
        return obj;
    }

    @RequestMapping(value={"/{wiid}"}, method={RequestMethod.DELETE})
    public void deleteWorkcheckitem(@PathVariable String wiid, HttpServletResponse response) {
        this.workcheckitemMag.deleteObjectById((Serializable)((Object)wiid));
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{wiid}"}, method={RequestMethod.PUT})
    public void updateWorkcheckitem(@PathVariable String wiid, @Valid Workcheckitem workcheckitem, HttpServletResponse response) {
        Workcheckitem dbWorkcheckitem = (Workcheckitem)this.workcheckitemMag.getObjectById((Serializable)((Object)wiid));
        if (null == workcheckitem) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        dbWorkcheckitem.copy(workcheckitem);
        this.workcheckitemMag.mergeObject((Serializable)dbWorkcheckitem);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }
}

