/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.check.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.po.UserUnit;
import com.centit.framework.system.service.SysUserManager;
import com.centit.framework.system.service.SysUserUnitManager;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.check.po.Checktemplate;
import com.nfgl.check.po.Workcheck;
import com.nfgl.check.po.Workcheckitem;
import com.nfgl.check.service.ChecktemplateManager;
import com.nfgl.check.service.WorkcheckManager;
import com.nfgl.check.service.WorkcheckitemManager;
import com.nfgl.common.controller.CommonController;
import com.nfgl.utils.controller.PmpWfRecordController;
import com.nfgl.utils.po.Attachment;
import com.nfgl.utils.po.DictionaryUtil;
import com.nfgl.utils.po.Images;
import com.nfgl.utils.service.AttachmentManager;
import com.nfgl.utils.service.ImagesManager;
import com.nfgl.utils.service.PmpWfRecordManager;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/check/workcheck"})
public class WorkcheckController
extends BaseController {
    private static final Log log = LogFactory.getLog(WorkcheckController.class);
    private static final long serialVersionUID = 1L;
    @Resource
    private WorkcheckManager workcheckMag;
    @Resource
    private CommonController commonController;
    @Resource
    private ChecktemplateManager checktemplateMag;
    @Resource
    private SysUserUnitManager sysUserUnitManager;
    @Resource
    private SysUserManager sysUserManager;
    @Resource
    private WorkcheckitemManager workcheckitemManager;
    @Resource
    private PmpWfRecordController pmpWfRecordController;
    @Resource
    private PmpWfRecordManager pmpWfRecordManager;
    @Resource
    private ImagesManager imagesManager;
    @Resource
    private AttachmentManager attachmentManager;

    @GetMapping
    @WrapUpResponseBody
    public ResponseData list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("addUserCodes", (Object)"T");
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        JSONArray arr = this.workcheckMag.listObjectsAsJson(searchColumn, pageDesc);
        JSONArray newArr = new JSONArray();
        if (arr != null && arr.size() > 0) {
            for (int i = 0; i < arr.size(); ++i) {
                JSONObject obj = arr.getJSONObject(i);
                String[] dis = new String[]{obj.getString("city"), obj.getString("county")};
                String[] names = this.commonController.getUnitNames(dis);
                if (StringUtils.isNotBlank((String)names[1])) {
                    obj.put("xzqh", (Object)names[1]);
                } else {
                    obj.put("xzqh", (Object)names[0]);
                }
                newArr.add((Object)obj);
            }
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)newArr);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @RequestMapping(value={"/wx/LoadWorkcheck"}, method={RequestMethod.GET})
    public ResponseData listWx(HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("addUserCodes", (Object)"T");
        Map map = this.commonController.selfCollectRequestParametersWx(request);
        Map searchColumn = (Map)map.get("searchColumn");
        PageDesc pageDesc = (PageDesc)map.get("pageDesc");
        JSONArray jsonArr = this.workcheckMag.listObjectsAsJson(searchColumn, pageDesc);
        JSONArray newArr = new JSONArray();
        if (jsonArr != null && jsonArr.size() > 0) {
            for (int i = 0; i < jsonArr.size(); ++i) {
                JSONObject obj = jsonArr.getJSONObject(i);
                String[] dis = new String[]{obj.getString("city"), obj.getString("county")};
                String[] names = this.commonController.getUnitNames(dis);
                obj.put("cityName", (Object)names[0]);
                obj.put("countyName", (Object)names[1]);
                String wresult = obj.getString("wresult");
                if (StringUtils.isNotBlank((String)wresult)) {
                    obj.put("wresultName", (Object)DictionaryUtil.getValueByCode((String)"wresultStatus", (String)wresult));
                }
                newArr.add((Object)obj);
            }
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)newArr);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @RequestMapping(value={"/{wid}"}, method={RequestMethod.GET})
    public void getWorkcheck(@PathVariable String wid, HttpServletResponse response) {
        Workcheck workcheck = (Workcheck)this.workcheckMag.getObjectById((Serializable)((Object)wid));
        JSONObject obj = (JSONObject)JSONObject.toJSON((Object)workcheck);
        if (obj != null) {
            String[] dis = new String[]{obj.getString("city"), obj.getString("county")};
            String[] names = this.commonController.getUnitNames(dis);
            if (StringUtils.isNotBlank((String)names[1])) {
                obj.put("xzqh", (Object)names[1]);
            } else {
                obj.put("xzqh", (Object)names[0]);
            }
        }
        JsonResultUtils.writeSingleDataJson((Object)obj, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/loadWorkcheckitem"}, method={RequestMethod.GET})
    public JSONObject loadWorkcheckitem(HttpServletRequest request, HttpServletResponse response) {
        JSONObject obj = new JSONObject();
        String wid = request.getParameter("wid");
        String cid = request.getParameter("cid");
        String wiid = request.getParameter("wiid");
        HashMap<String, String> map = new HashMap<String, String>();
        Workcheckitem wki = null;
        if (StringUtils.isNotBlank((String)wid) && StringUtils.isNotBlank((String)cid)) {
            map.put("wid", wid);
            map.put("cid", cid);
            List wkis = this.workcheckitemManager.listObjects(map);
            if (wkis != null && wkis.size() == 1) {
                wki = (Workcheckitem)wkis.get(0);
            } else {
                obj.put("isOk", (Object)false);
                obj.put("msg", (Object)"\u6570\u636e\u5e93\u672a\u67e5\u8be2\u5230\u8bb0\u5f55\u6216\u67e5\u8be2\u591a\u6761\u8bb0\u5f55\uff01");
            }
        } else if (StringUtils.isNotBlank((String)wiid)) {
            wki = (Workcheckitem)this.workcheckitemManager.getObjectById((Serializable)((Object)wiid));
        } else {
            obj.put("isOk", (Object)false);
            obj.put("msg", (Object)"\u53c2\u6570\u4f20\u9012\u9519\u8bef\uff0cwid\u548ccid\u5fc5\u9009\uff0c\u6216wiid\u5fc5\u9009\uff0c\u82e5\u90fd\u83b7\u53d6\u4ee5wid+cid\u83b7\u53d6\u6570\u636e\u4e3a\u51c6\uff01");
        }
        if (wki != null) {
            obj.put("isOk", (Object)true);
            Checktemplate checktemplate = (Checktemplate)this.checktemplateMag.getObjectById((Serializable)((Object)wki.getCid()));
            JSONObject rlt = (JSONObject)JSONObject.toJSON((Object)checktemplate);
            rlt.put("wiid", (Object)wki.getWiid());
            rlt.put("wid", (Object)wki.getWid());
            rlt.put("cid", (Object)wki.getCid());
            rlt.put("xscore", (Object)wki.getXscore());
            rlt.put("sscore", (Object)wki.getSscore());
            rlt.put("pscore", (Object)wki.getPscore());
            rlt.put("remarks", (Object)wki.getRemarks());
            obj.put("obj", (Object)rlt);
        }
        return obj;
    }

    @RequestMapping(value={"/saveWorkcheckWx"}, method={RequestMethod.POST})
    public JSONObject saveWorkcheckWx(@RequestBody Workcheck workcheck, HttpServletRequest request, HttpServletResponse response) {
        String userCode = null;
        String userName = null;
        String unitCode = null;
        userCode = request.getParameter("userCode");
        UserInfo userInfo = this.sysUserManager.getObjectById(userCode);
        userName = userInfo.getUserName();
        UserUnit userUnit = this.sysUserUnitManager.getPrimaryUnitByUserCode(userCode);
        unitCode = userUnit.getUnitCode();
        return this.savesaveWorkcheck(workcheck, userCode, userName, unitCode);
    }

    @RequestMapping(method={RequestMethod.POST})
    public JSONObject saveWorkcheck(@Valid Workcheck workcheck, HttpServletRequest request, HttpServletResponse response) {
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        String userCode = loginUser.getUserCode();
        String userName = loginUser.getUserInfo().getString("userName");
        String unitCode = loginUser.getCurrentUnitCode();
        return this.savesaveWorkcheck(workcheck, userCode, userName, unitCode);
    }

    public JSONObject savesaveWorkcheck(Workcheck workcheck, String userCode, String userName, String unitCode) {
        List wks;
        JSONObject rlt = new JSONObject();
        String wid = workcheck.getWid();
        if (wid == "") {
            wid = null;
            workcheck.setWid(wid);
        }
        Workcheck dbWorkcheck = null;
        if (StringUtils.isNotBlank((String)wid)) {
            dbWorkcheck = (Workcheck)this.workcheckMag.getObjectById((Serializable)((Object)wid));
        }
        boolean isChange = false;
        boolean isCf = false;
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONObject unitinfo = this.commonController.getUserUnitInfo(unitCode);
        if (StringUtils.isNotBlank((String)wid) && dbWorkcheck != null) {
            if (dbWorkcheck.getStatus() != null && !dbWorkcheck.getStatus().equals(workcheck.getStatus())) {
                isChange = true;
            }
            if (workcheck.getWyear() != null && !workcheck.getWyear().equals(dbWorkcheck.getWyear())) {
                isCf = true;
                map.put("wtype", workcheck.getWtype());
                map.put("wyear", workcheck.getWyear());
                if (StringUtils.isNotBlank((String)workcheck.getCounty())) {
                    map.put("county", workcheck.getCounty());
                } else if (StringUtils.isNotBlank((String)dbWorkcheck.getCounty())) {
                    map.put("county", dbWorkcheck.getCounty());
                } else if (StringUtils.isNotBlank((String)workcheck.getCity())) {
                    map.put("city", workcheck.getCity());
                } else if (StringUtils.isNotBlank((String)dbWorkcheck.getCity())) {
                    map.put("city", dbWorkcheck.getCity());
                } else {
                    rlt.put("isOk", (Object)false);
                    rlt.put("msg", (Object)"\u884c\u653f\u533a\u5212\u9519\u8bef\uff01");
                    return rlt;
                }
            }
            dbWorkcheck.copyNotNullProperty(workcheck);
            workcheck = dbWorkcheck;
            workcheck.setUpdatetime(new Date());
        } else {
            String status;
            isCf = true;
            if (unitinfo != null) {
                String countyCode = unitinfo.getString("countyCode");
                String city = unitinfo.getString("cityCode");
                map.put("wtype", workcheck.getWtype());
                map.put("wyear", workcheck.getWyear());
                if (StringUtils.isNotBlank((String)countyCode)) {
                    map.put("county", countyCode);
                } else if (StringUtils.isNotBlank((String)city)) {
                    map.put("city", city);
                }
                workcheck.setCity(city);
                workcheck.setCounty(countyCode);
            }
            if (StringUtils.isBlank((String)(status = workcheck.getStatus()))) {
                workcheck.setStatus("00");
            }
            if (!"00".equals(workcheck.getStatus())) {
                isChange = true;
            }
            workcheck.setUserCode(userCode);
            workcheck.setUserName(userName);
            workcheck.setUnitCode(unitCode);
            workcheck.setCreatetime(new Date());
            workcheck.setUpdatetime(new Date());
        }
        if (isCf && (wks = this.workcheckMag.listObjects(map)) != null && wks.size() > 0) {
            rlt.put("isOk", (Object)false);
            rlt.put("msg", (Object)(unitinfo.getString("district") + "\u7b2c" + workcheck.getWyear() + "\u5e74\u5de5\u4f5c\u7ee9\u6548\u5df2\u8bc4\u4ef7\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01"));
            return rlt;
        }
        this.workcheckMag.mergeObject((Serializable)workcheck);
        if (isChange) {
            String nowStatus = workcheck.getStatus();
            String ideaCode = null;
            if ("01".equals(nowStatus) || "03".equals(nowStatus) || "05".equals(nowStatus)) {
                ideaCode = "01";
            } else if ("02".equals(nowStatus) || "04".equals(nowStatus)) {
                ideaCode = "04";
            }
            this.pmpWfRecordController.savepmpWfRecord(nowStatus, ideaCode, workcheck.getWid(), userName, unitCode, Integer.valueOf(6));
        }
        rlt.put("isOk", (Object)true);
        rlt.put("obj", (Object)this.updateWorkScoreBywid(workcheck.getWid()));
        return rlt;
    }

    @RequestMapping(value={"/delete/{wid}"}, method={RequestMethod.POST})
    public JSONObject deleteWorkcheckWx(@PathVariable String wid, HttpServletResponse response) {
        return this.deleteWorkcheck(wid, response);
    }

    @RequestMapping(value={"/{wid}"}, method={RequestMethod.DELETE})
    public JSONObject deleteWorkcheck(@PathVariable String wid, HttpServletResponse response) {
        JSONObject obj = new JSONObject();
        try {
            List items = this.workcheckitemManager.listObjectsByProperty("wid", (Object)wid);
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (items != null && items.size() > 0) {
                map.put("emodule", 6L);
                for (Workcheckitem item : items) {
                    map.put("eid", item.getWiid());
                    List fjs = this.imagesManager.listObjects(map);
                    if (fjs != null && fjs.size() > 0) {
                        for (Images fj : fjs) {
                            this.imagesManager.deleteObject((Serializable)fj);
                        }
                    }
                    this.workcheckitemManager.deleteObject((Serializable)item);
                }
            }
            this.pmpWfRecordManager.deleteByWid(wid);
            map.clear();
            map.put("eid", wid);
            List attachments = this.attachmentManager.listObjects(map);
            if (attachments != null && attachments.size() > 0) {
                for (Attachment at : attachments) {
                    this.attachmentManager.deleteObject((Serializable)at);
                }
            }
            this.workcheckMag.deleteObjectById((Serializable)((Object)wid));
            obj.put("isOk", (Object)true);
            obj.put("wid", (Object)wid);
        }
        catch (Exception e) {
            obj.put("isOk", (Object)false);
            obj.put("msg", (Object)("\u6570\u636e\u5220\u9664\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + e.getMessage()));
            obj.put("wid", (Object)wid);
        }
        return obj;
    }

    @RequestMapping(value={"/{wid}"}, method={RequestMethod.PUT})
    public void updateWorkcheck(@PathVariable String wid, @Valid Workcheck workcheck, HttpServletResponse response) {
        Workcheck dbWorkcheck = (Workcheck)this.workcheckMag.getObjectById((Serializable)((Object)wid));
        if (null == workcheck) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        dbWorkcheck.copy(workcheck);
        this.workcheckMag.mergeObject((Serializable)dbWorkcheck);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/wx/checktemplateList"}, method={RequestMethod.GET})
    public List<Checktemplate> loadProjectcheck(HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("addUserCodes", (Object)"F");
        Map map = this.commonController.selfCollectRequestParametersWx(request);
        Map searchColumn = (Map)map.get("searchColumn");
        searchColumn.put("sort", "sorts");
        searchColumn.put("order", "asc");
        List checktemplates = this.checktemplateMag.listObjects(searchColumn);
        return checktemplates;
    }

    public Workcheck updateWorkScoreBywid(String wid) {
        List wks = this.workcheckitemManager.listObjectsByProperty("wid", (Object)wid);
        Workcheck workcheck = (Workcheck)this.workcheckMag.getObjectById((Serializable)((Object)wid));
        if (wks != null && wks.size() > 0) {
            BigDecimal xt = null;
            BigDecimal st = null;
            BigDecimal pt = null;
            for (Workcheckitem item : wks) {
                Double x = item.getXscore();
                Double s = item.getSscore();
                Double p = item.getPscore();
                if (x != null && x > 0.0) {
                    xt = xt == null ? BigDecimal.valueOf(x) : xt.add(BigDecimal.valueOf(x));
                }
                if (s != null && s > 0.0) {
                    st = st == null ? BigDecimal.valueOf(s) : st.add(BigDecimal.valueOf(s));
                }
                if (p == null || !(p > 0.0)) continue;
                if (pt == null) {
                    pt = BigDecimal.valueOf(p);
                    continue;
                }
                pt = pt.add(BigDecimal.valueOf(p));
            }
            if (xt != null) {
                workcheck.setXtotalscore(Double.valueOf(xt.doubleValue()));
            }
            if (st != null) {
                workcheck.setStotalscore(Double.valueOf(st.doubleValue()));
            }
            if (pt != null) {
                workcheck.setPtotalscore(Double.valueOf(pt.doubleValue()));
            }
            this.workcheckMag.mergeObject((Serializable)workcheck);
        }
        return workcheck;
    }
}

