/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.check.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.check.po.Projectcheckitem;
import com.nfgl.check.service.ProjectcheckManager;
import com.nfgl.check.service.ProjectcheckitemManager;
import com.nfgl.common.controller.CommonController;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/check/projectcheckitem"})
public class ProjectcheckitemController
extends BaseController {
    private static final Log log = LogFactory.getLog(ProjectcheckitemController.class);
    private static final long serialVersionUID = 1L;
    @Resource
    private ProjectcheckitemManager projectcheckitemMag;
    @Resource
    private CommonController commonController;
    @Resource
    private ProjectcheckManager projectcheckMag;

    @RequestMapping(method={RequestMethod.GET})
    public ResponseData list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        List listObjects = this.projectcheckitemMag.listObjects(searchColumn, pageDesc);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)listObjects);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @RequestMapping(value={"/{piid}"}, method={RequestMethod.GET})
    public void getProjectcheckitem(@PathVariable String piid, HttpServletResponse response) {
        Projectcheckitem projectcheckitem = (Projectcheckitem)this.projectcheckitemMag.getObjectById((Serializable)((Object)piid));
        JsonResultUtils.writeSingleDataJson((Object)projectcheckitem, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{piid}"}, method={RequestMethod.DELETE})
    public void deleteProjectcheckitem(@PathVariable String piid, HttpServletResponse response) {
        this.projectcheckitemMag.deleteObjectById((Serializable)((Object)piid));
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{piid}"}, method={RequestMethod.PUT})
    public void updateProjectcheckitem(@PathVariable String piid, @Valid Projectcheckitem projectcheckitem, HttpServletResponse response) {
        Projectcheckitem dbProjectcheckitem = (Projectcheckitem)this.projectcheckitemMag.getObjectById((Serializable)((Object)piid));
        if (null == projectcheckitem) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        dbProjectcheckitem.copy(projectcheckitem);
        this.projectcheckitemMag.mergeObject((Serializable)dbProjectcheckitem);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    public void createProjectcheckitem(HttpServletRequest request, HttpServletResponse response) {
        String list = request.getParameter("list");
        String pid = request.getParameter("pid");
        JSONArray arr = JSONArray.parseArray((String)list);
        this.saveProjectcheckitem(arr, pid);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    private void saveProjectcheckitem(JSONArray arr, String pid) {
        if (arr != null && arr.size() > 0 && StringUtils.isNotBlank((String)pid)) {
            for (int i = 0; i < arr.size(); ++i) {
                JSONObject obj = arr.getJSONObject(i);
                Projectcheckitem projectcheckitem = new Projectcheckitem();
                String piid = (String)obj.get((Object)"piid");
                String cid = (String)obj.get((Object)"cid");
                Double xscore = obj.getDouble("xscore");
                projectcheckitem.setXscore(xscore);
                Double sscore = obj.getDouble("sscore");
                projectcheckitem.setSscore(sscore);
                Double pscore = obj.getDouble("pscore");
                projectcheckitem.setPscore(pscore);
                if (StringUtils.isBlank((String)piid)) {
                    projectcheckitem.setPiid(null);
                } else {
                    projectcheckitem.setPiid(piid);
                }
                projectcheckitem.setPid(pid);
                projectcheckitem.setCid(cid);
                this.projectcheckitemMag.mergeObject((Serializable)projectcheckitem);
            }
        }
    }
}

