/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.check.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.check.po.Checktemplate;
import com.nfgl.check.po.Projectcheck;
import com.nfgl.check.po.Projectcheckitem;
import com.nfgl.check.service.ChecktemplateManager;
import com.nfgl.check.service.ProjectcheckManager;
import com.nfgl.check.service.ProjectcheckitemManager;
import com.nfgl.common.StaticVariable;
import com.nfgl.common.controller.CommonController;
import com.nfgl.sjcj.controller.DataExchangeSaveController;
import com.nfgl.sjcj.service.NewhousingjbxxManager;
import com.nfgl.utils.controller.AttachmentController;
import com.nfgl.utils.controller.PmpWfRecordController;
import com.nfgl.utils.po.Attachment;
import com.nfgl.utils.po.Images;
import com.nfgl.utils.service.AttachmentManager;
import com.nfgl.utils.service.ImagesManager;
import com.nfgl.utils.service.PmpWfRecordManager;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/check/projectcheck"})
public class ProjectcheckController
extends BaseController {
    private static final Log log = LogFactory.getLog(ProjectcheckController.class);
    private static final long serialVersionUID = 1L;
    @Resource
    private ProjectcheckManager projectcheckMag;
    @Resource
    private ProjectcheckitemManager projectcheckitemManager;
    @Resource
    private CommonController commonController;
    @Resource
    private NewhousingjbxxManager newhousingjbxxManager;
    @Resource
    private AttachmentController attachmentController;
    @Resource
    private ImagesManager imagesManager;
    @Resource
    private PmpWfRecordManager pmpWfRecordManager;
    @Resource
    private ChecktemplateManager checktemplateMag;
    @Resource
    private PmpWfRecordController pmpWfRecordController;
    @Resource
    private AttachmentManager attachmentManager;

    @RequestMapping(method={RequestMethod.GET})
    public ResponseData list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("addUserCodes", (Object)"T");
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        return this.getList(searchColumn, pageDesc);
    }

    public ResponseData getList(Map<String, Object> searchColumn, PageDesc pageDesc) {
        JSONArray jsonArr = this.projectcheckMag.listObjectsAsJson(searchColumn, pageDesc);
        if (jsonArr != null && jsonArr.size() > 0) {
            for (int i = 0; i < jsonArr.size(); ++i) {
                JSONObject jsonObject = jsonArr.getJSONObject(i);
                String[] diss = new String[]{jsonObject.getString("city"), jsonObject.getString("county")};
                String[] names = this.commonController.getUnitNames(diss);
                jsonObject.put("city", (Object)names[0]);
                jsonObject.put("county", (Object)names[1]);
            }
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)jsonArr);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @RequestMapping(value={"/{pid}"}, method={RequestMethod.GET})
    public void getProjectcheck(@PathVariable String pid, HttpServletResponse response) {
        Projectcheck projectcheck = (Projectcheck)this.projectcheckMag.getObjectById((Serializable)((Object)pid));
        JsonResultUtils.writeSingleDataJson((Object)projectcheck, (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    public void createProjectcheck(@Valid Projectcheck projectcheck, HttpServletResponse response, HttpServletRequest request) {
        CentitUserDetails loginUser = WebOptUtils.getCurrentUserDetails((HttpServletRequest)request);
        Date date = new Date();
        String pid = projectcheck.getPid();
        if ("".equals(pid)) {
            projectcheck.setPid(null);
        }
        String type = request.getParameter("type");
        String commitStatus = request.getParameter("commitStatus");
        String ideaCode = "";
        if ("01".equals(commitStatus) || "03".equals(commitStatus) || "05".equals(commitStatus)) {
            ideaCode = "01";
        } else if ("02".equals(commitStatus) || "04".equals(commitStatus)) {
            ideaCode = "04";
        }
        projectcheck.setStatus(commitStatus);
        if ("new".equals(type)) {
            projectcheck.setUserCode(loginUser.getUserCode());
            projectcheck.setUserName(loginUser.getUserInfo().getString("userName"));
            projectcheck.setUnitCode(loginUser.getCurrentUnitCode());
            projectcheck.setCreatetime(date);
            projectcheck.setUpdatetime(date);
        } else {
            Projectcheck dbProjectcheck = (Projectcheck)this.projectcheckMag.getObjectById((Serializable)((Object)pid));
            if (!dbProjectcheck.getStatus().equals(commitStatus)) {
                this.pmpWfRecordController.savepmpWfRecord(commitStatus, ideaCode, pid, loginUser.getUserInfo().getString("userName"), loginUser.getCurrentUnitCode(), Integer.valueOf(5));
            }
            dbProjectcheck.copyNotNullProperty(projectcheck);
            projectcheck = dbProjectcheck;
            projectcheck.setUpdatetime(date);
        }
        this.projectcheckMag.mergeObject((Serializable)projectcheck);
        if ("01".equals(commitStatus) && "new".equals(type)) {
            this.pmpWfRecordController.savepmpWfRecord(commitStatus, ideaCode, projectcheck.getPid(), loginUser.getUserInfo().getString("userName"), loginUser.getCurrentUnitCode(), Integer.valueOf(5));
        }
        JsonResultUtils.writeSingleDataJson((Object)projectcheck, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{pid}"}, method={RequestMethod.DELETE})
    public ResponseData deleteProjectcheck(@PathVariable String pid, HttpServletResponse response) {
        boolean isOk = true;
        String msg = "";
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("pid", pid);
            List projectcheckitems = this.projectcheckitemManager.listObjects(map);
            if (projectcheckitems != null && projectcheckitems.size() > 0) {
                for (Projectcheckitem hs : projectcheckitems) {
                    map.clear();
                    map.put("emodule", 5L);
                    map.put("eid", hs.getPiid());
                    List fjs = this.imagesManager.listObjects(map);
                    if (fjs != null && fjs.size() > 0) {
                        for (Images fj : fjs) {
                            this.imagesManager.deleteObject((Serializable)fj);
                        }
                    }
                    this.projectcheckitemManager.deleteObject((Serializable)hs);
                }
            }
            this.pmpWfRecordManager.deleteByWid(pid);
            map.clear();
            map.put("eid", pid);
            List attachments = this.attachmentManager.listObjects(map);
            if (attachments != null && attachments.size() > 0) {
                for (Attachment at : attachments) {
                    this.attachmentManager.deleteObject((Serializable)at);
                }
            }
            this.projectcheckMag.deleteObjectById((Serializable)((Object)pid));
        }
        catch (Exception e) {
            isOk = false;
            msg = e.getMessage();
        }
        JSONObject obj = new JSONObject();
        obj.put("isOk", (Object)isOk);
        obj.put("msg", (Object)msg);
        return ResponseData.makeResponseData((Map)obj);
    }

    @RequestMapping(value={"/{pid}"}, method={RequestMethod.PUT})
    public void updateProjectcheck(@PathVariable String pid, @Valid Projectcheck projectcheck, HttpServletResponse response) {
        Projectcheck dbProjectcheck = (Projectcheck)this.projectcheckMag.getObjectById((Serializable)((Object)pid));
        if (null == projectcheck) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        dbProjectcheck.copy(projectcheck);
        this.projectcheckMag.mergeObject((Serializable)dbProjectcheck);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/wx/projectcheckList"}, method={RequestMethod.GET})
    public ResponseData list(HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("addUserCodes", (Object)"T");
        Map map = this.commonController.selfCollectRequestParametersWx(request);
        Map searchColumn = (Map)map.get("searchColumn");
        PageDesc pageDesc = (PageDesc)map.get("pageDesc");
        return this.getList(searchColumn, pageDesc);
    }

    @RequestMapping(value={"/wx/loadProjectcheck/{pid}"}, method={RequestMethod.GET})
    public JSONObject loadProjectcheck(@PathVariable String pid, HttpServletRequest request, HttpServletResponse response) {
        Projectcheck projectcheck = (Projectcheck)this.projectcheckMag.getObjectById((Serializable)((Object)pid));
        JSONObject obj = new JSONObject();
        if (projectcheck != null) {
            JSONObject zb = (JSONObject)JSONObject.toJSON((Object)projectcheck);
            String[] diss = new String[]{zb.getString("city"), zb.getString("county")};
            String[] names = this.commonController.getUnitNames(diss);
            zb.put("cityName", (Object)names[0]);
            zb.put("countyName", (Object)names[1]);
            obj.put("projectCheck", (Object)zb);
            String isItem = request.getParameter("isItem");
            String isView = request.getParameter("isView");
            if ("T".equals(isItem)) {
                HashMap<String, String> searchColumn = new HashMap<String, String>();
                searchColumn.put("sort", "sorts");
                searchColumn.put("order", "asc");
                List checktemplates = this.checktemplateMag.listObjects(searchColumn);
                List pks = this.projectcheckitemManager.listObjectsByProperty("pid", (Object)pid);
                if (checktemplates != null && checktemplates.size() > 0) {
                    JSONArray arr = new JSONArray();
                    for (Checktemplate cp : checktemplates) {
                        JSONObject cpo = (JSONObject)JSONObject.toJSON((Object)cp);
                        boolean getScore = false;
                        if (pks != null && pks.size() > 0) {
                            for (Projectcheckitem pk : pks) {
                                if (!cp.getCid().equals(pk.getCid())) continue;
                                cpo.put("piid", (Object)pk.getPiid());
                                cpo.put("pid", (Object)pk.getPid());
                                cpo.put("cid", (Object)pk.getCid());
                                cpo.put("xscore", (Object)pk.getXscore());
                                cpo.put("sscore", (Object)pk.getSscore());
                                cpo.put("pscore", (Object)pk.getPscore());
                                cpo.put("remarks", (Object)pk.getRemarks());
                                getScore = true;
                                break;
                            }
                        }
                        if ("T".equals(isView)) {
                            if (!getScore) continue;
                            arr.add((Object)cpo);
                            continue;
                        }
                        arr.add((Object)cpo);
                    }
                    obj.put("projectCheckItemList", (Object)arr);
                }
            }
        }
        return obj;
    }

    @RequestMapping(value={"/wx/LoadProjectcheckitem"}, method={RequestMethod.GET})
    public JSONObject LoadProjectcheckitem(HttpServletRequest request, HttpServletResponse response) {
        String pid = request.getParameter("pid");
        String cid = request.getParameter("cid");
        String piid = request.getParameter("piid");
        JSONObject cpo = null;
        Projectcheckitem pk = null;
        Checktemplate cp = null;
        if (StringUtils.isNotBlank((String)piid)) {
            pk = (Projectcheckitem)this.projectcheckitemManager.getObjectById((Serializable)((Object)piid));
            cp = (Checktemplate)this.checktemplateMag.getObjectById((Serializable)((Object)pk.getCid()));
        } else if (StringUtils.isNotBlank((String)pid) && StringUtils.isNotBlank((String)cid)) {
            cp = (Checktemplate)this.checktemplateMag.getObjectById((Serializable)((Object)cid));
            HashMap<String, String> searchColumn = new HashMap<String, String>();
            searchColumn.put("pid", pid);
            searchColumn.put("cid", cid);
            List pks = this.projectcheckitemManager.listObjects(searchColumn);
            if (pks != null && pks.size() > 0) {
                pk = (Projectcheckitem)pks.get(0);
            } else {
                pk = new Projectcheckitem();
                pk.setPiid(UUID.randomUUID().toString().replaceAll("-", ""));
            }
        }
        if (cp != null) {
            cpo = (JSONObject)JSONObject.toJSON(cp);
            if (pk != null) {
                cpo.put("piid", (Object)pk.getPiid());
                cpo.put("pid", (Object)pk.getPid());
                cpo.put("cid", (Object)pk.getCid());
                cpo.put("xscore", (Object)pk.getXscore());
                cpo.put("sscore", (Object)pk.getSscore());
                cpo.put("pscore", (Object)pk.getPscore());
                cpo.put("remarks", (Object)pk.getRemarks());
            }
        }
        return cpo;
    }

    @RequestMapping(value={"/wx/saveProjectcheck"}, method={RequestMethod.POST})
    public JSONObject saveProjectcheck(@RequestBody Projectcheck projectcheck, HttpServletRequest request, HttpServletResponse response) {
        JSONObject rlt = new JSONObject();
        Map map = this.commonController.getUserInfosByUserCode(request);
        JSONObject user = (JSONObject)map.get("userInfo");
        JSONObject unit = (JSONObject)map.get("unitInfo");
        JSONObject userRoleInfo = (JSONObject)map.get("userRoleInfo");
        String commitStatus = request.getParameter("commitStatus");
        String ideaCode = "";
        if ("01".equals(commitStatus) || "03".equals(commitStatus) || "05".equals(commitStatus)) {
            ideaCode = "01";
        } else if ("02".equals(commitStatus) || "04".equals(commitStatus)) {
            ideaCode = "04";
        }
        if (StringUtils.isNotBlank((String)commitStatus)) {
            projectcheck.setStatus(commitStatus);
        }
        String pid = projectcheck.getPid();
        Projectcheck dbp = null;
        if (StringUtils.isNotBlank((String)pid)) {
            dbp = (Projectcheck)this.projectcheckMag.getObjectById((Serializable)((Object)pid));
        }
        if (StringUtils.isNotBlank((String)pid) && dbp != null) {
            if (StringUtils.isNotBlank((String)commitStatus) && !dbp.getStatus().equals(commitStatus)) {
                this.pmpWfRecordController.savepmpWfRecord(commitStatus, ideaCode, pid, user.getString("userName"), unit.getString("unitCode"), Integer.valueOf(5));
            }
            dbp.copyNotNullProperty(projectcheck);
            this.projectcheckMag.mergeObject((Serializable)dbp);
            projectcheck = dbp;
        } else {
            HashMap<String, String> fMap = new HashMap<String, String>();
            fMap.put("hid", projectcheck.getHid());
            List projectchecks = this.projectcheckMag.listObjects(fMap);
            if (projectchecks != null && projectchecks.size() > 0) {
                rlt.put("isOk", (Object)false);
                rlt.put("msg", (Object)(projectcheck.getHouseName() + "\u9879\u76ee\u5df2\u9a8c\u6536\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01"));
                return rlt;
            }
            projectcheck.setUserCode(user.getString("userCode"));
            projectcheck.setUserName(user.getString("userName"));
            projectcheck.setUnitCode(unit.getString("unitCode"));
            projectcheck.setCreatetime(new Date());
            projectcheck.setUpdatetime(new Date());
            projectcheck.setStatus("00");
            this.projectcheckMag.mergeObject((Serializable)projectcheck);
        }
        rlt.put("isOk", (Object)true);
        rlt.put("obj", (Object)this.updateProjectScoreBypid(projectcheck.getPid()));
        return rlt;
    }

    @RequestMapping(value={"/wx/saveProjectcheckitem"}, method={RequestMethod.POST})
    public JSONObject saveProjectcheckitem(@RequestBody Projectcheckitem projectcheckitem, HttpServletRequest request, HttpServletResponse response) {
        String pid = projectcheckitem.getPid();
        String cid = projectcheckitem.getCid();
        String piid = projectcheckitem.getPiid();
        JSONObject rlt = new JSONObject();
        Projectcheckitem pk = null;
        if (StringUtils.isNotBlank((String)pid) && StringUtils.isNotBlank((String)cid)) {
            HashMap<String, String> searchColumn = new HashMap<String, String>();
            searchColumn.put("pid", pid);
            searchColumn.put("cid", cid);
            List pks = this.projectcheckitemManager.listObjects(searchColumn);
            if (pks != null && pks.size() > 0) {
                pk = (Projectcheckitem)pks.get(0);
            }
            if (pk != null && StringUtils.isNotBlank((String)piid) && !piid.equals(pk.getPiid())) {
                rlt.put("isOk", (Object)false);
            } else {
                if (pk == null) {
                    this.projectcheckitemManager.mergeObject((Serializable)projectcheckitem);
                    rlt.put("isOk", (Object)true);
                    rlt.put("msg", (Object)"\u6570\u636e\u65b0\u589e\u4fdd\u5b58\u6210\u529f\uff01");
                } else {
                    pk.copyNotNullProperty(projectcheckitem);
                    this.projectcheckitemManager.mergeObject((Serializable)pk);
                    rlt.put("isOk", (Object)true);
                    rlt.put("msg", (Object)"\u6570\u636e\u4fee\u6539\u4fdd\u5b58\u6210\u529f\uff01");
                }
                this.updateProjectScoreBypid(pid);
            }
        } else {
            rlt.put("isOk", (Object)false);
            rlt.put("msg", (Object)"\u4fdd\u5b58\u5931\u8d25\uff01\u4e3b\u8868\u4e3b\u952e\u548c\u6a21\u677f\u8868\u4e3b\u952e\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        return rlt;
    }

    public Projectcheck updateProjectScoreBypid(String pid) {
        List pks = this.projectcheckitemManager.listObjectsByProperty("pid", (Object)pid);
        Projectcheck projectcheck = (Projectcheck)this.projectcheckMag.getObjectById((Serializable)((Object)pid));
        if (pks != null && pks.size() > 0) {
            BigDecimal xt = null;
            BigDecimal st = null;
            BigDecimal pt = null;
            for (Projectcheckitem item : pks) {
                Double x = item.getXscore();
                Double s = item.getSscore();
                Double p = item.getPscore();
                if (x != null && x >= 0.0) {
                    xt = xt == null ? BigDecimal.valueOf(x) : xt.add(BigDecimal.valueOf(x));
                }
                if (s != null && s >= 0.0) {
                    st = st == null ? BigDecimal.valueOf(s) : st.add(BigDecimal.valueOf(s));
                }
                if (p == null || !(p >= 0.0)) continue;
                if (pt == null) {
                    pt = BigDecimal.valueOf(p);
                    continue;
                }
                pt = pt.add(BigDecimal.valueOf(p));
            }
            if (xt != null) {
                projectcheck.setXtotalscore(Double.valueOf(xt.doubleValue()));
            }
            if (st != null) {
                projectcheck.setStotalscore(Double.valueOf(st.doubleValue()));
            }
            if (pt != null) {
                projectcheck.setPtotalscore(Double.valueOf(pt.doubleValue()));
            }
            this.projectcheckMag.mergeObject((Serializable)projectcheck);
        }
        return projectcheck;
    }

    @RequestMapping(value={"/getSHProjectcheck"}, method={RequestMethod.GET})
    public String getSHProjectcheck(HttpServletRequest request, HttpServletResponse response) {
        String res = "";
        String secret = request.getParameter("secret");
        String parentUnitCode = request.getParameter("parentUnitCode");
        String fyear = request.getParameter("fyear");
        String newhousestatus = request.getParameter("newhousestatus");
        Boolean b = DataExchangeSaveController.securityData((String)secret, (String)parentUnitCode);
        if (b.booleanValue()) {
            HashMap<String, Object> searchColumn = new HashMap<String, Object>();
            String[] codes = this.commonController.loadsubUnitsByParentUnitCode(parentUnitCode);
            searchColumn.put("unitCodes", codes);
            searchColumn.put("status", newhousestatus);
            JSONArray arr = this.projectcheckMag.listObjectsAsJson(searchColumn, null);
            res = StaticVariable.encryptAndBase64String((String)arr.toJSONString());
        }
        return res;
    }
}

