/*
 * Decompiled with CFR 0.152.
 */
package com.nfgl.check.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.core.controller.BaseController;
import com.centit.support.database.utils.PageDesc;
import com.nfgl.check.po.Checktemplate;
import com.nfgl.check.po.Projectcheckitem;
import com.nfgl.check.service.ChecktemplateManager;
import com.nfgl.check.service.ProjectcheckitemManager;
import com.nfgl.common.controller.CommonController;
import com.nfgl.utils.service.AttachmentManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/check/checktemplate"})
public class ChecktemplateController
extends BaseController {
    private static final Log log = LogFactory.getLog(ChecktemplateController.class);
    private static final long serialVersionUID = 1L;
    @Resource
    private ChecktemplateManager checktemplateMag;
    @Resource
    private CommonController commonController;
    @Resource
    private ProjectcheckitemManager projectcheckitemMag;
    @Resource
    private AttachmentManager attachmentManager;

    @RequestMapping(method={RequestMethod.GET})
    public ResponseData list(String[] field, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map searchColumn = this.commonController.selfCollectRequestParameters(request);
        String isPage = request.getParameter("isPage");
        String pid = request.getParameter("pid");
        if ("f".equals(isPage)) {
            pageDesc = null;
            searchColumn.put("isvalid", "1");
        }
        JSONArray jarr = this.checktemplateMag.listObjectsAsJson(searchColumn, pageDesc);
        if (StringUtils.isNotBlank((CharSequence)pid)) {
            for (int i = 0; i < jarr.size(); ++i) {
                JSONObject jsonObject = jarr.getJSONObject(i);
                String cid = jsonObject.getString("cid");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("pid", pid);
                map.put("cid", cid);
                List projectcheckitems = this.projectcheckitemMag.listObjects(map);
                if (projectcheckitems == null || projectcheckitems.size() <= 0) continue;
                Projectcheckitem projectcheckitem = (Projectcheckitem)projectcheckitems.get(0);
                jsonObject.put("xscore", projectcheckitem.getXscore() != null ? projectcheckitem.getXscore() : "");
                jsonObject.put("sscore", projectcheckitem.getSscore() != null ? projectcheckitem.getSscore() : "");
                jsonObject.put("pscore", projectcheckitem.getPscore() != null ? projectcheckitem.getPscore() : "");
                jsonObject.put("piid", (Object)projectcheckitem.getPiid());
            }
        }
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("objList", (Object)jarr);
        resData.addResponseData("pageDesc", (Object)pageDesc);
        return resData;
    }

    @RequestMapping(value={"/{cid}"}, method={RequestMethod.GET})
    public void getChecktemplate(@PathVariable String cid, HttpServletResponse response) {
        Checktemplate checktemplate = (Checktemplate)this.checktemplateMag.getObjectById((Serializable)((Object)cid));
        JsonResultUtils.writeSingleDataJson((Object)checktemplate, (HttpServletResponse)response);
    }

    @RequestMapping(method={RequestMethod.POST})
    public void createChecktemplate(@Valid Checktemplate checktemplate, HttpServletResponse response) {
        String cid = checktemplate.getCid();
        if (StringUtils.isBlank((CharSequence)cid)) {
            checktemplate.setCid(null);
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("ctype", checktemplate.getCtype());
            List checktemplates = this.checktemplateMag.listObjects(map);
            checktemplate.setSorts(Double.valueOf((double)checktemplates.size() + 1.0));
        }
        this.checktemplateMag.mergeObject((Serializable)checktemplate);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{cid}"}, method={RequestMethod.DELETE})
    public void deleteChecktemplate(@PathVariable String cid, HttpServletResponse response) {
        this.checktemplateMag.deleteObjectById((Serializable)((Object)cid));
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }

    @RequestMapping(value={"/{cid}"}, method={RequestMethod.PUT})
    public void updateChecktemplate(@PathVariable String cid, @Valid Checktemplate checktemplate, HttpServletResponse response) {
        Checktemplate dbChecktemplate = (Checktemplate)this.checktemplateMag.getObjectById((Serializable)((Object)cid));
        if (null == checktemplate) {
            JsonResultUtils.writeErrorMessageJson((String)"\u5f53\u524d\u5bf9\u8c61\u4e0d\u5b58\u5728", (HttpServletResponse)response);
            return;
        }
        dbChecktemplate.copy(checktemplate);
        this.checktemplateMag.mergeObject((Serializable)dbChecktemplate);
        JsonResultUtils.writeBlankJson((HttpServletResponse)response);
    }
}

