/*
 * Decompiled with CFR 0.152.
 */
package com.centit.nfgl.config;

import com.centit.framework.config.SystemSpringMvcConfig;
import com.centit.framework.config.WebConfig;
import com.centit.nfgl.config.NormalSpringMvcConfig;
import com.centit.nfgl.config.ServiceConfig;
import com.centit.nfgl.config.WebInitializer;
import java.util.EventListener;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class WebInitializer
implements WebApplicationInitializer {
    public void onStartup(ServletContext servletContext) throws ServletException {
        this.initializeSpringConfig(servletContext);
        this.initializeSystemSpringMvcConfig(servletContext);
        this.initializeNormalSpringMvcConfig(servletContext);
        WebConfig.registerRequestContextListener((ServletContext)servletContext);
        WebConfig.registerSingleSignOutHttpSessionListener((ServletContext)servletContext);
        String[] servletUrlPatterns = new String[]{"/system/*", "/service/*"};
        WebConfig.registerCharacterEncodingFilter((ServletContext)servletContext, (String[])servletUrlPatterns);
        WebConfig.registerHttpPutFormContentFilter((ServletContext)servletContext, (String[])servletUrlPatterns);
        WebConfig.registerHiddenHttpMethodFilter((ServletContext)servletContext, (String[])servletUrlPatterns);
        WebConfig.registerRequestThreadLocalFilter((ServletContext)servletContext);
        WebConfig.registerSpringSecurityFilter((ServletContext)servletContext, (String[])servletUrlPatterns);
        WebConfig.initializeH2Console((ServletContext)servletContext);
    }

    private void initializeSpringConfig(ServletContext servletContext) {
        AnnotationConfigWebApplicationContext springContext = new AnnotationConfigWebApplicationContext();
        springContext.register(new Class[]{ServiceConfig.class});
        servletContext.addListener((EventListener)new ContextLoaderListener((WebApplicationContext)springContext));
    }

    private void initializeSystemSpringMvcConfig(ServletContext servletContext) {
        AnnotationConfigWebApplicationContext context = new AnnotationConfigWebApplicationContext();
        context.register(new Class[]{SystemSpringMvcConfig.class, SwaggerConfig.class});
        ServletRegistration.Dynamic system = servletContext.addServlet("system", (Servlet)new DispatcherServlet((WebApplicationContext)context));
        system.addMapping(new String[]{"/system/*"});
        system.setLoadOnStartup(1);
        system.setAsyncSupported(true);
    }

    private void initializeNormalSpringMvcConfig(ServletContext servletContext) {
        AnnotationConfigWebApplicationContext context = new AnnotationConfigWebApplicationContext();
        context.register(new Class[]{NormalSpringMvcConfig.class, SwaggerConfig.class});
        ServletRegistration.Dynamic system = servletContext.addServlet("service", (Servlet)new DispatcherServlet((WebApplicationContext)context));
        system.addMapping(new String[]{"/service/*"});
        system.setLoadOnStartup(1);
        system.setAsyncSupported(true);
    }
}

