/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.framework.system.dao.OptLogDao;
import com.centit.framework.system.po.OptLog;
import com.centit.framework.system.service.OptLogManager;
import com.centit.support.database.utils.PageDesc;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="optLogManager")
public class OptLogManagerImpl
implements OptLogManager {
    public static final Logger logger = LoggerFactory.getLogger(OptLogManager.class);
    private OptLogDao optLogDao;

    @Autowired
    @NotNull
    public void setOptLogDao(OptLogDao optLogDao) {
        this.optLogDao = optLogDao;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void saveOptLog(OptLog optLog) {
        this.optLogDao.saveNewObject((Serializable)optLog);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void saveBatchOptLogs(List<OptLog> optLogs) {
        if (CollectionUtils.isEmpty(optLogs)) {
            return;
        }
        for (OptLog optLog : optLogs) {
            this.optLogDao.saveNewObject((Serializable)optLog);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void delete(Date begin, Date end) {
        this.optLogDao.delete(begin, end);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteMany(Long[] logIds) {
        for (Long logId : logIds) {
            this.optLogDao.deleteObjectById(logId);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public JSONArray listOptLogsAsJson(String[] fields, Map<String, Object> filterMap, PageDesc pageDesc) {
        return DictionaryMapUtils.mapJsonArray((JSONArray)this.optLogDao.listObjectsPartFieldAsJson(filterMap, fields, pageDesc), (Class[])new Class[]{OptLog.class});
    }

    @Transactional
    public OptLog getOptLogById(Long logId) {
        return this.optLogDao.getObjectById(logId);
    }

    @Transactional
    public void deleteOptLogById(Long logId) {
        this.optLogDao.deleteObjectById(logId);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void save(OperationLog optLog) {
        OptLog optlog = OptLog.valueOf((OperationLog)optLog);
        this.optLogDao.saveNewObject((Serializable)optlog);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void save(List<OperationLog> optLogs) {
        for (OperationLog optlog : optLogs) {
            this.optLogDao.saveNewObject((Serializable)OptLog.valueOf((OperationLog)optlog));
        }
    }

    public List<? extends OperationLog> listOptLog(String optId, Map<String, Object> filterMap, int startPos, int maxRows) {
        List optlogs;
        filterMap.put("optId", optId);
        List list = optlogs = startPos >= 0 && maxRows > 0 ? this.optLogDao.listObjects(filterMap, new PageDesc(startPos, maxRows)) : this.optLogDao.listObjects(filterMap);
        if (optlogs == null || optlogs.size() == 0) {
            return null;
        }
        return optlogs.stream().map(OptLog::toOperationLog).collect(Collectors.toList());
    }

    public int countOptLog(String optId, Map<String, Object> filterMap) {
        filterMap.put("optId", optId);
        return this.optLogDao.countObject(filterMap);
    }
}

