/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.po;

import com.centit.framework.core.dao.DictionaryMap;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="\u7cfb\u7edf\u64cd\u4f5c\u65e5\u5fd7\u5bf9\u8c61", description="\u7cfb\u7edf\u64cd\u4f5c\u65e5\u5fd7\u5bf9\u8c61 OptLog")
@Table(name="F_OPT_LOG")
public class OptLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="LOG_ID")
    @ValueGenerator(strategy=GeneratorType.UUID22)
    private String logId;
    @Column(name="LOG_LEVEL")
    @NotNull(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=2, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @ApiModelProperty(value="\u65e5\u5fd7\u7ea7\u522b \u4f7f\u7528\u5e38\u91cfLEVEL_INFO\u548cLEVEL_ERROR\u8868\u793a \u9ed8\u8ba4\u7ea7\u522b\u4e3aLEVEL_INFO", name="logLevel")
    @ValueGenerator(strategy=GeneratorType.CONSTANT, occasion=GeneratorTime.NEW, value="0")
    private @NotNull(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") @Length(max=2, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String logLevel;
    @Column(name="USER_CODE")
    @NotNull(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @DictionaryMap(fieldName={"userName"}, value={"userCode"})
    @ApiModelProperty(value="\u7528\u6237\u4ee3\u7801", name="userCode", required=true)
    private @NotNull(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String userCode;
    @OrderBy(value="desc")
    @Column(name="OPT_TIME")
    @NotNull(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    @Temporal(value=TemporalType.TIMESTAMP)
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="today()")
    private @NotNull(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") Date optTime;
    @Column(name="OPT_ID")
    @ValueGenerator(strategy=GeneratorType.CONSTANT, occasion=GeneratorTime.NEW, value="system")
    @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @DictionaryMap(fieldName={"optName"}, value={"optId"})
    private @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String optId;
    @Column(name="OPT_TAG")
    @Length(max=200, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=200, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String optTag;
    @Column(name="OPT_METHOD")
    @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String optMethod;
    @Column(name="OPT_CONTENT")
    @NotNull(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a") String optContent;
    @Column(name="NEW_VALUE")
    private String newValue;
    @Column(name="OLD_VALUE")
    private String oldValue;
    @Column(name="UNIT_CODE")
    private String unitCode;
    @Column(name="CORRELATION_ID")
    private String correlationId;

    public static OptLog valueOf(OperationLog other) {
        OptLog log = new OptLog();
        log.logLevel = other.getLogLevel();
        log.userCode = other.getUserCode();
        log.optTime = other.getOptTime();
        log.optId = other.getOptId();
        log.optTag = other.getOptTag();
        if (log.optTag != null && log.optTag.length() > 200) {
            log.optTag = log.optTag.substring(0, 200);
        }
        log.optMethod = other.getOptMethod();
        log.optContent = other.getOptContent();
        log.newValue = other.getNewValue();
        log.oldValue = other.getOldValue();
        log.unitCode = other.getUnitCode();
        log.correlationId = other.getCorrelationId();
        return log;
    }

    public OperationLog toOperationLog() {
        OperationLog log = new OperationLog();
        log.setLogLevel(this.logLevel);
        log.setUserCode(this.userCode);
        log.setOptTime(this.optTime);
        log.setOptId(this.optId);
        log.setOptTag(this.optTag);
        log.setOptMethod(this.optMethod);
        log.setOptContent(this.optContent);
        log.setNewValue(this.newValue);
        log.setOldValue(this.oldValue);
        log.setUnitCode(this.unitCode);
        log.setCorrelationId(this.correlationId);
        return log;
    }
}

