/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.system.po.OptLog;
import com.centit.support.database.utils.PersistenceException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="optLogDao")
public class OptLogDao
extends BaseDaoImpl<OptLog, Long> {
    public static final Logger logger = LoggerFactory.getLogger(OptLogDao.class);

    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("logId", "EQUAL");
        filterField.put("logLevel", "LIKE");
        filterField.put("userCode", "EQUAL");
        filterField.put("(date)optTimeBegin", "optTime >= :optTimeBegin ");
        filterField.put("(nextday)optTimeEnd", "optTime < :optTimeEnd");
        filterField.put("optId", "LIKE");
        filterField.put("optCode", "LIKE");
        filterField.put("optContent", "LIKE");
        filterField.put("oldValue", "LIKE");
        filterField.put("optMethod", "EQUAL");
        filterField.put("optTag", "EQUAL");
        filterField.put("userCode", "EQUAL");
        return filterField;
    }

    public OptLog getObjectById(Long logId) {
        return (OptLog)super.getObjectById((Object)logId);
    }

    @Transactional
    public void deleteObjectById(Long logId) {
        super.deleteObjectById((Object)logId);
    }

    @Transactional
    public void delete(Date begin, Date end) {
        String hql = "delete from F_OPT_LOG o where 1=1 ";
        ArrayList<Date> objects = new ArrayList<Date>();
        if (null != begin) {
            hql = hql + "and o.optTime > ?";
            objects.add(begin);
        }
        if (null != end) {
            hql = hql + "and o.optTime < ?";
            objects.add(end);
        }
        try {
            DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)hql, (Object[])objects.toArray(new Object[objects.size()]));
        }
        catch (DataAccessException e) {
            throw new PersistenceException((Throwable)e);
        }
    }
}

