/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.oa.po;

import com.centit.framework.core.dao.DictionaryMap;
import com.centit.framework.model.basedata.NoticeMessage;
import com.centit.product.oa.po.InnerMsgAnnex;
import com.centit.product.oa.po.InnerMsgRecipient;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="F_INNER_MSG")
@ApiModel(value="\u6d88\u606f\u5bf9\u8c61", description="\u6d88\u606f\u5bf9\u8c61InnerMsg")
public class InnerMsg
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="MSG_CODE")
    @ApiModelProperty(value="\u6d88\u606f\u7f16\u53f7", name="msgCode", required=true)
    @ValueGenerator(strategy=GeneratorType.UUID22)
    private String msgCode;
    @Column(name="REPLY_MSG_CODE")
    @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=32, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String replyMsgCode;
    @Column(name="SENDER")
    @Length(max=128, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    @DictionaryMap(fieldName={"senderName"}, value={"userCode"})
    @ApiModelProperty(value="\u53d1\u9001\u4eba", name="sender", required=true)
    private @Length(max=128, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String sender;
    @OrderBy(value="desc")
    @Column(name="SEND_DATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    @ValueGenerator(strategy=GeneratorType.FUNCTION, value="today()")
    private Date sendDate;
    @Column(name="MSG_TITLE")
    @Length(max=512, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=512, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String msgTitle;
    @Column(name="MSG_TYPE")
    @Length(max=16, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}")
    private @Length(max=16, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}") String msgType;
    @Column(name="MAIL_TYPE")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}")
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}") String mailType;
    @Column(name="RECEIVE_NAME")
    @Length(max=2048, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=2048, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String receiveName;
    @Column(name="MSG_STATE")
    @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}")
    private @Length(max=1, message="\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u4e3a{max}") String msgState;
    @Column(name="MSG_CONTENT")
    private String msgContent;
    @OneToMany(targetEntity=InnerMsgAnnex.class)
    @JoinColumn(name="MSG_CODE", referencedColumnName="MSG_CODE")
    private List<InnerMsgAnnex> innerMsgAnnexs;
    @Column(name="OPT_ID")
    @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String optId;
    @Column(name="OPT_METHOD")
    @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=64, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String optMethod;
    @Column(name="OPT_TAG")
    @Length(max=200, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}")
    private @Length(max=200, message="\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e{max}") String optTag;
    @OneToMany(targetEntity=InnerMsgRecipient.class)
    @JoinColumn(name="MSG_CODE", referencedColumnName="MSG_CODE")
    private List<InnerMsgRecipient> recipients;

    public static InnerMsg valueOf(NoticeMessage other) {
        InnerMsg innerMsg = new InnerMsg();
        innerMsg.msgContent = other.getMsgContent();
        innerMsg.msgTitle = other.getMsgSubject();
        innerMsg.msgType = other.getMsgType();
        innerMsg.optId = other.getOptId();
        innerMsg.optMethod = other.getOptMethod();
        innerMsg.optTag = other.getOptTag();
        return innerMsg;
    }

    public String getMsgCode() {
        return this.msgCode;
    }

    public String getReplyMsgCode() {
        return this.replyMsgCode;
    }

    public String getSender() {
        return this.sender;
    }

    public Date getSendDate() {
        return this.sendDate;
    }

    public String getMsgTitle() {
        return this.msgTitle;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getMailType() {
        return this.mailType;
    }

    public String getReceiveName() {
        return this.receiveName;
    }

    public String getMsgState() {
        return this.msgState;
    }

    public String getMsgContent() {
        return this.msgContent;
    }

    public List<InnerMsgAnnex> getInnerMsgAnnexs() {
        return this.innerMsgAnnexs;
    }

    public String getOptId() {
        return this.optId;
    }

    public String getOptMethod() {
        return this.optMethod;
    }

    public String getOptTag() {
        return this.optTag;
    }

    public List<InnerMsgRecipient> getRecipients() {
        return this.recipients;
    }

    public void setMsgCode(String msgCode) {
        this.msgCode = msgCode;
    }

    public void setReplyMsgCode(String replyMsgCode) {
        this.replyMsgCode = replyMsgCode;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public void setSendDate(Date sendDate) {
        this.sendDate = sendDate;
    }

    public void setMsgTitle(String msgTitle) {
        this.msgTitle = msgTitle;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public void setMailType(String mailType) {
        this.mailType = mailType;
    }

    public void setReceiveName(String receiveName) {
        this.receiveName = receiveName;
    }

    public void setMsgState(String msgState) {
        this.msgState = msgState;
    }

    public void setMsgContent(String msgContent) {
        this.msgContent = msgContent;
    }

    public void setInnerMsgAnnexs(List<InnerMsgAnnex> innerMsgAnnexs) {
        this.innerMsgAnnexs = innerMsgAnnexs;
    }

    public void setOptId(String optId) {
        this.optId = optId;
    }

    public void setOptMethod(String optMethod) {
        this.optMethod = optMethod;
    }

    public void setOptTag(String optTag) {
        this.optTag = optTag;
    }

    public void setRecipients(List<InnerMsgRecipient> recipients) {
        this.recipients = recipients;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InnerMsg)) {
            return false;
        }
        InnerMsg other = (InnerMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$msgCode = this.getMsgCode();
        String other$msgCode = other.getMsgCode();
        if (this$msgCode == null ? other$msgCode != null : !this$msgCode.equals(other$msgCode)) {
            return false;
        }
        String this$replyMsgCode = this.getReplyMsgCode();
        String other$replyMsgCode = other.getReplyMsgCode();
        if (this$replyMsgCode == null ? other$replyMsgCode != null : !this$replyMsgCode.equals(other$replyMsgCode)) {
            return false;
        }
        String this$sender = this.getSender();
        String other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        Date this$sendDate = this.getSendDate();
        Date other$sendDate = other.getSendDate();
        if (this$sendDate == null ? other$sendDate != null : !((Object)this$sendDate).equals(other$sendDate)) {
            return false;
        }
        String this$msgTitle = this.getMsgTitle();
        String other$msgTitle = other.getMsgTitle();
        if (this$msgTitle == null ? other$msgTitle != null : !this$msgTitle.equals(other$msgTitle)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$mailType = this.getMailType();
        String other$mailType = other.getMailType();
        if (this$mailType == null ? other$mailType != null : !this$mailType.equals(other$mailType)) {
            return false;
        }
        String this$receiveName = this.getReceiveName();
        String other$receiveName = other.getReceiveName();
        if (this$receiveName == null ? other$receiveName != null : !this$receiveName.equals(other$receiveName)) {
            return false;
        }
        String this$msgState = this.getMsgState();
        String other$msgState = other.getMsgState();
        if (this$msgState == null ? other$msgState != null : !this$msgState.equals(other$msgState)) {
            return false;
        }
        String this$msgContent = this.getMsgContent();
        String other$msgContent = other.getMsgContent();
        if (this$msgContent == null ? other$msgContent != null : !this$msgContent.equals(other$msgContent)) {
            return false;
        }
        List<InnerMsgAnnex> this$innerMsgAnnexs = this.getInnerMsgAnnexs();
        List<InnerMsgAnnex> other$innerMsgAnnexs = other.getInnerMsgAnnexs();
        if (this$innerMsgAnnexs == null ? other$innerMsgAnnexs != null : !((Object)this$innerMsgAnnexs).equals(other$innerMsgAnnexs)) {
            return false;
        }
        String this$optId = this.getOptId();
        String other$optId = other.getOptId();
        if (this$optId == null ? other$optId != null : !this$optId.equals(other$optId)) {
            return false;
        }
        String this$optMethod = this.getOptMethod();
        String other$optMethod = other.getOptMethod();
        if (this$optMethod == null ? other$optMethod != null : !this$optMethod.equals(other$optMethod)) {
            return false;
        }
        String this$optTag = this.getOptTag();
        String other$optTag = other.getOptTag();
        if (this$optTag == null ? other$optTag != null : !this$optTag.equals(other$optTag)) {
            return false;
        }
        List<InnerMsgRecipient> this$recipients = this.getRecipients();
        List<InnerMsgRecipient> other$recipients = other.getRecipients();
        return !(this$recipients == null ? other$recipients != null : !((Object)this$recipients).equals(other$recipients));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InnerMsg;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $msgCode = this.getMsgCode();
        result = result * 59 + ($msgCode == null ? 43 : $msgCode.hashCode());
        String $replyMsgCode = this.getReplyMsgCode();
        result = result * 59 + ($replyMsgCode == null ? 43 : $replyMsgCode.hashCode());
        String $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        Date $sendDate = this.getSendDate();
        result = result * 59 + ($sendDate == null ? 43 : ((Object)$sendDate).hashCode());
        String $msgTitle = this.getMsgTitle();
        result = result * 59 + ($msgTitle == null ? 43 : $msgTitle.hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $mailType = this.getMailType();
        result = result * 59 + ($mailType == null ? 43 : $mailType.hashCode());
        String $receiveName = this.getReceiveName();
        result = result * 59 + ($receiveName == null ? 43 : $receiveName.hashCode());
        String $msgState = this.getMsgState();
        result = result * 59 + ($msgState == null ? 43 : $msgState.hashCode());
        String $msgContent = this.getMsgContent();
        result = result * 59 + ($msgContent == null ? 43 : $msgContent.hashCode());
        List<InnerMsgAnnex> $innerMsgAnnexs = this.getInnerMsgAnnexs();
        result = result * 59 + ($innerMsgAnnexs == null ? 43 : ((Object)$innerMsgAnnexs).hashCode());
        String $optId = this.getOptId();
        result = result * 59 + ($optId == null ? 43 : $optId.hashCode());
        String $optMethod = this.getOptMethod();
        result = result * 59 + ($optMethod == null ? 43 : $optMethod.hashCode());
        String $optTag = this.getOptTag();
        result = result * 59 + ($optTag == null ? 43 : $optTag.hashCode());
        List<InnerMsgRecipient> $recipients = this.getRecipients();
        result = result * 59 + ($recipients == null ? 43 : ((Object)$recipients).hashCode());
        return result;
    }

    public String toString() {
        return "InnerMsg(msgCode=" + this.getMsgCode() + ", replyMsgCode=" + this.getReplyMsgCode() + ", sender=" + this.getSender() + ", sendDate=" + this.getSendDate() + ", msgTitle=" + this.getMsgTitle() + ", msgType=" + this.getMsgType() + ", mailType=" + this.getMailType() + ", receiveName=" + this.getReceiveName() + ", msgState=" + this.getMsgState() + ", msgContent=" + this.getMsgContent() + ", innerMsgAnnexs=" + this.getInnerMsgAnnexs() + ", optId=" + this.getOptId() + ", optMethod=" + this.getOptMethod() + ", optTag=" + this.getOptTag() + ", recipients=" + this.getRecipients() + ")";
    }
}

