/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.controller;

import com.alibaba.fastjson2.JSONObject;
import com.centit.fileserver.common.FileStore;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.po.FileStoreInfo;
import com.centit.fileserver.service.FileInfoManager;
import com.centit.fileserver.service.FileLibraryInfoManager;
import com.centit.fileserver.service.FileStoreInfoManager;
import com.centit.fileserver.task.AddThumbnailOpt;
import com.centit.fileserver.task.CreatePdfOpt;
import com.centit.fileserver.utils.FileIOUtils;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.ZipCompressor;
import com.centit.support.common.ObjectException;
import com.centit.support.file.FileIOOpt;
import com.centit.support.file.FileSystemOpt;
import com.centit.support.file.FileType;
import com.centit.support.image.ImageOpt;
import com.centit.support.office.Watermark4Pdf;
import com.centit.support.security.FileEncryptUtils;
import com.centit.support.security.Md5Encoder;
import com.centit.support.security.SecurityOptUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.detect.AutoDetectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/download"})
@Api(value="\u6587\u4ef6\u4e0b\u8f7d", tags={"\u6587\u4ef6\u4e0b\u8f7d"})
public class DownloadController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(DownloadController.class);
    @Autowired
    private FileInfoManager fileInfoManager;
    @Autowired
    private FileStoreInfoManager fileStoreInfoManager;
    @Autowired
    private FileLibraryInfoManager fileLibraryInfoManager;
    @Autowired
    protected FileStore fileStore;
    @Autowired
    protected CreatePdfOpt createPdfOpt;
    @Autowired
    protected AddThumbnailOpt addThumbnailOpt;

    @RequestMapping(value={"/downloadwithauth/{fileId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636e\u6743\u9650\u4e0b\u8f7d\u6587\u4ef6\uff0c\u53ef\u4ee5\u4f20\u5165authCode\u5206\u4eab\u7801")
    public void downloadWithAuthByFileId(@PathVariable(value="fileId") String fileId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        FileStoreInfo fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()));
        this.downloadFile(this.fileStore, fileInfo, fileStoreInfo, request, response);
        this.fileInfoManager.writeDownloadFileLog(fileInfo, request);
    }

    @RequestMapping(value={"/preview/{fileId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636e\u6743\u9650\u9884\u89c8\u6587\u4ef6\uff0c\u53ef\u4ee5\u4f20\u5165authCode\u5206\u4eab\u7801")
    public void previewFile(@PathVariable(value="fileId") String fileId, HttpServletRequest request, HttpServletResponse response) {
        block68: {
            response.setHeader("Cache-Control", "public, max-age=604800");
            if (fileId == null || fileId.trim().isEmpty()) {
                JsonResultUtils.writeErrorMessageJson((String)"\u65e0\u6548\u7684\u6587\u4ef6ID", (HttpServletResponse)response);
                return;
            }
            FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
            if (fileInfo == null) {
                JsonResultUtils.writeErrorMessageJson((String)"\u6587\u4ef6\u4e0d\u5b58\u5728", (HttpServletResponse)response);
                return;
            }
            String closeAuth = request.getParameter("closeAuth");
            if (this.noAuth(request, response, fileInfo, closeAuth)) {
                return;
            }
            boolean canView = false;
            try {
                Throwable throwable;
                InputStream is;
                FileStoreInfo fileStoreInfo;
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)fileInfo.getFileType(), (CharSequence[])new CharSequence[]{"txt", "csv", "pdf", "xml"}) && StringUtils.isBlank((CharSequence)fileInfo.getAttachedFileMd5())) {
                    Throwable throwable2;
                    InputStream is2;
                    fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()));
                    if (fileStoreInfo == null) {
                        JsonResultUtils.writeErrorMessageJson((String)"\u6587\u4ef6\u5b58\u50a8\u4fe1\u606f\u4e0d\u5b58\u5728", (HttpServletResponse)response);
                        return;
                    }
                    if (fileStoreInfo.getFileSize() == 0L) {
                        UploadDownloadUtils.downloadFile((InputStream)new ByteArrayInputStream(new byte[0]), (String)fileInfo.getFileName(), (HttpServletResponse)response);
                        return;
                    }
                    String charset = null;
                    if (StringUtils.equalsAnyIgnoreCase((CharSequence)fileInfo.getFileType(), (CharSequence[])new CharSequence[]{"txt", "csv"})) {
                        is2 = FileIOUtils.getFileStream(this.fileStore, fileStoreInfo);
                        throwable2 = null;
                        try {
                            if (is2 != null) {
                                charset = new AutoDetectReader(is2).getCharset().name();
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (is2 != null) {
                                if (throwable2 != null) {
                                    try {
                                        is2.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                } else {
                                    is2.close();
                                }
                            }
                        }
                    }
                    is2 = FileIOUtils.getFileStream(this.fileStore, fileStoreInfo);
                    throwable2 = null;
                    try {
                        UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)is2, (long)fileStoreInfo.getFileSize(), (String)fileInfo.getFileName(), (String)"inline", (String)charset);
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (is2 != null) {
                            if (throwable2 != null) {
                                try {
                                    is2.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable2.addSuppressed(throwable6);
                                }
                            } else {
                                is2.close();
                            }
                        }
                    }
                    canView = true;
                } else if (StringUtils.isNotBlank((CharSequence)fileInfo.getAttachedFileMd5())) {
                    FileStoreInfo attachedFileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getAttachedFileMd5()));
                    if (attachedFileStoreInfo != null && attachedFileStoreInfo.getFileSize() > 0L) {
                        is = FileIOUtils.getFileStream(this.fileStore, attachedFileStoreInfo);
                        throwable = null;
                        try {
                            String fileName = FileType.truncateFileExtName((String)fileInfo.getFileName()) + "." + fileInfo.getAttachedType();
                            UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)is, (long)attachedFileStoreInfo.getFileSize(), (String)fileName, (String)"inline", null);
                        }
                        catch (Throwable throwable7) {
                            throwable = throwable7;
                            throw throwable7;
                        }
                        finally {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable8) {
                                        throwable.addSuppressed(throwable8);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                        }
                        canView = true;
                    } else {
                        canView = FileIOUtils.reGetPdf(fileId, request, response, fileInfo, this.fileStore, this.createPdfOpt, this.fileInfoManager, this.fileStoreInfoManager);
                    }
                } else {
                    canView = FileIOUtils.reGetPdf(fileId, request, response, fileInfo, this.fileStore, this.createPdfOpt, this.fileInfoManager, this.fileStoreInfoManager);
                }
                if (canView) break block68;
                fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()));
                if (fileStoreInfo == null) {
                    JsonResultUtils.writeErrorMessageJson((String)"\u6587\u4ef6\u5b58\u50a8\u4fe1\u606f\u4e0d\u5b58\u5728", (HttpServletResponse)response);
                    return;
                }
                if (fileStoreInfo.getFileSize() == 0L) {
                    UploadDownloadUtils.downloadFile((InputStream)new ByteArrayInputStream(new byte[0]), (String)fileInfo.getFileName(), (HttpServletResponse)response);
                    return;
                }
                is = FileIOUtils.getFileStream(this.fileStore, fileStoreInfo);
                throwable = null;
                try {
                    UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)is, (long)fileStoreInfo.getFileSize(), (String)fileInfo.getFileName(), (String)"inline", null);
                }
                catch (Throwable throwable9) {
                    throwable = throwable9;
                    throw throwable9;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable10) {
                                throwable.addSuppressed(throwable10);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff0cfileId: {}", (Object)fileId, (Object)e);
                JsonResultUtils.writeErrorMessageJson((String)("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + e.getMessage()), (HttpServletResponse)response);
            }
        }
    }

    @RequestMapping(value={"/viewPdf"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6dfb\u52a0\u6c34\u5370\u5e76\u6d4f\u89c8")
    public void previewPdfWithWaterMark(@RequestBody String jsonStr, HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Cache-Control", "public, max-age=604800");
        JSONObject jsonObj = JSONObject.parseObject((String)jsonStr);
        String fileId = jsonObj.getString("fileId");
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        String closeAuth = request.getParameter("closeAuth");
        if (this.noAuth(request, response, fileInfo, closeAuth)) {
            return;
        }
        try {
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)fileInfo.getFileType(), (CharSequence[])new CharSequence[]{"pdf", "docx", "xlsx"})) {
                InputStream pdfFileStream = null;
                FileStoreInfo fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()));
                if (fileStoreInfo.getFileSize() == 0L) {
                    UploadDownloadUtils.downloadFile((InputStream)new ByteArrayInputStream(new byte[0]), (String)fileInfo.getFileName(), (HttpServletResponse)response);
                    return;
                }
                if ("pdf".equals(fileInfo.getFileType())) {
                    pdfFileStream = FileIOUtils.getFileStream(this.fileStore, fileStoreInfo);
                } else if (StringUtils.isNotBlank((CharSequence)fileInfo.getAttachedFileMd5())) {
                    FileStoreInfo attachedFileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getAttachedFileMd5()));
                    pdfFileStream = FileIOUtils.getFileStream(this.fileStore, attachedFileStoreInfo);
                } else {
                    pdfFileStream = FileIOUtils.createPdfStream(fileInfo, fileStoreInfo, this.fileStore, this.createPdfOpt, this.fileStoreInfoManager);
                }
                if (pdfFileStream != null) {
                    String waterMarkStr = StringBaseOpt.castObjectToString((Object)jsonObj.get("watermark"), (String)"");
                    float opacity = NumberBaseOpt.castObjectToFloat((Object)jsonObj.get("opacity"), (Float)Float.valueOf(0.4f)).floatValue();
                    float rotation = NumberBaseOpt.castObjectToFloat((Object)jsonObj.get("rotation"), (Float)Float.valueOf(45.0f)).floatValue();
                    float frontSize = NumberBaseOpt.castObjectToFloat((Object)jsonObj.get("frontSize"), (Float)Float.valueOf(60.0f)).floatValue();
                    boolean isRepeat = BooleanBaseOpt.castObjectToBoolean((Object)jsonObj.get("isRepeat"), (Boolean)false);
                    String fileName = FileType.truncateFileExtName((String)fileInfo.getFileName()) + ".pdf";
                    response.setContentType(FileType.getFileMimeType((String)fileName));
                    response.setHeader("Content-Disposition", "inline; filename=" + URLEncoder.encode(fileName, "UTF-8"));
                    Watermark4Pdf.addWatermark4Pdf((InputStream)pdfFileStream, (OutputStream)response.getOutputStream(), (String)waterMarkStr, (float)opacity, (float)rotation, (float)frontSize, (boolean)isRepeat);
                    pdfFileStream.close();
                    return;
                }
            }
            JsonResultUtils.writeErrorMessageJson((int)404, (String)this.getI18nMessage("error.404.file_cannot_be_converted_to_pdf", request, new Object[0]), (HttpServletResponse)response);
        }
        catch (Exception e) {
            JsonResultUtils.writeErrorMessageJson((String)e.getMessage(), (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/pattach/{fileId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636e\u6587\u4ef6\u7684id\u4e0b\u8f7d\u9644\u5c5e\u6587\u4ef6")
    public void downloadAttach(@PathVariable(value="fileId") String fileId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("Cache-Control", "public, max-age=604800");
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        if (null != fileInfo) {
            String at = fileInfo.getAttachedType();
            if (StringUtils.isBlank((CharSequence)at) || "N".equals(at)) {
                JsonResultUtils.writeHttpErrorMessage((int)404, (String)this.getI18nMessage("error.404.file_not_found", request, new Object[]{fileId + ": attached"}), (HttpServletResponse)response);
                return;
            }
            String fileName = FileType.truncateFileExtName((String)fileInfo.getFileName()) + "." + at;
            FileStoreInfo attachedFileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getAttachedFileMd5()));
            UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)this.fileStore.loadFileStream(attachedFileStoreInfo.getFileStorePath()), (long)this.fileStore.getFileSize(attachedFileStoreInfo.getFileStorePath()), (String)fileName, (String)request.getParameter("downloadType"), null);
        } else {
            JsonResultUtils.writeHttpErrorMessage((int)404, (String)this.getI18nMessage("error.404.file_not_found", request, new Object[]{fileId}), (HttpServletResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/thumbnail/{fileId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u7f29\u7565\u56fe")
    public void thumbnailFile(@PathVariable(value="fileId") String fileId, HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Cache-Control", "public, max-age=604800");
        if (fileId == null || fileId.isEmpty()) {
            JsonResultUtils.writeErrorMessageJson((String)"Invalid fileId", (HttpServletResponse)response);
            return;
        }
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        if (fileInfo == null) {
            JsonResultUtils.writeErrorMessageJson((String)"File not found", (HttpServletResponse)response);
            return;
        }
        String fileMd5 = fileInfo.getFileMd5();
        if (fileMd5 == null || fileMd5.isEmpty()) {
            JsonResultUtils.writeErrorMessageJson((String)"Invalid file MD5", (HttpServletResponse)response);
            return;
        }
        FileStoreInfo fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileMd5));
        if (fileStoreInfo == null) {
            JsonResultUtils.writeErrorMessageJson((String)"File store info not found", (HttpServletResponse)response);
            return;
        }
        try {
            if (fileStoreInfo.getFileSize() == 0L) {
                UploadDownloadUtils.downloadFile((InputStream)new ByteArrayInputStream(new byte[0]), (String)fileInfo.getFileName(), (HttpServletResponse)response);
                return;
            }
            int height = this.sanitizeParameter(request.getParameter("height"), 240, 1, 2048);
            int width = this.sanitizeParameter(request.getParameter("width"), 320, 1, 2048);
            int quality = this.sanitizeParameter(request.getParameter("quality"), 100, 1, 100);
            String tempDir = SystemTempFileUtils.getTempDirectory();
            String inFilePath = tempDir + fileMd5 + "_in.jpg";
            String outFilePath = tempDir + fileMd5 + "_out.jpg";
            try {
                try (InputStream fileStream = FileIOUtils.getFileStream(this.fileStore, fileStoreInfo);){
                    if (fileStream != null) {
                        FileIOOpt.appendInputStreamToFile((InputStream)fileStream, (String)inFilePath);
                    }
                }
                ImageOpt.createThumbnail((String)inFilePath, (int)width, (int)height, (int)quality, (String)outFilePath);
                var14_16 = null;
                try (InputStream is = Files.newInputStream(Paths.get(outFilePath, new String[0]), new OpenOption[0]);){
                    UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)is, (long)fileStoreInfo.getFileSize(), (String)fileInfo.getFileName(), (String)"inline", null);
                }
                catch (Throwable throwable) {
                    var14_16 = throwable;
                    throw throwable;
                }
            }
            finally {
                FileSystemOpt.deleteFile((String)inFilePath);
                FileSystemOpt.deleteFile((String)outFilePath);
            }
        }
        catch (IOException e) {
            JsonResultUtils.writeErrorMessageJson((String)("IO error: " + e.getMessage()), (HttpServletResponse)response);
        }
        catch (Exception e) {
            JsonResultUtils.writeErrorMessageJson((String)("Unexpected error: " + e.getMessage()), (HttpServletResponse)response);
        }
    }

    private int sanitizeParameter(String value, int defaultValue, int min, int max) {
        int result = NumberBaseOpt.castObjectToInteger((Object)value, (Integer)defaultValue);
        return Math.max(min, Math.min(result, max));
    }

    @RequestMapping(value={"/pfile/{fileId:.*}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636e\u6587\u4ef6\u7684id\u4e0b\u8f7d\u6587\u4ef6")
    public void downloadByFileId(@PathVariable(value="fileId") String fileId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("Cache-Control", "public, max-age=604800");
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        String fileName = request.getParameter("fileName");
        if (!StringUtils.isBlank((CharSequence)fileName)) {
            fileInfo.setFileName(fileName);
        }
        if (GeneralAlgorithm.isEmpty((Object)fileInfo)) {
            throw new ObjectException(603, this.getI18nMessage("error.404.file_not_found", request, new Object[]{fileId}));
        }
        if (StringUtils.isBlank((CharSequence)fileInfo.getFileMd5())) {
            throw new ObjectException(603, this.getI18nMessage("error.404.file_not_found", request, new Object[]{fileId}));
        }
        FileStoreInfo fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()));
        this.downloadFile(this.fileStore, fileInfo, fileStoreInfo, request, response);
        this.fileInfoManager.writeDownloadFileLog(fileInfo, request);
    }

    @RequestMapping(value={"/batchdownload"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6279\u91cf\u4e0b\u8f7d\u6587\u4ef6\uff0c\u8fd4\u56de\u538b\u7f29\u6587\u4ef6")
    public void batchDownloadFile(String[] fileIds, String fileName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        long fileSize;
        if (fileIds == null || fileIds.length == 0) {
            JsonResultUtils.writeErrorMessageJson((int)701, (String)this.getI18nMessage("error.701.field_is_blank", request, new Object[]{"fileIds"}), (HttpServletResponse)response);
            return;
        }
        InputStream inputStream = null;
        boolean singleNotZip = BooleanBaseOpt.castObjectToBoolean((Object)request.getParameter("singleNotZip"), (Boolean)false);
        if (fileIds.length == 1 && singleNotZip) {
            FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileIds[0]));
            FileStoreInfo fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()));
            fileSize = fileStoreInfo.getFileSize();
            String filePath = fileStoreInfo.getFileStorePath();
            fileName = fileInfo.getFileName();
            inputStream = this.fileStore.loadFileStream(filePath);
        } else {
            StringBuilder fileIdSb = new StringBuilder();
            Arrays.sort(fileIds, String::compareTo);
            for (String fid : fileIds) {
                fileIdSb.append(fid);
            }
            String fileId = Md5Encoder.encode((String)fileIdSb.toString());
            String tempFilePath = SystemTempFileUtils.getTempFilePath((String)fileId, (long)1024L);
            File file = new File(tempFilePath);
            if (!file.exists()) {
                int len = fileIds.length;
                String[] fileUrls = new String[len];
                String[] fileNames = new String[len];
                int j = 0;
                for (int i = 0; i < len; ++i) {
                    FileInfo si = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileIds[i]));
                    FileStoreInfo fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)si.getFileMd5()));
                    if (si == null) continue;
                    fileUrls[j] = fileStoreInfo.getFileStorePath();
                    fileNames[j] = si.getFileName();
                    ++j;
                }
                if (j == 0) {
                    JsonResultUtils.writeErrorMessageJson((int)701, (String)this.getI18nMessage("error.701.field_is_blank", request, new Object[]{"fileIds"}), (HttpServletResponse)response);
                    return;
                }
                this.compressFiles(tempFilePath, fileUrls, fileNames, j);
            }
            file = new File(tempFilePath);
            fileSize = file.length();
            inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
        }
        UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)inputStream, (long)fileSize, (String)fileName, (String)request.getParameter("downloadType"), null);
    }

    private void downloadFile(FileStore fileStore, FileInfo fileInfo, FileStoreInfo fileStoreInfo, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (null != fileInfo && fileStoreInfo != null) {
            if (fileStoreInfo.getFileSize() == 0L) {
                UploadDownloadUtils.downloadFile((InputStream)new ByteArrayInputStream(new byte[0]), (String)fileInfo.getFileName(), (HttpServletResponse)response);
                return;
            }
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)fileInfo.getEncryptType(), (CharSequence[])new CharSequence[]{"A", "S", "M", "G"})) {
                Throwable throwable;
                String password = SecurityOptUtils.decodeSecurityString((String)request.getParameter("password"));
                String tmpFilePath = SystemTempFileUtils.getTempFilePath((String)fileInfo.getFileMd5(), (long)fileStoreInfo.getFileSize());
                File tmpFile = new File(tmpFilePath);
                if (!fileStoreInfo.isTemp().booleanValue()) {
                    try {
                        throwable = null;
                        try (InputStream downFile = FileIOUtils.getFileStream(fileStore, fileStoreInfo);
                             FileOutputStream diminationFile = new FileOutputStream(tmpFile);){
                            FileEncryptUtils.decrypt((InputStream)downFile, (OutputStream)diminationFile, (String)FileInfo.mapEncryptType((String)fileInfo.getEncryptType()), (String)password);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        JsonResultUtils.writeErrorMessageJson((int)423, (String)this.getI18nMessage("error.423.cannt_encrypt_file", request, new Object[]{e.getMessage()}), (HttpServletResponse)response);
                        return;
                    }
                }
                throwable = null;
                try (FileInputStream inputStream = new FileInputStream(tmpFile);){
                    UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)inputStream, (long)tmpFile.length(), (String)fileInfo.getFileName(), (String)request.getParameter("downloadType"), null);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                FileSystemOpt.deleteFile((File)tmpFile);
            } else {
                try (InputStream is = FileIOUtils.getFileStream(fileStore, fileStoreInfo);){
                    UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)is, (long)fileStoreInfo.getFileSize(), (String)fileInfo.getFileName(), (String)request.getParameter("downloadType"), null);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    JsonResultUtils.writeErrorMessageJson((String)e.getMessage(), (HttpServletResponse)response);
                }
            }
        } else {
            JsonResultUtils.writeHttpErrorMessage((int)404, (String)this.getI18nMessage("error.404.file_not_found", request, new Object[]{"{fileInfo is null}"}), (HttpServletResponse)response);
        }
    }

    private boolean noAuth(HttpServletRequest request, HttpServletResponse response, FileInfo fileInfo, String closeAuth) {
        if (StringUtils.isNotBlank((CharSequence)closeAuth)) {
            return false;
        }
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            userCode = request.getParameter("userCode");
        }
        if (!this.fileLibraryInfoManager.checkAuth(topUnit, fileInfo, userCode, request.getParameter("authCode"))) {
            JsonResultUtils.writeErrorMessageJson((int)403, (String)this.getI18nMessage("error.403.download_file_forbidden", request, new Object[]{userCode, WebOptUtils.getCurrentUnitCode((HttpServletRequest)request), request.getParameter("authCode")}), (HttpServletResponse)response);
            return true;
        }
        return false;
    }

    private void compressFiles(String zipFilePathName, String[] fileUrls, String[] fileNames, int len) {
        try {
            File zipFile = new File(zipFilePathName);
            FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
            ZipOutputStream out = ZipCompressor.convertToZipOutputStream((OutputStream)fileOutputStream);
            String basedir = "";
            for (int i = 0; i < len; ++i) {
                try (InputStream fis = this.fileStore.loadFileStream(fileUrls[i]);){
                    String fileName = fileNames[i];
                    int n = 0;
                    for (int j = 0; j < i; ++j) {
                        if (!StringUtils.equalsAnyIgnoreCase((CharSequence)fileName, (CharSequence[])new CharSequence[]{fileNames[j]})) continue;
                        ++n;
                    }
                    if (n > 0) {
                        fileName = fileName + "(" + n + ")";
                    }
                    ZipCompressor.compressFile((InputStream)fis, (String)fileName, (ZipOutputStream)out, (String)basedir);
                    continue;
                }
                catch (Exception e) {
                    logger.info("\u83b7\u53d6\u6587\u4ef6" + fileUrls[i] + "\u51fa\u9519\uff01");
                }
            }
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

