/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.utils;

import com.centit.fileserver.common.FileStore;
import com.centit.fileserver.common.FileTaskInfo;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.po.FileStoreInfo;
import com.centit.fileserver.pretreat.AbstractOfficeToPdf;
import com.centit.fileserver.service.FileInfoManager;
import com.centit.fileserver.service.FileStoreInfoManager;
import com.centit.fileserver.task.CreatePdfOpt;
import com.centit.fileserver.utils.UploadDownloadUtils;
import com.centit.support.file.FileType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public abstract class FileIOUtils {
    private static final int URI_START_PARAM = 5;
    public static final String LOG_OPERATION_NAME = "FileServerLog";

    public static InputStream getFileStream(FileStore fileStore, FileStoreInfo fileStoreInfo) throws IOException {
        if ("E".equals(fileStoreInfo.getIsTemp())) {
            return null;
        }
        return fileStoreInfo.isTemp() != false ? Files.newInputStream(new File(fileStoreInfo.getFileStorePath()).toPath(), new OpenOption[0]) : fileStore.loadFileStream(fileStoreInfo.getFileStorePath());
    }

    public static boolean hasSensitiveExtName(String fileName) {
        return StringUtils.endsWithAny((CharSequence)fileName.trim().toLowerCase(), (CharSequence[])new CharSequence[]{".js", ".jsp", ".jspx", ".asp", ".php", ".exe", ".html", ".htm", ".py", ".py3", ".sh", ".vbs", ".wsh"});
    }

    public static boolean reGetPdf(String fileId, HttpServletRequest request, HttpServletResponse response, FileInfo fileInfo, FileStore fileStore, CreatePdfOpt createPdfOpt, FileInfoManager fileInfoManager, FileStoreInfoManager fileStoreInfoManager) throws IOException {
        boolean canView = false;
        if (AbstractOfficeToPdf.canTransToPdf(fileInfo.getFileType())) {
            FileStoreInfo attachedFileStoreInfo;
            FileStoreInfo fileStoreInfo = (FileStoreInfo)fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()));
            FileTaskInfo addPdfTaskInfo = new FileTaskInfo(createPdfOpt.getOpeatorName());
            addPdfTaskInfo.setFileId(fileId);
            addPdfTaskInfo.setFileSize(fileStoreInfo.getFileSize());
            createPdfOpt.doFileTask(addPdfTaskInfo);
            FileInfo newFileInfo = (FileInfo)fileInfoManager.getObjectById((Serializable)((Object)fileId));
            if (StringUtils.isNotBlank((CharSequence)newFileInfo.getAttachedFileMd5()) && (attachedFileStoreInfo = (FileStoreInfo)fileStoreInfoManager.getObjectById((Serializable)((Object)newFileInfo.getAttachedFileMd5()))) != null) {
                canView = true;
                try (InputStream is = FileIOUtils.getFileStream(fileStore, attachedFileStoreInfo);){
                    UploadDownloadUtils.downFileRange((HttpServletRequest)request, (HttpServletResponse)response, (InputStream)is, (long)attachedFileStoreInfo.getFileSize(), (String)(FileType.truncateFileExtName((String)newFileInfo.getFileName()) + ".pdf"), (String)"inline", null);
                }
            }
        }
        return canView;
    }

    public static InputStream createPdfStream(FileInfo fileInfo, FileStoreInfo fileStoreInfo, FileStore fileStore, CreatePdfOpt createPdfOpt, FileStoreInfoManager fileStoreInfoManager) throws IOException {
        createPdfOpt.doPdfOpt(fileInfo, fileStoreInfo.getFileSize());
        if (StringUtils.isNotBlank((CharSequence)fileInfo.getAttachedFileMd5())) {
            FileStoreInfo attachedFileStoreInfo = (FileStoreInfo)fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getAttachedFileMd5()));
            return FileIOUtils.getFileStream(fileStore, attachedFileStoreInfo);
        }
        return null;
    }

    public static ImmutableTriple<String, String, String> fetchUnitFilePath(String uri) throws UnsupportedEncodingException {
        String[] urips = uri.split("/");
        int n = urips.length;
        if (n < 7) {
            return null;
        }
        if (n == 7) {
            return new ImmutableTriple((Object)URLDecoder.decode(urips[5], "UTF-8"), (Object)"", (Object)URLDecoder.decode(urips[6], "UTF-8"));
        }
        StringBuilder sb = new StringBuilder(URLDecoder.decode(urips[6], "UTF-8"));
        for (int i = 7; i < n - 1; ++i) {
            sb.append("/").append(URLDecoder.decode(urips[i], "UTF-8"));
        }
        return new ImmutableTriple((Object)URLDecoder.decode(urips[5], "UTF-8"), (Object)sb.toString(), (Object)URLDecoder.decode(urips[n - 1], "UTF-8"));
    }
}

