/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.task;

import com.centit.fileserver.common.FileTaskInfo;
import com.centit.fileserver.common.FileTaskQueue;
import com.centit.support.file.FileSystemOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedBlockingQueueFileOptTaskQueue
implements FileTaskQueue {
    private static final Logger logger = LoggerFactory.getLogger(LinkedBlockingQueueFileOptTaskQueue.class);
    private File taskFile;
    private LinkedBlockingQueue<FileTaskInfo> taskQueue;

    public LinkedBlockingQueueFileOptTaskQueue(String taskFileRoot) throws Exception {
        FileSystemOpt.createDirect((String)taskFileRoot);
        this.taskFile = new File(FileSystemOpt.appendPath((String)taskFileRoot, (String)"task.dat"));
        if (this.taskFile.exists()) {
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.taskFile));){
                this.taskQueue = (LinkedBlockingQueue)ois.readObject();
            }
        } else {
            this.taskQueue = new LinkedBlockingQueue();
        }
    }

    public boolean add(FileTaskInfo task) {
        this.taskQueue.offer(task);
        this.saveTasksToDisk(task, "\u6dfb\u52a0");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileTaskInfo get() {
        LinkedBlockingQueue<FileTaskInfo> linkedBlockingQueue = this.taskQueue;
        synchronized (linkedBlockingQueue) {
            FileTaskInfo task = this.taskQueue.poll();
            if (null != task) {
                this.saveTasksToDisk(task, "\u5373\u5c06\u8f6c\u50a8");
            }
            return task;
        }
    }

    private void saveTasksToDisk(FileTaskInfo task, String prefix) {
        logger.info(prefix + "\u6301\u4e45\u5316\u4efb\u52a1, \u4efb\u52a1\u603b\u6570: " + this.taskQueue.size() + ",FileId:" + task.getFileId() + ",FileMd5" + task.getFileMd5());
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.taskFile));){
            oos.writeObject(this.taskQueue);
        }
        catch (IOException e) {
            logger.error("\u6301\u4e45\u5316\u6587\u4ef6\u5b58\u50a8\u4efb\u52a1\u5931\u8d25: " + e.getMessage());
        }
    }
}

