/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.controller;

import com.centit.fileserver.po.FileFavorite;
import com.centit.fileserver.service.FileFavoriteManager;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/favorite"})
@Api(value="FILE_FAVORITE", tags={"\u6587\u4ef6\u6536\u85cf"})
public class FileFavoriteController
extends BaseController {
    private final FileFavoriteManager fileFavoriteMag;

    public FileFavoriteController(FileFavoriteManager fileFavoriteMag) {
        this.fileFavoriteMag = fileFavoriteMag;
    }

    @RequestMapping(method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u6587\u4ef6\u6536\u85cf\u5217\u8868")
    @WrapUpResponseBody
    public PageQueryResult<FileFavorite> list(HttpServletRequest request, PageDesc pageDesc) {
        Map searchColumn = FileFavoriteController.collectRequestParameters((HttpServletRequest)request);
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        List<FileFavorite> fileFavorites = this.fileFavoriteMag.listFileFavorite(topUnit, searchColumn, pageDesc);
        return PageQueryResult.createResult(fileFavorites, (PageDesc)pageDesc);
    }

    @RequestMapping(value={"/{favoriteId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u6587\u4ef6\u6536\u85cf")
    @WrapUpResponseBody
    public FileFavorite getFileFavorite(@PathVariable String favoriteId) {
        return this.fileFavoriteMag.getFileFavorite(favoriteId);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ApiOperation(value="\u65b0\u589e\u6587\u4ef6\u6536\u85cf")
    @WrapUpResponseBody
    public void createFileFavorite(@RequestBody FileFavorite fileFavorite, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)fileFavorite.getFavoriteUser())) {
            fileFavorite.setFavoriteUser(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        }
        this.fileFavoriteMag.createFileFavorite(fileFavorite);
        JsonResultUtils.writeSingleDataJson((Object)fileFavorite, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/{favoriteId}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u6587\u4ef6\u6536\u85cf")
    @WrapUpResponseBody
    public void deleteFileFavorite(@PathVariable String favoriteId) {
        this.fileFavoriteMag.deleteFileFavorite(favoriteId);
    }

    @RequestMapping(method={RequestMethod.PUT})
    @ApiOperation(value="\u66f4\u65b0\u6587\u4ef6\u6536\u85cf")
    @WrapUpResponseBody
    public void updateFileFavorite(@RequestBody FileFavorite fileFavorite) {
        this.fileFavoriteMag.updateFileFavorite(fileFavorite);
    }
}

