/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.task;

import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileTaskInfo;
import com.centit.fileserver.common.FileTaskOpeator;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.po.FileStoreInfo;
import com.centit.fileserver.pretreat.AbstractOfficeToPdf;
import com.centit.fileserver.pretreat.FilePretreatUtils;
import com.centit.fileserver.service.FileInfoManager;
import com.centit.fileserver.service.FileStoreInfoManager;
import com.centit.fileserver.task.FileStoreOpt;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.file.FileMD5Maker;
import com.centit.support.file.FileSystemOpt;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CreatePdfOpt
extends FileStoreOpt
implements FileTaskOpeator {
    private static final Logger logger = LoggerFactory.getLogger(CreatePdfOpt.class);
    @Autowired
    private FileInfoManager fileInfoManager;
    @Autowired
    private FileStoreInfoManager fileStoreInfoManager;

    public String getOpeatorName() {
        return "pdf";
    }

    public void doPdfOpt(FileInfo fileInfo, long fileSize) {
        FileInfo pdfFileInfo = new FileInfo();
        pdfFileInfo.copy((Object)fileInfo);
        try {
            String pdfTempFile;
            FileStoreInfo fileStoreInfo;
            String originalTempFilePath = SystemTempFileUtils.getTempFilePath((String)fileInfo.getFileMd5(), (long)fileSize);
            if (!new File(originalTempFilePath).exists() && (fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()))) != null) {
                InputStream inputStream = this.fileStore.loadFileStream(fileStoreInfo.getFileStorePath());
                FileSystemOpt.createFile((InputStream)inputStream, (String)originalTempFilePath);
            }
            if (null != (pdfTempFile = FilePretreatUtils.createPdf(pdfFileInfo, originalTempFilePath))) {
                pdfFileInfo.setFileMd5(FileMD5Maker.makeFileMD5((File)new File(pdfTempFile)));
                super.save(pdfTempFile, pdfFileInfo, new File(pdfTempFile).length());
                fileInfo.setAttachedFileMd5(pdfFileInfo.getFileMd5());
                fileInfo.setAttachedType(pdfFileInfo.getFileType());
                this.fileInfoManager.updateObject((Serializable)fileInfo);
                logger.info("\u751f\u6210PDF\u5b8c\u6210");
            }
        }
        catch (IOException e) {
            logger.error("\u751f\u6210PDF\u6587\u4ef6\u51fa\u9519\uff01" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doFileTask(FileTaskInfo fileOptTaskInfo) {
        String fileId = fileOptTaskInfo.getFileId();
        long fileSize = fileOptTaskInfo.getFileSize();
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        if (null == fileInfo) {
            return;
        }
        this.doPdfOpt(fileInfo, fileSize);
    }

    public FileTaskInfo attachTaskInfo(FileInfo fileInfo, long fileSize, Map<String, Object> pretreatInfo) {
        if (BooleanBaseOpt.castObjectToBoolean((Object)pretreatInfo.get("pdf"), (Boolean)false).booleanValue() && AbstractOfficeToPdf.canTransToPdf(fileInfo.getFileType())) {
            FileTaskInfo taskInfo = new FileTaskInfo(this.getOpeatorName());
            taskInfo.copy((FileBaseInfo)fileInfo);
            taskInfo.setFileSize(Long.valueOf(fileSize));
            return taskInfo;
        }
        return null;
    }

    public int runTaskInfo(FileInfo fileInfo, long fileSize, Map<String, Object> pretreatInfo) {
        if (BooleanBaseOpt.castObjectToBoolean((Object)pretreatInfo.get("pdf"), (Boolean)false).booleanValue() && AbstractOfficeToPdf.canTransToPdf(fileInfo.getFileType())) {
            this.doPdfOpt(fileInfo, fileSize);
            return 1;
        }
        return 0;
    }
}

